/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.bottombar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.actions.RelativeTemporalAction;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.UncivGame;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.map.HexMath;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayerUnitSprite;
import com.unciv.ui.components.tilegroups.layers.UnitSpriteSlot;
import com.unciv.ui.components.widgets.ShadowedLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.Concurrency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\"#$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bJ,\u0010\u0015\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\b\b\u0002\u0010 \u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTableHelpers;", "", "<init>", "()V", "flashRedDuration", "", "moveActorsDuration", "moveActorsDisplacement", "attackAnimationFrameDuration", "damageLabelDuration", "damageLabelFontSize", "", "damageLabelDisplacement", "battleAnimationDeferred", "", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "attacker", "Lcom/unciv/logic/battle/ICombatant;", "damageToAttacker", "defender", "damageToDefender", "battleAnimation", "createDamageLabel", "damage", "target", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getHealthBar", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "maxHealth", "currentHealth", "maxRemainingHealth", "minRemainingHealth", "forDefender", "", "FlashRedAction", "MoveActorsAction", "AttackAnimationAction", "DamageLabelAnimation", "core"})
@SourceDebugExtension(value={"SMAP\nBattleTableHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleTableHelpers.kt\ncom/unciv/ui/screens/worldscreen/bottombar/BattleTableHelpers\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n767#2,2:283\n783#2,4:285\n1#3:289\n*S KotlinDebug\n*F\n+ 1 BattleTableHelpers.kt\ncom/unciv/ui/screens/worldscreen/bottombar/BattleTableHelpers\n*L\n177#1:283,2\n177#1:285,4\n*E\n"})
public final class BattleTableHelpers {
    @NotNull
    public static final BattleTableHelpers INSTANCE = new BattleTableHelpers();
    private static final float flashRedDuration = 0.2f;
    private static final float moveActorsDuration = 0.3f;
    private static final float moveActorsDisplacement = 10.0f;
    private static final float attackAnimationFrameDuration = 0.1f;
    private static final float damageLabelDuration = 1.2f;
    private static final int damageLabelFontSize = 40;
    private static final float damageLabelDisplacement = 90.0f;

    private BattleTableHelpers() {
    }

    public final void battleAnimationDeferred(@NotNull WorldScreen $this$battleAnimationDeferred, @NotNull ICombatant attacker, int damageToAttacker, @NotNull ICombatant defender, int damageToDefender) {
        Intrinsics.checkNotNullParameter($this$battleAnimationDeferred, "<this>");
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$battleAnimationDeferred, attacker, damageToAttacker, defender, damageToDefender, null){
            int label;
            final /* synthetic */ WorldScreen $this_battleAnimationDeferred;
            final /* synthetic */ ICombatant $attacker;
            final /* synthetic */ int $damageToAttacker;
            final /* synthetic */ ICombatant $defender;
            final /* synthetic */ int $damageToDefender;
            {
                this.$this_battleAnimationDeferred = $receiver;
                this.$attacker = $attacker;
                this.$damageToAttacker = $damageToAttacker;
                this.$defender = $defender;
                this.$damageToDefender = $damageToDefender;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        BattleTableHelpers.access$battleAnimation(BattleTableHelpers.INSTANCE, this.$this_battleAnimationDeferred, this.$attacker, this.$damageToAttacker, this.$defender, this.$damageToDefender);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void battleAnimation(WorldScreen $this$battleAnimation, ICombatant attacker, int damageToAttacker, ICombatant defender, int damageToDefender) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        Sequence sequence = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Actor>, Continuation<? super Unit>, Object>(damageToDefender, defender, damageToAttacker, attacker, $this$battleAnimation, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $damageToDefender;
            final /* synthetic */ ICombatant $defender;
            final /* synthetic */ int $damageToAttacker;
            final /* synthetic */ ICombatant $attacker;
            final /* synthetic */ WorldScreen $this_battleAnimation;
            {
                this.$damageToDefender = $damageToDefender;
                this.$defender = $defender;
                this.$damageToAttacker = $damageToAttacker;
                this.$attacker = $attacker;
                this.$this_battleAnimation = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        if (this.$damageToDefender != 0) {
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yieldAll(BattleTableHelpers.access$battleAnimation$getMapActorsForCombatant(this.$this_battleAnimation, this.$defender), (Continuation<? super Unit>)this);
                            if (v0 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if (this.$damageToAttacker != 0) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                            this.label = 2;
                            v1 = $this$sequence.yieldAll(BattleTableHelpers.access$battleAnimation$getMapActorsForCombatant(this.$this_battleAnimation, this.$attacker), (Continuation<? super Unit>)this);
                            if (v1 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl26:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Actor>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Actor> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        void var10_10 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Actor actor = (Actor)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Color color = it.getColor().cpy();
            map2.put(t, color);
        }
        Map actorsToFlashRed2 = destination$iv$iv;
        List<Actor> actorsToMove = SequencesKt.toList(BattleTableHelpers.battleAnimation$getMapActorsForCombatant($this$battleAnimation, attacker));
        Vector2 attackVectorHexCoords = defender.getTile().getPosition().cpy().sub(attacker.getTile().getPosition());
        Intrinsics.checkNotNull(attackVectorHexCoords);
        Vector2 attackVectorWorldCoords = HexMath.INSTANCE.hex2WorldCoords(attackVectorHexCoords).nor().scl(10.0f);
        WorldTileGroup worldTileGroup = $this$battleAnimation.getMapHolder().getTileGroups().get(attacker.getTile());
        Intrinsics.checkNotNull(worldTileGroup);
        WorldTileGroup attackerGroup = worldTileGroup;
        WorldTileGroup worldTileGroup2 = $this$battleAnimation.getMapHolder().getTileGroups().get(defender.getTile());
        Intrinsics.checkNotNull(worldTileGroup2);
        WorldTileGroup defenderGroup = worldTileGroup2;
        boolean hideDefenderDamage = defender.isDefeated() && Intrinsics.areEqual(attacker.getTile().getPosition(), defender.getTile().getPosition());
        Stage stage = $this$battleAnimation.getStage();
        Intrinsics.checkNotNull(attackVectorWorldCoords);
        Action action2 = new MoveActorsAction(actorsToMove, attackVectorWorldCoords);
        Action action3 = Actions.run(() -> BattleTableHelpers.battleAnimation$lambda$1(damageToAttacker, attackerGroup, hideDefenderDamage, damageToDefender, defenderGroup));
        Vector2 vector2 = attackVectorWorldCoords.cpy().scl(-1.0f);
        Intrinsics.checkNotNullExpressionValue(vector2, "scl(...)");
        stage.addAction(Actions.sequence(action2, action3, (Action)Actions.parallel((Action)new MoveActorsAction(actorsToMove, vector2), (Action)new AttackAnimationAction(attacker, damageToDefender != 0 ? SequencesKt.toList(BattleTableHelpers.battleAnimation$getMapActorsForCombatant($this$battleAnimation, defender)) : CollectionsKt.emptyList(), $this$battleAnimation.getMapHolder().getCurrentTileSetStrings()), (Action)new AttackAnimationAction(defender, damageToAttacker != 0 ? SequencesKt.toList(BattleTableHelpers.battleAnimation$getMapActorsForCombatant($this$battleAnimation, attacker)) : CollectionsKt.emptyList(), $this$battleAnimation.getMapHolder().getCurrentTileSetStrings()), (Action)Actions.sequence((Action)new FlashRedAction(0.0f, 1.0f, actorsToFlashRed2), (Action)new FlashRedAction(1.0f, 0.0f, actorsToFlashRed2)))));
    }

    private final void createDamageLabel(int damage, Actor target) {
        if (damage == 0) {
            return;
        }
        String string = TranslationsKt.tr(-damage);
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        ShadowedLabel container = new ShadowedLabel(string, 40, color, null, false, 0.0f, 56, null);
        Actor $this$createDamageLabel_u24lambda_u240 = target;
        boolean bl = false;
        Vector2 targetRight = $this$createDamageLabel_u24lambda_u240.localToStageCoordinates(new Vector2($this$createDamageLabel_u24lambda_u240.getWidth(), $this$createDamageLabel_u24lambda_u240.getHeight() * 0.5f));
        container.setPosition(targetRight.x, targetRight.y, 1);
        target.getStage().addActor(container);
        container.addAction(new DamageLabelAnimation(container));
    }

    @NotNull
    public final Table getHealthBar(int maxHealth, int currentHealth, int maxRemainingHealth, int minRemainingHealth, boolean forDefender) {
        Table healthBar = new Table();
        float totalWidth = 120.0f;
        Color color = Color.FIREBRICK;
        Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
        Image damagedHealth = ImageGetter.INSTANCE.getDot(color);
        Color color2 = Color.GREEN;
        Intrinsics.checkNotNullExpressionValue(color2, "GREEN");
        Image remainingHealthDot = ImageGetter.INSTANCE.getDot(color2);
        Color color3 = Color.ORANGE;
        Intrinsics.checkNotNullExpressionValue(color3, "ORANGE");
        Image maybeDamagedHealth = ImageGetter.INSTANCE.getDot(color3);
        Image missingHealth = ImageGetter.INSTANCE.getDot(ImageGetter.INSTANCE.getCHARCOAL());
        if (UncivGame.Companion.getCurrent().getSettings().getContinuousRendering()) {
            maybeDamagedHealth.addAction(Actions.forever(Actions.sequence((Action)Actions.color(Color.FIREBRICK, 0.7f), (Action)Actions.color(Color.ORANGE, 0.7f))));
        }
        float healthDecreaseWidth = (float)(currentHealth - minRemainingHealth) * totalWidth / (float)100;
        if (forDefender) {
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, missingHealth, maxHealth - currentHealth);
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, damagedHealth, currentHealth - maxRemainingHealth);
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, maybeDamagedHealth, maxRemainingHealth - minRemainingHealth);
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, remainingHealthDot, minRemainingHealth);
            remainingHealthDot.toFront();
            BattleTableHelpers.getHealthBar$animateHealth(remainingHealthDot, healthDecreaseWidth, healthDecreaseWidth);
        } else {
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, remainingHealthDot, minRemainingHealth);
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, maybeDamagedHealth, maxRemainingHealth - minRemainingHealth);
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, damagedHealth, currentHealth - maxRemainingHealth);
            BattleTableHelpers.getHealthBar$addHealthToBar(totalWidth, maxHealth, healthBar, missingHealth, maxHealth - currentHealth);
            remainingHealthDot.toFront();
            BattleTableHelpers.getHealthBar$animateHealth(remainingHealthDot, healthDecreaseWidth, 0.0f);
        }
        healthBar.pack();
        return healthBar;
    }

    public static /* synthetic */ Table getHealthBar$default(BattleTableHelpers battleTableHelpers, int n, int n2, int n3, int n4, boolean bl, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            bl = false;
        }
        return battleTableHelpers.getHealthBar(n, n2, n3, n4, bl);
    }

    private static final Sequence<Actor> battleAnimation$getMapActorsForCombatant(WorldScreen $this_battleAnimation, ICombatant combatant) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Actor>, Continuation<? super Unit>, Object>($this_battleAnimation, combatant, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WorldScreen $this_battleAnimation;
            final /* synthetic */ ICombatant $combatant;
            {
                this.$this_battleAnimation = $receiver;
                this.$combatant = $combatant;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                void $this$sequence;
                WorldTileGroup tileGroup;
                SequenceScope sequenceScope = (SequenceScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        WorldTileGroup worldTileGroup = this.$this_battleAnimation.getMapHolder().getTileGroups().get(this.$combatant.getTile());
                        Intrinsics.checkNotNull(worldTileGroup);
                        tileGroup = worldTileGroup;
                        if (!this.$combatant.isCity()) break;
                        Actor icon = tileGroup.getLayerImprovement().getImprovementIcon();
                        if (icon == null) return Unit.INSTANCE;
                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(tileGroup);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(icon);
                        this.label = 1;
                        Object object2 = $this$sequence.yield(icon, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Actor icon = (Actor)this.L$2;
                        WorldTileGroup tileGroup2 = (WorldTileGroup)this.L$1;
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                if (this.$combatant.isAirUnit()) return Unit.INSTANCE;
                TileLayerUnitSprite tileLayerUnitSprite = tileGroup.getLayerUnitArt();
                ICombatant iCombatant = this.$combatant;
                Intrinsics.checkNotNull(iCombatant, "null cannot be cast to non-null type com.unciv.logic.battle.MapUnitCombatant");
                UnitSpriteSlot slot = tileLayerUnitSprite.getSpriteSlot(((MapUnitCombatant)iCombatant).getUnit());
                if (slot == null) return Unit.INSTANCE;
                SnapshotArray<Actor> snapshotArray = slot.getSpriteGroup().getChildren();
                Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
                this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                this.L$1 = SpillingKt.nullOutSpilledVariable(tileGroup);
                this.L$2 = SpillingKt.nullOutSpilledVariable(slot);
                this.label = 2;
                Object object3 = $this$sequence.yieldAll((Iterable)snapshotArray, (Continuation<? super Unit>)this);
                if (object3 != object) return Unit.INSTANCE;
                return object;
                {
                    case 2: {
                        slot = (UnitSpriteSlot)this.L$2;
                        tileGroup = (WorldTileGroup)this.L$1;
                        ResultKt.throwOnFailure($result);
                        object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Actor>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Actor> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final void battleAnimation$lambda$1(int $damageToAttacker, WorldTileGroup $attackerGroup, boolean $hideDefenderDamage, int $damageToDefender, WorldTileGroup $defenderGroup) {
        INSTANCE.createDamageLabel($damageToAttacker, $attackerGroup);
        if (!$hideDefenderDamage) {
            INSTANCE.createDamageLabel($damageToDefender, $defenderGroup);
        }
    }

    private static final void getHealthBar$addHealthToBar(float totalWidth, int $maxHealth, Table healthBar, Image image, int amount) {
        float width = totalWidth * (float)amount / (float)$maxHealth;
        healthBar.add((Actor)image).size(RangesKt.coerceIn(width, 0.0f, totalWidth), 4.0f);
    }

    private static final void getHealthBar$animateHealth(Image health, float healthDecreaseWidth, float move) {
        health.addAction(Actions.sequence((Action)Actions.sizeBy(healthDecreaseWidth, 0.0f), (Action)Actions.sizeBy(-healthDecreaseWidth, 0.0f, 0.5f)));
        health.addAction(Actions.sequence((Action)Actions.moveBy(-move, 0.0f), (Action)Actions.moveBy(move, 0.0f, 0.5f)));
    }

    public static final /* synthetic */ void access$battleAnimation(BattleTableHelpers $this, WorldScreen $receiver, ICombatant attacker, int damageToAttacker, ICombatant defender, int damageToDefender) {
        $this.battleAnimation($receiver, attacker, damageToAttacker, defender, damageToDefender);
    }

    public static final /* synthetic */ Sequence access$battleAnimation$getMapActorsForCombatant(WorldScreen $this_battleAnimation, ICombatant combatant) {
        return BattleTableHelpers.battleAnimation$getMapActorsForCombatant($this_battleAnimation, combatant);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTableHelpers$AttackAnimationAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/SequenceAction;", "attacker", "Lcom/unciv/logic/battle/ICombatant;", "defenderActors", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "currentTileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "<init>", "(Lcom/unciv/logic/battle/ICombatant;Ljava/util/List;Lcom/unciv/ui/components/tilegroups/TileSetStrings;)V", "getAttackAnimationLocation", "", "core"})
    public static final class AttackAnimationAction
    extends SequenceAction {
        @NotNull
        private final ICombatant attacker;
        @NotNull
        private final TileSetStrings currentTileSetStrings;

        public AttackAnimationAction(@NotNull ICombatant attacker, @NotNull List<? extends Actor> defenderActors, @NotNull TileSetStrings currentTileSetStrings) {
            String attackAnimationLocation;
            Intrinsics.checkNotNullParameter(attacker, "attacker");
            Intrinsics.checkNotNullParameter(defenderActors, "defenderActors");
            Intrinsics.checkNotNullParameter(currentTileSetStrings, "currentTileSetStrings");
            this.attacker = attacker;
            this.currentTileSetStrings = currentTileSetStrings;
            if (CollectionsKt.any((Iterable)defenderActors) && (attackAnimationLocation = this.getAttackAnimationLocation()) != null) {
                int i = 1;
                while (ImageGetter.INSTANCE.imageExists(attackAnimationLocation + i)) {
                    Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, attackAnimationLocation + i, null, 2, null);
                    Group defenderParentGroup = CollectionsKt.first(defenderActors).getParent();
                    this.addAction(Actions.run(() -> AttackAnimationAction._init_$lambda$0(defenderParentGroup, image)));
                    this.addAction(Actions.delay(0.1f));
                    this.addAction(Actions.removeActor(image));
                    ++i;
                }
            }
        }

        private final String getAttackAnimationLocation() {
            String unitSpecificAttackAnimationLocation;
            if (this.attacker instanceof MapUnitCombatant && ImageGetter.INSTANCE.imageExists((unitSpecificAttackAnimationLocation = AttackAnimationAction.getAttackAnimationLocation$getLocation(this.currentTileSetStrings, ((MapUnitCombatant)this.attacker).getName())) + '1')) {
                return unitSpecificAttackAnimationLocation;
            }
            String unitTypeAttackAnimationLocation = AttackAnimationAction.getAttackAnimationLocation$getLocation(this.currentTileSetStrings, this.attacker.getUnitType().getName());
            if (ImageGetter.INSTANCE.imageExists(unitTypeAttackAnimationLocation + '1')) {
                return unitTypeAttackAnimationLocation;
            }
            return null;
        }

        private static final void _init_$lambda$0(Group $defenderParentGroup, Image $image) {
            $defenderParentGroup.addActor($image);
        }

        private static final String getAttackAnimationLocation$getLocation(TileSetStrings $this$getAttackAnimationLocation_u24getLocation, String name) {
            String[] stringArray = new String[]{$this$getAttackAnimationLocation_u24getLocation.getUnitsLocation(), name, "-attack-"};
            return $this$getAttackAnimationLocation_u24getLocation.getString(stringArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0014J\b\u0010\u000f\u001a\u00020\rH\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTableHelpers$DamageLabelAnimation;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "actor", "Lcom/badlogic/gdx/scenes/scene2d/ui/WidgetGroup;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/ui/WidgetGroup;)V", "startX", "", "getStartX", "()F", "startY", "getStartY", "update", "", "percent", "end", "core"})
    private static final class DamageLabelAnimation
    extends TemporalAction {
        private final float startX;
        private final float startY;

        public DamageLabelAnimation(@NotNull WidgetGroup actor) {
            Intrinsics.checkNotNullParameter(actor, "actor");
            super(1.2f);
            this.startX = actor.getX();
            this.startY = actor.getY();
        }

        public final float getStartX() {
            return this.startX;
        }

        public final float getStartY() {
            return this.startY;
        }

        @Override
        protected void update(float percent) {
            this.actor.getColor().a = Interpolation.fade.apply(1.0f - percent);
            this.actor.setPosition(this.startX, this.startY + percent * 90.0f);
        }

        @Override
        protected void end() {
            this.actor.remove();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTableHelpers$FlashRedAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/FloatAction;", "start", "", "end", "actorsToOriginalColors", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lcom/badlogic/gdx/graphics/Color;", "<init>", "(FFLjava/util/Map;)V", "updateRedPercent", "", "percent", "update", "core"})
    public static final class FlashRedAction
    extends FloatAction {
        @NotNull
        private final Map<Actor, Color> actorsToOriginalColors;

        public FlashRedAction(float start2, float end, @NotNull Map<Actor, ? extends Color> actorsToOriginalColors) {
            Intrinsics.checkNotNullParameter(actorsToOriginalColors, "actorsToOriginalColors");
            super(start2, end, 0.2f, Interpolation.sine);
            this.actorsToOriginalColors = actorsToOriginalColors;
        }

        private final void updateRedPercent(float percent) {
            for (Map.Entry<Actor, Color> entry : this.actorsToOriginalColors.entrySet()) {
                Actor actor = entry.getKey();
                Color color = entry.getValue();
                actor.setColor(color.cpy().lerp(Color.RED, this.getStart() + percent * (this.getEnd() - this.getStart())));
            }
        }

        @Override
        protected void update(float percent) {
            this.updateRedPercent(percent);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTableHelpers$MoveActorsAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/RelativeTemporalAction;", "actorsToMove", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "movementVector", "Lcom/badlogic/gdx/math/Vector2;", "<init>", "(Ljava/util/List;Lcom/badlogic/gdx/math/Vector2;)V", "updateRelative", "", "percentDelta", "", "core"})
    public static final class MoveActorsAction
    extends RelativeTemporalAction {
        @NotNull
        private final List<Actor> actorsToMove;
        @NotNull
        private final Vector2 movementVector;

        public MoveActorsAction(@NotNull List<? extends Actor> actorsToMove, @NotNull Vector2 movementVector) {
            Intrinsics.checkNotNullParameter(actorsToMove, "actorsToMove");
            Intrinsics.checkNotNullParameter(movementVector, "movementVector");
            this.actorsToMove = actorsToMove;
            this.movementVector = movementVector;
            this.setDuration(0.3f);
            this.setInterpolation(Interpolation.sine);
        }

        @Override
        protected void updateRelative(float percentDelta) {
            for (Actor actor : this.actorsToMove) {
                actor.moveBy(this.movementVector.x * percentDelta, this.movementVector.y * percentDelta);
            }
        }
    }
}

