/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArraySupplier;
import com.badlogic.gdx.utils.Null;
import java.util.Arrays;
import java.util.Comparator;

public class SnapshotArray<T>
extends Array<T> {
    private T[] snapshot;
    private T[] recycled;
    private int snapshots;

    public SnapshotArray() {
    }

    public SnapshotArray(Array array) {
        super(array);
    }

    public SnapshotArray(boolean ordered, int capacity, ArraySupplier<T[]> arraySupplier) {
        super(ordered, capacity, arraySupplier);
    }

    @Deprecated
    public SnapshotArray(boolean ordered, int capacity, Class arrayType) {
        super(ordered, capacity, arrayType);
    }

    public SnapshotArray(boolean ordered, int capacity) {
        super(ordered, capacity);
    }

    public SnapshotArray(boolean ordered, T[] array, int startIndex, int count2) {
        super(ordered, array, startIndex, count2);
    }

    public SnapshotArray(ArraySupplier<T[]> arraySupplier) {
        super(arraySupplier);
    }

    @Deprecated
    public SnapshotArray(Class arrayType) {
        super(arrayType);
    }

    public SnapshotArray(int capacity) {
        super(capacity);
    }

    public SnapshotArray(T[] array) {
        super(array);
    }

    public T[] begin() {
        this.modified();
        this.snapshot = this.items;
        ++this.snapshots;
        return this.items;
    }

    public void end() {
        this.snapshots = Math.max(0, this.snapshots - 1);
        if (this.snapshot == null) {
            return;
        }
        if (this.snapshot != this.items && this.snapshots == 0) {
            this.recycled = this.snapshot;
            Arrays.fill(this.recycled, null);
        }
        this.snapshot = null;
    }

    private void modified() {
        if (this.snapshot == null || this.snapshot != this.items) {
            return;
        }
        if (this.recycled != null && this.recycled.length >= this.size) {
            System.arraycopy(this.items, 0, this.recycled, 0, this.size);
            this.items = this.recycled;
            this.recycled = null;
        } else {
            this.resize(this.items.length);
        }
    }

    @Override
    public void set(int index, T value) {
        this.modified();
        super.set(index, value);
    }

    @Override
    public void insert(int index, T value) {
        this.modified();
        super.insert(index, value);
    }

    @Override
    public void insertRange(int index, int count2) {
        this.modified();
        super.insertRange(index, count2);
    }

    @Override
    public void swap(int first2, int second2) {
        this.modified();
        super.swap(first2, second2);
    }

    @Override
    public boolean replaceFirst(@Null T value, boolean identity, T replacement) {
        this.modified();
        return super.replaceFirst(value, identity, replacement);
    }

    @Override
    public int replaceAll(@Null T value, boolean identity, @Null T replacement) {
        this.modified();
        return super.replaceAll(value, identity, replacement);
    }

    @Override
    public boolean removeValue(T value, boolean identity) {
        this.modified();
        return super.removeValue(value, identity);
    }

    @Override
    public T removeIndex(int index) {
        this.modified();
        return super.removeIndex(index);
    }

    @Override
    public void removeRange(int start2, int end) {
        this.modified();
        super.removeRange(start2, end);
    }

    @Override
    public boolean removeAll(Array<? extends T> array, boolean identity) {
        this.modified();
        return super.removeAll(array, identity);
    }

    @Override
    public T pop() {
        this.modified();
        return super.pop();
    }

    @Override
    public void clear() {
        this.modified();
        super.clear();
    }

    @Override
    public void sort() {
        this.modified();
        super.sort();
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.modified();
        super.sort(comparator);
    }

    @Override
    public void reverse() {
        this.modified();
        super.reverse();
    }

    @Override
    public void shuffle() {
        this.modified();
        super.shuffle();
    }

    @Override
    public void truncate(int newSize) {
        this.modified();
        super.truncate(newSize);
    }

    @Override
    public T[] setSize(int newSize) {
        this.modified();
        return super.setSize(newSize);
    }

    public static <T> SnapshotArray<T> with(T ... array) {
        return new SnapshotArray<T>(array);
    }
}

