/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.TileMap;
import com.unciv.ui.screens.savescreens.Gzip;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0010J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\rJ\u0011\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\rJ\u0010\u0010!\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/unciv/logic/files/MapSaver;", "", "<init>", "()V", "mapsFolder", "", "saveZipped", "", "getSaveZipped", "()Z", "setSaveZipped", "(Z)V", "getMap", "Lcom/badlogic/gdx/files/FileHandle;", "mapName", "mapFromSavedString", "Lcom/unciv/logic/map/TileMap;", "mapString", "mapToSavedString", "tileMap", "saveMap", "", "loadMap", "mapFile", "getMaps", "", "()[Lcom/badlogic/gdx/files/FileHandle;", "mapFromJson", "json", "loadMapParameters", "Lcom/unciv/logic/map/MapParameters;", "loadMapPreview", "Lcom/unciv/logic/map/TileMap$Preview;", "mapPreviewFromSavedString", "core"})
public final class MapSaver {
    @NotNull
    public static final MapSaver INSTANCE = new MapSaver();
    @NotNull
    public static final String mapsFolder = "maps";
    private static boolean saveZipped = true;

    private MapSaver() {
    }

    public final boolean getSaveZipped() {
        return saveZipped;
    }

    public final void setSaveZipped(boolean bl) {
        saveZipped = bl;
    }

    private final FileHandle getMap(String mapName) {
        return UncivGame.Companion.getCurrent().getFiles().getLocalFile("maps/" + mapName);
    }

    @NotNull
    public final TileMap mapFromSavedString(@NotNull String mapString) {
        String string;
        Intrinsics.checkNotNullParameter(mapString, "mapString");
        try {
            string = Gzip.INSTANCE.unzip(((Object)StringsKt.trim((CharSequence)mapString)).toString());
        }
        catch (Exception exception2) {
            string = mapString;
        }
        String unzippedJson = string;
        return this.mapFromJson(unzippedJson);
    }

    @NotNull
    public final String mapToSavedString(@NotNull TileMap tileMap) {
        String string;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        tileMap.assignContinents(TileMap.AssignContinentsMode.Reassign);
        String mapJson = UncivJsonKt.json().toJson(tileMap);
        if (saveZipped) {
            Intrinsics.checkNotNull(mapJson);
            string = Gzip.INSTANCE.zip(mapJson);
        } else {
            Intrinsics.checkNotNull(mapJson);
            string = mapJson;
        }
        return string;
    }

    public final void saveMap(@NotNull String mapName, @NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(mapName, "mapName");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        this.getMap(mapName).writeString(this.mapToSavedString(tileMap), false, Charsets.UTF_8.name());
    }

    @NotNull
    public final TileMap loadMap(@NotNull FileHandle mapFile) {
        Intrinsics.checkNotNullParameter(mapFile, "mapFile");
        String string = mapFile.readString(Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        return this.mapFromSavedString(string);
    }

    @NotNull
    public final FileHandle[] getMaps() {
        FileHandle[] fileHandleArray = UncivGame.Companion.getCurrent().getFiles().getLocalFile(mapsFolder).list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        return fileHandleArray;
    }

    private final TileMap mapFromJson(String json) {
        TileMap tileMap = UncivJsonKt.json().fromJson(TileMap.class, json);
        Intrinsics.checkNotNullExpressionValue(tileMap, "fromJson(...)");
        return tileMap;
    }

    @NotNull
    public final MapParameters loadMapParameters(@NotNull FileHandle mapFile) {
        Intrinsics.checkNotNullParameter(mapFile, "mapFile");
        return this.loadMapPreview(mapFile).getMapParameters();
    }

    @NotNull
    public final TileMap.Preview loadMapPreview(@NotNull FileHandle mapFile) {
        Intrinsics.checkNotNullParameter(mapFile, "mapFile");
        String string = mapFile.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        return this.mapPreviewFromSavedString(string);
    }

    private final TileMap.Preview mapPreviewFromSavedString(String mapString) {
        String string;
        try {
            string = Gzip.INSTANCE.unzip(((Object)StringsKt.trim((CharSequence)mapString)).toString());
        }
        catch (Exception exception2) {
            string = mapString;
        }
        String unzippedJson = string;
        TileMap.Preview preview = UncivJsonKt.json().fromJson(TileMap.Preview.class, unzippedJson);
        Intrinsics.checkNotNullExpressionValue(preview, "fromJson(...)");
        return preview;
    }
}

