/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.GlobalUniques;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.RulesetFile;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.stats.GameResource;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.SubStat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0007\u0010\u008b\u0001\u001a\u00020\u0000J\u0013\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u00012\u0007\u0010\u008e\u0001\u001a\u00020\u000bJM\u0010\u008f\u0001\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0005\u0012\u0003H\u0090\u00010\u0016j\u000f\u0012\u0004\u0012\u00020\u000b\u0012\u0005\u0012\u0003H\u0090\u0001`\u0018\"\f\b\u0000\u0010\u0090\u0001\u0018\u0001*\u00030\u0091\u00012\u000f\u0010\u0092\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0090\u00010\u0093\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u0094\u0001J\u0011\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u0000J\b\u0010\u0098\u0001\u001a\u00030\u0096\u0001J\u0011\u0010\u0099\u0001\u001a\n\u0012\u0005\u0012\u00030\u009b\u00010\u009a\u0001H\u0007J\u0011\u0010\u009c\u0001\u001a\n\u0012\u0005\u0012\u00030\u009d\u00010\u009a\u0001H\u0007J\u0011\u0010\u009e\u0001\u001a\n\u0012\u0005\u0012\u00030\u009f\u00010\u009a\u0001H\u0007J\u0011\u0010\u00a0\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u00a1\u0001\u001a\u00020\u0005J\u0010\u0010\u00a2\u0001\u001a\u00030\u0096\u0001H\u0000\u00a2\u0006\u0003\b\u00a3\u0001J\u0010\u0010\u00a4\u0001\u001a\u00030\u0096\u0001H\u0000\u00a2\u0006\u0003\b\u00a5\u0001J&\u0010\u00a6\u0001\u001a\u00030\u0096\u00012\u0014\u0010\u00a7\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0093\u0001\"\u00020\u000bH\u0007\u00a2\u0006\u0003\u0010\u00a8\u0001J\t\u0010\u00a9\u0001\u001a\u00020\u000bH\u0016J\t\u0010\u00aa\u0001\u001a\u00020\u000bH\u0007J\u0014\u0010\u00ab\u0001\u001a\u00030\u00ac\u00012\n\b\u0002\u0010\u00ad\u0001\u001a\u00030\u00ae\u0001R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0011j\b\u0012\u0004\u0012\u00020\u000b`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R-\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0017`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR-\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001c`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR-\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001f0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001f`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR-\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\"0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\"`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR-\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020%`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u001a\u0010'\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R-\u0010-\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020.0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020.`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001aR-\u00100\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002010\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u000201`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001aR-\u00103\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002040\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u000204`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001aR!\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u000b07j\b\u0012\u0004\u0012\u00020\u000b`8\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R-\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020<0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020<`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u001aR-\u0010>\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020?0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020?`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001aR-\u0010A\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020B0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020B`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001aR-\u0010D\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020E0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020E`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u001aR!\u0010G\u001a\u0012\u0012\u0004\u0012\u00020H07j\b\u0012\u0004\u0012\u00020H`8\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010:R-\u0010J\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020K0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020K`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u001aR-\u0010M\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020N0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020N`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u001aR-\u0010P\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Q0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Q`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u001aR-\u0010S\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020T0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020T`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u001aR-\u0010V\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020W0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020W`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u001aR-\u0010Y\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Z0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020Z`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u001aR6\u0010\\\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020]0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020]`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010\u001a\"\u0004\b_\u0010`R6\u0010a\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020b0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020b`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010\u001a\"\u0004\bd\u0010`R-\u0010e\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020f0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020f`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\u001aR-\u0010h\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020i0\u0016j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020i`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\u001aR\u001a\u0010k\u001a\u00020lX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR&\u0010q\u001a\r\u0012\t\u0012\u00070T\u00a2\u0006\u0002\bs0r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bv\u0010w\u001a\u0004\bt\u0010uR&\u0010x\u001a\r\u0012\t\u0012\u00070N\u00a2\u0006\u0002\bs0r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bz\u0010w\u001a\u0004\by\u0010uR&\u0010{\u001a\r\u0012\t\u0012\u00070N\u00a2\u0006\u0002\bs0r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b}\u0010w\u001a\u0004\b|\u0010uR%\u0010~\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010\u007f8FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0083\u0001\u0010w\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R!\u0010\u0084\u0001\u001a\u0004\u0018\u00010N8FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u0087\u0001\u0010w\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001R!\u0010\u0088\u0001\u001a\u0004\u0018\u00010N8FX\u0086\u0084\u0002\u00a2\u0006\u000f\n\u0005\b\u008a\u0001\u0010w\u001a\u0006\b\u0089\u0001\u0010\u0086\u0001\u00a8\u0006\u00af\u0001\u00b2\u0006\u000b\u0010\u00b0\u0001\u001a\u00020\u0000X\u008a\u0084\u0002"}, d2={"Lcom/unciv/models/ruleset/Ruleset;", "", "<init>", "()V", "folderLocation", "Lcom/badlogic/gdx/files/FileHandle;", "getFolderLocation", "()Lcom/badlogic/gdx/files/FileHandle;", "setFolderLocation", "(Lcom/badlogic/gdx/files/FileHandle;)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "mods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getMods", "()Ljava/util/LinkedHashSet;", "beliefs", "Ljava/util/LinkedHashMap;", "Lcom/unciv/models/ruleset/Belief;", "Lkotlin/collections/LinkedHashMap;", "getBeliefs", "()Ljava/util/LinkedHashMap;", "buildings", "Lcom/unciv/models/ruleset/Building;", "getBuildings", "difficulties", "Lcom/unciv/models/ruleset/nation/Difficulty;", "getDifficulties", "eras", "Lcom/unciv/models/ruleset/tech/Era;", "getEras", "speeds", "Lcom/unciv/models/ruleset/Speed;", "getSpeeds", "globalUniques", "Lcom/unciv/models/ruleset/GlobalUniques;", "getGlobalUniques$core", "()Lcom/unciv/models/ruleset/GlobalUniques;", "setGlobalUniques$core", "(Lcom/unciv/models/ruleset/GlobalUniques;)V", "nations", "Lcom/unciv/models/ruleset/nation/Nation;", "getNations", "policies", "Lcom/unciv/models/ruleset/Policy;", "getPolicies", "policyBranches", "Lcom/unciv/models/ruleset/PolicyBranch;", "getPolicyBranches", "religions", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getReligions", "()Ljava/util/ArrayList;", "ruinRewards", "Lcom/unciv/models/ruleset/RuinReward;", "getRuinRewards", "quests", "Lcom/unciv/models/ruleset/Quest;", "getQuests", "specialists", "Lcom/unciv/models/ruleset/Specialist;", "getSpecialists", "technologies", "Lcom/unciv/models/ruleset/tech/Technology;", "getTechnologies", "techColumns", "Lcom/unciv/models/ruleset/tech/TechColumn;", "getTechColumns", "terrains", "Lcom/unciv/models/ruleset/tile/Terrain;", "getTerrains", "tileImprovements", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "getTileImprovements", "tileResources", "Lcom/unciv/models/ruleset/tile/TileResource;", "getTileResources", "units", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getUnits", "unitPromotions", "Lcom/unciv/models/ruleset/unit/Promotion;", "getUnitPromotions", "unitTypes", "Lcom/unciv/models/ruleset/unit/UnitType;", "getUnitTypes", "victories", "Lcom/unciv/models/ruleset/Victory;", "getVictories", "setVictories", "(Ljava/util/LinkedHashMap;)V", "cityStateTypes", "Lcom/unciv/models/ruleset/nation/CityStateType;", "getCityStateTypes", "setCityStateTypes", "personalities", "Lcom/unciv/models/ruleset/nation/Personality;", "getPersonalities", "events", "Lcom/unciv/models/ruleset/Event;", "getEvents", "modOptions", "Lcom/unciv/models/ruleset/ModOptions;", "getModOptions", "()Lcom/unciv/models/ruleset/ModOptions;", "setModOptions", "(Lcom/unciv/models/ruleset/ModOptions;)V", "greatGeneralUnits", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getGreatGeneralUnits", "()Ljava/util/List;", "greatGeneralUnits$delegate", "Lkotlin/Lazy;", "tileRemovals", "getTileRemovals", "tileRemovals$delegate", "nonRoadTileRemovals", "getNonRoadTileRemovals", "nonRoadTileRemovals$delegate", "allHappinessLevelsThatAffectUniques", "", "", "getAllHappinessLevelsThatAffectUniques", "()Ljava/util/Set;", "allHappinessLevelsThatAffectUniques$delegate", "roadImprovement", "getRoadImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "roadImprovement$delegate", "railroadImprovement", "getRailroadImprovement", "railroadImprovement$delegate", "clone", "getGameResource", "Lcom/unciv/models/stats/GameResource;", "resourceName", "createHashmap", "T", "Lcom/unciv/models/stats/INamed;", "items", "", "([Lcom/unciv/models/stats/INamed;)Ljava/util/LinkedHashMap;", "add", "", "ruleset", "clear", "allRulesetObjects", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/IRulesetObject;", "allUniques", "Lcom/unciv/models/ruleset/unique/Unique;", "allICivilopediaText", "Lcom/unciv/ui/screens/civilopediascreen/ICivilopediaText;", "load", "folderHandle", "updateBuildingCosts", "updateBuildingCosts$core", "updateResourceTransients", "updateResourceTransients$core", "addGlobalUniques", "uniques", "([Ljava/lang/String;)V", "toString", "getSummary", "getErrorList", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "tryFixUnknownUniques", "", "core", "fallbackRuleset"})
@SourceDebugExtension(value={"SMAP\nRuleset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ruleset.kt\ncom/unciv/models/ruleset/Ruleset\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,564:1\n172#1,11:662\n172#1,11:673\n172#1,11:684\n172#1,11:695\n172#1,11:706\n172#1,11:723\n172#1,11:734\n172#1,11:745\n172#1,11:756\n172#1,11:767\n172#1,11:778\n172#1,11:789\n172#1,11:802\n172#1,11:813\n172#1,11:824\n172#1,11:835\n172#1,11:846\n172#1,11:857\n172#1,11:868\n172#1,11:879\n1374#2:565\n1460#2,2:566\n1462#2,3:575\n1869#2,2:578\n1374#2:580\n1460#2,2:581\n1462#2,3:590\n1869#2,2:593\n1374#2:595\n1460#2,2:596\n1462#2,3:605\n1869#2,2:608\n1374#2:610\n1460#2,2:611\n1462#2,3:620\n1869#2,2:623\n1374#2:625\n1460#2,2:626\n1462#2,3:635\n1869#2,2:638\n1374#2:640\n1460#2,2:641\n1462#2,3:651\n1869#2,2:654\n1374#2:656\n1460#2,5:657\n1869#2,2:721\n295#2,2:800\n774#2:890\n865#2,2:891\n774#2:893\n865#2,2:894\n774#2:898\n865#2,2:899\n774#2:901\n865#2,2:902\n774#2:904\n865#2:905\n866#2:910\n536#3:568\n521#3,6:569\n536#3:583\n521#3,6:584\n536#3:598\n521#3,6:599\n536#3:613\n521#3,6:614\n536#3:628\n521#3,6:629\n536#3:643\n521#3,2:644\n523#3,4:647\n1#4:646\n126#5:717\n153#5,3:718\n1255#6,2:896\n37#7,2:906\n19985#8,2:908\n*S KotlinDebug\n*F\n+ 1 Ruleset.kt\ncom/unciv/models/ruleset/Ruleset\n*L\n327#1:662,11\n331#1:673,11\n339#1:684,11\n342#1:695,11\n345#1:706,11\n353#1:723,11\n357#1:734,11\n360#1:745,11\n363#1:756,11\n366#1:767,11\n369#1:778,11\n373#1:789,11\n418#1:802,11\n426#1:813,11\n430#1:824,11\n436#1:835,11\n446#1:846,11\n451#1:857,11\n456#1:868,11\n461#1:879,11\n188#1:565\n188#1:566,2\n188#1:575,3\n190#1:578,2\n199#1:580\n199#1:581,2\n199#1:590,3\n201#1:593,2\n206#1:595\n206#1:596,2\n206#1:605,3\n208#1:608,2\n216#1:610\n216#1:611,2\n216#1:620,3\n218#1:623,2\n234#1:625\n234#1:626,2\n234#1:635,3\n236#1:638,2\n248#1:640\n248#1:641,2\n248#1:651,3\n250#1:654,2\n297#1:656\n297#1:657,5\n349#1:721,2\n398#1:800,2\n492#1:890\n492#1:891,2\n500#1:893\n500#1:894,2\n128#1:898\n128#1:899,2\n131#1:901\n131#1:902,2\n132#1:904\n132#1:905\n132#1:910\n189#1:568\n189#1:569,6\n200#1:583\n200#1:584,6\n207#1:598\n207#1:599,6\n217#1:613\n217#1:614,6\n235#1:628\n235#1:629,6\n249#1:643\n249#1:644,2\n249#1:647,4\n349#1:717\n349#1:718,3\n522#1:896,2\n133#1:906,2\n133#1:908,2\n*E\n"})
public final class Ruleset {
    @Nullable
    private FileHandle folderLocation;
    @NotNull
    private String name = "";
    @NotNull
    private final LinkedHashSet<String> mods = new LinkedHashSet();
    @NotNull
    private final LinkedHashMap<String, Belief> beliefs = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Building> buildings = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Difficulty> difficulties = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Era> eras = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Speed> speeds = new LinkedHashMap();
    @NotNull
    private GlobalUniques globalUniques = new GlobalUniques();
    @NotNull
    private final LinkedHashMap<String, Nation> nations = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Policy> policies = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, PolicyBranch> policyBranches = new LinkedHashMap();
    @NotNull
    private final ArrayList<String> religions = new ArrayList();
    @NotNull
    private final LinkedHashMap<String, RuinReward> ruinRewards = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Quest> quests = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Specialist> specialists = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Technology> technologies = new LinkedHashMap();
    @NotNull
    private final ArrayList<TechColumn> techColumns = new ArrayList();
    @NotNull
    private final LinkedHashMap<String, Terrain> terrains = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, TileImprovement> tileImprovements = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, TileResource> tileResources = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, BaseUnit> units = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Promotion> unitPromotions = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, UnitType> unitTypes = new LinkedHashMap();
    @NotNull
    private LinkedHashMap<String, Victory> victories = new LinkedHashMap();
    @NotNull
    private LinkedHashMap<String, CityStateType> cityStateTypes = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Personality> personalities = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, Event> events = new LinkedHashMap();
    @NotNull
    private ModOptions modOptions = new ModOptions();
    @NotNull
    private final Lazy greatGeneralUnits$delegate = LazyKt.lazy(() -> Ruleset.greatGeneralUnits_delegate$lambda$0(this));
    @NotNull
    private final Lazy tileRemovals$delegate = LazyKt.lazy(() -> Ruleset.tileRemovals_delegate$lambda$0(this));
    @NotNull
    private final Lazy nonRoadTileRemovals$delegate = LazyKt.lazy(() -> Ruleset.nonRoadTileRemovals_delegate$lambda$0(this));
    @NotNull
    private final Lazy allHappinessLevelsThatAffectUniques$delegate = LazyKt.lazy(() -> Ruleset.allHappinessLevelsThatAffectUniques_delegate$lambda$0(this));
    @NotNull
    private final Lazy roadImprovement$delegate = LazyKt.lazy(() -> Ruleset.roadImprovement_delegate$lambda$0(this));
    @NotNull
    private final Lazy railroadImprovement$delegate = LazyKt.lazy(() -> Ruleset.railroadImprovement_delegate$lambda$0(this));

    @Nullable
    public final FileHandle getFolderLocation() {
        return this.folderLocation;
    }

    public final void setFolderLocation(@Nullable FileHandle fileHandle) {
        this.folderLocation = fileHandle;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final LinkedHashSet<String> getMods() {
        return this.mods;
    }

    @NotNull
    public final LinkedHashMap<String, Belief> getBeliefs() {
        return this.beliefs;
    }

    @NotNull
    public final LinkedHashMap<String, Building> getBuildings() {
        return this.buildings;
    }

    @NotNull
    public final LinkedHashMap<String, Difficulty> getDifficulties() {
        return this.difficulties;
    }

    @NotNull
    public final LinkedHashMap<String, Era> getEras() {
        return this.eras;
    }

    @NotNull
    public final LinkedHashMap<String, Speed> getSpeeds() {
        return this.speeds;
    }

    @NotNull
    public final GlobalUniques getGlobalUniques$core() {
        return this.globalUniques;
    }

    public final void setGlobalUniques$core(@NotNull GlobalUniques globalUniques) {
        Intrinsics.checkNotNullParameter(globalUniques, "<set-?>");
        this.globalUniques = globalUniques;
    }

    @NotNull
    public final LinkedHashMap<String, Nation> getNations() {
        return this.nations;
    }

    @NotNull
    public final LinkedHashMap<String, Policy> getPolicies() {
        return this.policies;
    }

    @NotNull
    public final LinkedHashMap<String, PolicyBranch> getPolicyBranches() {
        return this.policyBranches;
    }

    @NotNull
    public final ArrayList<String> getReligions() {
        return this.religions;
    }

    @NotNull
    public final LinkedHashMap<String, RuinReward> getRuinRewards() {
        return this.ruinRewards;
    }

    @NotNull
    public final LinkedHashMap<String, Quest> getQuests() {
        return this.quests;
    }

    @NotNull
    public final LinkedHashMap<String, Specialist> getSpecialists() {
        return this.specialists;
    }

    @NotNull
    public final LinkedHashMap<String, Technology> getTechnologies() {
        return this.technologies;
    }

    @NotNull
    public final ArrayList<TechColumn> getTechColumns() {
        return this.techColumns;
    }

    @NotNull
    public final LinkedHashMap<String, Terrain> getTerrains() {
        return this.terrains;
    }

    @NotNull
    public final LinkedHashMap<String, TileImprovement> getTileImprovements() {
        return this.tileImprovements;
    }

    @NotNull
    public final LinkedHashMap<String, TileResource> getTileResources() {
        return this.tileResources;
    }

    @NotNull
    public final LinkedHashMap<String, BaseUnit> getUnits() {
        return this.units;
    }

    @NotNull
    public final LinkedHashMap<String, Promotion> getUnitPromotions() {
        return this.unitPromotions;
    }

    @NotNull
    public final LinkedHashMap<String, UnitType> getUnitTypes() {
        return this.unitTypes;
    }

    @NotNull
    public final LinkedHashMap<String, Victory> getVictories() {
        return this.victories;
    }

    public final void setVictories(@NotNull LinkedHashMap<String, Victory> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.victories = linkedHashMap;
    }

    @NotNull
    public final LinkedHashMap<String, CityStateType> getCityStateTypes() {
        return this.cityStateTypes;
    }

    public final void setCityStateTypes(@NotNull LinkedHashMap<String, CityStateType> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.cityStateTypes = linkedHashMap;
    }

    @NotNull
    public final LinkedHashMap<String, Personality> getPersonalities() {
        return this.personalities;
    }

    @NotNull
    public final LinkedHashMap<String, Event> getEvents() {
        return this.events;
    }

    @NotNull
    public final ModOptions getModOptions() {
        return this.modOptions;
    }

    public final void setModOptions(@NotNull ModOptions modOptions) {
        Intrinsics.checkNotNullParameter(modOptions, "<set-?>");
        this.modOptions = modOptions;
    }

    @NotNull
    public final List<BaseUnit> getGreatGeneralUnits() {
        Lazy lazy = this.greatGeneralUnits$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<TileImprovement> getTileRemovals() {
        Lazy lazy = this.tileRemovals$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<TileImprovement> getNonRoadTileRemovals() {
        Lazy lazy = this.nonRoadTileRemovals$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Set<Integer> getAllHappinessLevelsThatAffectUniques() {
        Lazy lazy = this.allHappinessLevelsThatAffectUniques$delegate;
        return (Set)lazy.getValue();
    }

    @Nullable
    public final TileImprovement getRoadImprovement() {
        Lazy lazy = this.roadImprovement$delegate;
        return (TileImprovement)lazy.getValue();
    }

    @Nullable
    public final TileImprovement getRailroadImprovement() {
        Lazy lazy = this.railroadImprovement$delegate;
        return (TileImprovement)lazy.getValue();
    }

    @NotNull
    public final Ruleset clone() {
        Ruleset newRuleset = new Ruleset();
        newRuleset.add(this);
        newRuleset.name = this.name;
        newRuleset.modOptions.setBaseRuleset(this.modOptions.isBaseRuleset());
        return newRuleset;
    }

    @Nullable
    public final GameResource getGameResource(@NotNull String resourceName) {
        GameResource gameResource;
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Stat stat = Stat.Companion.safeValueOf(resourceName);
        if (stat != null) {
            gameResource = stat;
        } else {
            SubStat subStat = SubStat.Companion.safeValueOf(resourceName);
            gameResource = subStat != null ? (GameResource)subStat : (GameResource)this.tileResources.get(resourceName);
        }
        return gameResource;
    }

    private final /* synthetic */ <T extends INamed> LinkedHashMap<String, T> createHashmap(T[] items) {
        boolean $i$f$createHashmap = false;
        LinkedHashMap hashMap = new LinkedHashMap(items.length);
        for (T item : items) {
            String string;
            try {
                string = item.getName();
            }
            catch (Exception ex) {
                StringBuilder stringBuilder = new StringBuilder();
                Intrinsics.reifiedOperationMarker(4, "T");
                throw new Exception(stringBuilder.append(Reflection.getOrCreateKotlinClass(INamed.class).getSimpleName()).append(" is missing a name!").toString());
            }
            String itemName = string;
            ((Map)hashMap).put(itemName, item);
            IRulesetObject iRulesetObject = item instanceof IRulesetObject ? (IRulesetObject)item : null;
            if (iRulesetObject == null) continue;
            iRulesetObject.setOriginRuleset(this.name);
        }
        return hashMap;
    }

    public final void add(@NotNull Ruleset ruleset) {
        Object element$iv$iv;
        Object element$iv;
        Iterable list$iv$iv;
        Map.Entry it;
        Map.Entry element$iv$iv2;
        Iterator iterator2;
        Map $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Map destination$iv$iv;
        boolean $i$f$filter;
        Map $this$filter$iv;
        Object $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.beliefs.putAll((Map<String, Belief>)ruleset.beliefs);
        Iterable $this$flatMap$iv = ruleset.modOptions.getBuildingsToRemove();
        boolean $i$f$flatMap = false;
        Object object = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator3 = $this$flatMapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv$iv22 = iterator3.next();
            String buildingToRemove = (String)element$iv$iv22;
            boolean bl = false;
            $this$filter$iv = this.buildings;
            $i$f$filter = false;
            Map map2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv2 = iterator2.next();
                boolean bl2 = false;
                if (!Building.matchesFilter$default((Building)it.getValue(), buildingToRemove, null, 2, null)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        Object $this$forEach$iv = (IHasUniques[])CollectionsKt.toSet((List)destination$iv$iv2);
        boolean $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            element$iv = $this$flatMapTo$iv$iv.next();
            String it2 = (String)element$iv;
            boolean bl = false;
            this.buildings.remove(it2);
        }
        this.buildings.putAll((Map<String, Building>)ruleset.buildings);
        this.difficulties.putAll((Map<String, Difficulty>)ruleset.difficulties);
        this.eras.putAll((Map<String, Era>)ruleset.eras);
        this.speeds.putAll((Map<String, Speed>)ruleset.speeds);
        $this$forEach$iv = new IHasUniques[]{ruleset.globalUniques};
        this.globalUniques = GlobalUniques.Companion.combine(this.globalUniques, (IHasUniques[])$this$forEach$iv);
        $this$flatMap$iv = ruleset.modOptions.getNationsToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            String nationToRemove = (String)element$iv$iv;
            boolean bl3 = false;
            $this$filter$iv = this.nations;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv2 = iterator2.next();
                boolean bl4 = false;
                if (!Nation.matchesFilter$default((Nation)it.getValue(), nationToRemove, null, false, 6, null)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)destination$iv$iv3);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            element$iv = $this$flatMapTo$iv$iv.next();
            String it3 = (String)element$iv;
            boolean bl5 = false;
            this.nations.remove(it3);
        }
        this.nations.putAll((Map<String, Nation>)ruleset.nations);
        $this$flatMap$iv = ruleset.modOptions.getPolicyBranchesToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl5 = $this$flatMapTo$iv$iv.iterator();
        while (bl5.hasNext()) {
            element$iv$iv = bl5.next();
            String policyBranchToRemove = (String)element$iv$iv;
            boolean bl6 = false;
            $this$filter$iv = this.policyBranches;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv2 = iterator2.next();
                boolean bl7 = false;
                if (!Policy.matchesFilter$default((Policy)it.getValue(), policyBranchToRemove, null, 2, null)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)destination$iv$iv3);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            element$iv = $this$flatMapTo$iv$iv.next();
            String it4 = (String)element$iv;
            boolean bl8 = false;
            this.policyBranches.remove(it4);
        }
        this.policyBranches.putAll((Map<String, PolicyBranch>)ruleset.policyBranches);
        this.policies.putAll((Map<String, Policy>)ruleset.policies);
        $this$flatMap$iv = ruleset.modOptions.getPoliciesToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl8 = $this$flatMapTo$iv$iv.iterator();
        while (bl8.hasNext()) {
            element$iv$iv = bl8.next();
            String policyToRemove = (String)element$iv$iv;
            boolean bl9 = false;
            $this$filter$iv = this.policies;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv2 = iterator2.next();
                boolean bl10 = false;
                if (!Policy.matchesFilter$default((Policy)it.getValue(), policyToRemove, null, 2, null)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)destination$iv$iv3);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            element$iv = $this$flatMapTo$iv$iv.next();
            String it5 = (String)element$iv;
            boolean bl11 = false;
            this.policies.remove(it5);
        }
        Iterator<String> iterator4 = ruleset.modOptions.getPoliciesToRemove().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        $this$forEach$iv = iterator4;
        while ($this$forEach$iv.hasNext()) {
            Object e = $this$forEach$iv.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            String policyToRemove = (String)e;
            for (Object object2 : this.policyBranches.values()) {
                Intrinsics.checkNotNullExpressionValue(object2, "next(...)");
                PolicyBranch branch = (PolicyBranch)object2;
                CollectionsKt.removeAll((List)branch.getPolicies(), arg_0 -> Ruleset.add$lambda$8(policyToRemove, arg_0));
            }
        }
        this.quests.putAll((Map<String, Quest>)ruleset.quests);
        this.religions.addAll((Collection<String>)ruleset.religions);
        this.ruinRewards.putAll((Map<String, RuinReward>)ruleset.ruinRewards);
        this.specialists.putAll((Map<String, Specialist>)ruleset.specialists);
        $this$flatMap$iv = ruleset.modOptions.getTechsToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl11 = $this$flatMapTo$iv$iv.iterator();
        while (bl11.hasNext()) {
            element$iv$iv = bl11.next();
            String techToRemove = (String)element$iv$iv;
            boolean bl12 = false;
            $this$filter$iv = this.technologies;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv2 = iterator2.next();
                boolean bl13 = false;
                if (!Technology.matchesFilter$default((Technology)it.getValue(), techToRemove, null, false, 6, null)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)destination$iv$iv3);
        $i$f$forEach = false;
        $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            element$iv = $this$flatMapTo$iv$iv.next();
            String it6 = (String)element$iv;
            boolean bl14 = false;
            this.technologies.remove(it6);
        }
        this.technologies.putAll((Map<String, Technology>)ruleset.technologies);
        this.techColumns.addAll((Collection<TechColumn>)ruleset.techColumns);
        this.terrains.putAll((Map<String, Terrain>)ruleset.terrains);
        this.tileImprovements.putAll((Map<String, TileImprovement>)ruleset.tileImprovements);
        this.tileResources.putAll((Map<String, TileResource>)ruleset.tileResources);
        this.unitTypes.putAll((Map<String, UnitType>)ruleset.unitTypes);
        this.victories.putAll((Map<String, Victory>)ruleset.victories);
        this.cityStateTypes.putAll((Map<String, CityStateType>)ruleset.cityStateTypes);
        $this$flatMap$iv = ruleset.modOptions.getUnitsToRemove();
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$flatMapTo = false;
        Iterator bl14 = $this$flatMapTo$iv$iv.iterator();
        while (bl14.hasNext()) {
            element$iv$iv = bl14.next();
            String unitToRemove = (String)element$iv$iv;
            boolean bl15 = false;
            $this$filter$iv = this.units;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                it = element$iv$iv2 = iterator2.next();
                boolean bl16 = false;
                Map.Entry $this$add_u24lambda_u2411_u240_u240 = entry = it;
                boolean bl17 = false;
                ((BaseUnit)$this$add_u24lambda_u2411_u240_u240.getValue()).setRuleset(this);
                if (!BaseUnit.matchesFilter$default((BaseUnit)entry.getValue(), unitToRemove, null, false, 6, null)) continue;
                destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            list$iv$iv = destination$iv$iv.keySet();
            CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
        }
        $this$forEach$iv = CollectionsKt.toSet((List)destination$iv$iv3);
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            element$iv = object.next();
            String it7 = (String)element$iv;
            boolean bl18 = false;
            this.units.remove(it7);
        }
        this.units.putAll((Map<String, BaseUnit>)ruleset.units);
        this.personalities.putAll((Map<String, Personality>)ruleset.personalities);
        this.events.putAll((Map<String, Event>)ruleset.events);
        this.modOptions.getUniques().addAll((Collection<String>)ruleset.modOptions.getUniques());
        this.modOptions.getConstants().merge(ruleset.modOptions.getConstants());
        this.unitPromotions.putAll((Map<String, Promotion>)ruleset.unitPromotions);
        CollectionsKt.addAll((Collection)this.mods, (Iterable)ruleset.mods);
    }

    public final void clear() {
        this.beliefs.clear();
        this.buildings.clear();
        this.difficulties.clear();
        this.eras.clear();
        this.speeds.clear();
        this.globalUniques = new GlobalUniques();
        this.mods.clear();
        this.nations.clear();
        this.policies.clear();
        this.policyBranches.clear();
        this.quests.clear();
        this.religions.clear();
        this.ruinRewards.clear();
        this.specialists.clear();
        this.technologies.clear();
        this.techColumns.clear();
        this.terrains.clear();
        this.tileImprovements.clear();
        this.tileResources.clear();
        this.unitPromotions.clear();
        this.units.clear();
        this.unitTypes.clear();
        this.victories.clear();
        this.cityStateTypes.clear();
        this.personalities.clear();
        this.events.clear();
    }

    @Readonly
    @NotNull
    public final Sequence<IRulesetObject> allRulesetObjects() {
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)RulesetFile.getEntries()), arg_0 -> Ruleset.allRulesetObjects$lambda$0(this, arg_0));
    }

    @Readonly
    @NotNull
    public final Sequence<Unique> allUniques() {
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)RulesetFile.getEntries()), arg_0 -> Ruleset.allUniques$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final Sequence<ICivilopediaText> allICivilopediaText() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Sequence<IRulesetObject> sequence = this.allRulesetObjects();
        Collection<Event> collection = this.events.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        Sequence<IRulesetObject> sequence2 = sequence;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Event it = (Event)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getChoices();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return SequencesKt.plus(sequence2, (List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void load(@NotNull FileHandle folderHandle) {
        Object ex$iv202;
        FileHandle eventsFile;
        FileHandle personalitiesFile;
        FileHandle cityStateTypesFile;
        FileHandle fileHandle;
        FileHandle globalUniquesFile;
        String itemName$iv;
        FileHandle fileHandle2;
        FileHandle nationsFile;
        FileHandle fileHandle3;
        FileHandle religionsFile;
        String itemName$iv2;
        FileHandle fileHandle4;
        Object it;
        FileHandle policiesFile;
        FileHandle specialistsFile;
        FileHandle questsFile;
        FileHandle promotionsFile;
        FileHandle unitsFile;
        Map this_$iv;
        FileHandle unitTypesFile;
        Map this_$iv2;
        INamed[] items$iv;
        INamed[] $this$mapTo$iv$iv;
        FileHandle fileHandle5;
        FileHandle improvementsFile;
        FileHandle resourcesFile;
        Object terrain;
        FileHandle terrainsFile;
        INamed[] items$iv2;
        FileHandle buildingsFile;
        FileHandle techFile;
        Intrinsics.checkNotNullParameter(folderHandle, "folderHandle");
        FileHandle modOptionsFile = folderHandle.child("ModOptions.json");
        if (modOptionsFile.exists()) {
            try {
                Json json = UncivJsonKt.json();
                Intrinsics.checkNotNull(modOptionsFile);
                this.modOptions = UncivJsonKt.fromJsonFile(json, ModOptions.class, modOptionsFile);
                BackwardCompatibility.INSTANCE.updateDeprecations(this.modOptions);
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Failed to get modOptions from json file", ex);
            }
        }
        if ((techFile = folderHandle.child("Techs.json")).exists()) {
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(techFile);
            for (TechColumn techColumn : UncivJsonKt.fromJsonFile(json, TechColumn[].class, techFile)) {
                this.techColumns.add(techColumn);
                Iterator<Technology> iterator2 = techColumn.getTechs().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                Iterator<Technology> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Technology technology = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(technology, "next(...)");
                    Technology tech = technology;
                    if (tech.getCost() == 0) {
                        tech.setCost(techColumn.getTechCost());
                    }
                    tech.setColumn(techColumn);
                    tech.setOriginRuleset(this.name);
                    ((Map)this.technologies).put(tech.getName(), tech);
                }
            }
        }
        if ((buildingsFile = folderHandle.child("Buildings.json")).exists()) {
            Map this_$iv3;
            Map map2 = this.buildings;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(buildingsFile);
            items$iv2 = UncivJsonKt.fromJsonFile(json, Building[].class, buildingsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv2.length);
            for (INamed item$iv : items$iv2) {
                Unit unit;
                String string;
                try {
                    string = item$iv.getName();
                }
                catch (Exception ex$iv2) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Building.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv3 = string;
                ((Map)hashMap$iv).put(itemName$iv3, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv3)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv3 = hashMap$iv;
            map2.putAll(this_$iv3);
        }
        if ((terrainsFile = folderHandle.child("Terrains.json")).exists()) {
            Map this_$iv4;
            Map this_$iv3 = this.terrains;
            items$iv2 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(terrainsFile);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, Terrain[].class, terrainsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(iNamedArray.length);
            for (INamed item$iv : iNamedArray) {
                Unit unit;
                String ex$iv2;
                try {
                    ex$iv2 = item$iv.getName();
                }
                catch (Exception ex$iv3) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Terrain.class).getSimpleName() + " is missing a name!");
                }
                String string = ex$iv2;
                ((Map)hashMap$iv).put(string, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv4)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv4 = hashMap$iv;
            this_$iv3.putAll(this_$iv4);
            for (Object e : this.terrains.values()) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                terrain = (Terrain)e;
                ((RulesetStatsObject)terrain).setOriginRuleset(this.name);
                ((Terrain)terrain).setTransients();
            }
        }
        if ((resourcesFile = folderHandle.child("TileResources.json")).exists()) {
            terrain = this.tileResources;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(resourcesFile);
            INamed[] items$iv4 = UncivJsonKt.fromJsonFile(json, TileResource[].class, resourcesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv4.length);
            for (INamed item$iv : items$iv4) {
                Unit unit;
                String ex$iv3;
                try {
                    ex$iv3 = item$iv.getName();
                }
                catch (Exception exception2) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(TileResource.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv5 = ex$iv3;
                ((Map)hashMap$iv).put(itemName$iv5, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map2 = hashMap$iv;
            terrain.putAll(map2);
        }
        if ((improvementsFile = folderHandle.child("TileImprovements.json")).exists()) {
            Map this_$iv6;
            Map map3 = this.tileImprovements;
            INamed[] items$iv4 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(improvementsFile);
            INamed[] items$iv5 = UncivJsonKt.fromJsonFile(json, TileImprovement[].class, improvementsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv5.length);
            for (INamed item$iv : items$iv5) {
                Unit unit;
                String string;
                try {
                    string = item$iv.getName();
                }
                catch (Exception ex$iv5) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(TileImprovement.class).getSimpleName() + " is missing a name!");
                }
                String string2 = string;
                ((Map)hashMap$iv).put(string2, item$iv);
                IRulesetObject iRulesetObject = item$iv instanceof IRulesetObject ? (IRulesetObject)item$iv : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv6)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv6 = hashMap$iv;
            map3.putAll(this_$iv6);
        }
        if ((fileHandle5 = folderHandle.child("Eras.json")).exists()) {
            Map this_$iv7;
            Map this_$iv6 = this.eras;
            INamed[] items$iv5 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle5);
            INamed[] items$iv6 = UncivJsonKt.fromJsonFile(json, Era[].class, fileHandle5);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv6.length);
            for (INamed iNamed : items$iv6) {
                Unit unit;
                String ex$iv5;
                try {
                    ex$iv5 = iNamed.getName();
                }
                catch (Exception exception3) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Era.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv7 = ex$iv5;
                ((Map)hashMap$iv).put(itemName$iv7, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv7)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv7 = hashMap$iv;
            this_$iv6.putAll(this_$iv7);
        }
        Map $this$map$iv = this.eras;
        boolean $i$f$map = false;
        Map items$iv6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator item$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (item$iv.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = item$iv.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Era era = (Era)entry.getValue();
            collection.add(era);
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((List)destination$iv$iv);
        boolean $i$f$forEach22 = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            IndexedValue element$iv;
            IndexedValue it3 = element$iv = $this$mapTo$iv$iv.next();
            boolean bl = false;
            ((Era)it3.getValue()).setEraNumber(it3.getIndex());
        }
        FileHandle speedsFile = folderHandle.child("Speeds.json");
        if (speedsFile.exists()) {
            Map $i$f$forEach22 = this.speeds;
            $this$mapTo$iv$iv = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(speedsFile);
            items$iv = UncivJsonKt.fromJsonFile(json, Speed[].class, speedsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv.length);
            for (INamed item$iv2 : items$iv) {
                Unit unit;
                String string;
                try {
                    string = item$iv2.getName();
                }
                catch (Exception ex$iv7) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Speed.class).getSimpleName() + " is missing a name!");
                }
                String string3 = string;
                ((Map)hashMap$iv).put(string3, item$iv2);
                IRulesetObject iRulesetObject = item$iv2 instanceof IRulesetObject ? (IRulesetObject)item$iv2 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv2)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv2 = hashMap$iv;
            $i$f$forEach22.putAll(this_$iv2);
        }
        if ((unitTypesFile = folderHandle.child("UnitTypes.json")).exists()) {
            void var16_95;
            this_$iv2 = this.unitTypes;
            items$iv = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(unitTypesFile);
            INamed[] items$iv7 = UncivJsonKt.fromJsonFile(json, UnitType[].class, unitTypesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv7.length);
            boolean bl = false;
            int item$iv2 = items$iv7.length;
            while (var16_95 < item$iv2) {
                Unit unit;
                String ex$iv7;
                INamed iNamed = items$iv7[var16_95];
                try {
                    ex$iv7 = iNamed.getName();
                }
                catch (Exception exception4) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(UnitType.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv9 = ex$iv7;
                ((Map)hashMap$iv).put(itemName$iv9, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv)).name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var16_95;
            }
            this_$iv = hashMap$iv;
            this_$iv2.putAll(this_$iv);
        }
        if ((unitsFile = folderHandle.child("Units.json")).exists()) {
            Map this_$iv8;
            this_$iv = this.units;
            INamed[] items$iv7 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(unitsFile);
            INamed[] items$iv8 = UncivJsonKt.fromJsonFile(json, BaseUnit[].class, unitsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(items$iv8.length);
            for (INamed item$iv3 : items$iv8) {
                Unit unit;
                String string;
                try {
                    string = item$iv3.getName();
                }
                catch (Exception ex$iv9) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(BaseUnit.class).getSimpleName() + " is missing a name!");
                }
                String string4 = string;
                ((Map)linkedHashMap).put(string4, item$iv3);
                IRulesetObject iRulesetObject = item$iv3 instanceof IRulesetObject ? (IRulesetObject)item$iv3 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv8)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv8 = linkedHashMap;
            this_$iv.putAll(this_$iv8);
        }
        if ((promotionsFile = folderHandle.child("UnitPromotions.json")).exists()) {
            Map this_$iv9;
            void var18_124;
            Map this_$iv8 = this.unitPromotions;
            INamed[] items$iv8 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(promotionsFile);
            INamed[] items$iv9 = UncivJsonKt.fromJsonFile(json, Promotion[].class, promotionsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv9.length);
            boolean bl2 = false;
            int item$iv3 = items$iv9.length;
            while (var18_124 < item$iv3) {
                Unit unit;
                String ex$iv9;
                INamed iNamed = items$iv9[var18_124];
                try {
                    ex$iv9 = iNamed.getName();
                }
                catch (Exception exception5) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Promotion.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv11 = ex$iv9;
                ((Map)hashMap$iv).put(itemName$iv11, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv9)).name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var18_124;
            }
            this_$iv9 = hashMap$iv;
            this_$iv8.putAll(this_$iv9);
        }
        if ((questsFile = folderHandle.child("Quests.json")).exists()) {
            Map this_$iv10;
            Map this_$iv9 = this.quests;
            INamed[] items$iv9 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(questsFile);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, Quest[].class, questsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(iNamedArray.length);
            for (INamed item$iv4 : iNamedArray) {
                Unit unit;
                String string;
                try {
                    string = item$iv4.getName();
                }
                catch (Exception ex$iv11) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Quest.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv12 = string;
                ((Map)linkedHashMap).put(itemName$iv12, item$iv4);
                IRulesetObject iRulesetObject = item$iv4 instanceof IRulesetObject ? (IRulesetObject)item$iv4 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv10)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv10 = linkedHashMap;
            this_$iv9.putAll(this_$iv10);
        }
        if ((specialistsFile = folderHandle.child("Specialists.json")).exists()) {
            void var20_156;
            Map this_$iv10 = this.specialists;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(specialistsFile);
            INamed[] items$iv11 = UncivJsonKt.fromJsonFile(json, Specialist[].class, specialistsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv11.length);
            boolean bl3 = false;
            int item$iv4 = items$iv11.length;
            while (var20_156 < item$iv4) {
                Unit unit;
                String ex$iv11;
                INamed iNamed = items$iv11[var20_156];
                try {
                    ex$iv11 = iNamed.getName();
                }
                catch (Exception ex$iv12) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Specialist.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv13 = ex$iv11;
                ((Map)hashMap$iv).put(itemName$iv13, iNamed);
                IRulesetObject iRulesetObject = iNamed instanceof IRulesetObject ? (IRulesetObject)iNamed : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var20_156;
            }
            Map map4 = hashMap$iv;
            this_$iv10.putAll(map4);
        }
        if ((policiesFile = folderHandle.child("Policies.json")).exists()) {
            Map this_$iv12;
            Map map5 = this.policyBranches;
            INamed[] items$iv11 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(policiesFile);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, PolicyBranch[].class, policiesFile);
            boolean $i$f$createHashmap2 = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(iNamedArray.length);
            for (INamed item$iv5 : iNamedArray) {
                Unit unit;
                String ex$iv12;
                try {
                    ex$iv12 = item$iv5.getName();
                }
                catch (Exception ex$iv13) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(PolicyBranch.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv14 = ex$iv12;
                ((Map)linkedHashMap).put(itemName$iv14, item$iv5);
                IRulesetObject iRulesetObject = item$iv5 instanceof IRulesetObject ? (IRulesetObject)item$iv5 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv12)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv12 = linkedHashMap;
            map5.putAll(this_$iv12);
            for (PolicyBranch policyBranch : this.policyBranches.values()) {
                Intrinsics.checkNotNullExpressionValue(policyBranch, "next(...)");
                PolicyBranch branch = policyBranch;
                branch.setRequires(new ArrayList<String>());
                branch.setBranch(branch);
                for (Victory victory : this.victories.values()) {
                    Intrinsics.checkNotNullExpressionValue(victory, "next(...)");
                    Victory victoryType = victory;
                    if (branch.getPriorities().keySet().contains(victoryType.getName())) continue;
                    ((Map)branch.getPriorities()).put(victoryType.getName(), 0);
                }
                ((Map)this.policies).put(branch.getName(), branch);
                Iterator<Policy> victoryType = branch.getPolicies().iterator();
                Intrinsics.checkNotNullExpressionValue(victoryType, "iterator(...)");
                Iterator<Policy> iterator3 = victoryType;
                while (iterator3.hasNext()) {
                    Policy policy = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(policy, "next(...)");
                    Policy policy2 = policy;
                    policy2.setBranch(branch);
                    policy2.setOriginRuleset(this.name);
                    if (policy2.getRequires() == null) {
                        String[] stringArray = new String[]{branch.getName()};
                        policy2.setRequires(CollectionsKt.arrayListOf(stringArray));
                    }
                    if (!Intrinsics.areEqual(policy2, CollectionsKt.last((List)branch.getPolicies()))) {
                        Object v38;
                        block136: {
                            Collection<Policy> item$iv4 = this.policies.values();
                            Intrinsics.checkNotNullExpressionValue(item$iv4, "<get-values>(...)");
                            Iterable $this$firstOrNull$iv = item$iv4;
                            boolean bl = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (Policy)element$iv;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual(((Policy)it).getBranch().getName(), policy2.getBranch().getName()) && ((Policy)it).getColumn() == policy2.getColumn() && ((Policy)it).getRow() == policy2.getRow())) continue;
                                v38 = element$iv;
                                break block136;
                            }
                            v38 = null;
                        }
                        Policy policy3 = v38;
                        if (policy3 != null) {
                            this.policies.remove(policy3.getName());
                        }
                    }
                    ((Map)this.policies).put(policy2.getName(), policy2);
                }
                ((Policy)CollectionsKt.last((List)branch.getPolicies())).setName(branch.getName() + " Complete");
            }
        }
        if ((fileHandle4 = folderHandle.child("Beliefs.json")).exists()) {
            void var22_190;
            Map branch = this.beliefs;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle4);
            INamed[] items$iv13 = UncivJsonKt.fromJsonFile(json, Belief[].class, fileHandle4);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv13.length);
            boolean bl5 = false;
            int item$iv5 = items$iv13.length;
            while (var22_190 < item$iv5) {
                Unit unit;
                INamed item$iv6 = items$iv13[var22_190];
                try {
                    it = item$iv6.getName();
                }
                catch (Exception ex$iv14) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Belief.class).getSimpleName() + " is missing a name!");
                }
                itemName$iv2 = it;
                ((Map)hashMap$iv).put(itemName$iv2, item$iv6);
                IRulesetObject iRulesetObject = item$iv6 instanceof IRulesetObject ? (IRulesetObject)item$iv6 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var22_190;
            }
            Map map6 = hashMap$iv;
            branch.putAll(map6);
        }
        if ((religionsFile = folderHandle.child("Religions.json")).exists()) {
            Collection collection = this.religions;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(religionsFile);
            CollectionsKt.addAll(collection, (Iterable)ArraysKt.toList((Object[])UncivJsonKt.fromJsonFile(json, String[].class, religionsFile)));
        }
        if ((fileHandle3 = folderHandle.child("Ruins.json")).exists()) {
            Map items$iv13 = this.ruinRewards;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle3);
            INamed[] items$iv14 = UncivJsonKt.fromJsonFile(json, RuinReward[].class, fileHandle3);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv14.length);
            for (INamed item$iv7 : items$iv14) {
                Unit unit;
                try {
                    itemName$iv2 = item$iv7.getName();
                }
                catch (Exception ex$iv15) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(RuinReward.class).getSimpleName() + " is missing a name!");
                }
                String string = itemName$iv2;
                ((Map)hashMap$iv).put(string, item$iv7);
                IRulesetObject iRulesetObject = item$iv7 instanceof IRulesetObject ? (IRulesetObject)item$iv7 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map7 = hashMap$iv;
            items$iv13.putAll(map7);
        }
        if ((nationsFile = folderHandle.child("Nations.json")).exists()) {
            Map this_$iv15;
            Map map8 = this.nations;
            INamed[] items$iv14 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(nationsFile);
            INamed[] iNamedArray = UncivJsonKt.fromJsonFile(json, Nation[].class, nationsFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(iNamedArray.length);
            for (INamed item$iv8 : iNamedArray) {
                Unit unit;
                String ex$iv15;
                try {
                    ex$iv15 = item$iv8.getName();
                }
                catch (Exception exception6) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Nation.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv16 = ex$iv15;
                ((Map)hashMap$iv).put(itemName$iv16, item$iv8);
                IRulesetObject iRulesetObject = item$iv8 instanceof IRulesetObject ? (IRulesetObject)item$iv8 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv15)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv15 = hashMap$iv;
            map8.putAll(this_$iv15);
            for (Nation nation : this.nations.values()) {
                Intrinsics.checkNotNullExpressionValue(nation, "next(...)");
                Nation nation2 = nation;
                nation2.setTransients();
            }
        }
        if ((fileHandle2 = folderHandle.child("Difficulties.json")).exists()) {
            Map nation2 = this.difficulties;
            INamed[] iNamedArray = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle2);
            INamed[] items$iv16 = UncivJsonKt.fromJsonFile(json, Difficulty[].class, fileHandle2);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv16.length);
            for (INamed item$iv9 : items$iv16) {
                Unit unit;
                String string;
                try {
                    string = item$iv9.getName();
                }
                catch (Exception ex$iv17) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Difficulty.class).getSimpleName() + " is missing a name!");
                }
                itemName$iv = string;
                ((Map)hashMap$iv).put(itemName$iv, item$iv9);
                IRulesetObject iRulesetObject = item$iv9 instanceof IRulesetObject ? (IRulesetObject)item$iv9 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(iNamedArray.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map9 = hashMap$iv;
            nation2.putAll(map9);
        }
        if ((globalUniquesFile = folderHandle.child("GlobalUniques.json")).exists()) {
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(globalUniquesFile);
            this.globalUniques = UncivJsonKt.fromJsonFile(json, GlobalUniques.class, globalUniquesFile);
            this.globalUniques.setOriginRuleset(this.name);
        }
        if ((fileHandle = folderHandle.child("VictoryTypes.json")).exists()) {
            Map this_$iv17;
            Map items$iv16 = this.victories;
            INamed[] $i$f$createHashmap = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(fileHandle);
            INamed[] items$iv17 = UncivJsonKt.fromJsonFile(json, Victory[].class, fileHandle);
            boolean $i$f$createHashmap4 = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv17.length);
            for (INamed item$iv10 : items$iv17) {
                Unit unit;
                try {
                    itemName$iv = item$iv10.getName();
                }
                catch (Exception ex$iv18) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Victory.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv17 = itemName$iv;
                ((Map)hashMap$iv).put(itemName$iv17, item$iv10);
                IRulesetObject iRulesetObject = item$iv10 instanceof IRulesetObject ? (IRulesetObject)item$iv10 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv17)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv17 = hashMap$iv;
            items$iv16.putAll(this_$iv17);
        }
        if ((cityStateTypesFile = folderHandle.child("CityStateTypes.json")).exists()) {
            Map this_$iv18;
            void var29_246;
            Map this_$iv17 = this.cityStateTypes;
            INamed[] items$iv17 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(cityStateTypesFile);
            INamed[] items$iv18 = UncivJsonKt.fromJsonFile(json, CityStateType[].class, cityStateTypesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv18.length);
            boolean bl = false;
            int item$iv10 = items$iv18.length;
            while (var29_246 < item$iv10) {
                Unit unit;
                String ex$iv18;
                INamed item$iv11 = items$iv18[var29_246];
                try {
                    ex$iv18 = item$iv11.getName();
                }
                catch (Exception ex$iv19) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(CityStateType.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv18 = ex$iv18;
                ((Map)hashMap$iv).put(itemName$iv18, item$iv11);
                IRulesetObject iRulesetObject = item$iv11 instanceof IRulesetObject ? (IRulesetObject)item$iv11 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv18)).name);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                ++var29_246;
            }
            this_$iv18 = hashMap$iv;
            this_$iv17.putAll(this_$iv18);
        }
        if ((personalitiesFile = folderHandle.child("Personalities.json")).exists()) {
            Map this_$iv19;
            Map this_$iv18 = this.personalities;
            INamed[] items$iv18 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(personalitiesFile);
            INamed[] items$iv19 = UncivJsonKt.fromJsonFile(json, Personality[].class, personalitiesFile);
            boolean $i$f$createHashmap = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap(items$iv19.length);
            for (INamed item$iv12 : items$iv19) {
                Unit unit;
                String ex$iv19;
                try {
                    ex$iv19 = item$iv12.getName();
                }
                catch (Exception ex$iv202) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Personality.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv19 = ex$iv19;
                ((Map)linkedHashMap).put(itemName$iv19, item$iv12);
                IRulesetObject iRulesetObject = item$iv12 instanceof IRulesetObject ? (IRulesetObject)item$iv12 : null;
                if (iRulesetObject != null) {
                    iRulesetObject.setOriginRuleset(((Ruleset)((Object)this_$iv19)).name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            this_$iv19 = linkedHashMap;
            this_$iv18.putAll(this_$iv19);
        }
        if ((eventsFile = folderHandle.child("Events.json")).exists()) {
            Map this_$iv19 = this.events;
            INamed[] items$iv19 = this;
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(eventsFile);
            INamed[] items$iv20 = UncivJsonKt.fromJsonFile(json, Event[].class, eventsFile);
            boolean bl = false;
            LinkedHashMap hashMap$iv = new LinkedHashMap(items$iv20.length);
            for (INamed item$iv13 : items$iv20) {
                Unit unit;
                try {
                    ex$iv202 = item$iv13.getName();
                }
                catch (Exception ex$iv21) {
                    throw new Exception(Reflection.getOrCreateKotlinClass(Event.class).getSimpleName() + " is missing a name!");
                }
                String itemName$iv20 = ex$iv202;
                ((Map)hashMap$iv).put(itemName$iv20, item$iv13);
                IRulesetObject iRulesetObject = item$iv13 instanceof IRulesetObject ? (IRulesetObject)item$iv13 : null;
                if (iRulesetObject != null) {
                    void this_$iv20;
                    iRulesetObject.setOriginRuleset(this_$iv20.name);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            Map map10 = hashMap$iv;
            this_$iv19.putAll(map10);
        }
        if (this.modOptions.isBaseRuleset()) {
            Lazy<Ruleset> fallbackRuleset$delegate = LazyKt.lazy(Ruleset::load$lambda$3);
            if (this.unitTypes.isEmpty()) {
                this.unitTypes.putAll((Map<String, UnitType>)Ruleset.load$lambda$4(fallbackRuleset$delegate).unitTypes);
            }
            if (!fileHandle3.exists()) {
                this.ruinRewards.putAll((Map<String, RuinReward>)Ruleset.load$lambda$4(fallbackRuleset$delegate).ruinRewards);
            }
            if (!globalUniquesFile.exists()) {
                this.globalUniques = Ruleset.load$lambda$4(fallbackRuleset$delegate).globalUniques;
            }
            if (this.victories.isEmpty()) {
                this.victories.putAll((Map<String, Victory>)Ruleset.load$lambda$4(fallbackRuleset$delegate).victories);
            }
            if (this.speeds.isEmpty()) {
                this.speeds.putAll((Map<String, Speed>)Ruleset.load$lambda$4(fallbackRuleset$delegate).speeds);
            }
            if (this.difficulties.isEmpty()) {
                this.difficulties.putAll((Map<String, Difficulty>)Ruleset.load$lambda$4(fallbackRuleset$delegate).difficulties);
            }
            if (this.cityStateTypes.isEmpty()) {
                for (CityStateType cityStateType : Ruleset.load$lambda$4(fallbackRuleset$delegate).cityStateTypes.values()) {
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    CityStateType cityStateType2;
                    Intrinsics.checkNotNullExpressionValue(cityStateType, "next(...)");
                    CityStateType cityStateType22 = cityStateType;
                    Map map11 = this.cityStateTypes;
                    String string = cityStateType22.getName();
                    CityStateType $this$load_u24lambda_u245 = cityStateType2 = new CityStateType();
                    boolean bl = false;
                    $this$load_u24lambda_u245.setName(cityStateType22.getName());
                    $this$load_u24lambda_u245.setColor(cityStateType22.getColor());
                    ex$iv202 = cityStateType22.getFriendBonusUniques();
                    CityStateType cityStateType3 = $this$load_u24lambda_u245;
                    boolean $i$f$filter = false;
                    void var39_284 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it4 = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (!new UniqueValidator((Ruleset)this).checkUnique(new Unique(it4, null, null, 6, null), false, null, true).isEmpty()) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv2;
                    Collection collection = list2;
                    cityStateType3.setFriendBonusUniques(new ArrayList<String>(collection));
                    $this$filter$iv = cityStateType22.getAllyBonusUniques();
                    cityStateType3 = $this$load_u24lambda_u245;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it2 = (String)element$iv$iv;
                        boolean bl3 = false;
                        if (!new UniqueValidator((Ruleset)this).checkUnique(new Unique(it2, null, null, 6, null), false, null, true).isEmpty()) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    list2 = (List)destination$iv$iv3;
                    Collection collection2 = list2;
                    cityStateType3.setAllyBonusUniques(new ArrayList<String>(collection2));
                    map11.put(string, cityStateType2);
                }
            }
            this.updateResourceTransients$core();
        }
    }

    public final void updateBuildingCosts$core() {
        Iterator<Building> iterator2 = this.buildings.values().iterator();
        while (iterator2.hasNext()) {
            TechColumn column;
            boolean bl;
            Building building;
            block2: {
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                if (building.getCost() != -1) continue;
                Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(building, UniqueType.Unbuildable, null, 2, null);
                boolean $i$f$any = false;
                Iterator iterator3 = $this$any$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv = iterator3.next();
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!it.getModifiers().isEmpty()) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (bl || building.techColumn(this) == null) continue;
            building.setCost(building.isAnyWonder() ? column.getWonderCost() : column.getBuildingCost());
        }
    }

    public final void updateResourceTransients$core() {
        Iterator<TileResource> iterator2 = this.tileResources.values().iterator();
        while (iterator2.hasNext()) {
            TileResource resource;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            resource.setTransients(this);
        }
    }

    @VisibleForTesting
    public final void addGlobalUniques(String ... uniques) {
        Intrinsics.checkNotNullParameter(uniques, "uniques");
        CollectionsKt.addAll((Collection)this.globalUniques.getUniques(), uniques);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String toString() {
        String string;
        if (((CharSequence)this.name).length() > 0) {
            string = this.name;
            return string;
        }
        if (this.mods.size() == 1) {
            Object object = RulesetCache.INSTANCE.get(CollectionsKt.first((Iterable)this.mods));
            Intrinsics.checkNotNull(object);
            if (((Ruleset)object).modOptions.isBaseRuleset()) {
                string = (String)CollectionsKt.first((Iterable)this.mods);
                return string;
            }
        }
        string = "Combined RuleSet (" + this.mods + ')';
        return string;
    }

    @Readonly
    @NotNull
    public final String getSummary() {
        ArrayList stringList = new ArrayList();
        if (this.modOptions.isBaseRuleset()) {
            ((Collection)stringList).add("Base Ruleset");
        }
        if (!((Map)this.technologies).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.technologies.size() + "] Techs");
        }
        if (!((Map)this.nations).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.nations.size() + "] Nations");
        }
        if (!((Map)this.units).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.units.size() + "] Units");
        }
        if (!((Map)this.buildings).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.buildings.size() + "] Buildings");
        }
        if (!((Map)this.tileResources).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.tileResources.size() + "] Resources");
        }
        if (!((Map)this.tileImprovements).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.tileImprovements.size() + "] Improvements");
        }
        if (!((Collection)this.religions).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.religions.size() + "] Religions");
        }
        if (!((Map)this.beliefs).isEmpty()) {
            ((Collection)stringList).add("" + '[' + this.beliefs.size() + "] Beliefs");
        }
        return CollectionsKt.joinToString$default(stringList, null, null, null, 0, null, Ruleset::getSummary$lambda$0, 31, null);
    }

    @NotNull
    public final RulesetErrorList getErrorList(boolean tryFixUnknownUniques) {
        return RulesetValidator.Companion.create(this, tryFixUnknownUniques).getErrorList();
    }

    public static /* synthetic */ RulesetErrorList getErrorList$default(Ruleset ruleset, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ruleset.getErrorList(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final List greatGeneralUnits_delegate$lambda$0(Ruleset this$0) {
        void $this$filterTo$iv$iv;
        Collection<BaseUnit> collection = this$0.units.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BaseUnit it = (BaseUnit)element$iv$iv;
            boolean bl = false;
            if (!it.hasUnique(UniqueType.GreatPersonFromCombat, GameContext.Companion.getIgnoreConditionals())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List tileRemovals_delegate$lambda$0(Ruleset this$0) {
        void $this$filterTo$iv$iv;
        Collection<TileImprovement> collection = this$0.tileImprovements.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileImprovement it = (TileImprovement)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default(it.getName(), "Remove ", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List nonRoadTileRemovals_delegate$lambda$0(Ruleset this$0) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this$0.getTileRemovals();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block2: {
                void $this$none$iv;
                TileImprovement rulesetImprovement = (TileImprovement)element$iv$iv;
                boolean bl2 = false;
                RoadStatus[] $this$toTypedArray$iv = (RoadStatus[])RoadStatus.getEntries();
                boolean $i$f$toTypedArray = false;
                RoadStatus[] thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = thisCollection$iv.toArray(new RoadStatus[0]);
                boolean $i$f$none = false;
                for (void element$iv : $this$none$iv) {
                    RoadStatus it = (RoadStatus)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getRemoveAction(), rulesetImprovement.getName())) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Set allHappinessLevelsThatAffectUniques_delegate$lambda$0(Ruleset this$0) {
        return SequencesKt.toSet(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object>(this$0, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ruleset this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        var3_4 = this.this$0.allUniques().iterator();
                        while (var3_4.hasNext()) {
                            unique = var3_4.next();
                            var5_6 = unique.getModifiers().iterator();
lbl10:
                            // 4 sources

                            while (var5_6.hasNext()) {
                                conditional = var5_6.next();
                                if (conditional.getType() == UniqueType.ConditionalWhenBelowAmountStatResource && Intrinsics.areEqual(conditional.getParams().get(1), "Happiness")) {
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var3_4;
                                    this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                                    this.L$3 = var5_6;
                                    this.L$4 = conditional;
                                    this.label = 1;
                                    v0 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(0))), this);
                                    if (v0 == var7_3) {
                                        return var7_3;
                                    }
                                }
                                ** GOTO lbl32
                            }
                        }
                        break;
                    }
                    case 1: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator<Unique>)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        if (conditional.getType() == UniqueType.ConditionalWhenAboveAmountStatResource && Intrinsics.areEqual(conditional.getParams().get(1), "Happiness")) {
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                            this.L$3 = var5_6;
                            this.L$4 = conditional;
                            this.label = 2;
                            v1 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(0))), this);
                            if (v1 == var7_3) {
                                return var7_3;
                            }
                        }
                        ** GOTO lbl50
                    }
                    case 2: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl50:
                        // 2 sources

                        if (conditional.getType() != UniqueType.ConditionalWhenBetweenStatResource || !Intrinsics.areEqual(conditional.getParams().get(2), "Happiness")) ** GOTO lbl85
                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                        this.L$3 = var5_6;
                        this.L$4 = conditional;
                        this.label = 3;
                        v2 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(0))), this);
                        if (v2 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl68
                    }
                    case 3: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl68:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                        this.L$3 = var5_6;
                        this.L$4 = conditional;
                        this.label = 4;
                        v3 = $this$sequence.yield(Boxing.boxInt(Integer.parseInt(conditional.getParams().get(1)) + 1), this);
                        if (v3 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl85
                    }
                    case 4: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl85:
                        // 3 sources

                        if (conditional.getType() != UniqueType.ConditionalHappy) ** GOTO lbl10
                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                        this.L$3 = var5_6;
                        this.L$4 = SpillingKt.nullOutSpilledVariable(conditional);
                        this.label = 5;
                        v4 = $this$sequence.yield(Boxing.boxInt(0), this);
                        if (v4 != var7_3) ** GOTO lbl10
                        return var7_3;
                    }
                    case 5: {
                        conditional = (Unique)this.L$4;
                        var5_6 = (Iterator)this.L$3;
                        unique = (Unique)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
                        ** GOTO lbl10
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Integer>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Integer> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final TileImprovement roadImprovement_delegate$lambda$0(Ruleset this$0) {
        return RoadStatus.Road.improvement(this$0);
    }

    private static final TileImprovement railroadImprovement_delegate$lambda$0(Ruleset this$0) {
        return RoadStatus.Railroad.improvement(this$0);
    }

    private static final boolean add$lambda$8(String $policyToRemove, Policy it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Policy.matchesFilter$default(it, $policyToRemove, null, 2, null);
    }

    private static final Sequence allRulesetObjects$lambda$0(Ruleset this$0, RulesetFile it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getGetRulesetObjects().invoke(this$0);
    }

    private static final Sequence allUniques$lambda$0(Ruleset this$0, RulesetFile it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getGetUniques().invoke(this$0);
    }

    private static final Ruleset load$lambda$3() {
        return RulesetCache.INSTANCE.getVanillaRuleset();
    }

    private static final Ruleset load$lambda$4(Lazy<Ruleset> $fallbackRuleset$delegate) {
        Lazy<Ruleset> lazy = $fallbackRuleset$delegate;
        return lazy.getValue();
    }

    private static final CharSequence getSummary$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }
}

