/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.logic.map.HexMath;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.tilegroups.layers.TileLayerTerrain;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 0*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00010B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001aH\u0016J\"\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\tH\u0016J\u001a\u0010,\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0015R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/unciv/ui/components/tilegroups/TileGroupMap;", "T", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "mapHolder", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "tileGroups", "", "worldWrap", "", "tileGroupsToUnwrap", "", "<init>", "(Lcom/unciv/ui/components/widgets/ZoomableScrollPane;Ljava/lang/Iterable;ZLjava/util/Set;)V", "getMapHolder", "()Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "getWorldWrap", "()Z", "shouldAct", "getShouldAct", "setShouldAct", "(Z)V", "shouldHit", "getShouldHit", "setShouldHit", "topX", "", "topY", "bottomX", "bottomY", "drawTopX", "drawBottomX", "maxVisibleMapWidth", "getPositionalVector", "Lcom/badlogic/gdx/math/Vector2;", "stageCoords", "act", "", "delta", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTileGroupMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileGroupMap.kt\ncom/unciv/ui/components/tilegroups/TileGroupMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1491#2:235\n1516#2,3:236\n1519#2,3:246\n1068#2:249\n1374#2:250\n1460#2,5:251\n1869#2,2:257\n382#3,7:239\n1#4:256\n*S KotlinDebug\n*F\n+ 1 TileGroupMap.kt\ncom/unciv/ui/components/tilegroups/TileGroupMap\n*L\n116#1:235\n116#1:236,3\n116#1:246,3\n117#1:249\n117#1:250\n117#1:251,5\n213#1:257,2\n116#1:239,7\n*E\n"})
public final class TileGroupMap<T extends TileGroup>
extends Group {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomableScrollPane mapHolder;
    private final boolean worldWrap;
    private boolean shouldAct;
    private boolean shouldHit;
    private float topX;
    private float topY;
    private float bottomX;
    private float bottomY;
    private float drawTopX;
    private float drawBottomX;
    private float maxVisibleMapWidth;
    public static final float groupSize = 50.0f;
    public static final float groupSizeDiagonal = 57.735027f;
    public static final float groupHorizontalAdvance = 43.30127f;

    /*
     * WARNING - void declaration
     */
    public TileGroupMap(@NotNull ZoomableScrollPane mapHolder, @NotNull Iterable<? extends T> tileGroups, boolean worldWrap, @Nullable Set<? extends T> tileGroupsToUnwrap) {
        int n;
        Iterable<Object> iterable;
        TileLayerTerrain $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable list$iv$iv;
        Object it;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(mapHolder, "mapHolder");
        Intrinsics.checkNotNullParameter(tileGroups, "tileGroups");
        this.mapHolder = mapHolder;
        this.worldWrap = worldWrap;
        this.shouldAct = true;
        this.shouldHit = true;
        this.topX = -3.4028235E38f;
        this.topY = -3.4028235E38f;
        this.bottomX = Float.MAX_VALUE;
        this.bottomY = Float.MAX_VALUE;
        for (TileGroup tileGroup : tileGroups) {
            Set<T> set = tileGroupsToUnwrap;
            Vector2 positionalVector = (set != null ? set.contains(tileGroup) : false) ? HexMath.INSTANCE.hex2WorldCoords(tileGroup.getTile().getTileMap().getUnWrappedPosition(tileGroup.getTile().getPosition())) : HexMath.INSTANCE.hex2WorldCoords(tileGroup.getTile().getPosition());
            ((Actor)tileGroup).setPosition(positionalVector.x * 0.8f * 50.0f, positionalVector.y * 0.8f * 50.0f);
            this.topX = this.worldWrap ? Math.max(this.topX, ((Actor)tileGroup).getX() + 60.000004f) : Math.max(this.topX, ((Actor)tileGroup).getX() + 50.0f + 4.0f);
            this.topY = Math.max(this.topY, ((Actor)tileGroup).getY() + 50.0f);
            this.bottomX = Math.min(this.bottomX, ((Actor)tileGroup).getX());
            this.bottomY = Math.min(this.bottomY, ((Actor)tileGroup).getY());
        }
        for (TileGroup group : tileGroups) {
            ((Actor)group).moveBy(-this.bottomX, -this.bottomY);
        }
        this.drawTopX = this.topX - this.bottomX;
        this.drawBottomX = this.bottomX - this.bottomX;
        int numberOfTilegroups = CollectionsKt.count(tileGroups);
        ArrayList<TileLayerTerrain> baseLayers = new ArrayList<TileLayerTerrain>(numberOfTilegroups);
        ArrayList featureLayers = new ArrayList(numberOfTilegroups);
        ArrayList borderLayers = new ArrayList(numberOfTilegroups);
        ArrayList resourceLayers = new ArrayList(numberOfTilegroups);
        ArrayList improvementLayers = new ArrayList(numberOfTilegroups);
        ArrayList miscLayers = new ArrayList(numberOfTilegroups);
        ArrayList yieldLayers = new ArrayList(numberOfTilegroups);
        ArrayList pixelUnitLayers = new ArrayList(numberOfTilegroups);
        ArrayList circleFogCrosshairLayers = new ArrayList(numberOfTilegroups);
        ArrayList unitLayers = new ArrayList(numberOfTilegroups);
        ArrayList cityButtonLayers = new ArrayList(numberOfTilegroups);
        Iterable<T> $this$groupBy$iv = tileGroups;
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (TileGroup)element$iv$iv;
            boolean bl = false;
            Float key$iv$iv = Float.valueOf(((TileGroup)it).getTile().getPosition().x + ((TileGroup)it).getTile().getPosition().y);
            Map map2 = destination$iv$iv;
            Float key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = destination$iv$iv.entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Float)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getKey()));
            }
        });
        int $i$f$flatMap = 0;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator iterator3 = $this$flatMapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator3.next();
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (TileGroup group : (List)destination$iv$iv) {
            void $this$_init__u24lambda_u2413;
            TileLayer $this$_init__u24lambda_u2412;
            TileLayer $this$_init__u24lambda_u2411;
            TileLayer $this$_init__u24lambda_u2410;
            TileLayer $this$_init__u24lambda_u249;
            TileLayer $this$_init__u24lambda_u248;
            TileLayer $this$_init__u24lambda_u247;
            TileLayer $this$_init__u24lambda_u246;
            TileLayer $this$_init__u24lambda_u245;
            TileLayer $this$_init__u24lambda_u244;
            TileLayer $this$_init__u24lambda_u243;
            $this$flatMapTo$iv$iv = $i$f$flatMap = group.getLayerTerrain();
            iterable = baseLayers;
            boolean bl = false;
            $this$_init__u24lambda_u243.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add($i$f$flatMap);
            $this$_init__u24lambda_u243 = $i$f$flatMap = group.getLayerFeatures();
            iterable = featureLayers;
            boolean bl3 = false;
            $this$_init__u24lambda_u244.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add($i$f$flatMap);
            $this$_init__u24lambda_u244 = $i$f$flatMap = group.getLayerBorders();
            iterable = borderLayers;
            boolean bl4 = false;
            $this$_init__u24lambda_u245.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add($i$f$flatMap);
            $this$_init__u24lambda_u245 = $i$f$flatMap = group.getLayerResource();
            iterable = resourceLayers;
            boolean bl5 = false;
            $this$_init__u24lambda_u246.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
            $this$_init__u24lambda_u246 = $i$f$flatMap = group.getLayerImprovement();
            iterable = improvementLayers;
            boolean bl6 = false;
            $this$_init__u24lambda_u247.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
            $this$_init__u24lambda_u247 = $i$f$flatMap = group.getLayerMisc();
            iterable = miscLayers;
            boolean bl7 = false;
            $this$_init__u24lambda_u248.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
            $this$_init__u24lambda_u248 = $i$f$flatMap = group.getLayerYield();
            iterable = yieldLayers;
            boolean bl8 = false;
            $this$_init__u24lambda_u249.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
            $this$_init__u24lambda_u249 = $i$f$flatMap = group.getLayerUnitArt();
            iterable = pixelUnitLayers;
            boolean bl9 = false;
            $this$_init__u24lambda_u2410.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
            $this$_init__u24lambda_u2410 = $i$f$flatMap = group.getLayerOverlay();
            iterable = circleFogCrosshairLayers;
            boolean bl10 = false;
            $this$_init__u24lambda_u2411.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
            $this$_init__u24lambda_u2411 = $i$f$flatMap = group.getLayerUnitFlag();
            iterable = unitLayers;
            boolean bl11 = false;
            $this$_init__u24lambda_u2412.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
            $this$_init__u24lambda_u2412 = $i$f$flatMap = group.getLayerCityButton();
            iterable = cityButtonLayers;
            boolean bl12 = false;
            $this$_init__u24lambda_u2413.setPosition(((Actor)group).getX(), ((Actor)group).getY());
            ((ArrayList)iterable).add((TileLayerTerrain)$i$f$flatMap);
        }
        Object object = new Iterable[]{baseLayers, featureLayers, borderLayers, resourceLayers, improvementLayers, miscLayers, yieldLayers, pixelUnitLayers, circleFogCrosshairLayers, tileGroups, unitLayers, cityButtonLayers};
        List<Iterable> layerLists = CollectionsKt.listOf(object);
        object = layerLists;
        iterable = this.getChildren();
        $i$f$flatMap = 0;
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            void it2;
            Object bl12 = iterator2.next();
            Iterable $i$f$flatMapTo2 = (Iterable)bl12;
            n = $i$f$flatMap;
            boolean bl = false;
            int n2 = CollectionsKt.count(it2);
            $i$f$flatMap = n + n2;
        }
        n = $i$f$flatMap;
        ((Array)iterable).ensureCapacity(n);
        for (Iterable layer : layerLists) {
            for (Group group : layer) {
                this.addActor(group);
            }
        }
        this.setSize(this.topX - this.bottomX, this.topY - this.bottomY);
        this.setCullingArea(new Rectangle(0.0f, 0.0f, this.getWidth(), this.getHeight()));
        this.maxVisibleMapWidth = this.getWidth() - 75.0f;
    }

    public /* synthetic */ TileGroupMap(ZoomableScrollPane zoomableScrollPane, Iterable iterable, boolean bl, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        this(zoomableScrollPane, iterable, bl, set);
    }

    @NotNull
    public final ZoomableScrollPane getMapHolder() {
        return this.mapHolder;
    }

    public final boolean getWorldWrap() {
        return this.worldWrap;
    }

    public final boolean getShouldAct() {
        return this.shouldAct;
    }

    public final void setShouldAct(boolean bl) {
        this.shouldAct = bl;
    }

    public final boolean getShouldHit() {
        return this.shouldHit;
    }

    public final void setShouldHit(boolean bl) {
        this.shouldHit = bl;
    }

    @NotNull
    public final Vector2 getPositionalVector(@NotNull Vector2 stageCoords) {
        Intrinsics.checkNotNullParameter(stageCoords, "stageCoords");
        float trueGroupSize = 40.0f;
        Vector2 vector2 = new Vector2(this.bottomX, this.bottomY).add(stageCoords).sub(25.0f, 25.0f).scl(1.0f / trueGroupSize);
        Intrinsics.checkNotNullExpressionValue(vector2, "scl(...)");
        return vector2;
    }

    @Override
    public void act(float delta) {
        if (this.shouldAct) {
            super.act(delta);
        }
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        if (this.shouldHit) {
            return super.hit(x, y, touchable);
        }
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (this.worldWrap) {
            boolean beyondLeft;
            float visibleMapWidth = this.mapHolder.getWidth() > this.maxVisibleMapWidth ? this.maxVisibleMapWidth : this.mapHolder.getWidth();
            float rightSide2 = this.mapHolder.getScrollX() + visibleMapWidth / 2.0f;
            float leftSide = this.mapHolder.getScrollX() - visibleMapWidth / 2.0f;
            float diffRight = rightSide2 - this.drawTopX;
            float diffLeft = leftSide - this.drawBottomX;
            boolean beyondRight = diffRight >= 0.0f;
            boolean bl = beyondLeft = diffLeft <= 0.0f;
            if (beyondRight || beyondLeft) {
                float newBottomX = 0.0f;
                newBottomX = Float.MAX_VALUE;
                float newTopX = 0.0f;
                newTopX = -3.4028235E38f;
                SnapshotArray<Actor> snapshotArray = this.getChildren();
                Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
                Iterable $this$forEach$iv = snapshotArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Actor it = (Actor)element$iv;
                    boolean bl2 = false;
                    if (beyondRight) {
                        if (it.getX() - this.drawBottomX <= diffRight) {
                            it.setX(it.getX() + this.getWidth());
                        }
                    } else if (beyondLeft && it.getX() + 50.0f + 4.0f >= this.drawTopX + diffLeft) {
                        it.setX(it.getX() - this.getWidth());
                    }
                    newBottomX = Math.min(newBottomX, it.getX());
                    newTopX = Math.max(newTopX, it.getX() + 50.0f + 4.0f);
                }
                this.drawBottomX = newBottomX;
                this.drawTopX = newTopX;
            }
        }
        super.draw(batch, parentAlpha);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/components/tilegroups/TileGroupMap$Companion;", "", "<init>", "()V", "groupSize", "", "groupSizeDiagonal", "groupHorizontalAdvance", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

