/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.unciv.GUI;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.NotificationsScroll;
import com.unciv.utils.Display;
import com.unciv.utils.ScreenMode;
import com.unciv.utils.ScreenOrientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a \u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\u000f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a.\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a.\u0010\u0012\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a.\u0010\u0014\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a.\u0010\u0016\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a.\u0010\u0018\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u001b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001c"}, d2={"displayTab", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "onChange", "Lkotlin/Function0;", "", "addScrollSpeedSlider", "table", "settings", "Lcom/unciv/models/metadata/GameSettings;", "selectBoxMinWidth", "", "addUnitIconAlphaSlider", "addPediaUnitArtSizeSlider", "addScreenModeSelectBox", "addScreenSizeSelectBox", "onResolutionChange", "addScreenOrientationSelectBox", "onOrientationChange", "addTileSetSelectBox", "onTilesetChange", "addUnitSetSelectBox", "onUnitsetChange", "addSkinSelectBox", "onSkinChange", "addResetTutorials", "addNotificationScrollSelect", "core"})
@SourceDebugExtension(value={"SMAP\nDisplayTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayTab.kt\ncom/unciv/ui/popups/options/DisplayTabKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n37#2,2:303\n37#2,2:309\n1563#3:305\n1634#3,3:306\n1563#3:311\n1634#3,3:312\n*S KotlinDebug\n*F\n+ 1 DisplayTab.kt\ncom/unciv/ui/popups/options/DisplayTabKt\n*L\n164#1:303,2\n194#1:309,2\n179#1:305\n179#1:306,3\n292#1:311\n292#1:312,3\n*E\n"})
public final class DisplayTabKt {
    @NotNull
    public static final Table displayTab(@NotNull OptionsPopup optionsPopup, @NotNull Function0<Unit> onChange) {
        Table table2;
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        Intrinsics.checkNotNullParameter(onChange, "onChange");
        Table $this$displayTab_u24lambda_u240 = table2 = new Table(BaseScreen.Companion.getSkin());
        boolean bl = false;
        $this$displayTab_u24lambda_u240.pad(10.0f);
        $this$displayTab_u24lambda_u240.defaults().pad(2.5f);
        GameSettings settings = optionsPopup.getSettings();
        $this$displayTab_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel$default("Screen", null, 24, 0, false, 13, null)).colspan(2).row();
        DisplayTabKt.addScreenSizeSelectBox($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth(), onChange);
        DisplayTabKt.addScreenOrientationSelectBox($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth(), onChange);
        DisplayTabKt.addScreenModeSelectBox($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth());
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Map mouse auto-scroll", settings.getMapAutoScroll(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$0(settings, arg_0), 16, null);
            DisplayTabKt.addScrollSpeedSlider($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth());
        }
        Scene2dExtensionsKt.addSeparator$default($this$displayTab_u24lambda_u240, null, 0, 0.0f, 7, null);
        $this$displayTab_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel$default("Graphics", null, 24, 0, false, 13, null)).colspan(2).row();
        DisplayTabKt.addTileSetSelectBox($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth(), onChange);
        DisplayTabKt.addUnitSetSelectBox($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth(), onChange);
        DisplayTabKt.addSkinSelectBox($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth(), onChange);
        Scene2dExtensionsKt.addSeparator$default($this$displayTab_u24lambda_u240, null, 0, 0.0f, 7, null);
        $this$displayTab_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel$default("UI", null, 24, 0, false, 13, null)).colspan(2).row();
        DisplayTabKt.addNotificationScrollSelect($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth());
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show minimap", settings.getShowMinimap(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$1(settings, arg_0), 16, null);
        optionsPopup.addCheckbox$core($this$displayTab_u24lambda_u240, "Show tutorials", settings.getShowTutorials(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$2(settings, arg_0));
        DisplayTabKt.addResetTutorials($this$displayTab_u24lambda_u240, settings);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show zoom buttons in world screen", settings.getShowZoomButtons(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$3(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Never close popups by clicking outside", settings.getForbidPopupClickBehindToClose(), false, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$4(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Use circles to indicate movable tiles", settings.getUseCirclesToIndicateMovableTiles(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$5(settings, arg_0), 16, null);
        DisplayTabKt.addPediaUnitArtSizeSlider($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth());
        Scene2dExtensionsKt.addSeparator$default($this$displayTab_u24lambda_u240, null, 0, 0.0f, 7, null);
        $this$displayTab_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel$default("Visual Hints", null, 24, 0, false, 13, null)).colspan(2).row();
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show unit movement arrows", settings.getShowUnitMovements(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$6(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show suggested city locations for units that can found cities", settings.getShowSettlersSuggestedCityLocations(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$7(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show tile yields", settings.getShowTileYields(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$8(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show worked tiles", settings.getShowWorkedTiles(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$9(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show resources and improvements", settings.getShowResourcesAndImprovements(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$10(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Show pixel improvements", settings.getShowPixelImprovements(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$11(settings, arg_0), 16, null);
        DisplayTabKt.addUnitIconAlphaSlider($this$displayTab_u24lambda_u240, settings, optionsPopup.getSelectBoxMinWidth());
        Scene2dExtensionsKt.addSeparator$default($this$displayTab_u24lambda_u240, null, 0, 0.0f, 7, null);
        $this$displayTab_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel$default("Performance", null, 24, 0, false, 13, null)).colspan(2).row();
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Continuous rendering", settings.getContinuousRendering(), false, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$12(settings, arg_0), 24, null);
        String continuousRenderingDescription = "When disabled, saves battery life but certain animations will be suspended";
        float f = optionsPopup.getTabs().getPrefWidth();
        Color color = Color.ORANGE;
        Intrinsics.checkNotNullExpressionValue(color, "ORANGE");
        WrappableLabel continuousRenderingLabel = new WrappableLabel(continuousRenderingDescription, f, Scene2dExtensionsKt.brighten(color, 0.7f), 14, false, 16, null);
        continuousRenderingLabel.setWrap(true);
        $this$displayTab_u24lambda_u240.add((Actor)continuousRenderingLabel).colspan(2).padTop(10.0f).row();
        Scene2dExtensionsKt.addSeparator$default($this$displayTab_u24lambda_u240, null, 0, 0.0f, 7, null);
        $this$displayTab_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel$default("Experimental", null, 24, 0, false, 13, null)).colspan(2).row();
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Experimental Demographics scoreboard", settings.getUseDemographics(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$13(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Unit movement button", settings.getUnitMovementButtonAnimation(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$14(settings, arg_0), 16, null);
        OptionsPopup.addCheckbox$core$default(optionsPopup, $this$displayTab_u24lambda_u240, "Unit actions menu", settings.getUnitActionsTableAnimation(), true, false, arg_0 -> DisplayTabKt.displayTab$lambda$0$15(settings, arg_0), 16, null);
        return table2;
    }

    private static final void addScrollSpeedSlider(Table table2, GameSettings settings, float selectBoxMinWidth) {
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Map panning speed")).left().fillX();
        UncivSlider scrollSpeedSlider = new UncivSlider(0.2f, 25.0f, 0.2f, false, false, settings.getMapPanningSpeed(), null, null, null, arg_0 -> DisplayTabKt.addScrollSpeedSlider$lambda$0(settings, arg_0), 472, null);
        table2.add((Actor)scrollSpeedSlider).minWidth(selectBoxMinWidth).pad(10.0f).row();
    }

    private static final void addUnitIconAlphaSlider(Table table2, GameSettings settings, float selectBoxMinWidth) {
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Unit icon opacity")).left().fillX();
        Function1<Float, String> getTipText = DisplayTabKt::addUnitIconAlphaSlider$lambda$0;
        UncivSlider unitIconAlphaSlider = new UncivSlider(0.0f, 1.0f, 0.1f, false, false, settings.getUnitIconOpacity(), null, null, getTipText, arg_0 -> DisplayTabKt.addUnitIconAlphaSlider$lambda$1(settings, arg_0), 216, null);
        table2.add((Actor)unitIconAlphaSlider).minWidth(selectBoxMinWidth).pad(10.0f).row();
    }

    private static final void addPediaUnitArtSizeSlider(Table table2, GameSettings settings, float selectBoxMinWidth) {
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Size of Unitset art in Civilopedia")).left().fillX();
        UncivSlider unitArtSizeSlider = new UncivSlider(0.0f, 360.0f, 1.0f, false, false, settings.getPediaUnitArtSize(), null, null, null, arg_0 -> DisplayTabKt.addPediaUnitArtSizeSlider$lambda$0(settings, arg_0), 472, null);
        float[] fArray = new float[]{0.0f, 32.0f, 48.0f, 64.0f, 96.0f, 120.0f, 180.0f, 240.0f, 360.0f};
        unitArtSizeSlider.setSnapToValues(60.0f, fArray);
        table2.add((Actor)unitArtSizeSlider).minWidth(selectBoxMinWidth).pad(10.0f).row();
    }

    private static final void addScreenModeSelectBox(Table table2, GameSettings settings, float selectBoxMinWidth) {
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Screen Mode")).left().fillX();
        Map<Integer, ScreenMode> modes = Display.INSTANCE.getScreenModes();
        ScreenMode current = modes.get(settings.getScreenMode());
        SelectBox<ScreenMode> selectBox = new SelectBox<ScreenMode>(table2.getSkin());
        Collection<ScreenMode> $this$toTypedArray$iv = modes.values();
        boolean $i$f$toTypedArray = false;
        Collection<ScreenMode> thisCollection$iv = $this$toTypedArray$iv;
        selectBox.setItems(new Array<ScreenMode>(thisCollection$iv.toArray(new ScreenMode[0])));
        selectBox.setSelected(current);
        ActivationExtensionsKt.onChange(selectBox, arg_0 -> DisplayTabKt.addScreenModeSelectBox$lambda$0(settings, selectBox, arg_0));
        table2.add((Actor)selectBox).minWidth(selectBoxMinWidth).pad(10.0f).row();
    }

    /*
     * WARNING - void declaration
     */
    private static final void addScreenSizeSelectBox(Table table2, GameSettings settings, float selectBoxMinWidth, Function0<Unit> onResolutionChange) {
        void $this$mapTo$iv$iv;
        table2.add((Actor)Scene2dExtensionsKt.toLabel("UI Scale")).left().fillX();
        Iterable $this$map$iv = GameSettings.ScreenSize.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GameSettings.ScreenSize screenSize = (GameSettings.ScreenSize)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        String string = settings.getScreenSize().name();
        Collection collection = (List)destination$iv$iv;
        TranslatedSelectBox screenSizeSelectBox = new TranslatedSelectBox(collection, string);
        table2.add((Actor)screenSizeSelectBox).minWidth(selectBoxMinWidth).pad(10.0f).row();
        ActivationExtensionsKt.onChange(screenSizeSelectBox, arg_0 -> DisplayTabKt.addScreenSizeSelectBox$lambda$1(settings, screenSizeSelectBox, onResolutionChange, arg_0));
    }

    private static final void addScreenOrientationSelectBox(Table table2, GameSettings settings, float selectBoxMinWidth, Function0<Unit> onOrientationChange) {
        if (!Display.INSTANCE.hasOrientation()) {
            return;
        }
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Screen orientation")).left().fillX();
        SelectBox<ScreenOrientation> selectBox = new SelectBox<ScreenOrientation>(BaseScreen.Companion.getSkin());
        Collection $this$toTypedArray$iv = ScreenOrientation.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        selectBox.setItems(new Array<ScreenOrientation>(thisCollection$iv.toArray(new ScreenOrientation[0])));
        selectBox.setSelected(settings.getDisplayOrientation());
        ActivationExtensionsKt.onChange(selectBox, arg_0 -> DisplayTabKt.addScreenOrientationSelectBox$lambda$0(selectBox, settings, onOrientationChange, arg_0));
        table2.add((Actor)selectBox).minWidth(selectBoxMinWidth).pad(10.0f).row();
    }

    private static final void addTileSetSelectBox(Table table2, GameSettings settings, float selectBoxMinWidth, Function0<Unit> onTilesetChange) {
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Tileset")).left().fillX();
        SelectBox tileSetSelectBox = new SelectBox(table2.getSkin());
        Array<String> tileSetArray = new Array<String>();
        Sequence<String> tileSets = ImageGetter.INSTANCE.getAvailableTilesets();
        Iterator<String> iterator2 = tileSets.iterator();
        while (iterator2.hasNext()) {
            String tileset = iterator2.next();
            tileSetArray.add(tileset);
        }
        tileSetSelectBox.setItems(tileSetArray);
        tileSetSelectBox.setSelected(settings.getTileSet());
        table2.add((Actor)tileSetSelectBox).minWidth(selectBoxMinWidth).pad(10.0f).row();
        Sequence<String> unitSets = ImageGetter.INSTANCE.getAvailableUnitsets();
        ActivationExtensionsKt.onChange(tileSetSelectBox, arg_0 -> DisplayTabKt.addTileSetSelectBox$lambda$0(settings, unitSets, tileSetSelectBox, onTilesetChange, arg_0));
    }

    private static final void addUnitSetSelectBox(Table table2, GameSettings settings, float selectBoxMinWidth, Function0<Unit> onUnitsetChange) {
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Unitset")).left().fillX();
        SelectBox unitSetSelectBox = new SelectBox(table2.getSkin());
        Array<String> unitSetArray = new Array<String>();
        String nullValue = TranslationsKt.tr$default("None", false, false, 3, null);
        unitSetArray.add(nullValue);
        Sequence<String> unitSets = ImageGetter.INSTANCE.getAvailableUnitsets();
        Iterator<String> iterator2 = unitSets.iterator();
        while (iterator2.hasNext()) {
            String unitset = iterator2.next();
            unitSetArray.add(unitset);
        }
        unitSetSelectBox.setItems(unitSetArray);
        String string = settings.getUnitSet();
        if (string == null) {
            string = nullValue;
        }
        unitSetSelectBox.setSelected(string);
        table2.add((Actor)unitSetSelectBox).minWidth(selectBoxMinWidth).pad(10.0f).row();
        ActivationExtensionsKt.onChange(unitSetSelectBox, arg_0 -> DisplayTabKt.addUnitSetSelectBox$lambda$0(settings, unitSetSelectBox, nullValue, onUnitsetChange, arg_0));
    }

    private static final void addSkinSelectBox(Table table2, GameSettings settings, float selectBoxMinWidth, Function0<Unit> onSkinChange) {
        table2.add((Actor)Scene2dExtensionsKt.toLabel("UI Skin")).left().fillX();
        SelectBox skinSelectBox = new SelectBox(table2.getSkin());
        Array<String> skinArray = new Array<String>();
        Sequence<String> skins = ImageGetter.INSTANCE.getAvailableSkins();
        Iterator<String> iterator2 = skins.iterator();
        while (iterator2.hasNext()) {
            String skin = iterator2.next();
            skinArray.add(skin);
        }
        skinSelectBox.setItems(skinArray);
        skinSelectBox.setSelected(settings.getSkin());
        table2.add((Actor)skinSelectBox).minWidth(selectBoxMinWidth).pad(10.0f).row();
        ActivationExtensionsKt.onChange(skinSelectBox, arg_0 -> DisplayTabKt.addSkinSelectBox$lambda$0(settings, skinSelectBox, onSkinChange, arg_0));
    }

    private static final void addResetTutorials(Table table2, GameSettings settings) {
        TextButton resetTutorialsButton = Scene2dExtensionsKt.toTextButton$default("Reset tutorials", null, false, 3, null);
        ActivationExtensionsKt.onClick(resetTutorialsButton, () -> DisplayTabKt.addResetTutorials$lambda$0(table2, settings, resetTutorialsButton));
        table2.add((Actor)resetTutorialsButton).center().row();
    }

    /*
     * WARNING - void declaration
     */
    private static final void addNotificationScrollSelect(Table table2, GameSettings settings, float selectBoxMinWidth) {
        void $this$mapTo$iv$iv;
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Notifications on world screen")).left().fillX();
        Iterable $this$map$iv = NotificationsScroll.UserSetting.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotificationsScroll.UserSetting userSetting = (NotificationsScroll.UserSetting)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        String string = settings.getNotificationScroll();
        Collection collection = (List)destination$iv$iv;
        TranslatedSelectBox selectBox = new TranslatedSelectBox(collection, string);
        table2.add((Actor)selectBox).minWidth(selectBoxMinWidth).pad(10.0f).row();
        ActivationExtensionsKt.onChange(selectBox, arg_0 -> DisplayTabKt.addNotificationScrollSelect$lambda$1(settings, selectBox, arg_0));
    }

    private static final Unit displayTab$lambda$0$0(GameSettings $settings, boolean it) {
        $settings.setMapAutoScroll(it);
        if (GUI.INSTANCE.isWorldLoaded()) {
            GUI.INSTANCE.getMap().setAutoScrollEnabled($settings.getMapAutoScroll());
        }
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$1(GameSettings $settings, boolean it) {
        $settings.setShowMinimap(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$2(GameSettings $settings, boolean it) {
        $settings.setShowTutorials(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$3(GameSettings $settings, boolean it) {
        $settings.setShowZoomButtons(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$4(GameSettings $settings, boolean it) {
        $settings.setForbidPopupClickBehindToClose(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$5(GameSettings $settings, boolean it) {
        $settings.setUseCirclesToIndicateMovableTiles(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$6(GameSettings $settings, boolean it) {
        $settings.setShowUnitMovements(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$7(GameSettings $settings, boolean it) {
        $settings.setShowSettlersSuggestedCityLocations(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$8(GameSettings $settings, boolean it) {
        $settings.setShowTileYields(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$9(GameSettings $settings, boolean it) {
        $settings.setShowWorkedTiles(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$10(GameSettings $settings, boolean it) {
        $settings.setShowResourcesAndImprovements(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$11(GameSettings $settings, boolean it) {
        $settings.setShowPixelImprovements(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$12(GameSettings $settings, boolean it) {
        $settings.setContinuousRendering(it);
        Gdx.graphics.setContinuousRendering(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$13(GameSettings $settings, boolean it) {
        $settings.setUseDemographics(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$14(GameSettings $settings, boolean it) {
        $settings.setUnitMovementButtonAnimation(it);
        return Unit.INSTANCE;
    }

    private static final Unit displayTab$lambda$0$15(GameSettings $settings, boolean it) {
        $settings.setUnitActionsTableAnimation(it);
        return Unit.INSTANCE;
    }

    private static final Unit addScrollSpeedSlider$lambda$0(GameSettings $settings, float it) {
        $settings.setMapPanningSpeed(it);
        $settings.save();
        if (GUI.INSTANCE.isWorldLoaded()) {
            GUI.INSTANCE.getMap().setMapPanningSpeed($settings.getMapPanningSpeed());
        }
        return Unit.INSTANCE;
    }

    private static final String addUnitIconAlphaSlider$lambda$0(float it) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "%.0f";
        Object[] objectArray = new Object[]{Float.valueOf(it * (float)100)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return stringBuilder.append(string2).append('%').toString();
    }

    private static final Unit addUnitIconAlphaSlider$lambda$1(GameSettings $settings, float it) {
        $settings.setUnitIconOpacity(it);
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }

    private static final Unit addPediaUnitArtSizeSlider$lambda$0(GameSettings $settings, float it) {
        $settings.setPediaUnitArtSize(it);
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }

    private static final Unit addScreenModeSelectBox$lambda$0(GameSettings $settings, SelectBox $selectBox, ChangeListener.ChangeEvent it) {
        $settings.refreshWindowSize();
        ScreenMode mode = (ScreenMode)$selectBox.getSelected();
        $settings.setScreenMode(mode.getId());
        Display.INSTANCE.setScreenMode(mode.getId(), $settings);
        return Unit.INSTANCE;
    }

    private static final Unit addScreenSizeSelectBox$lambda$1(GameSettings $settings, TranslatedSelectBox $screenSizeSelectBox, Function0 $onResolutionChange, ChangeListener.ChangeEvent it) {
        $settings.setScreenSize(GameSettings.ScreenSize.valueOf(((TranslatedSelectBox.TranslatedString)$screenSizeSelectBox.getSelected()).getValue()));
        $onResolutionChange.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addScreenOrientationSelectBox$lambda$0(SelectBox $selectBox, GameSettings $settings, Function0 $onOrientationChange, ChangeListener.ChangeEvent it) {
        ScreenOrientation orientation = (ScreenOrientation)((Object)$selectBox.getSelected());
        Intrinsics.checkNotNull((Object)orientation);
        $settings.setDisplayOrientation(orientation);
        Display.INSTANCE.setOrientation(orientation);
        $onOrientationChange.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addTileSetSelectBox$lambda$0(GameSettings $settings, Sequence $unitSets, SelectBox $tileSetSelectBox, Function0 $onTilesetChange, ChangeListener.ChangeEvent it) {
        if (Intrinsics.areEqual($settings.getTileSet(), $settings.getUnitSet()) && SequencesKt.contains($unitSets, $tileSetSelectBox.getSelected())) {
            $settings.setUnitSet((String)$tileSetSelectBox.getSelected());
        }
        Object t = $tileSetSelectBox.getSelected();
        Intrinsics.checkNotNullExpressionValue(t, "getSelected(...)");
        $settings.setTileSet((String)t);
        TileSetCache.INSTANCE.assembleTileSetConfigs((Set<String>)ImageGetter.INSTANCE.getRuleset().getMods());
        $onTilesetChange.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addUnitSetSelectBox$lambda$0(GameSettings $settings, SelectBox $unitSetSelectBox, String $nullValue, Function0 $onUnitsetChange, ChangeListener.ChangeEvent it) {
        $settings.setUnitSet(!Intrinsics.areEqual($unitSetSelectBox.getSelected(), $nullValue) ? (String)$unitSetSelectBox.getSelected() : null);
        TileSetCache.INSTANCE.assembleTileSetConfigs((Set<String>)ImageGetter.INSTANCE.getRuleset().getMods());
        $onUnitsetChange.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addSkinSelectBox$lambda$0(GameSettings $settings, SelectBox $skinSelectBox, Function0 $onSkinChange, ChangeListener.ChangeEvent it) {
        Object t = $skinSelectBox.getSelected();
        Intrinsics.checkNotNullExpressionValue(t, "getSelected(...)");
        $settings.setSkin((String)t);
        SkinCache.INSTANCE.assembleSkinConfigs((Set<String>)ImageGetter.INSTANCE.getRuleset().getMods());
        $onSkinChange.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addResetTutorials$lambda$0(Table $table, GameSettings $settings, TextButton $resetTutorialsButton) {
        Stage stage = $table.getStage();
        Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
        new ConfirmPopup(stage, "Do you want to reset completed tutorials?", "Reset", false, null, () -> DisplayTabKt.addResetTutorials$lambda$0$0($settings, $resetTutorialsButton), 24, null).open(true);
        return Unit.INSTANCE;
    }

    private static final Unit addResetTutorials$lambda$0$0(GameSettings $settings, TextButton $resetTutorialsButton) {
        $settings.getTutorialsShown().clear();
        $settings.getTutorialTasksCompleted().clear();
        $resetTutorialsButton.setText(TranslationsKt.tr$default("Done!", false, false, 3, null));
        $resetTutorialsButton.clearListeners();
        return Unit.INSTANCE;
    }

    private static final Unit addNotificationScrollSelect$lambda$1(GameSettings $settings, TranslatedSelectBox $selectBox, ChangeListener.ChangeEvent it) {
        $settings.setNotificationScroll(((TranslatedSelectBox.TranslatedString)$selectBox.getSelected()).getValue());
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }
}

