/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../../core/auth_flow/AuthFlowState.js";
import { SIGN_IN_COMPLETED_STATE_TYPE } from "../../../core/auth_flow/AuthFlowStateTypes.js";

/**
 * Represents the completed state of the sign-in operation.
 * This state indicates that the sign-in process has finished successfully.
 */
export class SignInCompletedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = SIGN_IN_COMPLETED_STATE_TYPE;
}
