/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../../core/auth_flow/AuthFlowState.js";
import {
    GET_ACCESS_TOKEN_COMPLETED_STATE_TYPE,
    GET_ACCESS_TOKEN_FAILED_STATE_TYPE,
} from "../../../core/auth_flow/AuthFlowStateTypes.js";

/**
 * The completed state of the get access token flow.
 */
export class GetAccessTokenCompletedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = GET_ACCESS_TOKEN_COMPLETED_STATE_TYPE;
}

/**
 * The failed state of the get access token flow.
 */
export class GetAccessTokenFailedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = GET_ACCESS_TOKEN_FAILED_STATE_TYPE;
}
