/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../../core/auth_flow/AuthFlowState.js";
import {
    GET_ACCOUNT_COMPLETED_STATE_TYPE,
    GET_ACCOUNT_FAILED_STATE_TYPE,
} from "../../../core/auth_flow/AuthFlowStateTypes.js";

/**
 * The completed state of the get account flow.
 */
export class GetAccountCompletedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = GET_ACCOUNT_COMPLETED_STATE_TYPE;
}

/**
 * The failed state of the get account flow.
 */
export class GetAccountFailedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = GET_ACCOUNT_FAILED_STATE_TYPE;
}
