/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../../core/auth_flow/AuthFlowState.js";
import { RESET_PASSWORD_FAILED_STATE_TYPE } from "../../../core/auth_flow/AuthFlowStateTypes.js";

/**
 * State of a reset password operation that has failed.
 */
export class ResetPasswordFailedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = RESET_PASSWORD_FAILED_STATE_TYPE;
}
