/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../../core/auth_flow/AuthFlowState.js";
import { SIGN_UP_FAILED_STATE_TYPE } from "../../../core/auth_flow/AuthFlowStateTypes.js";

/**
 * Represents the state of a sign-up operation that has failed.
 */
export class SignUpFailedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = SIGN_UP_FAILED_STATE_TYPE;
}
