/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemWritableFileStream.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FileSystemWritableFileStream::WriteCommandType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("write"),
        MAKE_STATIC_STRING_IMPL("seek"),
        MAKE_STATIC_STRING_IMPL("truncate"),
    };
    static_assert(static_cast<size_t>(FileSystemWritableFileStream::WriteCommandType::Write) == 0, "FileSystemWritableFileStream::WriteCommandType::Write is not 0 as expected");
    static_assert(static_cast<size_t>(FileSystemWritableFileStream::WriteCommandType::Seek) == 1, "FileSystemWritableFileStream::WriteCommandType::Seek is not 1 as expected");
    static_assert(static_cast<size_t>(FileSystemWritableFileStream::WriteCommandType::Truncate) == 2, "FileSystemWritableFileStream::WriteCommandType::Truncate is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FileSystemWritableFileStream::WriteCommandType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FileSystemWritableFileStream::WriteCommandType> parseEnumerationFromString<FileSystemWritableFileStream::WriteCommandType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, FileSystemWritableFileStream::WriteCommandType>, 3> mappings {
        std::pair<ComparableASCIILiteral, FileSystemWritableFileStream::WriteCommandType> { "seek"_s, FileSystemWritableFileStream::WriteCommandType::Seek },
        std::pair<ComparableASCIILiteral, FileSystemWritableFileStream::WriteCommandType> { "truncate"_s, FileSystemWritableFileStream::WriteCommandType::Truncate },
        std::pair<ComparableASCIILiteral, FileSystemWritableFileStream::WriteCommandType> { "write"_s, FileSystemWritableFileStream::WriteCommandType::Write },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FileSystemWritableFileStream::WriteCommandType> parseEnumeration<FileSystemWritableFileStream::WriteCommandType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FileSystemWritableFileStream::WriteCommandType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FileSystemWritableFileStream::WriteCommandType>()
{
    return "\"write\", \"seek\", \"truncate\""_s;
}

template<> ConversionResult<IDLDictionary<FileSystemWritableFileStream::WriteParams>> convertDictionary<FileSystemWritableFileStream::WriteParams>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FileSystemWritableFileStream::WriteParams result;
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!dataValue.isUndefined()) {
        auto dataConversionResult = convert<IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLInterface<Blob>, IDLUSVString>>>(lexicalGlobalObject, dataValue);
        if (dataConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.data = dataConversionResult.releaseReturnValue();
    }
    JSValue positionValue;
    if (isNullOrUndefined)
        positionValue = jsUndefined();
    else {
        positionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "position"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!positionValue.isUndefined()) {
        auto positionConversionResult = convert<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, positionValue);
        if (positionConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.position = positionConversionResult.releaseReturnValue();
    }
    JSValue sizeValue;
    if (isNullOrUndefined)
        sizeValue = jsUndefined();
    else {
        sizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "size"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sizeValue.isUndefined()) {
        auto sizeConversionResult = convert<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, sizeValue);
        if (sizeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.size = sizeConversionResult.releaseReturnValue();
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (typeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type"_s, "WriteParams"_s, "WriteCommandType"_s);
        return ConversionResultException { };
    }
    auto typeConversionResult = convert<IDLEnumeration<FileSystemWritableFileStream::WriteCommandType>>(lexicalGlobalObject, typeValue);
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const FileSystemWritableFileStream::WriteParams& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLInterface<Blob>, IDLUSVString>>::isNullValue(dictionary.data)) {
        auto dataValue = toJS<IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLInterface<Blob>, IDLUSVString>>>(lexicalGlobalObject, globalObject, throwScope, IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLInterface<Blob>, IDLUSVString>>::extractValueFromNullable(dictionary.data));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "data"_s), dataValue);
    }
    if (!IDLNullable<IDLUnsignedLongLong>::isNullValue(dictionary.position)) {
        auto positionValue = toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLNullable<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.position));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "position"_s), positionValue);
    }
    if (!IDLNullable<IDLUnsignedLongLong>::isNullValue(dictionary.size)) {
        auto sizeValue = toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLNullable<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.size));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "size"_s), sizeValue);
    }
    auto typeValue = toJS<IDLEnumeration<FileSystemWritableFileStream::WriteCommandType>>(lexicalGlobalObject, throwScope, dictionary.type);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "type"_s), typeValue);
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemWritableFileStreamPrototypeFunction_write);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemWritableFileStreamPrototypeFunction_seek);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemWritableFileStreamPrototypeFunction_truncate);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemWritableFileStreamConstructor);

class JSFileSystemWritableFileStreamPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemWritableFileStreamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemWritableFileStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemWritableFileStreamPrototype>(vm)) JSFileSystemWritableFileStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemWritableFileStreamPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemWritableFileStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemWritableFileStreamPrototype, JSFileSystemWritableFileStreamPrototype::Base);

using JSFileSystemWritableFileStreamDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemWritableFileStream>;

template<> const ClassInfo JSFileSystemWritableFileStreamDOMConstructor::s_info = { "FileSystemWritableFileStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemWritableFileStreamDOMConstructor) };

template<> JSValue JSFileSystemWritableFileStreamDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWritableStream::getConstructor(vm, &globalObject);
}

template<> void JSFileSystemWritableFileStreamDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemWritableFileStream"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemWritableFileStream::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSFileSystemWritableFileStreamPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemWritableFileStreamConstructor, 0 } },
    HashTableValue { "write"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemWritableFileStreamPrototypeFunction_write, 1 } },
    HashTableValue { "seek"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemWritableFileStreamPrototypeFunction_seek, 1 } },
    HashTableValue { "truncate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemWritableFileStreamPrototypeFunction_truncate, 1 } },
};

const ClassInfo JSFileSystemWritableFileStreamPrototype::s_info = { "FileSystemWritableFileStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemWritableFileStreamPrototype) };

void JSFileSystemWritableFileStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemWritableFileStream::info(), JSFileSystemWritableFileStreamPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemWritableFileStream::s_info = { "FileSystemWritableFileStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemWritableFileStream) };

JSFileSystemWritableFileStream::JSFileSystemWritableFileStream(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemWritableFileStream>&& impl)
    : JSWritableStream(structure, globalObject, WTFMove(impl))
{
}

Ref<FileSystemWritableFileStream> JSFileSystemWritableFileStream::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, FileSystemWritableFileStream>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSFileSystemWritableFileStream::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemWritableFileStreamPrototype::createStructure(vm, &globalObject, JSWritableStream::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFileSystemWritableFileStreamPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemWritableFileStream::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemWritableFileStream>(vm, globalObject);
}

JSValue JSFileSystemWritableFileStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemWritableFileStreamDOMConstructor, DOMConstructorID::FileSystemWritableFileStream>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemWritableFileStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemWritableFileStreamPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemWritableFileStream::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileSystemWritableFileStreamPrototypeFunction_writeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemWritableFileStream>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLInterface<Blob>, IDLUSVString, IDLDictionary<FileSystemWritableFileStream::WriteParams>>>(*lexicalGlobalObject, argument0.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.write(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), dataConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemWritableFileStreamPrototypeFunction_write, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemWritableFileStream>::call<jsFileSystemWritableFileStreamPrototypeFunction_writeBody>(*lexicalGlobalObject, *callFrame, "write");
}

static inline JSC::EncodedJSValue jsFileSystemWritableFileStreamPrototypeFunction_seekBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemWritableFileStream>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto positionConversionResult = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, argument0.value());
    if (positionConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.seek(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), positionConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemWritableFileStreamPrototypeFunction_seek, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemWritableFileStream>::call<jsFileSystemWritableFileStreamPrototypeFunction_seekBody>(*lexicalGlobalObject, *callFrame, "seek");
}

static inline JSC::EncodedJSValue jsFileSystemWritableFileStreamPrototypeFunction_truncateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemWritableFileStream>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sizeConversionResult = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, argument0.value());
    if (sizeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.truncate(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), sizeConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemWritableFileStreamPrototypeFunction_truncate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemWritableFileStream>::call<jsFileSystemWritableFileStreamPrototypeFunction_truncateBody>(*lexicalGlobalObject, *callFrame, "truncate");
}

JSC::GCClient::IsoSubspace* JSFileSystemWritableFileStream::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemWritableFileStream, UseCustomHeapCellType::No>(vm, "JSFileSystemWritableFileStream"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemWritableFileStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemWritableFileStream = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemWritableFileStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemWritableFileStream = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemWritableFileStream::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemWritableFileStream*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
