/*
    Copyright 2021 natinusala

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#include <borealis/core/bind.hpp>

namespace brls
{

ViewNotFoundException::ViewNotFoundException(View* owner, std::string searchedId)
{
    this->errorMessage = "Cannot find view with ID \"" + searchedId + "\" in owner view " + owner->describe();
}

ViewNotFoundException::ViewNotFoundException(Activity* owner, std::string searchedId)
{
    this->errorMessage = "Cannot find view with ID \"" + searchedId + "\" in given owner activity";
}

const char* ViewNotFoundException::what() const noexcept
{
    return this->errorMessage.c_str();
}

} // namespace brls
