/*
    Copyright 2021 XITRIX

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#pragma once

#include <borealis/core/application.hpp>
#include <borealis/core/bind.hpp>
#include <borealis/core/box.hpp>
#include <borealis/views/cells/cell_detail.hpp>
#include <borealis/views/recycler.hpp>
#include <string>

namespace brls
{

class SelectorCell : public DetailCell
{
  public:
    SelectorCell();

    void init(std::string title, std::vector<std::string> data, int selected, Event<int>::Callback callback, Event<int>::Callback dismissCb = [](int){});

    void setData(std::vector<std::string> data)
    {
        this->data = data;
    }

    void setSelection(int selection, bool silent = false);
    int getSelection()
    {
        return selection;
    }

    Event<int>* getEvent()
    {
        return &event;
    }

    static View* create();

  protected:
    int selection;
    std::vector<std::string> data;

    Event<int> event;
    Event<int>::Callback dismissCb;
    void updateUI();
};

} // namespace brls
