// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.


// Take the name prefix into account.
#define yylex   frontend_verilog_yylex



#include "verilog_parser.tab.hh"


// Unqualified %code blocks.
#line 127 "frontends/verilog/verilog_parser.y"

	#include <list>
	#include <stack>
	#include <memory>
	#include <string.h>
	#include "kernel/log.h"
	#include "frontends/verilog/verilog_lexer.h"

	USING_YOSYS_NAMESPACE
	using namespace AST;
	using namespace VERILOG_FRONTEND;

	// Silly little C adapter between C++ bison and C++ flex
	auto frontend_verilog_yylex(YOSYS_NAMESPACE_PREFIX VERILOG_FRONTEND::VerilogLexer* lexer) {
		return lexer->nextToken();
	}

	#define SET_AST_NODE_LOC(WHICH, BEGIN, END) (WHICH)->location = location_range(BEGIN, END)

	#define SET_RULE_LOC(LHS, BEGIN, END) \
		do { (LHS).begin = BEGIN.begin; \
		(LHS).end = (END).end; } while(0)

	YOSYS_NAMESPACE_BEGIN
	namespace VERILOG_FRONTEND {

		static Location location_range(Location begin, Location end) {
			return Location(begin.begin, end.end);
		}

		static void append_attr(AstNode *ast, std::unique_ptr<dict<IdString, std::unique_ptr<AstNode>>> al)
		{
			for (auto &it : *al) {
				ast->attributes[it.first] = std::move(it.second);
			}
		}

		static void append_attr_clone(AstNode *ast, std::unique_ptr<dict<IdString, std::unique_ptr<AstNode>>> &al)
		{
			for (auto &it : *al) {
				ast->attributes[it.first] = it.second->clone();
			}
		}

		static std::unique_ptr<AstNode> makeRange(parser::location_type loc, int msb = 31, int lsb = 0, bool isSigned = true)
		{
			auto range = std::make_unique<AstNode>(loc, AST_RANGE);
			range->children.push_back(AstNode::mkconst_int(loc, msb, true));
			range->children.push_back(AstNode::mkconst_int(loc, lsb, true));
			range->is_signed = isSigned;
			return range;
		}

		static void addRange(AstNode *parent, int msb = 31, int lsb = 0, bool isSigned = true)
		{
			auto range = makeRange(parent->location, msb, lsb, isSigned);
			parent->children.push_back(std::move(range));
		}

		static std::unique_ptr<AstNode> checkRange(AstNode *type_node, std::unique_ptr<AstNode> range_node)
		{
			if (type_node->range_left >= 0 && type_node->range_right >= 0) {
				// type already restricts the range
				if (range_node) {
					err_at_loc(type_node->location, "integer/genvar types cannot have packed dimensions.");
				}
				else {
					range_node = makeRange(type_node->location, type_node->range_left, type_node->range_right, false);
				}
			}

			if (range_node) {
				bool valid = true;
				if (range_node->type == AST_RANGE) {
					valid = range_node->children.size() == 2;
				} else {  // AST_MULTIRANGE
					for (auto& child : range_node->children) {
						valid = valid && child->children.size() == 2;
					}
				}
				if (!valid)
					err_at_loc(type_node->location, "wire/reg/logic packed dimension must be of the form [<expr>:<expr>]");
			}

			return range_node;
		}

		static void rewriteRange(AstNode *rangeNode)
		{
			if (rangeNode->type == AST_RANGE && rangeNode->children.size() == 1) {
				// SV array size [n], rewrite as [0:n-1]
				rangeNode->children.push_back(std::make_unique<AstNode>(rangeNode->location, AST_SUB, std::move(rangeNode->children[0]), AstNode::mkconst_int(rangeNode->location, 1, true)));
				rangeNode->children[0] = AstNode::mkconst_int(rangeNode->location, 0, false);
			}
		}

		static void rewriteAsMemoryNode(AstNode *node, std::unique_ptr<AstNode> rangeNode)
		{
			node->type = AST_MEMORY;
			if (rangeNode->type == AST_MULTIRANGE) {
				for (auto& child : rangeNode->children)
					rewriteRange(child.get());
			} else
				rewriteRange(rangeNode.get());
			node->children.push_back(std::move(rangeNode));
		}

		static void checkLabelsMatch(const frontend_verilog_yy::parser::location_type& loc, const char *element, const std::string* before, const std::string *after)
		{
			if (!before && after)
				err_at_loc(loc, "%s missing where end label (%s) was given.",
					element, after->c_str() + 1);
			if (before && after && *before != *after)
				err_at_loc(loc, "%s (%s) and end label (%s) don't match.",
					element, before->c_str() + 1, after->c_str() + 1);
		}

		AstNode* ParseState::saveChild(std::unique_ptr<AstNode> child) {
			auto* child_leaky = child.get();
			ast_stack.back()->children.push_back(std::move(child));
			return child_leaky;
		}
		AstNode* ParseState::pushChild(std::unique_ptr<AstNode> child) {
			auto* child_leaky = saveChild(std::move(child));
			ast_stack.push_back(child_leaky);
			return child_leaky;
		}

		void ParseState::addWiretypeNode(std::string *name, AstNode* node)
		{
			log_assert(node);
			node->is_custom_type = true;
			node->children.push_back(std::make_unique<AstNode>(node->location, AST_WIRETYPE));
			node->children.back()->str = *name;
		}

		void ParseState::addTypedefNode(std::string *name, std::unique_ptr<AstNode> node)
		{
			log_assert((bool)node);
			AstNode* tnode = saveChild(std::make_unique<AstNode>(node->location, AST_TYPEDEF, std::move(node)));
			log_assert((bool)name);
			tnode->str = *name;
			auto &user_types = user_type_stack.back();
			user_types[*name] = tnode;
			if (current_ast_mod && current_ast_mod->type == AST_PACKAGE) {
				// typedef inside a package so we need the qualified name
				auto qname = current_ast_mod->str + "::" + (*name).substr(1);
				pkg_user_types[qname] = tnode;
			}
		}

		void ParseState::enterTypeScope()
		{
			user_type_stack.push_back(UserTypeMap());
		}

		void ParseState::exitTypeScope()
		{
			user_type_stack.pop_back();
		}

		bool ParseState::isInLocalScope(const std::string *name)
		{
			// tests if a name was declared in the current block scope
			auto &user_types = user_type_stack.back();
			return (user_types.count(*name) > 0);
		}

		// This transforms a loop like
		//   for (genvar i = 0; i < 10; i++) begin : blk
		// to
		//   genvar _i;
		//   for (_i = 0; _i < 10; _i++) begin : blk
		//     localparam i = _i;
		// where `_i` is actually some auto-generated name.
		void ParseState::rewriteGenForDeclInit(AstNode *loop)
		{
			// check if this generate for loop contains an inline declaration
			log_assert(loop->type == AST_GENFOR);
			auto& decl = loop->children[0];
			if (decl->type == AST_ASSIGN_EQ)
				return;

			log_assert(decl->type == AST_GENVAR);
			log_assert(loop->children.size() == 5);

			// identify each component of the loop
			AstNode *init = loop->children[1].get();
			AstNode *cond = loop->children[2].get();
			AstNode *incr = loop->children[3].get();
			AstNode *body = loop->children[4].get();
			log_assert(init->type == AST_ASSIGN_EQ);
			log_assert(incr->type == AST_ASSIGN_EQ);
			log_assert(body->type == AST_GENBLOCK);

			// create a unique name for the genvar
			std::string old_str = decl->str;
			std::string new_str = stringf("$genfordecl$%d$%s", autoidx++, old_str);

			// rename and move the genvar declaration to the containing description
			decl->str = new_str;
			log_assert(current_ast_mod != nullptr);
			current_ast_mod->children.push_back(std::move(decl));

			// create a new localparam with old name so that the items in the loop
			// can simply use the old name and shadow it as necessary
			auto indirect = std::make_unique<AstNode>(loop->location, AST_LOCALPARAM);
			indirect->str = old_str;
			auto ident = std::make_unique<AstNode>(loop->location, AST_IDENTIFIER);
			ident->str = new_str;
			indirect->children.push_back(std::move(ident));

			body->children.insert(body->children.begin(), std::move(indirect));

			// only perform the renaming for the initialization, guard, and
			// incrementation to enable proper shadowing of the synthetic localparam
			std::function<void(AstNode*)> substitute = [&](AstNode *node) {
				if (node->type == AST_IDENTIFIER && node->str == old_str)
					node->str = new_str;
				for (auto& child : node->children)
					substitute(child.get());
			};
			substitute(init);
			substitute(cond);
			substitute(incr);
			loop->children.erase(loop->children.begin());
		}

		void ParseState::ensureAsgnExprAllowed(const parser::location_type loc, bool sv_mode)
		{
			if (!sv_mode)
				err_at_loc(loc, "Assignments within expressions are only supported in SystemVerilog mode.");
			if (ast_stack.back()->type != AST_BLOCK)
				err_at_loc(loc, "Assignments within expressions are only permitted within procedures.");
		}

		// add a pre/post-increment/decrement statement
		const AstNode *ParseState::addIncOrDecStmt(std::unique_ptr<dict<IdString, std::unique_ptr<AstNode>>> stmt_attr,
							std::unique_ptr<AstNode> lhs,
							std::unique_ptr<dict<IdString, std::unique_ptr<AstNode>>> op_attr, AST::AstNodeType op,
							Location loc)
		{
			auto one = AstNode::mkconst_int(loc, 1, true);
			auto rhs = std::make_unique<AstNode>(loc, op, lhs->clone(), std::move(one));
			if (op_attr)
				append_attr(rhs.get(), std::move(op_attr));
			auto stmt_owned = std::make_unique<AstNode>(loc, AST_ASSIGN_EQ, std::move(lhs), std::move(rhs));
			auto* stmt = stmt_owned.get();
			ast_stack.back()->children.push_back(std::move(stmt_owned));
			if (stmt_attr)
				append_attr(stmt, std::move(stmt_attr));
			return stmt;
		}

		// create a pre/post-increment/decrement expression, and add the corresponding statement
		std::unique_ptr<AstNode> ParseState::addIncOrDecExpr(std::unique_ptr<AstNode> lhs,
								     std::unique_ptr<dict<IdString,
								     std::unique_ptr<AstNode>>> attr,
								     AST::AstNodeType op, Location loc, bool undo, bool sv_mode)
		{
			ensureAsgnExprAllowed(loc, sv_mode);
			const AstNode *stmt = addIncOrDecStmt(nullptr, std::move(lhs), std::move(attr), op, loc);
			log_assert(stmt->type == AST_ASSIGN_EQ);
			auto expr = stmt->children[0]->clone();
			if (undo) {
				auto one = AstNode::mkconst_int(loc, 1, false, 1);
				auto minus_one = std::make_unique<AstNode>(loc, AST_NEG, std::move(one));
				expr = std::make_unique<AstNode>(loc, op, std::move(expr), std::move(minus_one));
			}
			return expr;
		}

		// add a binary operator assignment statement, e.g., a += b
		std::unique_ptr<AstNode> ParseState::addAsgnBinopStmt(std::unique_ptr<dict<IdString, std::unique_ptr<AstNode>>> attr,
								      std::unique_ptr<AstNode> eq_lhs, AST::AstNodeType op, std::unique_ptr<AstNode> rhs)
		{
			Location loc = location_range(eq_lhs->location, rhs->location);
			if (op == AST_SHIFT_LEFT || op == AST_SHIFT_RIGHT ||
				op == AST_SHIFT_SLEFT || op == AST_SHIFT_SRIGHT) {
				rhs = std::make_unique<AstNode>(rhs->location, AST_TO_UNSIGNED, std::move(rhs));
			}
			auto binop_lhs = eq_lhs->clone();
			auto eq_rhs_owned = std::make_unique<AstNode>(loc, op, std::move(binop_lhs), std::move(rhs));
			auto ret_lhs = eq_lhs->clone();
			auto stmt_owned = std::make_unique<AstNode>(loc, AST_ASSIGN_EQ, std::move(eq_lhs), std::move(eq_rhs_owned));
			auto* stmt = stmt_owned.get();
			ast_stack.back()->children.push_back(std::move(stmt_owned));
			if (attr)
				append_attr(stmt, std::move(attr));
			return ret_lhs;
		}
	};
	YOSYS_NAMESPACE_END

	void frontend_verilog_yy::parser::error(const frontend_verilog_yy::parser::location_type& loc, const std::string& msg)
	{
		err_at_loc(loc, "%s", msg);
	}

#line 348 "frontends/verilog/verilog_parser.tab.cc"


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (false)
# endif


// Enable debugging if requested.
#if FRONTEND_VERILOG_YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !FRONTEND_VERILOG_YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !FRONTEND_VERILOG_YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

namespace frontend_verilog_yy {
#line 440 "frontends/verilog/verilog_parser.tab.cc"

  /// Build a parser object.
  parser::parser (YOSYS_NAMESPACE_PREFIX VERILOG_FRONTEND::VerilogLexer* lexer_yyarg, YOSYS_NAMESPACE_PREFIX VERILOG_FRONTEND::ParseState* extra_yyarg, YOSYS_NAMESPACE_PREFIX VERILOG_FRONTEND::ParseMode* mode_yyarg)
#if FRONTEND_VERILOG_YYDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      yy_lac_established_ (false),
      lexer (lexer_yyarg),
      extra (extra_yyarg),
      mode (mode_yyarg)
  {}

  parser::~parser ()
  {}

  parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------.
  | symbol.  |
  `---------*/



  // by_state.
  parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  parser::symbol_kind_type
  parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  parser::stack_symbol_type::stack_symbol_type ()
  {}

  parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state), YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_al_t: // al_t
      case symbol_kind::S_attr: // attr
      case symbol_kind::S_if_attr: // if_attr
      case symbol_kind::S_case_attr: // case_attr
        value.YY_MOVE_OR_COPY< al_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ast_node_type_t: // ast_node_type_t
      case symbol_kind::S_asgn_binop: // asgn_binop
      case symbol_kind::S_inc_or_dec_op: // inc_or_dec_op
        value.YY_MOVE_OR_COPY< ast_node_type_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ast_t: // ast_t
      case symbol_kind::S_io_wire_type: // io_wire_type
      case symbol_kind::S_non_io_wire_type: // non_io_wire_type
      case symbol_kind::S_wire_type: // wire_type
      case symbol_kind::S_non_opt_range: // non_opt_range
      case symbol_kind::S_non_opt_multirange: // non_opt_multirange
      case symbol_kind::S_range: // range
      case symbol_kind::S_range_or_multirange: // range_or_multirange
      case symbol_kind::S_func_return_type: // func_return_type
      case symbol_kind::S_specify_if: // specify_if
      case symbol_kind::S_specify_condition: // specify_condition
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_opt_enum_init: // opt_enum_init
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_struct_union: // struct_union
      case symbol_kind::S_typedef_base_type: // typedef_base_type
      case symbol_kind::S_enum_struct_type: // enum_struct_type
      case symbol_kind::S_rvalue: // rvalue
      case symbol_kind::S_lvalue: // lvalue
      case symbol_kind::S_lvalue_concat_list: // lvalue_concat_list
      case symbol_kind::S_genvar_identifier: // genvar_identifier
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_basic_expr: // basic_expr
      case symbol_kind::S_503_84: // @84
      case symbol_kind::S_concat_list: // concat_list
        value.YY_MOVE_OR_COPY< ast_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_boolean_t: // "boolean"
      case symbol_kind::S_opt_signedness_default_signed: // opt_signedness_default_signed
      case symbol_kind::S_opt_signedness_default_unsigned: // opt_signedness_default_unsigned
      case symbol_kind::S_always_comb_or_latch: // always_comb_or_latch
      case symbol_kind::S_always_or_always_ff: // always_or_always_ff
      case symbol_kind::S_opt_property: // opt_property
        value.YY_MOVE_OR_COPY< boolean_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ch_t: // "invalid token"
      case symbol_kind::S_specify_edge: // specify_edge
        value.YY_MOVE_OR_COPY< ch_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_integer_t: // "integer"
      case symbol_kind::S_integer_atom_type: // integer_atom_type
      case symbol_kind::S_integer_vector_type: // integer_vector_type
        value.YY_MOVE_OR_COPY< integer_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_specify_rise_fall_ptr_t: // "specify rise and fall"
      case symbol_kind::S_specify_rise_fall: // specify_rise_fall
        value.YY_MOVE_OR_COPY< specify_rise_fall_ptr_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_specify_target_ptr_t: // "specify target"
      case symbol_kind::S_specify_target: // specify_target
        value.YY_MOVE_OR_COPY< specify_target_ptr_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_specify_triple_ptr_t: // "specify triple"
      case symbol_kind::S_specify_opt_triple: // specify_opt_triple
      case symbol_kind::S_specify_triple: // specify_triple
        value.YY_MOVE_OR_COPY< specify_triple_ptr_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_t: // "string"
      case symbol_kind::S_TOK_STRING: // TOK_STRING
      case symbol_kind::S_TOK_ID: // TOK_ID
      case symbol_kind::S_TOK_CONSTVAL: // TOK_CONSTVAL
      case symbol_kind::S_TOK_REALVAL: // TOK_REALVAL
      case symbol_kind::S_TOK_PRIMITIVE: // TOK_PRIMITIVE
      case symbol_kind::S_TOK_SVA_LABEL: // TOK_SVA_LABEL
      case symbol_kind::S_TOK_SPECIFY_OPER: // TOK_SPECIFY_OPER
      case symbol_kind::S_TOK_MSG_TASKS: // TOK_MSG_TASKS
      case symbol_kind::S_TOK_BASE: // TOK_BASE
      case symbol_kind::S_TOK_BASED_CONSTVAL: // TOK_BASED_CONSTVAL
      case symbol_kind::S_TOK_UNBASED_UNSIZED_CONSTVAL: // TOK_UNBASED_UNSIZED_CONSTVAL
      case symbol_kind::S_TOK_USER_TYPE: // TOK_USER_TYPE
      case symbol_kind::S_TOK_PKG_USER_TYPE: // TOK_PKG_USER_TYPE
      case symbol_kind::S_hierarchical_id: // hierarchical_id
      case symbol_kind::S_hierarchical_type_id: // hierarchical_type_id
      case symbol_kind::S_type_name: // type_name
      case symbol_kind::S_tok_prim_wrapper: // tok_prim_wrapper
      case symbol_kind::S_opt_label: // opt_label
      case symbol_kind::S_opt_sva_label: // opt_sva_label
      case symbol_kind::S_integral_number: // integral_number
        value.YY_MOVE_OR_COPY< string_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s, YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_al_t: // al_t
      case symbol_kind::S_attr: // attr
      case symbol_kind::S_if_attr: // if_attr
      case symbol_kind::S_case_attr: // case_attr
        value.move< al_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ast_node_type_t: // ast_node_type_t
      case symbol_kind::S_asgn_binop: // asgn_binop
      case symbol_kind::S_inc_or_dec_op: // inc_or_dec_op
        value.move< ast_node_type_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ast_t: // ast_t
      case symbol_kind::S_io_wire_type: // io_wire_type
      case symbol_kind::S_non_io_wire_type: // non_io_wire_type
      case symbol_kind::S_wire_type: // wire_type
      case symbol_kind::S_non_opt_range: // non_opt_range
      case symbol_kind::S_non_opt_multirange: // non_opt_multirange
      case symbol_kind::S_range: // range
      case symbol_kind::S_range_or_multirange: // range_or_multirange
      case symbol_kind::S_func_return_type: // func_return_type
      case symbol_kind::S_specify_if: // specify_if
      case symbol_kind::S_specify_condition: // specify_condition
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_opt_enum_init: // opt_enum_init
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_struct_union: // struct_union
      case symbol_kind::S_typedef_base_type: // typedef_base_type
      case symbol_kind::S_enum_struct_type: // enum_struct_type
      case symbol_kind::S_rvalue: // rvalue
      case symbol_kind::S_lvalue: // lvalue
      case symbol_kind::S_lvalue_concat_list: // lvalue_concat_list
      case symbol_kind::S_genvar_identifier: // genvar_identifier
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_basic_expr: // basic_expr
      case symbol_kind::S_503_84: // @84
      case symbol_kind::S_concat_list: // concat_list
        value.move< ast_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_boolean_t: // "boolean"
      case symbol_kind::S_opt_signedness_default_signed: // opt_signedness_default_signed
      case symbol_kind::S_opt_signedness_default_unsigned: // opt_signedness_default_unsigned
      case symbol_kind::S_always_comb_or_latch: // always_comb_or_latch
      case symbol_kind::S_always_or_always_ff: // always_or_always_ff
      case symbol_kind::S_opt_property: // opt_property
        value.move< boolean_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ch_t: // "invalid token"
      case symbol_kind::S_specify_edge: // specify_edge
        value.move< ch_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_integer_t: // "integer"
      case symbol_kind::S_integer_atom_type: // integer_atom_type
      case symbol_kind::S_integer_vector_type: // integer_vector_type
        value.move< integer_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_specify_rise_fall_ptr_t: // "specify rise and fall"
      case symbol_kind::S_specify_rise_fall: // specify_rise_fall
        value.move< specify_rise_fall_ptr_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_specify_target_ptr_t: // "specify target"
      case symbol_kind::S_specify_target: // specify_target
        value.move< specify_target_ptr_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_specify_triple_ptr_t: // "specify triple"
      case symbol_kind::S_specify_opt_triple: // specify_opt_triple
      case symbol_kind::S_specify_triple: // specify_triple
        value.move< specify_triple_ptr_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_t: // "string"
      case symbol_kind::S_TOK_STRING: // TOK_STRING
      case symbol_kind::S_TOK_ID: // TOK_ID
      case symbol_kind::S_TOK_CONSTVAL: // TOK_CONSTVAL
      case symbol_kind::S_TOK_REALVAL: // TOK_REALVAL
      case symbol_kind::S_TOK_PRIMITIVE: // TOK_PRIMITIVE
      case symbol_kind::S_TOK_SVA_LABEL: // TOK_SVA_LABEL
      case symbol_kind::S_TOK_SPECIFY_OPER: // TOK_SPECIFY_OPER
      case symbol_kind::S_TOK_MSG_TASKS: // TOK_MSG_TASKS
      case symbol_kind::S_TOK_BASE: // TOK_BASE
      case symbol_kind::S_TOK_BASED_CONSTVAL: // TOK_BASED_CONSTVAL
      case symbol_kind::S_TOK_UNBASED_UNSIZED_CONSTVAL: // TOK_UNBASED_UNSIZED_CONSTVAL
      case symbol_kind::S_TOK_USER_TYPE: // TOK_USER_TYPE
      case symbol_kind::S_TOK_PKG_USER_TYPE: // TOK_PKG_USER_TYPE
      case symbol_kind::S_hierarchical_id: // hierarchical_id
      case symbol_kind::S_hierarchical_type_id: // hierarchical_type_id
      case symbol_kind::S_type_name: // type_name
      case symbol_kind::S_tok_prim_wrapper: // tok_prim_wrapper
      case symbol_kind::S_opt_label: // opt_label
      case symbol_kind::S_opt_sva_label: // opt_sva_label
      case symbol_kind::S_integral_number: // integral_number
        value.move< string_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_al_t: // al_t
      case symbol_kind::S_attr: // attr
      case symbol_kind::S_if_attr: // if_attr
      case symbol_kind::S_case_attr: // case_attr
        value.copy< al_t > (that.value);
        break;

      case symbol_kind::S_ast_node_type_t: // ast_node_type_t
      case symbol_kind::S_asgn_binop: // asgn_binop
      case symbol_kind::S_inc_or_dec_op: // inc_or_dec_op
        value.copy< ast_node_type_t > (that.value);
        break;

      case symbol_kind::S_ast_t: // ast_t
      case symbol_kind::S_io_wire_type: // io_wire_type
      case symbol_kind::S_non_io_wire_type: // non_io_wire_type
      case symbol_kind::S_wire_type: // wire_type
      case symbol_kind::S_non_opt_range: // non_opt_range
      case symbol_kind::S_non_opt_multirange: // non_opt_multirange
      case symbol_kind::S_range: // range
      case symbol_kind::S_range_or_multirange: // range_or_multirange
      case symbol_kind::S_func_return_type: // func_return_type
      case symbol_kind::S_specify_if: // specify_if
      case symbol_kind::S_specify_condition: // specify_condition
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_opt_enum_init: // opt_enum_init
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_struct_union: // struct_union
      case symbol_kind::S_typedef_base_type: // typedef_base_type
      case symbol_kind::S_enum_struct_type: // enum_struct_type
      case symbol_kind::S_rvalue: // rvalue
      case symbol_kind::S_lvalue: // lvalue
      case symbol_kind::S_lvalue_concat_list: // lvalue_concat_list
      case symbol_kind::S_genvar_identifier: // genvar_identifier
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_basic_expr: // basic_expr
      case symbol_kind::S_503_84: // @84
      case symbol_kind::S_concat_list: // concat_list
        value.copy< ast_t > (that.value);
        break;

      case symbol_kind::S_boolean_t: // "boolean"
      case symbol_kind::S_opt_signedness_default_signed: // opt_signedness_default_signed
      case symbol_kind::S_opt_signedness_default_unsigned: // opt_signedness_default_unsigned
      case symbol_kind::S_always_comb_or_latch: // always_comb_or_latch
      case symbol_kind::S_always_or_always_ff: // always_or_always_ff
      case symbol_kind::S_opt_property: // opt_property
        value.copy< boolean_t > (that.value);
        break;

      case symbol_kind::S_ch_t: // "invalid token"
      case symbol_kind::S_specify_edge: // specify_edge
        value.copy< ch_t > (that.value);
        break;

      case symbol_kind::S_integer_t: // "integer"
      case symbol_kind::S_integer_atom_type: // integer_atom_type
      case symbol_kind::S_integer_vector_type: // integer_vector_type
        value.copy< integer_t > (that.value);
        break;

      case symbol_kind::S_specify_rise_fall_ptr_t: // "specify rise and fall"
      case symbol_kind::S_specify_rise_fall: // specify_rise_fall
        value.copy< specify_rise_fall_ptr_t > (that.value);
        break;

      case symbol_kind::S_specify_target_ptr_t: // "specify target"
      case symbol_kind::S_specify_target: // specify_target
        value.copy< specify_target_ptr_t > (that.value);
        break;

      case symbol_kind::S_specify_triple_ptr_t: // "specify triple"
      case symbol_kind::S_specify_opt_triple: // specify_opt_triple
      case symbol_kind::S_specify_triple: // specify_triple
        value.copy< specify_triple_ptr_t > (that.value);
        break;

      case symbol_kind::S_string_t: // "string"
      case symbol_kind::S_TOK_STRING: // TOK_STRING
      case symbol_kind::S_TOK_ID: // TOK_ID
      case symbol_kind::S_TOK_CONSTVAL: // TOK_CONSTVAL
      case symbol_kind::S_TOK_REALVAL: // TOK_REALVAL
      case symbol_kind::S_TOK_PRIMITIVE: // TOK_PRIMITIVE
      case symbol_kind::S_TOK_SVA_LABEL: // TOK_SVA_LABEL
      case symbol_kind::S_TOK_SPECIFY_OPER: // TOK_SPECIFY_OPER
      case symbol_kind::S_TOK_MSG_TASKS: // TOK_MSG_TASKS
      case symbol_kind::S_TOK_BASE: // TOK_BASE
      case symbol_kind::S_TOK_BASED_CONSTVAL: // TOK_BASED_CONSTVAL
      case symbol_kind::S_TOK_UNBASED_UNSIZED_CONSTVAL: // TOK_UNBASED_UNSIZED_CONSTVAL
      case symbol_kind::S_TOK_USER_TYPE: // TOK_USER_TYPE
      case symbol_kind::S_TOK_PKG_USER_TYPE: // TOK_PKG_USER_TYPE
      case symbol_kind::S_hierarchical_id: // hierarchical_id
      case symbol_kind::S_hierarchical_type_id: // hierarchical_type_id
      case symbol_kind::S_type_name: // type_name
      case symbol_kind::S_tok_prim_wrapper: // tok_prim_wrapper
      case symbol_kind::S_opt_label: // opt_label
      case symbol_kind::S_opt_sva_label: // opt_sva_label
      case symbol_kind::S_integral_number: // integral_number
        value.copy< string_t > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    return *this;
  }

  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_al_t: // al_t
      case symbol_kind::S_attr: // attr
      case symbol_kind::S_if_attr: // if_attr
      case symbol_kind::S_case_attr: // case_attr
        value.move< al_t > (that.value);
        break;

      case symbol_kind::S_ast_node_type_t: // ast_node_type_t
      case symbol_kind::S_asgn_binop: // asgn_binop
      case symbol_kind::S_inc_or_dec_op: // inc_or_dec_op
        value.move< ast_node_type_t > (that.value);
        break;

      case symbol_kind::S_ast_t: // ast_t
      case symbol_kind::S_io_wire_type: // io_wire_type
      case symbol_kind::S_non_io_wire_type: // non_io_wire_type
      case symbol_kind::S_wire_type: // wire_type
      case symbol_kind::S_non_opt_range: // non_opt_range
      case symbol_kind::S_non_opt_multirange: // non_opt_multirange
      case symbol_kind::S_range: // range
      case symbol_kind::S_range_or_multirange: // range_or_multirange
      case symbol_kind::S_func_return_type: // func_return_type
      case symbol_kind::S_specify_if: // specify_if
      case symbol_kind::S_specify_condition: // specify_condition
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_opt_enum_init: // opt_enum_init
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_struct_union: // struct_union
      case symbol_kind::S_typedef_base_type: // typedef_base_type
      case symbol_kind::S_enum_struct_type: // enum_struct_type
      case symbol_kind::S_rvalue: // rvalue
      case symbol_kind::S_lvalue: // lvalue
      case symbol_kind::S_lvalue_concat_list: // lvalue_concat_list
      case symbol_kind::S_genvar_identifier: // genvar_identifier
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_basic_expr: // basic_expr
      case symbol_kind::S_503_84: // @84
      case symbol_kind::S_concat_list: // concat_list
        value.move< ast_t > (that.value);
        break;

      case symbol_kind::S_boolean_t: // "boolean"
      case symbol_kind::S_opt_signedness_default_signed: // opt_signedness_default_signed
      case symbol_kind::S_opt_signedness_default_unsigned: // opt_signedness_default_unsigned
      case symbol_kind::S_always_comb_or_latch: // always_comb_or_latch
      case symbol_kind::S_always_or_always_ff: // always_or_always_ff
      case symbol_kind::S_opt_property: // opt_property
        value.move< boolean_t > (that.value);
        break;

      case symbol_kind::S_ch_t: // "invalid token"
      case symbol_kind::S_specify_edge: // specify_edge
        value.move< ch_t > (that.value);
        break;

      case symbol_kind::S_integer_t: // "integer"
      case symbol_kind::S_integer_atom_type: // integer_atom_type
      case symbol_kind::S_integer_vector_type: // integer_vector_type
        value.move< integer_t > (that.value);
        break;

      case symbol_kind::S_specify_rise_fall_ptr_t: // "specify rise and fall"
      case symbol_kind::S_specify_rise_fall: // specify_rise_fall
        value.move< specify_rise_fall_ptr_t > (that.value);
        break;

      case symbol_kind::S_specify_target_ptr_t: // "specify target"
      case symbol_kind::S_specify_target: // specify_target
        value.move< specify_target_ptr_t > (that.value);
        break;

      case symbol_kind::S_specify_triple_ptr_t: // "specify triple"
      case symbol_kind::S_specify_opt_triple: // specify_opt_triple
      case symbol_kind::S_specify_triple: // specify_triple
        value.move< specify_triple_ptr_t > (that.value);
        break;

      case symbol_kind::S_string_t: // "string"
      case symbol_kind::S_TOK_STRING: // TOK_STRING
      case symbol_kind::S_TOK_ID: // TOK_ID
      case symbol_kind::S_TOK_CONSTVAL: // TOK_CONSTVAL
      case symbol_kind::S_TOK_REALVAL: // TOK_REALVAL
      case symbol_kind::S_TOK_PRIMITIVE: // TOK_PRIMITIVE
      case symbol_kind::S_TOK_SVA_LABEL: // TOK_SVA_LABEL
      case symbol_kind::S_TOK_SPECIFY_OPER: // TOK_SPECIFY_OPER
      case symbol_kind::S_TOK_MSG_TASKS: // TOK_MSG_TASKS
      case symbol_kind::S_TOK_BASE: // TOK_BASE
      case symbol_kind::S_TOK_BASED_CONSTVAL: // TOK_BASED_CONSTVAL
      case symbol_kind::S_TOK_UNBASED_UNSIZED_CONSTVAL: // TOK_UNBASED_UNSIZED_CONSTVAL
      case symbol_kind::S_TOK_USER_TYPE: // TOK_USER_TYPE
      case symbol_kind::S_TOK_PKG_USER_TYPE: // TOK_PKG_USER_TYPE
      case symbol_kind::S_hierarchical_id: // hierarchical_id
      case symbol_kind::S_hierarchical_type_id: // hierarchical_type_id
      case symbol_kind::S_type_name: // type_name
      case symbol_kind::S_tok_prim_wrapper: // tok_prim_wrapper
      case symbol_kind::S_opt_label: // opt_label
      case symbol_kind::S_opt_sva_label: // opt_sva_label
      case symbol_kind::S_integral_number: // integral_number
        value.move< string_t > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if FRONTEND_VERILOG_YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " ("
            << yysym.location << ": ";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  parser::yypop_ (int n) YY_NOEXCEPT
  {
    yystack_.pop (n);
  }

#if FRONTEND_VERILOG_YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // FRONTEND_VERILOG_YYDEBUG

  parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  parser::yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  parser::yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::operator() ()
  {
    return parse ();
  }

  int
  parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

    // Discard the LAC context in case there still is one left from a
    // previous invocation.
    yy_lac_discard_ ("init");

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            symbol_type yylookahead (yylex (lexer));
            yyla.move (yylookahead);
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        if (!yy_lac_establish_ (yyla.kind ()))
          goto yyerrlab;
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        if (!yy_lac_establish_ (yyla.kind ()))
          goto yyerrlab;

        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    yy_lac_discard_ ("shift");
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_al_t: // al_t
      case symbol_kind::S_attr: // attr
      case symbol_kind::S_if_attr: // if_attr
      case symbol_kind::S_case_attr: // case_attr
        yylhs.value.emplace< al_t > ();
        break;

      case symbol_kind::S_ast_node_type_t: // ast_node_type_t
      case symbol_kind::S_asgn_binop: // asgn_binop
      case symbol_kind::S_inc_or_dec_op: // inc_or_dec_op
        yylhs.value.emplace< ast_node_type_t > ();
        break;

      case symbol_kind::S_ast_t: // ast_t
      case symbol_kind::S_io_wire_type: // io_wire_type
      case symbol_kind::S_non_io_wire_type: // non_io_wire_type
      case symbol_kind::S_wire_type: // wire_type
      case symbol_kind::S_non_opt_range: // non_opt_range
      case symbol_kind::S_non_opt_multirange: // non_opt_multirange
      case symbol_kind::S_range: // range
      case symbol_kind::S_range_or_multirange: // range_or_multirange
      case symbol_kind::S_func_return_type: // func_return_type
      case symbol_kind::S_specify_if: // specify_if
      case symbol_kind::S_specify_condition: // specify_condition
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_opt_enum_init: // opt_enum_init
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_struct_union: // struct_union
      case symbol_kind::S_typedef_base_type: // typedef_base_type
      case symbol_kind::S_enum_struct_type: // enum_struct_type
      case symbol_kind::S_rvalue: // rvalue
      case symbol_kind::S_lvalue: // lvalue
      case symbol_kind::S_lvalue_concat_list: // lvalue_concat_list
      case symbol_kind::S_genvar_identifier: // genvar_identifier
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_basic_expr: // basic_expr
      case symbol_kind::S_503_84: // @84
      case symbol_kind::S_concat_list: // concat_list
        yylhs.value.emplace< ast_t > ();
        break;

      case symbol_kind::S_boolean_t: // "boolean"
      case symbol_kind::S_opt_signedness_default_signed: // opt_signedness_default_signed
      case symbol_kind::S_opt_signedness_default_unsigned: // opt_signedness_default_unsigned
      case symbol_kind::S_always_comb_or_latch: // always_comb_or_latch
      case symbol_kind::S_always_or_always_ff: // always_or_always_ff
      case symbol_kind::S_opt_property: // opt_property
        yylhs.value.emplace< boolean_t > ();
        break;

      case symbol_kind::S_ch_t: // "invalid token"
      case symbol_kind::S_specify_edge: // specify_edge
        yylhs.value.emplace< ch_t > ();
        break;

      case symbol_kind::S_integer_t: // "integer"
      case symbol_kind::S_integer_atom_type: // integer_atom_type
      case symbol_kind::S_integer_vector_type: // integer_vector_type
        yylhs.value.emplace< integer_t > ();
        break;

      case symbol_kind::S_specify_rise_fall_ptr_t: // "specify rise and fall"
      case symbol_kind::S_specify_rise_fall: // specify_rise_fall
        yylhs.value.emplace< specify_rise_fall_ptr_t > ();
        break;

      case symbol_kind::S_specify_target_ptr_t: // "specify target"
      case symbol_kind::S_specify_target: // specify_target
        yylhs.value.emplace< specify_target_ptr_t > ();
        break;

      case symbol_kind::S_specify_triple_ptr_t: // "specify triple"
      case symbol_kind::S_specify_opt_triple: // specify_opt_triple
      case symbol_kind::S_specify_triple: // specify_triple
        yylhs.value.emplace< specify_triple_ptr_t > ();
        break;

      case symbol_kind::S_string_t: // "string"
      case symbol_kind::S_TOK_STRING: // TOK_STRING
      case symbol_kind::S_TOK_ID: // TOK_ID
      case symbol_kind::S_TOK_CONSTVAL: // TOK_CONSTVAL
      case symbol_kind::S_TOK_REALVAL: // TOK_REALVAL
      case symbol_kind::S_TOK_PRIMITIVE: // TOK_PRIMITIVE
      case symbol_kind::S_TOK_SVA_LABEL: // TOK_SVA_LABEL
      case symbol_kind::S_TOK_SPECIFY_OPER: // TOK_SPECIFY_OPER
      case symbol_kind::S_TOK_MSG_TASKS: // TOK_MSG_TASKS
      case symbol_kind::S_TOK_BASE: // TOK_BASE
      case symbol_kind::S_TOK_BASED_CONSTVAL: // TOK_BASED_CONSTVAL
      case symbol_kind::S_TOK_UNBASED_UNSIZED_CONSTVAL: // TOK_UNBASED_UNSIZED_CONSTVAL
      case symbol_kind::S_TOK_USER_TYPE: // TOK_USER_TYPE
      case symbol_kind::S_TOK_PKG_USER_TYPE: // TOK_PKG_USER_TYPE
      case symbol_kind::S_hierarchical_id: // hierarchical_id
      case symbol_kind::S_hierarchical_type_id: // hierarchical_type_id
      case symbol_kind::S_type_name: // type_name
      case symbol_kind::S_tok_prim_wrapper: // tok_prim_wrapper
      case symbol_kind::S_opt_label: // opt_label
      case symbol_kind::S_opt_sva_label: // opt_sva_label
      case symbol_kind::S_integral_number: // integral_number
        yylhs.value.emplace< string_t > ();
        break;

      default:
        break;
    }


      // Default location.
      {
        stack_type::slice range (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, range, yylen);
        yyerror_range[1].location = yylhs.location;
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 2: // $@1: %empty
#line 593 "frontends/verilog/verilog_parser.y"
       {
	(void)yynerrs_;
	extra->ast_stack.clear();
	extra->ast_stack.push_back(extra->current_ast);
}
#line 1356 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 3: // input: $@1 design
#line 597 "frontends/verilog/verilog_parser.y"
         {
	extra->ast_stack.pop_back();
	log_assert(GetSize(extra->ast_stack) == 0);
	extra->default_attr_list.clear();
}
#line 1366 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 15: // $@2: %empty
#line 617 "frontends/verilog/verilog_parser.y"
        {
		if (extra->attr_list)
			extra->attr_list_stack.push(std::move(extra->attr_list));
		extra->attr_list = std::make_unique<dict<IdString, std::unique_ptr<AstNode>>>();
		for (auto &it : extra->default_attr_list)
			(*extra->attr_list)[it.first] = it.second->clone();
	}
#line 1378 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 16: // attr: $@2 attr_opt
#line 623 "frontends/verilog/verilog_parser.y"
                   {
		yylhs.value.as < al_t > () = std::move(extra->attr_list);
		if (!extra->attr_list_stack.empty()) {
			extra->attr_list = std::move(extra->attr_list_stack.top());
			extra->attr_list_stack.pop();
		} else
			extra->attr_list = nullptr;
	}
#line 1391 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 17: // attr_opt: attr_opt ATTR_BEGIN opt_attr_list ATTR_END
#line 633 "frontends/verilog/verilog_parser.y"
                                                   {
		SET_RULE_LOC(yylhs.location, yystack_[2].location, yylhs.location);
	}
#line 1399 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 19: // $@3: %empty
#line 639 "frontends/verilog/verilog_parser.y"
                      {
		if (extra->attr_list != nullptr)
			extra->attr_list_stack.push(std::move(extra->attr_list));
		extra->attr_list = std::make_unique<dict<IdString, std::unique_ptr<AstNode>>>();
		extra->default_attr_list.clear();
	}
#line 1410 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 20: // $@4: %empty
#line 644 "frontends/verilog/verilog_parser.y"
                        {
		extra->attr_list->swap(extra->default_attr_list);
		extra->attr_list.reset();
		if (!extra->attr_list_stack.empty()) {
			extra->attr_list = std::move(extra->attr_list_stack.top());
			extra->attr_list_stack.pop();
		} else
			extra->attr_list = nullptr;
	}
#line 1424 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 26: // attr_assign: hierarchical_id
#line 662 "frontends/verilog/verilog_parser.y"
                        {
		(*extra->attr_list)[*yystack_[0].value.as < string_t > ()] = AstNode::mkconst_int(yystack_[0].location, 1, false);
	}
#line 1432 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 27: // attr_assign: hierarchical_id "'='" expr
#line 665 "frontends/verilog/verilog_parser.y"
                                    {
		(*extra->attr_list)[*yystack_[2].value.as < string_t > ()] = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 1440 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 28: // hierarchical_id: TOK_ID
#line 670 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ());
	}
#line 1448 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 29: // hierarchical_id: hierarchical_id TOK_PACKAGESEP TOK_ID
#line 673 "frontends/verilog/verilog_parser.y"
                                              {
		if (yystack_[0].value.as < string_t > ()->compare(0, 1, "\\") == 0)
			*yystack_[2].value.as < string_t > () += "::" + yystack_[0].value.as < string_t > ()->substr(1);
		else
			*yystack_[2].value.as < string_t > () += "::" + *yystack_[0].value.as < string_t > ();
		yylhs.value.as < string_t > () = std::move(yystack_[2].value.as < string_t > ());
	}
#line 1460 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 30: // hierarchical_id: hierarchical_id "'.'" TOK_ID
#line 680 "frontends/verilog/verilog_parser.y"
                                       {
		if (yystack_[0].value.as < string_t > ()->compare(0, 1, "\\") == 0)
			*yystack_[2].value.as < string_t > () += "." + yystack_[0].value.as < string_t > ()->substr(1);
		else
			*yystack_[2].value.as < string_t > () += "." + *yystack_[0].value.as < string_t > ();
		yylhs.value.as < string_t > () = std::move(yystack_[2].value.as < string_t > ());
	}
#line 1472 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 31: // hierarchical_type_id: TOK_USER_TYPE
#line 689 "frontends/verilog/verilog_parser.y"
                      {yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ()); }
#line 1478 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 32: // hierarchical_type_id: TOK_PKG_USER_TYPE
#line 690 "frontends/verilog/verilog_parser.y"
                            {yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ()); }
#line 1484 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 33: // hierarchical_type_id: "'('" TOK_USER_TYPE "')'"
#line 691 "frontends/verilog/verilog_parser.y"
                                                { yylhs.value.as < string_t > () = std::move(yystack_[1].value.as < string_t > ()); }
#line 1490 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 34: // $@5: %empty
#line 695 "frontends/verilog/verilog_parser.y"
                        {
		extra->enterTypeScope();
	}
#line 1498 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 35: // $@6: %empty
#line 697 "frontends/verilog/verilog_parser.y"
                 {
		extra->do_not_require_port_stubs = false;
		AstNode* mod = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_MODULE));
		extra->current_ast_mod = mod;
		extra->port_stubs.clear();
		extra->port_counter = 0;
		mod->str = *yystack_[0].value.as < string_t > ();
		append_attr(mod, std::move(yystack_[3].value.as < al_t > ()));
	}
#line 1512 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 36: // module: attr TOK_MODULE $@5 TOK_ID $@6 module_para_opt module_args_opt "';'" module_body TOK_ENDMODULE opt_label
#line 705 "frontends/verilog/verilog_parser.y"
                                                                                          {
		if (extra->port_stubs.size() != 0)
			err_at_loc(yystack_[4].location, "Missing details for module port `%s'.",
					extra->port_stubs.begin()->first.c_str());
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[9].location, yylhs.location);
		extra->ast_stack.pop_back();
		log_assert(extra->ast_stack.size() == 1);
		checkLabelsMatch(yystack_[0].location, "Module name", yystack_[7].value.as < string_t > ().get(), yystack_[0].value.as < string_t > ().get());
		extra->current_ast_mod = nullptr;
		extra->exitTypeScope();
	}
#line 1528 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 42: // $@7: %empty
#line 725 "frontends/verilog/verilog_parser.y"
                           {
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_PARAMETER);
		extra->astbuf1->children.push_back(AstNode::mkconst_int(yystack_[0].location, 0, true));
		append_attr(extra->astbuf1.get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 1538 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 44: // $@8: %empty
#line 730 "frontends/verilog/verilog_parser.y"
                            {
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_LOCALPARAM);
		extra->astbuf1->children.push_back(AstNode::mkconst_int(yystack_[0].location, 0, true));
		append_attr(extra->astbuf1.get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 1548 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 54: // module_arg_opt_assignment: "'='" expr
#line 747 "frontends/verilog/verilog_parser.y"
                    {
		if (extra->ast_stack.back()->children.size() > 0 && extra->ast_stack.back()->children.back()->type == AST_WIRE) {
			if (extra->ast_stack.back()->children.back()->is_input) {
				auto& n = extra->ast_stack.back()->children.back();
				n->attributes[ID::defaultvalue] = std::move(yystack_[0].value.as < ast_t > ());
			} else {
				auto wire = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
				wire->str = extra->ast_stack.back()->children.back()->str;
				if (extra->ast_stack.back()->children.back()->is_reg || extra->ast_stack.back()->children.back()->is_logic)
					extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_INITIAL, std::make_unique<AstNode>(yylhs.location, AST_BLOCK, std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_LE, std::move(wire), std::move(yystack_[0].value.as < ast_t > ())))));
				else
					extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN, std::move(wire), std::move(yystack_[0].value.as < ast_t > ())));
			}
		} else
			err_at_loc(yystack_[0].location, "SystemVerilog interface in module port list cannot have a default value.");
	}
#line 1569 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 56: // $@9: %empty
#line 766 "frontends/verilog/verilog_parser.y"
               {
		if (extra->ast_stack.back()->children.size() > 0 && extra->ast_stack.back()->children.back()->type == AST_WIRE) {
			auto node = extra->ast_stack.back()->children.back()->clone();
			node->str = *yystack_[0].value.as < string_t > ();
			node->port_id = ++extra->port_counter;
			SET_AST_NODE_LOC(node.get(), yystack_[0].location, yystack_[0].location);
			extra->ast_stack.back()->children.push_back(std::move(node));
		} else {
			if (extra->port_stubs.count(*yystack_[0].value.as < string_t > ()) != 0)
				err_at_loc(yystack_[0].location, "Duplicate module port `%s'.", *yystack_[0].value.as < string_t > ());
			extra->port_stubs[*yystack_[0].value.as < string_t > ()] = ++extra->port_counter;
		}
	}
#line 1587 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 58: // $@10: %empty
#line 779 "frontends/verilog/verilog_parser.y"
               {
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_INTERFACEPORT);
		extra->astbuf1->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_INTERFACEPORTTYPE));
		extra->astbuf1->children[0]->str = *yystack_[0].value.as < string_t > ();
	}
#line 1597 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 59: // $@11: %empty
#line 783 "frontends/verilog/verilog_parser.y"
                 {  /* SV interfaces */
		if (!mode->sv)
			err_at_loc(yystack_[0].location, "Interface found in port list (%s). This is not supported unless read_verilog is called with -sv!", *yystack_[0].value.as < string_t > ());
		extra->astbuf2 = extra->astbuf1->clone(); // really only needed if multiple instances of same type.
		extra->astbuf2->str = *yystack_[0].value.as < string_t > ();
		extra->astbuf2->port_id = ++extra->port_counter;
		extra->ast_stack.back()->children.push_back(std::move(extra->astbuf2));
	}
#line 1610 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 61: // $@12: %empty
#line 791 "frontends/verilog/verilog_parser.y"
                                                  {
		auto node = std::move(yystack_[2].value.as < ast_t > ());
		node->str = *yystack_[0].value.as < string_t > ();
		SET_AST_NODE_LOC(node.get(), yystack_[0].location, yystack_[0].location);
		node->port_id = ++extra->port_counter;
		auto range = checkRange(node.get(), std::move(yystack_[1].value.as < ast_t > ()));
		if (range != nullptr)
			node->children.push_back(std::move(range));
		if (!node->is_input && !node->is_output)
			err_at_loc(yystack_[0].location, "Module port `%s' is neither input nor output.", *yystack_[0].value.as < string_t > ());
		if (node->is_reg && node->is_input && !node->is_output && !mode->sv)
			err_at_loc(yystack_[0].location, "Input port `%s' is declared as register.", *yystack_[0].value.as < string_t > ());
		append_attr(node.get(), std::move(yystack_[3].value.as < al_t > ()));
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 1630 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 63: // module_arg: "'.'" "'.'" "'.'"
#line 806 "frontends/verilog/verilog_parser.y"
                                {
		extra->do_not_require_port_stubs = true;
	}
#line 1638 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 64: // $@13: %empty
#line 811 "frontends/verilog/verilog_parser.y"
                         {
		extra->enterTypeScope();
	}
#line 1646 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 65: // $@14: %empty
#line 813 "frontends/verilog/verilog_parser.y"
                 {
		AstNode* mod = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_PACKAGE));
		extra->current_ast_mod = mod;
		mod->str = *yystack_[0].value.as < string_t > ();
		append_attr(mod, std::move(yystack_[3].value.as < al_t > ()));
	}
#line 1657 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 66: // package: attr TOK_PACKAGE $@13 TOK_ID $@14 "';'" package_body TOK_ENDPACKAGE opt_label
#line 818 "frontends/verilog/verilog_parser.y"
                                                            {
		extra->ast_stack.pop_back();
		checkLabelsMatch(yystack_[0].location, "Package name", yystack_[5].value.as < string_t > ().get(), yystack_[0].value.as < string_t > ().get());
		extra->current_ast_mod = nullptr;
		extra->exitTypeScope();
	}
#line 1668 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 73: // import_stmt: TOK_IMPORT TOK_ID TOK_PACKAGESEP "'*'" "';'"
#line 832 "frontends/verilog/verilog_parser.y"
                                                               {
		// Create an import node to track wildcard package imports
		auto import_node = std::make_unique<AstNode>(yylhs.location, AST_IMPORT);
		import_node->str = *yystack_[3].value.as < string_t > ();
		extra->ast_stack.back()->children.push_back(std::move(import_node));
	}
#line 1679 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 74: // $@15: %empty
#line 838 "frontends/verilog/verilog_parser.y"
                                         {
		// Start a specific import: create and push the AST_IMPORT node
		AstNode* import_node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_IMPORT));
		import_node->str = *yystack_[1].value.as < string_t > ();
	}
#line 1689 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 75: // import_stmt: TOK_IMPORT TOK_ID TOK_PACKAGESEP $@15 import_item_list "';'"
#line 842 "frontends/verilog/verilog_parser.y"
                                       {
		// Done collecting specific items, pop the AST_IMPORT node
		extra->ast_stack.pop_back();
	}
#line 1698 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 78: // import_item: TOK_ID
#line 852 "frontends/verilog/verilog_parser.y"
               {
		// Append this specific import name under the current AST_IMPORT
		auto item_node = std::make_unique<AstNode>(yylhs.location, AST_NONE);
		item_node->str = *yystack_[0].value.as < string_t > ();
		extra->ast_stack.back()->children.push_back(std::move(item_node));
	}
#line 1709 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 79: // $@16: %empty
#line 860 "frontends/verilog/verilog_parser.y"
                      {
		extra->enterTypeScope();
	}
#line 1717 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 80: // $@17: %empty
#line 862 "frontends/verilog/verilog_parser.y"
                 {
		extra->do_not_require_port_stubs = false;
		AstNode* intf = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_INTERFACE));
		extra->current_ast_mod = intf;
		extra->port_stubs.clear();
		extra->port_counter = 0;
		intf->str = *yystack_[0].value.as < string_t > ();
	}
#line 1730 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 81: // interface: TOK_INTERFACE $@16 TOK_ID $@17 module_para_opt module_args_opt "';'" interface_body TOK_ENDINTERFACE
#line 869 "frontends/verilog/verilog_parser.y"
                                                                                      {
		if (extra->port_stubs.size() != 0)
			err_at_loc(yystack_[3].location, "Missing details for module port `%s'.",
				extra->port_stubs.begin()->first.c_str());
		extra->ast_stack.pop_back();
		log_assert(extra->ast_stack.size() == 1);
		extra->current_ast_mod = nullptr;
		extra->exitTypeScope();
	}
#line 1744 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 93: // $@18: %empty
#line 887 "frontends/verilog/verilog_parser.y"
                 {
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_BIND));
	}
#line 1752 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 94: // $@19: %empty
#line 890 "frontends/verilog/verilog_parser.y"
                    {
		// bind_target should have added at least one child
		log_assert(extra->ast_stack.back()->children.size() >= 1);
	}
#line 1761 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 95: // $@20: %empty
#line 894 "frontends/verilog/verilog_parser.y"
               {
		// The single_cell parser in cell_list_no_array uses extra->astbuf1 as
		// a sort of template for constructing cells.
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_CELL);
		extra->astbuf1->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_CELLTYPE));
		extra->astbuf1->children[0]->str = *yystack_[0].value.as < string_t > ();
	}
#line 1773 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 96: // bind_directive: TOK_BIND $@18 bind_target $@19 TOK_ID $@20 cell_parameter_list_opt cell_list_no_array "';'"
#line 901 "frontends/verilog/verilog_parser.y"
                                                               {
		// cell_list should have added at least one more child
		log_assert(extra->ast_stack.back()->children.size() >= 2);
		(void)extra->astbuf1.reset();
		extra->ast_stack.pop_back();
	}
#line 1784 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 102: // bind_target_instance: hierarchical_id
#line 936 "frontends/verilog/verilog_parser.y"
                        {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
		node->str = *yystack_[0].value.as < string_t > ();
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 1794 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 103: // mintypmax_expr: expr
#line 943 "frontends/verilog/verilog_parser.y"
             { }
#line 1800 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 104: // mintypmax_expr: expr "':'" expr "':'" expr
#line 944 "frontends/verilog/verilog_parser.y"
                                       { }
#line 1806 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 105: // non_opt_delay: "'#'" TOK_ID
#line 947 "frontends/verilog/verilog_parser.y"
                        { }
#line 1812 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 106: // non_opt_delay: "'#'" TOK_CONSTVAL
#line 948 "frontends/verilog/verilog_parser.y"
                              { }
#line 1818 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 107: // non_opt_delay: "'#'" TOK_REALVAL
#line 949 "frontends/verilog/verilog_parser.y"
                             { }
#line 1824 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 115: // $@21: %empty
#line 961 "frontends/verilog/verilog_parser.y"
        { extra->astbuf3 = std::make_unique<AstNode>(yylhs.location, AST_WIRE); extra->current_wire_rand = false; extra->current_wire_const = false; }
#line 1830 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 116: // io_wire_type: $@21 wire_type_token_io wire_type_const_rand opt_wire_type_token wire_type_signedness
#line 963 "frontends/verilog/verilog_parser.y"
        { yylhs.value.as < ast_t > () = std::move(extra->astbuf3); SET_RULE_LOC(yylhs.location, yystack_[3].location, yylhs.location); }
#line 1836 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 117: // $@22: %empty
#line 966 "frontends/verilog/verilog_parser.y"
        { extra->astbuf3 = std::make_unique<AstNode>(yylhs.location, AST_WIRE); extra->current_wire_rand = false; extra->current_wire_const = false; }
#line 1842 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 118: // non_io_wire_type: $@22 wire_type_const_rand wire_type_token wire_type_signedness
#line 968 "frontends/verilog/verilog_parser.y"
        { yylhs.value.as < ast_t > () = std::move(extra->astbuf3); SET_RULE_LOC(yylhs.location, yystack_[2].location, yylhs.location); }
#line 1848 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 119: // wire_type: io_wire_type
#line 971 "frontends/verilog/verilog_parser.y"
                     { yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ()); }
#line 1854 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 120: // wire_type: non_io_wire_type
#line 972 "frontends/verilog/verilog_parser.y"
                         { yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ()); }
#line 1860 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 121: // wire_type_token_io: TOK_INPUT
#line 975 "frontends/verilog/verilog_parser.y"
                  {
		extra->astbuf3->is_input = true;
	}
#line 1868 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 122: // wire_type_token_io: TOK_OUTPUT
#line 978 "frontends/verilog/verilog_parser.y"
                   {
		extra->astbuf3->is_output = true;
	}
#line 1876 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 123: // wire_type_token_io: TOK_INOUT
#line 981 "frontends/verilog/verilog_parser.y"
                  {
		extra->astbuf3->is_input = true;
		extra->astbuf3->is_output = true;
	}
#line 1885 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 124: // wire_type_signedness: TOK_SIGNED
#line 987 "frontends/verilog/verilog_parser.y"
                     { extra->astbuf3->is_signed = true;  }
#line 1891 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 125: // wire_type_signedness: TOK_UNSIGNED
#line 988 "frontends/verilog/verilog_parser.y"
                     { extra->astbuf3->is_signed = false; }
#line 1897 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 127: // wire_type_const_rand: TOK_RAND TOK_CONST
#line 992 "frontends/verilog/verilog_parser.y"
                           {
	    extra->current_wire_rand = true;
	    extra->current_wire_const = true;
	}
#line 1906 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 128: // wire_type_const_rand: TOK_CONST
#line 996 "frontends/verilog/verilog_parser.y"
                  {
	    extra->current_wire_const = true;
	}
#line 1914 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 129: // wire_type_const_rand: TOK_RAND
#line 999 "frontends/verilog/verilog_parser.y"
                 {
	    extra->current_wire_rand = true;
	}
#line 1922 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 133: // wire_type_token: net_type
#line 1009 "frontends/verilog/verilog_parser.y"
                 {
	}
#line 1929 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 134: // wire_type_token: net_type logic_type
#line 1011 "frontends/verilog/verilog_parser.y"
                            {
	}
#line 1936 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 135: // wire_type_token: TOK_REG
#line 1014 "frontends/verilog/verilog_parser.y"
                {
		extra->astbuf3->is_reg = true;
	}
#line 1944 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 136: // wire_type_token: TOK_VAR TOK_REG
#line 1017 "frontends/verilog/verilog_parser.y"
                        {
		extra->astbuf3->is_reg = true;
	}
#line 1952 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 137: // wire_type_token: TOK_VAR
#line 1021 "frontends/verilog/verilog_parser.y"
                {
		extra->astbuf3->is_logic = true;
	}
#line 1960 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 138: // wire_type_token: TOK_VAR logic_type
#line 1024 "frontends/verilog/verilog_parser.y"
                           {
		extra->astbuf3->is_logic = true;
	}
#line 1968 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 139: // wire_type_token: logic_type
#line 1027 "frontends/verilog/verilog_parser.y"
                   {
		extra->astbuf3->is_logic = true;
	}
#line 1976 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 140: // wire_type_token: TOK_GENVAR
#line 1030 "frontends/verilog/verilog_parser.y"
                   {
		extra->astbuf3->type = AST_GENVAR;
		extra->astbuf3->is_reg = true;
		extra->astbuf3->is_signed = true;
		extra->astbuf3->range_left = 31;
		extra->astbuf3->range_right = 0;
	}
#line 1988 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 141: // net_type: TOK_WOR
#line 1039 "frontends/verilog/verilog_parser.y"
                {
		extra->astbuf3->is_wor = true;
	}
#line 1996 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 142: // net_type: TOK_WAND
#line 1042 "frontends/verilog/verilog_parser.y"
                 {
		extra->astbuf3->is_wand = true;
	}
#line 2004 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 144: // logic_type: TOK_LOGIC
#line 1048 "frontends/verilog/verilog_parser.y"
                  {
	}
#line 2011 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 145: // logic_type: integer_atom_type
#line 1050 "frontends/verilog/verilog_parser.y"
                          {
		extra->astbuf3->range_left = yystack_[0].value.as < integer_t > () - 1;
		extra->astbuf3->range_right = 0;
		extra->astbuf3->is_signed = true;
	}
#line 2021 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 146: // logic_type: hierarchical_type_id
#line 1055 "frontends/verilog/verilog_parser.y"
                             {
		extra->addWiretypeNode(yystack_[0].value.as < string_t > ().get(), extra->astbuf3.get());
	}
#line 2029 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 147: // integer_atom_type: TOK_INTEGER
#line 1060 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < integer_t > () = 32; }
#line 2035 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 148: // integer_atom_type: TOK_INT
#line 1061 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < integer_t > () = 32; }
#line 2041 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 149: // integer_atom_type: TOK_SHORTINT
#line 1062 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < integer_t > () = 16; }
#line 2047 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 150: // integer_atom_type: TOK_LONGINT
#line 1063 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < integer_t > () = 64; }
#line 2053 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 151: // integer_atom_type: TOK_BYTE
#line 1064 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < integer_t > () =  8; }
#line 2059 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 152: // integer_vector_type: TOK_LOGIC
#line 1067 "frontends/verilog/verilog_parser.y"
                  { yylhs.value.as < integer_t > () = token::TOK_LOGIC; }
#line 2065 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 153: // integer_vector_type: TOK_REG
#line 1068 "frontends/verilog/verilog_parser.y"
                  { yylhs.value.as < integer_t > () = token::TOK_REG; }
#line 2071 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 154: // non_opt_range: "'['" expr "':'" expr "']'"
#line 1071 "frontends/verilog/verilog_parser.y"
                                            {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_RANGE);
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[3].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
	}
#line 2081 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 155: // non_opt_range: "'['" expr TOK_POS_INDEXED expr "']'"
#line 1076 "frontends/verilog/verilog_parser.y"
                                                    {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_RANGE);
		auto expr = std::make_unique<AstNode>(yylhs.location, AST_SELFSZ, std::move(yystack_[3].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_SUB, std::make_unique<AstNode>(yylhs.location, AST_ADD, expr->clone(), std::move(yystack_[1].value.as < ast_t > ())), AstNode::mkconst_int(yylhs.location, 1, true)));
		yylhs.value.as < ast_t > ()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_ADD, std::move(expr), AstNode::mkconst_int(yylhs.location, 0, true)));
	}
#line 2092 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 156: // non_opt_range: "'['" expr TOK_NEG_INDEXED expr "']'"
#line 1082 "frontends/verilog/verilog_parser.y"
                                                    {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_RANGE);
		auto expr = std::make_unique<AstNode>(yylhs.location, AST_SELFSZ, std::move(yystack_[3].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_ADD, expr->clone(), AstNode::mkconst_int(yylhs.location, 0, true)));
		yylhs.value.as < ast_t > ()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_SUB, std::make_unique<AstNode>(yylhs.location, AST_ADD, std::move(expr), AstNode::mkconst_int(yylhs.location, 1, true)), std::move(yystack_[1].value.as < ast_t > ())));
	}
#line 2103 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 157: // non_opt_range: "'['" expr "']'"
#line 1088 "frontends/verilog/verilog_parser.y"
                               {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_RANGE);
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
	}
#line 2112 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 158: // non_opt_multirange: non_opt_range non_opt_range
#line 1094 "frontends/verilog/verilog_parser.y"
                                    {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_MULTIRANGE, std::move(yystack_[1].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 2120 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 159: // non_opt_multirange: non_opt_multirange non_opt_range
#line 1097 "frontends/verilog/verilog_parser.y"
                                         {
		yylhs.value.as < ast_t > () = std::move(yystack_[1].value.as < ast_t > ());
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 2129 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 160: // range: non_opt_range
#line 1103 "frontends/verilog/verilog_parser.y"
                      {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 2137 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 161: // range: %empty
#line 1106 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < ast_t > () = nullptr;
	}
#line 2145 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 162: // range_or_multirange: range
#line 1111 "frontends/verilog/verilog_parser.y"
              { yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ()); }
#line 2151 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 163: // range_or_multirange: non_opt_multirange
#line 1112 "frontends/verilog/verilog_parser.y"
                           { yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ()); }
#line 2157 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 188: // $@23: %empty
#line 1128 "frontends/verilog/verilog_parser.y"
                                       {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_GENBLOCK));
		node->str = *yystack_[1].value.as < string_t > ();
	}
#line 2166 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 189: // checker_decl: TOK_CHECKER TOK_ID "';'" $@23 module_body TOK_ENDCHECKER
#line 1131 "frontends/verilog/verilog_parser.y"
                                     {
		extra->ast_stack.pop_back();
	}
#line 2174 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 190: // $@24: %empty
#line 1136 "frontends/verilog/verilog_parser.y"
                                            {
		extra->current_function_or_task = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_DPI_FUNCTION, AstNode::mkconst_str(yystack_[1].location, *yystack_[1].value.as < string_t > ()), AstNode::mkconst_str(yystack_[0].location, *yystack_[0].value.as < string_t > ())));
		extra->current_function_or_task->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->current_function_or_task, std::move(yystack_[3].value.as < al_t > ()));
	}
#line 2184 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 191: // task_func_decl: attr TOK_DPI_FUNCTION TOK_ID TOK_ID $@24 opt_dpi_function_args "';'"
#line 1140 "frontends/verilog/verilog_parser.y"
                                            {
		extra->current_function_or_task = nullptr;
	}
#line 2192 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 192: // $@25: %empty
#line 1143 "frontends/verilog/verilog_parser.y"
                                                          {
		extra->current_function_or_task = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_DPI_FUNCTION, AstNode::mkconst_str(yystack_[1].location, *yystack_[1].value.as < string_t > ()), AstNode::mkconst_str(yystack_[3].location, *yystack_[3].value.as < string_t > ())));
		extra->current_function_or_task->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->current_function_or_task, std::move(yystack_[5].value.as < al_t > ()));
	}
#line 2202 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 193: // task_func_decl: attr TOK_DPI_FUNCTION TOK_ID "'='" TOK_ID TOK_ID $@25 opt_dpi_function_args "';'"
#line 1147 "frontends/verilog/verilog_parser.y"
                                            {
		extra->current_function_or_task = nullptr;
	}
#line 2210 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 194: // $@26: %empty
#line 1150 "frontends/verilog/verilog_parser.y"
                                                                         {
		extra->current_function_or_task = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_DPI_FUNCTION, AstNode::mkconst_str(yystack_[1].location, *yystack_[1].value.as < string_t > ()), AstNode::mkconst_str(location_range(yystack_[5].location, yystack_[3].location), *yystack_[5].value.as < string_t > () + ":" + RTLIL::unescape_id(*yystack_[3].value.as < string_t > ()))));
		extra->current_function_or_task->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->current_function_or_task, std::move(yystack_[7].value.as < al_t > ()));
	}
#line 2220 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 195: // task_func_decl: attr TOK_DPI_FUNCTION TOK_ID "':'" TOK_ID "'='" TOK_ID TOK_ID $@26 opt_dpi_function_args "';'"
#line 1154 "frontends/verilog/verilog_parser.y"
                                            {
		extra->current_function_or_task = nullptr;
	}
#line 2228 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 196: // $@27: %empty
#line 1157 "frontends/verilog/verilog_parser.y"
                                           {
		extra->current_function_or_task = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_TASK));
		extra->current_function_or_task->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->current_function_or_task, std::move(yystack_[3].value.as < al_t > ()));
		extra->current_function_or_task_port_id = 1;
	}
#line 2239 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 197: // task_func_decl: attr TOK_TASK opt_automatic TOK_ID $@27 task_func_args_opt "';'" task_func_body TOK_ENDTASK
#line 1162 "frontends/verilog/verilog_parser.y"
                                                                    {
		extra->current_function_or_task = nullptr;
		extra->ast_stack.pop_back();
	}
#line 2248 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 198: // $@28: %empty
#line 1166 "frontends/verilog/verilog_parser.y"
                                                        {
		// The difference between void functions and tasks is that
		// always_comb's implicit sensitivity list behaves as if functions were
		// inlined, but ignores signals read only in tasks. This only matters
		// for event based simulation, and for synthesis we can treat a void
		// function like a task.
		extra->current_function_or_task = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_TASK));
		extra->current_function_or_task->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->current_function_or_task, std::move(yystack_[4].value.as < al_t > ()));
		extra->current_function_or_task_port_id = 1;
	}
#line 2264 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 199: // task_func_decl: attr TOK_FUNCTION opt_automatic TOK_VOID TOK_ID $@28 task_func_args_opt "';'" task_func_body TOK_ENDFUNCTION
#line 1176 "frontends/verilog/verilog_parser.y"
                                                                        {
		extra->current_function_or_task = nullptr;
		extra->ast_stack.pop_back();
	}
#line 2273 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 200: // $@29: %empty
#line 1180 "frontends/verilog/verilog_parser.y"
                                                                {
		extra->current_function_or_task = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_FUNCTION));
		extra->current_function_or_task->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->current_function_or_task, std::move(yystack_[4].value.as < al_t > ()));
		auto outreg = std::make_unique<AstNode>(yylhs.location, AST_WIRE);
		outreg->str = *yystack_[0].value.as < string_t > ();
		outreg->is_signed = false;
		outreg->is_reg = true;
		if (yystack_[1].value.as < ast_t > () != nullptr) {
			outreg->is_signed = yystack_[1].value.as < ast_t > ()->is_signed;
			yystack_[1].value.as < ast_t > ()->is_signed = false;
			outreg->is_custom_type = yystack_[1].value.as < ast_t > ()->type == AST_WIRETYPE;
			outreg->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
		}
		extra->current_function_or_task->children.push_back(std::move(outreg));
		extra->current_function_or_task_port_id = 1;
	}
#line 2295 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 201: // task_func_decl: attr TOK_FUNCTION opt_automatic func_return_type TOK_ID $@29 task_func_args_opt "';'" task_func_body TOK_ENDFUNCTION
#line 1196 "frontends/verilog/verilog_parser.y"
                                                                        {
		extra->current_function_or_task = nullptr;
		extra->ast_stack.pop_back();
	}
#line 2304 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 202: // func_return_type: hierarchical_type_id
#line 1202 "frontends/verilog/verilog_parser.y"
                             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_WIRETYPE);
		yylhs.value.as < ast_t > ()->str = *yystack_[0].value.as < string_t > ();
	}
#line 2313 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 203: // func_return_type: opt_type_vec opt_signedness_default_unsigned
#line 1206 "frontends/verilog/verilog_parser.y"
                                                     {
		yylhs.value.as < ast_t > () = makeRange(yylhs.location, 0, 0, yystack_[0].value.as < boolean_t > ());
	}
#line 2321 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 204: // func_return_type: opt_type_vec opt_signedness_default_unsigned non_opt_range
#line 1209 "frontends/verilog/verilog_parser.y"
                                                                   {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
		yylhs.value.as < ast_t > ()->is_signed = yystack_[1].value.as < boolean_t > ();
	}
#line 2330 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 205: // func_return_type: integer_atom_type opt_signedness_default_signed
#line 1213 "frontends/verilog/verilog_parser.y"
                                                        {
		yylhs.value.as < ast_t > () = makeRange(yylhs.location, yystack_[1].value.as < integer_t > () - 1, 0, yystack_[0].value.as < boolean_t > ());
	}
#line 2338 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 209: // opt_signedness_default_signed: %empty
#line 1224 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < boolean_t > () = true; }
#line 2344 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 210: // opt_signedness_default_signed: TOK_SIGNED
#line 1225 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < boolean_t > () = true; }
#line 2350 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 211: // opt_signedness_default_signed: TOK_UNSIGNED
#line 1226 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < boolean_t > () = false; }
#line 2356 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 212: // opt_signedness_default_unsigned: %empty
#line 1229 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < boolean_t > () = false; }
#line 2362 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 213: // opt_signedness_default_unsigned: TOK_SIGNED
#line 1230 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < boolean_t > () = true; }
#line 2368 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 214: // opt_signedness_default_unsigned: TOK_UNSIGNED
#line 1231 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < boolean_t > () = false; }
#line 2374 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 215: // dpi_function_arg: TOK_ID TOK_ID
#line 1235 "frontends/verilog/verilog_parser.y"
                      {
		extra->current_function_or_task->children.push_back(AstNode::mkconst_str(yystack_[1].location, *yystack_[1].value.as < string_t > ()));
	}
#line 2382 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 216: // dpi_function_arg: TOK_ID
#line 1238 "frontends/verilog/verilog_parser.y"
               {
		extra->current_function_or_task->children.push_back(AstNode::mkconst_str(yystack_[0].location, *yystack_[0].value.as < string_t > ()));
	}
#line 2390 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 227: // $@30: %empty
#line 1257 "frontends/verilog/verilog_parser.y"
                                                    {
		extra->albuf = nullptr;
		extra->astbuf1 = nullptr;
		extra->astbuf2 = nullptr;
	}
#line 2400 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 228: // $@31: %empty
#line 1261 "frontends/verilog/verilog_parser.y"
                                        {
		(void)extra->astbuf1.reset();
		if (extra->astbuf2 != nullptr)
			(void)extra->astbuf2.reset();
		extra->albuf.reset();
	}
#line 2411 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 232: // $@32: %empty
#line 1272 "frontends/verilog/verilog_parser.y"
                                           {
		bool prev_was_input = true;
		bool prev_was_output = false;
		if (extra->albuf) {
			prev_was_input = extra->astbuf1->is_input;
			prev_was_output = extra->astbuf1->is_output;
			(void)extra->astbuf1.reset();
			if (extra->astbuf2 != nullptr)
				(void)extra->astbuf2.reset();
			extra->albuf.reset();
		}
		extra->albuf = std::move(yystack_[2].value.as < al_t > ());
		extra->astbuf1 = std::move(yystack_[1].value.as < ast_t > ());
		extra->astbuf2 = checkRange(extra->astbuf1.get(), std::move(yystack_[0].value.as < ast_t > ()));
		if (!extra->astbuf1->is_input && !extra->astbuf1->is_output) {
			if (!mode->sv)
				err_at_loc(yystack_[1].location, "task/function argument direction missing");
			extra->astbuf1->is_input = prev_was_input;
			extra->astbuf1->is_output = prev_was_output;
		}
	}
#line 2437 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 234: // $@33: %empty
#line 1293 "frontends/verilog/verilog_parser.y"
        {
		if (!extra->astbuf1) {
			if (!mode->sv)
				err_at_loc(yylhs.location, "task/function argument direction missing");
			extra->albuf = std::make_unique<dict<IdString, std::unique_ptr<AstNode>>>();
			extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_WIRE);
			extra->current_wire_rand = false;
			extra->current_wire_const = false;
			extra->astbuf1->is_input = true;
			extra->astbuf2 = nullptr;
		}
	}
#line 2454 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 241: // specify_item: specify_if "'('" specify_edge expr TOK_SPECIFY_OPER specify_target "')'" "'='" specify_rise_fall "';'"
#line 1320 "frontends/verilog/verilog_parser.y"
                                                                                                                                {
		auto en_expr = std::move(yystack_[9].value.as < ast_t > ());
		char specify_edge = yystack_[7].value.as < ch_t > ();
		auto src_expr = std::move(yystack_[6].value.as < ast_t > ());
		string *oper = yystack_[5].value.as < string_t > ().get();
		specify_target_ptr_t target = std::move(yystack_[4].value.as < specify_target_ptr_t > ());
		specify_rise_fall_ptr_t timing = std::move(yystack_[1].value.as < specify_rise_fall_ptr_t > ());

		if (specify_edge != 0 && target->dat == nullptr)
			err_at_loc(yystack_[7].location, "Found specify edge but no data spec.");

		auto cell_owned = std::make_unique<AstNode>(yylhs.location, AST_CELL);
		auto cell = cell_owned.get();
		extra->ast_stack.back()->children.push_back(std::move(cell_owned));
		cell->str = stringf("$specify$%d", autoidx++);
		cell->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_CELLTYPE));
		cell->children.back()->str = target->dat ? "$specify3" : "$specify2";
		SET_AST_NODE_LOC(cell, en_expr.get() ? yystack_[9].location : yystack_[8].location, yystack_[0].location);

		char oper_polarity = 0;
		char oper_type = oper->at(0);

		if (oper->size() == 3) {
			oper_polarity = oper->at(0);
			oper_type = oper->at(1);
		}

		cell->children.push_back(std::make_unique<AstNode>(yystack_[5].location, AST_PARASET, AstNode::mkconst_int(yystack_[5].location, oper_type == '*', false, 1)));
		cell->children.back()->str = "\\FULL";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[5].location, AST_PARASET, AstNode::mkconst_int(yystack_[5].location, oper_polarity != 0, false, 1)));
		cell->children.back()->str = "\\SRC_DST_PEN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[5].location, AST_PARASET, AstNode::mkconst_int(yystack_[5].location, oper_polarity == '+', false, 1)));
		cell->children.back()->str = "\\SRC_DST_POL";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[1].location, AST_PARASET, std::move(timing->rise.t_min)));
		cell->children.back()->str = "\\T_RISE_MIN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[1].location, AST_PARASET, std::move(timing->rise.t_avg)));
		cell->children.back()->str = "\\T_RISE_TYP";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[1].location, AST_PARASET, std::move(timing->rise.t_max)));
		cell->children.back()->str = "\\T_RISE_MAX";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[1].location, AST_PARASET, std::move(timing->fall.t_min)));
		cell->children.back()->str = "\\T_FALL_MIN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[1].location, AST_PARASET, std::move(timing->fall.t_avg)));
		cell->children.back()->str = "\\T_FALL_TYP";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[1].location, AST_PARASET, std::move(timing->fall.t_max)));
		cell->children.back()->str = "\\T_FALL_MAX";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[9].location, AST_ARGUMENT, en_expr ? std::move(en_expr) : AstNode::mkconst_int(yystack_[9].location, 1, false, 1)));
		cell->children.back()->str = "\\EN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[6].location, AST_ARGUMENT, std::move(src_expr)));
		cell->children.back()->str = "\\SRC";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[4].location, AST_ARGUMENT, std::move(target->dst)));
		cell->children.back()->str = "\\DST";

		if (target->dat)
		{
			cell->children.push_back(std::make_unique<AstNode>(yystack_[7].location, AST_PARASET, AstNode::mkconst_int(yystack_[7].location, specify_edge != 0, false, 1)));
			cell->children.back()->str = "\\EDGE_EN";

			cell->children.push_back(std::make_unique<AstNode>(yystack_[7].location, AST_PARASET, AstNode::mkconst_int(yystack_[7].location, specify_edge == 'p', false, 1)));
			cell->children.back()->str = "\\EDGE_POL";

			cell->children.push_back(std::make_unique<AstNode>(yystack_[4].location, AST_PARASET, AstNode::mkconst_int(yystack_[4].location, target->polarity_op != 0, false, 1)));
			cell->children.back()->str = "\\DAT_DST_PEN";

			cell->children.push_back(std::make_unique<AstNode>(yystack_[4].location, AST_PARASET, AstNode::mkconst_int(yystack_[4].location, target->polarity_op == '+', false, 1)));
			cell->children.back()->str = "\\DAT_DST_POL";

			cell->children.push_back(std::make_unique<AstNode>(yystack_[4].location, AST_ARGUMENT, std::move(target->dat)));
			cell->children.back()->str = "\\DAT";
		}
	}
#line 2540 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 242: // specify_item: TOK_ID "'('" specify_edge expr specify_condition "','" specify_edge expr specify_condition "','" specify_triple specify_opt_triple "')'" "';'"
#line 1401 "frontends/verilog/verilog_parser.y"
                                                                                                                                                                               {
		if (*yystack_[13].value.as < string_t > () != "$setup" && *yystack_[13].value.as < string_t > () != "$hold" && *yystack_[13].value.as < string_t > () != "$setuphold" && *yystack_[13].value.as < string_t > () != "$removal" && *yystack_[13].value.as < string_t > () != "$recovery" &&
				*yystack_[13].value.as < string_t > () != "$recrem" && *yystack_[13].value.as < string_t > () != "$skew" && *yystack_[13].value.as < string_t > () != "$timeskew" && *yystack_[13].value.as < string_t > () != "$fullskew" && *yystack_[13].value.as < string_t > () != "$nochange")
			err_at_loc(yystack_[13].location, "Unsupported specify rule type: %s", *yystack_[13].value.as < string_t > ());

		auto src_pen = AstNode::mkconst_int(yystack_[11].location, yystack_[11].value.as < ch_t > () != 0, false, 1);
		auto src_pol = AstNode::mkconst_int(yystack_[11].location, yystack_[11].value.as < ch_t > () == 'p', false, 1);
		auto src_expr = std::move(yystack_[10].value.as < ast_t > ()), src_en = yystack_[9].value.as < ast_t > () ? std::move(yystack_[9].value.as < ast_t > ()) : AstNode::mkconst_int(yystack_[9].location, 1, false, 1);

		auto dst_pen = AstNode::mkconst_int(yystack_[7].location, yystack_[7].value.as < ch_t > () != 0, false, 1);
		auto dst_pol = AstNode::mkconst_int(yystack_[7].location, yystack_[7].value.as < ch_t > () == 'p', false, 1);
		auto dst_expr = std::move(yystack_[6].value.as < ast_t > ()), dst_en = yystack_[5].value.as < ast_t > () ? std::move(yystack_[5].value.as < ast_t > ()) : AstNode::mkconst_int(yystack_[9].location, 1, false, 1);

		specify_triple_ptr_t limit = std::move(yystack_[3].value.as < specify_triple_ptr_t > ());
		specify_triple_ptr_t limit2 = std::move(yystack_[2].value.as < specify_triple_ptr_t > ());

		auto cell_owned = std::make_unique<AstNode>(yylhs.location, AST_CELL);
		auto cell = cell_owned.get();
		extra->ast_stack.back()->children.push_back(std::move(cell_owned));
		cell->str = stringf("$specify$%d", autoidx++);
		cell->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_CELLTYPE));
		cell->children.back()->str = "$specrule";
		SET_AST_NODE_LOC(cell, yystack_[13].location, yystack_[0].location);

		cell->children.push_back(std::make_unique<AstNode>(yystack_[13].location, AST_PARASET, AstNode::mkconst_str(yystack_[13].location, *yystack_[13].value.as < string_t > ())));
		cell->children.back()->str = "\\TYPE";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[3].location, AST_PARASET, std::move(limit->t_min)));
		cell->children.back()->str = "\\T_LIMIT_MIN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[3].location, AST_PARASET, std::move(limit->t_avg)));
		cell->children.back()->str = "\\T_LIMIT_TYP";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[3].location, AST_PARASET, std::move(limit->t_max)));
		cell->children.back()->str = "\\T_LIMIT_MAX";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[2].location, AST_PARASET, limit2 ? std::move(limit2->t_min) : AstNode::mkconst_int(yystack_[2].location, 0, true)));
		cell->children.back()->str = "\\T_LIMIT2_MIN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[2].location, AST_PARASET, limit2 ? std::move(limit2->t_avg) : AstNode::mkconst_int(yystack_[2].location, 0, true)));
		cell->children.back()->str = "\\T_LIMIT2_TYP";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[2].location, AST_PARASET, limit2 ? std::move(limit2->t_max) : AstNode::mkconst_int(yystack_[2].location, 0, true)));
		cell->children.back()->str = "\\T_LIMIT2_MAX";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[11].location, AST_PARASET, std::move(src_pen)));
		cell->children.back()->str = "\\SRC_PEN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[11].location, AST_PARASET, std::move(src_pol)));
		cell->children.back()->str = "\\SRC_POL";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[11].location, AST_PARASET, std::move(dst_pen)));
		cell->children.back()->str = "\\DST_PEN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[7].location, AST_PARASET, std::move(dst_pol)));
		cell->children.back()->str = "\\DST_POL";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[9].location, AST_ARGUMENT, std::move(src_en)));
		cell->children.back()->str = "\\SRC_EN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[10].location, AST_ARGUMENT, std::move(src_expr)));
		cell->children.back()->str = "\\SRC";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[5].location, AST_ARGUMENT, std::move(dst_en)));
		cell->children.back()->str = "\\DST_EN";

		cell->children.push_back(std::make_unique<AstNode>(yystack_[6].location, AST_ARGUMENT, std::move(dst_expr)));
		cell->children.back()->str = "\\DST";
	}
#line 2614 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 243: // specify_opt_triple: "','" specify_triple
#line 1472 "frontends/verilog/verilog_parser.y"
                                 {
		yylhs.value.as < specify_triple_ptr_t > () = std::move(yystack_[0].value.as < specify_triple_ptr_t > ());
	}
#line 2622 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 244: // specify_opt_triple: %empty
#line 1475 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < specify_triple_ptr_t > () = nullptr;
	}
#line 2630 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 245: // specify_if: TOK_IF "'('" expr "')'"
#line 1480 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::move(yystack_[1].value.as < ast_t > ());
	}
#line 2638 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 246: // specify_if: %empty
#line 1483 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < ast_t > () = nullptr;
	}
#line 2646 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 247: // specify_condition: TOK_SPECIFY_AND expr
#line 1488 "frontends/verilog/verilog_parser.y"
                             {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 2654 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 248: // specify_condition: %empty
#line 1491 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < ast_t > () = nullptr;
	}
#line 2662 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 249: // specify_target: expr
#line 1496 "frontends/verilog/verilog_parser.y"
             {
		yylhs.value.as < specify_target_ptr_t > () = std::make_unique<struct specify_target>();
		yylhs.value.as < specify_target_ptr_t > ()->polarity_op = 0;
		yylhs.value.as < specify_target_ptr_t > ()->dst = std::move(yystack_[0].value.as < ast_t > ());
		yylhs.value.as < specify_target_ptr_t > ()->dat = nullptr;
	}
#line 2673 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 250: // specify_target: "'('" expr "':'" expr "')'"
#line 1502 "frontends/verilog/verilog_parser.y"
                                               {
		yylhs.value.as < specify_target_ptr_t > () = std::make_unique<struct specify_target>();
		yylhs.value.as < specify_target_ptr_t > ()->polarity_op = 0;
		yylhs.value.as < specify_target_ptr_t > ()->dst = std::move(yystack_[3].value.as < ast_t > ());
		yylhs.value.as < specify_target_ptr_t > ()->dat = std::move(yystack_[1].value.as < ast_t > ());
	}
#line 2684 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 251: // specify_target: "'('" expr TOK_NEG_INDEXED expr "')'"
#line 1508 "frontends/verilog/verilog_parser.y"
                                                       {
		yylhs.value.as < specify_target_ptr_t > () = std::make_unique<struct specify_target>();
		yylhs.value.as < specify_target_ptr_t > ()->polarity_op = '-';
		yylhs.value.as < specify_target_ptr_t > ()->dst = std::move(yystack_[3].value.as < ast_t > ());
		yylhs.value.as < specify_target_ptr_t > ()->dat = std::move(yystack_[1].value.as < ast_t > ());
	}
#line 2695 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 252: // specify_target: "'('" expr TOK_POS_INDEXED expr "')'"
#line 1514 "frontends/verilog/verilog_parser.y"
                                                       {
		yylhs.value.as < specify_target_ptr_t > () = std::make_unique<struct specify_target>();
		yylhs.value.as < specify_target_ptr_t > ()->polarity_op = '+';
		yylhs.value.as < specify_target_ptr_t > ()->dst = std::move(yystack_[3].value.as < ast_t > ());
		yylhs.value.as < specify_target_ptr_t > ()->dat = std::move(yystack_[1].value.as < ast_t > ());
	}
#line 2706 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 253: // specify_edge: TOK_POSEDGE
#line 1522 "frontends/verilog/verilog_parser.y"
                    { yylhs.value.as < ch_t > () = 'p'; }
#line 2712 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 254: // specify_edge: TOK_NEGEDGE
#line 1523 "frontends/verilog/verilog_parser.y"
                    { yylhs.value.as < ch_t > () = 'n'; }
#line 2718 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 255: // specify_edge: %empty
#line 1524 "frontends/verilog/verilog_parser.y"
               { yylhs.value.as < ch_t > () = 0; }
#line 2724 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 256: // specify_rise_fall: specify_triple
#line 1527 "frontends/verilog/verilog_parser.y"
                       {
		yylhs.value.as < specify_rise_fall_ptr_t > () = std::make_unique<struct specify_rise_fall>();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->fall.t_min = yystack_[0].value.as < specify_triple_ptr_t > ()->t_min->clone();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->fall.t_avg = yystack_[0].value.as < specify_triple_ptr_t > ()->t_avg->clone();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->fall.t_max = yystack_[0].value.as < specify_triple_ptr_t > ()->t_max->clone();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->rise = std::move(*yystack_[0].value.as < specify_triple_ptr_t > ());
	}
#line 2736 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 257: // specify_rise_fall: "'('" specify_triple "','" specify_triple "')'"
#line 1534 "frontends/verilog/verilog_parser.y"
                                                                      {
		yylhs.value.as < specify_rise_fall_ptr_t > () = std::make_unique<struct specify_rise_fall>();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->rise = std::move(*yystack_[3].value.as < specify_triple_ptr_t > ());
		yylhs.value.as < specify_rise_fall_ptr_t > ()->fall = std::move(*yystack_[1].value.as < specify_triple_ptr_t > ());
	}
#line 2746 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 258: // specify_rise_fall: "'('" specify_triple "','" specify_triple "','" specify_triple "')'"
#line 1539 "frontends/verilog/verilog_parser.y"
                                                                                               {
		yylhs.value.as < specify_rise_fall_ptr_t > () = std::make_unique<struct specify_rise_fall>();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->rise = std::move(*yystack_[5].value.as < specify_triple_ptr_t > ());
		yylhs.value.as < specify_rise_fall_ptr_t > ()->fall = std::move(*yystack_[3].value.as < specify_triple_ptr_t > ());
		warn_at_loc(yylhs.location, "Path delay expressions beyond rise/fall not currently supported. Ignoring.");
	}
#line 2757 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 259: // specify_rise_fall: "'('" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "')'"
#line 1545 "frontends/verilog/verilog_parser.y"
                                                                                                                                                                          {
		yylhs.value.as < specify_rise_fall_ptr_t > () = std::make_unique<struct specify_rise_fall>();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->rise = std::move(*yystack_[11].value.as < specify_triple_ptr_t > ());
		yylhs.value.as < specify_rise_fall_ptr_t > ()->fall = std::move(*yystack_[9].value.as < specify_triple_ptr_t > ());
		warn_at_loc(yylhs.location, "Path delay expressions beyond rise/fall not currently supported. Ignoring.");
	}
#line 2768 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 260: // specify_rise_fall: "'('" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "','" specify_triple "')'"
#line 1551 "frontends/verilog/verilog_parser.y"
                                                                                                                                                                                                                                                                                                                                {
		yylhs.value.as < specify_rise_fall_ptr_t > () = std::make_unique<struct specify_rise_fall>();
		yylhs.value.as < specify_rise_fall_ptr_t > ()->rise = std::move(*yystack_[23].value.as < specify_triple_ptr_t > ());
		yylhs.value.as < specify_rise_fall_ptr_t > ()->fall = std::move(*yystack_[21].value.as < specify_triple_ptr_t > ());
		warn_at_loc(yylhs.location, "Path delay expressions beyond rise/fall not currently supported. Ignoring.");
	}
#line 2779 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 261: // specify_triple: expr
#line 1559 "frontends/verilog/verilog_parser.y"
             {
		yylhs.value.as < specify_triple_ptr_t > () = std::make_unique<struct specify_triple>();
		yylhs.value.as < specify_triple_ptr_t > ()->t_avg = yystack_[0].value.as < ast_t > ()->clone();
		yylhs.value.as < specify_triple_ptr_t > ()->t_max = yystack_[0].value.as < ast_t > ()->clone();
		yylhs.value.as < specify_triple_ptr_t > ()->t_min = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 2790 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 262: // specify_triple: expr "':'" expr "':'" expr
#line 1565 "frontends/verilog/verilog_parser.y"
                                       {
		yylhs.value.as < specify_triple_ptr_t > () = std::make_unique<struct specify_triple>();
		yylhs.value.as < specify_triple_ptr_t > ()->t_min = std::move(yystack_[4].value.as < ast_t > ());
		yylhs.value.as < specify_triple_ptr_t > ()->t_avg = std::move(yystack_[2].value.as < ast_t > ());
		yylhs.value.as < specify_triple_ptr_t > ()->t_max = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 2801 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 335: // ignspec_constant_expression: expr
#line 1728 "frontends/verilog/verilog_parser.y"
             {  }
#line 2807 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 336: // ignspec_expr: expr
#line 1731 "frontends/verilog/verilog_parser.y"
             {  }
#line 2813 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 337: // ignspec_expr: expr "':'" expr "':'" expr
#line 1732 "frontends/verilog/verilog_parser.y"
                                       {
	}
#line 2820 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 338: // $@34: %empty
#line 1736 "frontends/verilog/verilog_parser.y"
               {  }
#line 2826 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 339: // ignspec_id: TOK_ID $@34 range_or_multirange
#line 1737 "frontends/verilog/verilog_parser.y"
                            {  }
#line 2832 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 340: // param_signed: TOK_SIGNED
#line 1742 "frontends/verilog/verilog_parser.y"
                   {
		extra->astbuf1->is_signed = true;
	}
#line 2840 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 341: // param_signed: TOK_UNSIGNED
#line 1744 "frontends/verilog/verilog_parser.y"
                         {
		extra->astbuf1->is_signed = false;
	}
#line 2848 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 343: // param_integer: type_atom
#line 1749 "frontends/verilog/verilog_parser.y"
                  {
		extra->astbuf1->is_reg = false;
	}
#line 2856 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 344: // param_real: TOK_REAL
#line 1754 "frontends/verilog/verilog_parser.y"
                 {
		extra->astbuf1->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_REALVALUE));
	}
#line 2864 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 345: // param_range: range
#line 1759 "frontends/verilog/verilog_parser.y"
              {
		if (yystack_[0].value.as < ast_t > () != nullptr) {
			extra->astbuf1->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		}
	}
#line 2874 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 347: // param_range_type: type_vec param_signed
#line 1767 "frontends/verilog/verilog_parser.y"
                              {
		addRange(extra->astbuf1.get(), 0, 0);
	}
#line 2882 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 348: // param_range_type: type_vec param_signed non_opt_range
#line 1770 "frontends/verilog/verilog_parser.y"
                                            {
		extra->astbuf1->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 2890 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 354: // param_type: hierarchical_type_id
#line 1777 "frontends/verilog/verilog_parser.y"
                             {
		extra->addWiretypeNode(yystack_[0].value.as < string_t > ().get(), extra->astbuf1.get());
	}
#line 2898 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 355: // $@35: %empty
#line 1782 "frontends/verilog/verilog_parser.y"
                           {
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_PARAMETER);
		extra->astbuf1->children.push_back(AstNode::mkconst_int(yylhs.location, 0, true));
		append_attr(extra->astbuf1.get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 2908 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 356: // param_decl: attr TOK_PARAMETER $@35 param_type param_decl_list "';'"
#line 1786 "frontends/verilog/verilog_parser.y"
                                                 {
		(void)extra->astbuf1.reset();
	}
#line 2916 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 357: // $@36: %empty
#line 1791 "frontends/verilog/verilog_parser.y"
                            {
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_LOCALPARAM);
		extra->astbuf1->children.push_back(AstNode::mkconst_int(yylhs.location, 0, true));
		append_attr(extra->astbuf1.get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 2926 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 358: // localparam_decl: attr TOK_LOCALPARAM $@36 param_type param_decl_list "';'"
#line 1795 "frontends/verilog/verilog_parser.y"
                                                 {
		(void)extra->astbuf1.reset();
	}
#line 2934 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 361: // single_param_decl: single_param_decl_ident "'='" expr
#line 1803 "frontends/verilog/verilog_parser.y"
                                            {
		AstNode *decl = extra->ast_stack.back()->children.back().get();
		log_assert(decl->type == AST_PARAMETER || decl->type == AST_LOCALPARAM);
		decl->children[0] = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 2944 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 362: // single_param_decl: single_param_decl_ident
#line 1808 "frontends/verilog/verilog_parser.y"
                                {
		AstNode *decl = extra->ast_stack.back()->children.back().get();
		if (decl->type != AST_PARAMETER) {
			log_assert(decl->type == AST_LOCALPARAM);
			err_at_loc(yystack_[0].location, "localparam initialization is missing!");
		}
		if (!mode->sv)
			err_at_loc(yystack_[0].location, "Parameter defaults can only be omitted in SystemVerilog mode!");
		decl->children.erase(decl->children.begin());
	}
#line 2959 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 363: // single_param_decl_ident: TOK_ID
#line 1820 "frontends/verilog/verilog_parser.y"
               {
		std::unique_ptr<AstNode> node_owned;
		if (extra->astbuf1 == nullptr) {
			if (!mode->sv)
				err_at_loc(yystack_[0].location, "In pure Verilog (not SystemVerilog), parameter/localparam with an initializer must use the parameter/localparam keyword");
			node_owned = std::make_unique<AstNode>(yylhs.location, AST_PARAMETER);
			node_owned->children.push_back(AstNode::mkconst_int(yylhs.location, 0, true));
		} else {
			node_owned = extra->astbuf1->clone();
		}
		node_owned->str = *yystack_[0].value.as < string_t > ();
		auto node = node_owned.get();
		extra->ast_stack.back()->children.push_back(std::move(node_owned));
		SET_AST_NODE_LOC(node, yystack_[0].location, yystack_[0].location);
	}
#line 2979 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 367: // single_defparam_decl: range rvalue "'='" expr
#line 1843 "frontends/verilog/verilog_parser.y"
                                 {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_DEFPARAM);
		node->children.push_back(std::move(yystack_[2].value.as < ast_t > ()));
		node->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		if (yystack_[3].value.as < ast_t > () != nullptr)
			node->children.push_back(std::move(yystack_[3].value.as < ast_t > ()));
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 2992 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 368: // $@37: %empty
#line 1856 "frontends/verilog/verilog_parser.y"
                    {
		static int enum_count;
		// create parent node for the enum
		extra->astbuf2 = std::make_unique<AstNode>(yylhs.location, AST_ENUM);
		extra->astbuf2->str = std::string("$enum");
		extra->astbuf2->str += std::to_string(enum_count++);
		log_assert(!extra->cell_hack);
		extra->cell_hack = extra->astbuf2.get();
		extra->ast_stack.back()->children.push_back(std::move(extra->astbuf2));
		// create the template for the names
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_ENUM_ITEM);
		extra->astbuf1->children.push_back(AstNode::mkconst_int(yylhs.location, 0, true));
	}
#line 3010 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 369: // enum_type: TOK_ENUM $@37 enum_base_type "'{'" enum_name_list optional_comma "'}'"
#line 1868 "frontends/verilog/verilog_parser.y"
                                                                           {
		// create template for the enum vars
		log_assert(extra->cell_hack);
		auto tnode_owned = extra->astbuf1->clone();
		auto* tnode = tnode_owned.get();
		extra->astbuf1 = std::move(tnode_owned);
		tnode->type = AST_WIRE;
		tnode->attributes[ID::enum_type] = AstNode::mkconst_str(yylhs.location, extra->cell_hack->str);
		extra->cell_hack = nullptr;
		// drop constant but keep any range
		tnode->children.erase(tnode->children.begin());
		yylhs.value.as < ast_t > () = extra->astbuf1->clone();
	}
#line 3028 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 371: // enum_base_type: type_vec type_signing range
#line 1883 "frontends/verilog/verilog_parser.y"
                                        { if (yystack_[0].value.as < ast_t > ()) extra->astbuf1->children.push_back(std::move(yystack_[0].value.as < ast_t > ())); }
#line 3034 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 372: // enum_base_type: %empty
#line 1884 "frontends/verilog/verilog_parser.y"
                                        { extra->astbuf1->is_reg = true; addRange(extra->astbuf1.get()); }
#line 3040 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 373: // type_atom: integer_atom_type
#line 1888 "frontends/verilog/verilog_parser.y"
                          {
		extra->astbuf1->is_reg = true;
		extra->astbuf1->is_signed = true;
		addRange(extra->astbuf1.get(), yystack_[0].value.as < integer_t > () - 1, 0);
	}
#line 3050 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 374: // type_vec: TOK_REG
#line 1894 "frontends/verilog/verilog_parser.y"
                                { extra->astbuf1->is_reg   = true; }
#line 3056 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 375: // type_vec: TOK_LOGIC
#line 1895 "frontends/verilog/verilog_parser.y"
                                { extra->astbuf1->is_logic = true; }
#line 3062 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 376: // type_signing: TOK_SIGNED
#line 1899 "frontends/verilog/verilog_parser.y"
                                { extra->astbuf1->is_signed = true; }
#line 3068 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 377: // type_signing: TOK_UNSIGNED
#line 1900 "frontends/verilog/verilog_parser.y"
                                { extra->astbuf1->is_signed = false; }
#line 3074 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 381: // enum_name_decl: TOK_ID opt_enum_init
#line 1909 "frontends/verilog/verilog_parser.y"
                             {
		// put in fn
		log_assert((bool)extra->astbuf1);
		log_assert((bool)extra->cell_hack);
		auto node = extra->astbuf1->clone();
		node->str = *yystack_[1].value.as < string_t > ();
		SET_AST_NODE_LOC(node.get(), yystack_[1].location, yystack_[1].location);
		node->children[0] = yystack_[0].value.as < ast_t > () ? std::move(yystack_[0].value.as < ast_t > ()) : std::make_unique<AstNode>(yylhs.location, AST_NONE);
		extra->cell_hack->children.push_back(std::move(node));
	}
#line 3089 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 382: // opt_enum_init: "'='" basic_expr
#line 1922 "frontends/verilog/verilog_parser.y"
                                        { yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ()); }
#line 3095 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 383: // opt_enum_init: %empty
#line 1923 "frontends/verilog/verilog_parser.y"
                                { yylhs.value.as < ast_t > () = nullptr; }
#line 3101 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 386: // enum_var: TOK_ID
#line 1931 "frontends/verilog/verilog_parser.y"
                 {
		log_assert((bool)extra->astbuf1);
		auto node = extra->astbuf1->clone();
		node->str = *yystack_[0].value.as < string_t > ();
		SET_AST_NODE_LOC(node.get(), yystack_[0].location, yystack_[0].location);
		node->is_enum = true;
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 3114 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 387: // enum_decl: enum_type enum_var_list "';'"
#line 1941 "frontends/verilog/verilog_parser.y"
                                                        {  }
#line 3120 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 388: // $@38: %empty
#line 1949 "frontends/verilog/verilog_parser.y"
                         {
		append_attr(extra->astbuf2.get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 3128 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 389: // struct_decl: attr struct_type $@38 struct_var_list "';'"
#line 1951 "frontends/verilog/verilog_parser.y"
                                      {
		(void)extra->astbuf2.reset();
	}
#line 3136 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 390: // $@39: %empty
#line 1957 "frontends/verilog/verilog_parser.y"
                     {
		extra->astbuf2 = std::move(yystack_[0].value.as < ast_t > ());
		extra->astbuf2->is_custom_type = true;
	}
#line 3145 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 391: // struct_type: struct_union $@39 struct_body
#line 1960 "frontends/verilog/verilog_parser.y"
                      {
		yylhs.value.as < ast_t > () = extra->astbuf2->clone();
	}
#line 3153 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 392: // struct_union: TOK_STRUCT
#line 1966 "frontends/verilog/verilog_parser.y"
                                { yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_STRUCT); }
#line 3159 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 393: // struct_union: TOK_UNION
#line 1967 "frontends/verilog/verilog_parser.y"
                                { yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_UNION); }
#line 3165 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 396: // opt_packed: %empty
#line 1975 "frontends/verilog/verilog_parser.y"
               { err_at_loc(yylhs.location, "Only PACKED supported at this time"); }
#line 3171 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 397: // opt_signed_struct: TOK_SIGNED
#line 1978 "frontends/verilog/verilog_parser.y"
                                { extra->astbuf2->is_signed = true; }
#line 3177 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 398: // opt_signed_struct: TOK_UNSIGNED
#line 1979 "frontends/verilog/verilog_parser.y"
                                { extra->astbuf2->is_signed = false; }
#line 3183 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 402: // struct_member: struct_member_type member_name_list "';'"
#line 1987 "frontends/verilog/verilog_parser.y"
                                                                        { (void)extra->astbuf1.reset(); }
#line 3189 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 405: // $@40: %empty
#line 1995 "frontends/verilog/verilog_parser.y"
                    {
		extra->astbuf1->str = yystack_[0].value.as < string_t > ()->substr(1);
		extra->astbuf3 = extra->astbuf1->clone();
		log_assert(!extra->member_hack);
		extra->member_hack = extra->astbuf3.get();
		SET_AST_NODE_LOC(extra->member_hack, yystack_[0].location, yystack_[0].location);
		extra->astbuf2->children.push_back(std::move(extra->astbuf3));
	}
#line 3202 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 406: // member_name: TOK_ID $@40 range
#line 2002 "frontends/verilog/verilog_parser.y"
                {
		log_assert((bool)extra->member_hack);
		if (yystack_[0].value.as < ast_t > ()) extra->member_hack->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		extra->member_hack = nullptr;
	}
#line 3212 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 407: // $@41: %empty
#line 2009 "frontends/verilog/verilog_parser.y"
                    { extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_STRUCT_ITEM); }
#line 3218 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 409: // member_type_token: member_type range_or_multirange
#line 2013 "frontends/verilog/verilog_parser.y"
                                        {
		auto range = checkRange(extra->astbuf1.get(), std::move(yystack_[0].value.as < ast_t > ()));
		if (range)
			extra->astbuf1->children.push_back(std::move(range));
	}
#line 3228 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 410: // $@42: %empty
#line 2018 "frontends/verilog/verilog_parser.y"
          {
		(void)extra->astbuf1.reset();
	}
#line 3236 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 411: // $@43: %empty
#line 2020 "frontends/verilog/verilog_parser.y"
                       {
			// stash state on extra->ast_stack
			// sketchy!
			extra->ast_stack.push_back(extra->astbuf2.release());
			extra->astbuf2 = std::move(yystack_[0].value.as < ast_t > ());
		}
#line 3247 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 412: // member_type_token: $@42 struct_union $@43 struct_body
#line 2025 "frontends/verilog/verilog_parser.y"
                               {
			extra->astbuf1 = std::move(extra->astbuf2);
			// recover state
			extra->astbuf2.reset(extra->ast_stack.back());
			extra->ast_stack.pop_back();
		}
#line 3258 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 415: // member_type: hierarchical_type_id
#line 2035 "frontends/verilog/verilog_parser.y"
                               { extra->addWiretypeNode(yystack_[0].value.as < string_t > ().get(), extra->astbuf1.get()); }
#line 3264 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 418: // struct_var: TOK_ID
#line 2043 "frontends/verilog/verilog_parser.y"
                {
		auto var_node = extra->astbuf2->clone();
		var_node->str = *yystack_[0].value.as < string_t > ();
		SET_AST_NODE_LOC(var_node.get(), yystack_[0].location, yystack_[0].location);
		extra->ast_stack.back()->children.push_back(std::move(var_node));
	}
#line 3275 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 419: // $@44: %empty
#line 2055 "frontends/verilog/verilog_parser.y"
                                           {
		extra->albuf = std::move(yystack_[2].value.as < al_t > ());
		extra->astbuf1 = std::move(yystack_[1].value.as < ast_t > ());
		extra->astbuf2 = checkRange(extra->astbuf1.get(), std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 3285 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 420: // $@45: %empty
#line 2059 "frontends/verilog/verilog_parser.y"
                               {
		(void)extra->astbuf1.reset();
		if (extra->astbuf2 != nullptr)
			(void)extra->astbuf2.reset();
		extra->albuf.reset();
	}
#line 3296 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 422: // $@46: %empty
#line 2065 "frontends/verilog/verilog_parser.y"
                                {
		extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_WIRE));
		extra->ast_stack.back()->children.back()->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->ast_stack.back()->children.back().get(), std::move(yystack_[2].value.as < al_t > ()));
		extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN, std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER), AstNode::mkconst_int(yylhs.location, 0, false, 1)));
		extra->ast_stack.back()->children.back()->children[0]->str = *yystack_[0].value.as < string_t > ();
	}
#line 3308 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 424: // $@47: %empty
#line 2072 "frontends/verilog/verilog_parser.y"
                                {
		extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_WIRE));
		extra->ast_stack.back()->children.back()->str = *yystack_[0].value.as < string_t > ();
		append_attr(extra->ast_stack.back()->children.back().get(), std::move(yystack_[2].value.as < al_t > ()));
		extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN, std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER), AstNode::mkconst_int(yylhs.location, 1, false, 1)));
		extra->ast_stack.back()->children.back()->children[0]->str = *yystack_[0].value.as < string_t > ();
	}
#line 3320 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 427: // opt_supply_wires: opt_supply_wires "','" TOK_ID
#line 2082 "frontends/verilog/verilog_parser.y"
                                          {
		auto wire_node = extra->ast_stack.back()->children.at(GetSize(extra->ast_stack.back()->children)-2)->clone();
		auto assign_node = extra->ast_stack.back()->children.at(GetSize(extra->ast_stack.back()->children)-1)->clone();
		wire_node->str = *yystack_[0].value.as < string_t > ();
		assign_node->children[0]->str = *yystack_[0].value.as < string_t > ();
		extra->ast_stack.back()->children.push_back(std::move(wire_node));
		extra->ast_stack.back()->children.push_back(std::move(assign_node));
	}
#line 3333 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 430: // wire_name_and_opt_assign: wire_name
#line 2095 "frontends/verilog/verilog_parser.y"
                  {
		bool attr_anyconst = false;
		bool attr_anyseq = false;
		bool attr_allconst = false;
		bool attr_allseq = false;
		if (extra->ast_stack.back()->children.back()->get_bool_attribute(ID::anyconst)) {
			extra->ast_stack.back()->children.back()->attributes.erase(ID::anyconst);
			attr_anyconst = true;
		}
		if (extra->ast_stack.back()->children.back()->get_bool_attribute(ID::anyseq)) {
			extra->ast_stack.back()->children.back()->attributes.erase(ID::anyseq);
			attr_anyseq = true;
		}
		if (extra->ast_stack.back()->children.back()->get_bool_attribute(ID::allconst)) {
			extra->ast_stack.back()->children.back()->attributes.erase(ID::allconst);
			attr_allconst = true;
		}
		if (extra->ast_stack.back()->children.back()->get_bool_attribute(ID::allseq)) {
			extra->ast_stack.back()->children.back()->attributes.erase(ID::allseq);
			attr_allseq = true;
		}
		if (extra->current_wire_rand || attr_anyconst || attr_anyseq || attr_allconst || attr_allseq) {
			auto wire = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
			auto fcall = std::make_unique<AstNode>(yylhs.location, AST_FCALL);
			wire->str = extra->ast_stack.back()->children.back()->str;
			fcall->str = extra->current_wire_const ? "\\$anyconst" : "\\$anyseq";
			if (attr_anyconst)
				fcall->str = "\\$anyconst";
			if (attr_anyseq)
				fcall->str = "\\$anyseq";
			if (attr_allconst)
				fcall->str = "\\$allconst";
			if (attr_allseq)
				fcall->str = "\\$allseq";
			fcall->attributes[ID::reg] = AstNode::mkconst_str(yylhs.location, RTLIL::unescape_id(wire->str));
			extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN, std::move(wire), std::move(fcall)));
		}
	}
#line 3376 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 431: // wire_name_and_opt_assign: wire_name "'='" expr
#line 2133 "frontends/verilog/verilog_parser.y"
                              {
		auto wire = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
		wire->str = extra->ast_stack.back()->children.back()->str;
		if (extra->astbuf1->is_input) {
			extra->astbuf1->attributes[ID::defaultvalue] = std::move(yystack_[0].value.as < ast_t > ());
		}
		else if (extra->astbuf1->is_reg || extra->astbuf1->is_logic){
			auto assign = std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_LE, std::move(wire), std::move(yystack_[0].value.as < ast_t > ()));
			SET_AST_NODE_LOC(assign.get(), yystack_[2].location, yystack_[0].location);
			auto block = std::make_unique<AstNode>(yylhs.location, AST_BLOCK, std::move(assign));
			SET_AST_NODE_LOC(block.get(), yystack_[2].location, yystack_[0].location);
			auto init = std::make_unique<AstNode>(yylhs.location, AST_INITIAL, std::move(block));
			SET_AST_NODE_LOC(init.get(), yystack_[2].location, yystack_[0].location);

			extra->ast_stack.back()->children.push_back(std::move(init));
		}
		else {
			auto assign = std::make_unique<AstNode>(yylhs.location, AST_ASSIGN, std::move(wire), std::move(yystack_[0].value.as < ast_t > ()));
			SET_AST_NODE_LOC(assign.get(), yystack_[2].location, yystack_[0].location);
			extra->ast_stack.back()->children.push_back(std::move(assign));
		}

	}
#line 3404 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 432: // wire_name: TOK_ID range_or_multirange
#line 2158 "frontends/verilog/verilog_parser.y"
                                   {
		if (extra->astbuf1 == nullptr)
			err_at_loc(yystack_[1].location, "Internal error - should not happen - no AST_WIRE node.");
		auto node = extra->astbuf1->clone();
		node->str = *yystack_[1].value.as < string_t > ();
		append_attr_clone(node.get(), extra->albuf);
		if (extra->astbuf2 != nullptr)
			node->children.push_back(extra->astbuf2->clone());
		if (yystack_[0].value.as < ast_t > () != nullptr) {
			if (node->is_input || node->is_output)
				err_at_loc(yystack_[0].location, "input/output/inout ports cannot have unpacked dimensions.");
			if (!extra->astbuf2 && !node->is_custom_type) {
				addRange(node.get(), 0, 0, false);
			}
			rewriteAsMemoryNode(node.get(), std::move(yystack_[0].value.as < ast_t > ()));
		}
		if (extra->current_function_or_task) {
			if (node->is_input || node->is_output)
				node->port_id = extra->current_function_or_task_port_id++;
		} else if (extra->ast_stack.back()->type == AST_GENBLOCK) {
			if (node->is_input || node->is_output)
				err_at_loc(yystack_[1].location, "Cannot declare module port `%s' within a generate block.", *yystack_[1].value.as < string_t > ());
		} else {
			if (extra->do_not_require_port_stubs && (node->is_input || node->is_output) && extra->port_stubs.count(*yystack_[1].value.as < string_t > ()) == 0) {
				extra->port_stubs[*yystack_[1].value.as < string_t > ()] = ++extra->port_counter;
			}
			if (extra->port_stubs.count(*yystack_[1].value.as < string_t > ()) != 0) {
				if (!node->is_input && !node->is_output)
					err_at_loc(yystack_[1].location, "Module port `%s' is neither input nor output.", *yystack_[1].value.as < string_t > ());
				if (node->is_reg && node->is_input && !node->is_output && !mode->sv)
					err_at_loc(yystack_[1].location, "Input port `%s' is declared as register.", *yystack_[1].value.as < string_t > ());
				node->port_id = extra->port_stubs[*yystack_[1].value.as < string_t > ()];
				extra->port_stubs.erase(*yystack_[1].value.as < string_t > ());
			} else {
				if (node->is_input || node->is_output)
					err_at_loc(yystack_[1].location, "Module port `%s' is not declared in module header.", *yystack_[1].value.as < string_t > ());
			}
		}
		//FIXME: for some reason, TOK_ID has a location which always points to one column *after* the real last column...
		SET_AST_NODE_LOC(node.get(), yystack_[1].location, yystack_[1].location);
		extra->ast_stack.back()->children.push_back(std::move(node));

	}
#line 3452 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 436: // assign_expr: lvalue "'='" expr
#line 2209 "frontends/verilog/verilog_parser.y"
                           {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN, std::move(yystack_[2].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yylhs.location, yylhs.location);
	}
#line 3461 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 437: // type_name: TOK_ID
#line 2214 "frontends/verilog/verilog_parser.y"
                  { yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ()); }
#line 3467 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 438: // type_name: TOK_USER_TYPE
#line 2215 "frontends/verilog/verilog_parser.y"
                                { if (extra->isInLocalScope(yystack_[0].value.as < string_t > ().get())) err_at_loc(yystack_[0].location, "Duplicate declaration of TYPEDEF '%s'", yystack_[0].value.as < string_t > ()->c_str()+1); yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ()); }
#line 3473 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 439: // typedef_decl: TOK_TYPEDEF typedef_base_type range_or_multirange type_name range_or_multirange "';'"
#line 2219 "frontends/verilog/verilog_parser.y"
                                                                                                    {
		extra->astbuf1 = std::move(yystack_[4].value.as < ast_t > ());
		extra->astbuf2 = checkRange(extra->astbuf1.get(), std::move(yystack_[3].value.as < ast_t > ()));
		bool has_a_range = (bool)extra->astbuf2;
		if (extra->astbuf2) {
			extra->astbuf1->children.push_back(std::move(extra->astbuf2));
		}

		if (yystack_[1].value.as < ast_t > () != nullptr) {
			if (!has_a_range && !extra->astbuf1->is_custom_type) {
				addRange(extra->astbuf1.get(), 0, 0, false);
			}
			rewriteAsMemoryNode(extra->astbuf1.get(), std::move(yystack_[1].value.as < ast_t > ()));
		}
		extra->addTypedefNode(yystack_[2].value.as < string_t > ().get(), std::move(extra->astbuf1)); }
#line 3493 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 440: // typedef_decl: TOK_TYPEDEF enum_struct_type type_name "';'"
#line 2234 "frontends/verilog/verilog_parser.y"
                                                               { extra->addTypedefNode(yystack_[1].value.as < string_t > ().get(), std::move(yystack_[2].value.as < ast_t > ())); }
#line 3499 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 441: // typedef_base_type: hierarchical_type_id
#line 2238 "frontends/verilog/verilog_parser.y"
                             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_WIRE);
		yylhs.value.as < ast_t > ()->is_logic = true;
		extra->addWiretypeNode(yystack_[0].value.as < string_t > ().get(), yylhs.value.as < ast_t > ().get());
	}
#line 3509 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 442: // typedef_base_type: integer_vector_type opt_signedness_default_unsigned
#line 2243 "frontends/verilog/verilog_parser.y"
                                                            {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_WIRE);
		if (yystack_[1].value.as < integer_t > () == token::TOK_REG) {
			yylhs.value.as < ast_t > ()->is_reg = true;
		} else {
			yylhs.value.as < ast_t > ()->is_logic = true;
		}
		yylhs.value.as < ast_t > ()->is_signed = yystack_[0].value.as < boolean_t > ();
	}
#line 3523 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 443: // typedef_base_type: integer_atom_type opt_signedness_default_signed
#line 2252 "frontends/verilog/verilog_parser.y"
                                                        {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_WIRE);
		yylhs.value.as < ast_t > ()->is_logic = true;
		yylhs.value.as < ast_t > ()->is_signed = yystack_[0].value.as < boolean_t > ();
		yylhs.value.as < ast_t > ()->range_left = yystack_[1].value.as < integer_t > () - 1;
		yylhs.value.as < ast_t > ()->range_right = 0;
	}
#line 3535 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 444: // enum_struct_type: enum_type
#line 2261 "frontends/verilog/verilog_parser.y"
                    { yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ()); }
#line 3541 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 445: // enum_struct_type: struct_type
#line 2262 "frontends/verilog/verilog_parser.y"
                      { yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ()); }
#line 3547 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 446: // $@48: %empty
#line 2266 "frontends/verilog/verilog_parser.y"
                    {
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_CELL);
		append_attr(extra->astbuf1.get(), std::move(yystack_[1].value.as < al_t > ()));
		extra->astbuf1->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_CELLTYPE));
		extra->astbuf1->children[0]->str = *yystack_[0].value.as < string_t > ();
	}
#line 3558 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 447: // cell_stmt: attr TOK_ID $@48 cell_parameter_list_opt cell_list "';'"
#line 2271 "frontends/verilog/verilog_parser.y"
                                                        {
		(void)extra->astbuf1.reset();
	}
#line 3566 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 448: // $@49: %empty
#line 2274 "frontends/verilog/verilog_parser.y"
                                    {
		extra->astbuf1 = std::make_unique<AstNode>(yylhs.location, AST_PRIMITIVE);
		extra->astbuf1->str = *yystack_[1].value.as < string_t > ();
		append_attr(extra->astbuf1.get(), std::move(yystack_[2].value.as < al_t > ()));
	}
#line 3576 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 449: // cell_stmt: attr tok_prim_wrapper delay $@49 prim_list "';'"
#line 2278 "frontends/verilog/verilog_parser.y"
                                {
		(void)extra->astbuf1.reset();
	}
#line 3584 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 450: // tok_prim_wrapper: TOK_PRIMITIVE
#line 2283 "frontends/verilog/verilog_parser.y"
                      {
		yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ());
	}
#line 3592 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 451: // tok_prim_wrapper: TOK_OR
#line 2286 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < string_t > () = std::make_unique<std::string>("or");
	}
#line 3600 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 456: // $@50: %empty
#line 2298 "frontends/verilog/verilog_parser.y"
               {
		extra->astbuf2 = extra->astbuf1->clone();
		if (extra->astbuf2->type != AST_PRIMITIVE)
			extra->astbuf2->str = *yystack_[0].value.as < string_t > ();
		// TODO optimize again
		extra->cell_hack = extra->astbuf2.get();
		extra->ast_stack.back()->children.push_back(std::move(extra->astbuf2));
	}
#line 3613 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 457: // single_cell_no_array: TOK_ID $@50 "'('" cell_port_list "')'"
#line 2305 "frontends/verilog/verilog_parser.y"
                                               {
		log_assert(extra->cell_hack);
		SET_AST_NODE_LOC(extra->cell_hack, yystack_[4].location, yylhs.location);
		extra->cell_hack = nullptr;
	}
#line 3623 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 458: // $@51: %empty
#line 2312 "frontends/verilog/verilog_parser.y"
                             {
		extra->astbuf2 = extra->astbuf1->clone();
		if (extra->astbuf2->type != AST_PRIMITIVE)
			extra->astbuf2->str = *yystack_[1].value.as < string_t > ();
		// TODO optimize again
		extra->cell_hack = extra->astbuf2.get();
		extra->ast_stack.back()->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_CELLARRAY, std::move(yystack_[0].value.as < ast_t > ()), std::move(extra->astbuf2)));
	}
#line 3636 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 459: // single_cell_arraylist: TOK_ID non_opt_range $@51 "'('" cell_port_list "')'"
#line 2319 "frontends/verilog/verilog_parser.y"
                                              {
		log_assert(extra->cell_hack);
		SET_AST_NODE_LOC(extra->cell_hack, yystack_[5].location, yylhs.location);
		extra->cell_hack = nullptr;
	}
#line 3646 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 465: // $@52: %empty
#line 2335 "frontends/verilog/verilog_parser.y"
                      {
		extra->astbuf2 = extra->astbuf1->clone();
		log_assert(!extra->cell_hack);
		extra->cell_hack = extra->astbuf2.get();
		// TODO optimize again
		extra->ast_stack.back()->children.push_back(std::move(extra->astbuf2));
	}
#line 3658 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 466: // single_prim: $@52 "'('" cell_port_list "')'"
#line 2341 "frontends/verilog/verilog_parser.y"
                                               {
		log_assert(extra->cell_hack);
		SET_AST_NODE_LOC(extra->cell_hack, yystack_[3].location, yylhs.location);
		extra->cell_hack = nullptr;
	}
#line 3668 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 472: // cell_parameter: expr
#line 2355 "frontends/verilog/verilog_parser.y"
             {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_PARASET);
		node->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		extra->astbuf1->children.push_back(std::move(node));
	}
#line 3678 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 473: // cell_parameter: "'.'" TOK_ID "'('" "')'"
#line 2360 "frontends/verilog/verilog_parser.y"
                                             {
		// just ignore empty parameters
	}
#line 3686 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 474: // cell_parameter: "'.'" TOK_ID "'('" expr "')'"
#line 2363 "frontends/verilog/verilog_parser.y"
                                                  {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_PARASET);
		node->str = *yystack_[3].value.as < string_t > ();
		node->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
		extra->astbuf1->children.push_back(std::move(node));
	}
#line 3697 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 475: // cell_port_list: cell_port_list_rules
#line 2371 "frontends/verilog/verilog_parser.y"
                             {
		// remove empty args from end of list
		while (!extra->cell_hack->children.empty()) {
			auto& node = extra->cell_hack->children.back();
			if (node->type != AST_ARGUMENT) break;
			if (!node->children.empty()) break;
			if (!node->str.empty()) break;
			extra->cell_hack->children.pop_back();
		}

		// check port types
		bool has_positional_args = false;
		bool has_named_args = false;
		for (auto& node : extra->cell_hack->children) {
			if (node->type != AST_ARGUMENT) continue;
			if (node->str.empty())
				has_positional_args = true;
			else
				has_named_args = true;
		}

		if (has_positional_args && has_named_args)
			err_at_loc(yystack_[0].location, "Mix of positional and named cell ports.");
	}
#line 3726 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 478: // cell_port: attr
#line 2400 "frontends/verilog/verilog_parser.y"
             {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_ARGUMENT);
		extra->cell_hack->children.push_back(std::move(node));
	}
#line 3735 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 479: // cell_port: attr expr
#line 2404 "frontends/verilog/verilog_parser.y"
                  {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_ARGUMENT);
		node->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		extra->cell_hack->children.push_back(std::move(node));
	}
#line 3745 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 480: // cell_port: attr "'.'" TOK_ID "'('" expr "')'"
#line 2409 "frontends/verilog/verilog_parser.y"
                                                       {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_ARGUMENT);
		node->str = *yystack_[3].value.as < string_t > ();
		node->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
		extra->cell_hack->children.push_back(std::move(node));
	}
#line 3756 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 481: // cell_port: attr "'.'" TOK_ID "'('" "')'"
#line 2415 "frontends/verilog/verilog_parser.y"
                                                  {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_ARGUMENT);
		node->str = *yystack_[2].value.as < string_t > ();
		extra->cell_hack->children.push_back(std::move(node));
	}
#line 3766 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 482: // cell_port: attr "'.'" TOK_ID
#line 2420 "frontends/verilog/verilog_parser.y"
                            {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_ARGUMENT);
		node->str = *yystack_[0].value.as < string_t > ();
		node->children.push_back(std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER));
		node->children.back()->str = *yystack_[0].value.as < string_t > ();
		extra->cell_hack->children.push_back(std::move(node));
	}
#line 3778 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 483: // cell_port: attr TOK_WILDCARD_CONNECT
#line 2427 "frontends/verilog/verilog_parser.y"
                                  {
		if (!mode->sv)
			err_at_loc(yystack_[0].location, "Wildcard port connections are only supported in SystemVerilog mode.");
		extra->cell_hack->attributes[ID::wildcard_port_conns] = AstNode::mkconst_int(yystack_[0].location, 1, false);
	}
#line 3788 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 484: // always_comb_or_latch: TOK_ALWAYS_COMB
#line 2434 "frontends/verilog/verilog_parser.y"
                        {
		yylhs.value.as < boolean_t > () = false;
	}
#line 3796 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 485: // always_comb_or_latch: TOK_ALWAYS_LATCH
#line 2437 "frontends/verilog/verilog_parser.y"
                         {
		yylhs.value.as < boolean_t > () = true;
	}
#line 3804 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 486: // always_or_always_ff: TOK_ALWAYS
#line 2442 "frontends/verilog/verilog_parser.y"
                   {
		yylhs.value.as < boolean_t > () = false;
	}
#line 3812 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 487: // always_or_always_ff: TOK_ALWAYS_FF
#line 2445 "frontends/verilog/verilog_parser.y"
                      {
		yylhs.value.as < boolean_t > () = true;
	}
#line 3820 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 488: // $@53: %empty
#line 2450 "frontends/verilog/verilog_parser.y"
                                 {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_ALWAYS));
		append_attr(node, std::move(yystack_[1].value.as < al_t > ()));
		if (yystack_[0].value.as < boolean_t > ())
			node->attributes[ID::always_ff] = AstNode::mkconst_int(yystack_[0].location, 1, false);
	}
#line 3831 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 489: // $@54: %empty
#line 2455 "frontends/verilog/verilog_parser.y"
                      {
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_BLOCK));
	}
#line 3839 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 490: // always_stmt: attr always_or_always_ff $@53 always_cond $@54 behavioral_stmt
#line 2457 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
		extra->ast_stack.pop_back();

		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[4].location, yylhs.location);
		extra->ast_stack.pop_back();

		SET_RULE_LOC(yylhs.location, yystack_[4].location, yylhs.location);
	}
#line 3853 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 491: // $@55: %empty
#line 2466 "frontends/verilog/verilog_parser.y"
                                  {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_ALWAYS));
		append_attr(node, std::move(yystack_[1].value.as < al_t > ()));
		if (yystack_[0].value.as < boolean_t > ())
			node->attributes[ID::always_latch] = AstNode::mkconst_int(yystack_[0].location, 1, false);
		else
			node->attributes[ID::always_comb] = AstNode::mkconst_int(yystack_[0].location, 1, false);
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_BLOCK));
	}
#line 3867 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 492: // always_stmt: attr always_comb_or_latch $@55 behavioral_stmt
#line 2474 "frontends/verilog/verilog_parser.y"
                          {
		extra->ast_stack.pop_back();
		extra->ast_stack.pop_back();
	}
#line 3876 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 493: // $@56: %empty
#line 2478 "frontends/verilog/verilog_parser.y"
                         {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_INITIAL));
		append_attr(node, std::move(yystack_[1].value.as < al_t > ()));
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_BLOCK));
	}
#line 3886 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 494: // always_stmt: attr TOK_INITIAL $@56 behavioral_stmt
#line 2482 "frontends/verilog/verilog_parser.y"
                          {
		extra->ast_stack.pop_back();
		extra->ast_stack.pop_back();
	}
#line 3895 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 504: // always_event: TOK_POSEDGE expr
#line 2501 "frontends/verilog/verilog_parser.y"
                         {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_POSEDGE);
		SET_AST_NODE_LOC(node.get(), yystack_[1].location, yystack_[1].location);
		node->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 3906 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 505: // always_event: TOK_NEGEDGE expr
#line 2507 "frontends/verilog/verilog_parser.y"
                         {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_NEGEDGE);
		SET_AST_NODE_LOC(node.get(), yystack_[1].location, yystack_[1].location);
		node->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 3917 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 506: // always_event: expr
#line 2513 "frontends/verilog/verilog_parser.y"
             {
		auto node = std::make_unique<AstNode>(yylhs.location, AST_EDGE);
		node->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 3927 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 507: // opt_label: "':'" TOK_ID
#line 2520 "frontends/verilog/verilog_parser.y"
                       {
		yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ());
	}
#line 3935 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 508: // opt_label: %empty
#line 2523 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < string_t > () = nullptr;
	}
#line 3943 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 509: // opt_sva_label: TOK_SVA_LABEL "':'"
#line 2528 "frontends/verilog/verilog_parser.y"
                              {
		yylhs.value.as < string_t > () = std::move(yystack_[1].value.as < string_t > ());
	}
#line 3951 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 510: // opt_sva_label: %empty
#line 2531 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < string_t > () = nullptr;
	}
#line 3959 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 511: // opt_property: TOK_PROPERTY
#line 2536 "frontends/verilog/verilog_parser.y"
                     {
		yylhs.value.as < boolean_t > () = true;
	}
#line 3967 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 512: // opt_property: TOK_FINAL
#line 2539 "frontends/verilog/verilog_parser.y"
                  {
		yylhs.value.as < boolean_t > () = false;
	}
#line 3975 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 513: // opt_property: %empty
#line 2542 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < boolean_t > () = false;
	}
#line 3983 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 514: // $@57: %empty
#line 2547 "frontends/verilog/verilog_parser.y"
                       {
		AstNode* modport = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_MODPORT));
        modport->str = *yystack_[0].value.as < string_t > ();

    }
#line 3993 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 515: // $@58: %empty
#line 2551 "frontends/verilog/verilog_parser.y"
                        {
        extra->ast_stack.pop_back();
        log_assert(extra->ast_stack.size() == 2);
    }
#line 4002 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 523: // modport_member: TOK_ID
#line 2567 "frontends/verilog/verilog_parser.y"
           {
		AstNode* modport_member = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_MODPORTMEMBER));
        modport_member->str = *yystack_[0].value.as < string_t > ();
        modport_member->is_input = extra->current_modport_input;
        modport_member->is_output = extra->current_modport_output;

    }
#line 4014 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 524: // modport_type_token: TOK_INPUT
#line 2576 "frontends/verilog/verilog_parser.y"
              {extra->current_modport_input = 1; extra->current_modport_output = 0;}
#line 4020 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 525: // modport_type_token: TOK_OUTPUT
#line 2576 "frontends/verilog/verilog_parser.y"
                                                                                                  {extra->current_modport_input = 0; extra->current_modport_output = 1;}
#line 4026 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 526: // assert: opt_sva_label TOK_ASSERT opt_property "'('" expr "')'" "';'"
#line 2579 "frontends/verilog/verilog_parser.y"
                                                                                     {
		if (mode->noassert) {

		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, mode->assume_asserts ? AST_ASSUME : AST_ASSERT, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, (yystack_[6].value.as < string_t > () != nullptr ? yystack_[6].location : yystack_[5].location), yystack_[1].location);
			if (yystack_[6].value.as < string_t > () != nullptr)
				node->str = *yystack_[6].value.as < string_t > ();
		}
	}
#line 4041 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 527: // assert: opt_sva_label TOK_ASSUME opt_property "'('" expr "')'" "';'"
#line 2589 "frontends/verilog/verilog_parser.y"
                                                                                     {
		if (mode->noassume) {
		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, mode->assert_assumes ? AST_ASSERT : AST_ASSUME, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, (yystack_[6].value.as < string_t > () != nullptr ? yystack_[6].location : yystack_[5].location), yystack_[1].location);
			if (yystack_[6].value.as < string_t > () != nullptr)
				node->str = *yystack_[6].value.as < string_t > ();
		}
	}
#line 4055 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 528: // assert: opt_sva_label TOK_ASSERT opt_property "'('" TOK_EVENTUALLY expr "')'" "';'"
#line 2598 "frontends/verilog/verilog_parser.y"
                                                                                                    {
		if (mode->noassert) {
		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, mode->assume_asserts ? AST_FAIR : AST_LIVE, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, (yystack_[7].value.as < string_t > () != nullptr ? yystack_[7].location : yystack_[6].location), yystack_[1].location);
			if (yystack_[7].value.as < string_t > () != nullptr)
				node->str = *yystack_[7].value.as < string_t > ();
		}
	}
#line 4069 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 529: // assert: opt_sva_label TOK_ASSUME opt_property "'('" TOK_EVENTUALLY expr "')'" "';'"
#line 2607 "frontends/verilog/verilog_parser.y"
                                                                                                    {
		if (mode->noassume) {
		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, mode->assert_assumes ? AST_LIVE : AST_FAIR, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, (yystack_[7].value.as < string_t > () != nullptr ? yystack_[7].location : yystack_[6].location), yystack_[1].location);
			if (yystack_[7].value.as < string_t > () != nullptr)
				node->str = *yystack_[7].value.as < string_t > ();
		}
	}
#line 4083 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 530: // assert: opt_sva_label TOK_COVER opt_property "'('" expr "')'" "';'"
#line 2616 "frontends/verilog/verilog_parser.y"
                                                                                    {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_COVER, std::move(yystack_[2].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, (yystack_[6].value.as < string_t > () != nullptr ? yystack_[6].location : yystack_[5].location), yystack_[1].location);
		if (yystack_[6].value.as < string_t > () != nullptr) {
			node->str = *yystack_[6].value.as < string_t > ();
		}
	}
#line 4095 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 531: // assert: opt_sva_label TOK_COVER opt_property "'('" "')'" "';'"
#line 2623 "frontends/verilog/verilog_parser.y"
                                                                               {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_COVER, AstNode::mkconst_int(yylhs.location, 1, false)));
		SET_AST_NODE_LOC(node, (yystack_[5].value.as < string_t > () != nullptr ? yystack_[5].location : yystack_[4].location), yystack_[1].location);
		if (yystack_[5].value.as < string_t > () != nullptr) {
			node->str = *yystack_[5].value.as < string_t > ();
		}
	}
#line 4107 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 532: // assert: opt_sva_label TOK_COVER "';'"
#line 2630 "frontends/verilog/verilog_parser.y"
                                            {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_COVER, AstNode::mkconst_int(yylhs.location, 1, false)));
		SET_AST_NODE_LOC(node, (yystack_[2].value.as < string_t > () != nullptr ? yystack_[2].location : yystack_[1].location), yystack_[1].location);
		if (yystack_[2].value.as < string_t > () != nullptr) {
			node->str = *yystack_[2].value.as < string_t > ();
		}
	}
#line 4119 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 533: // assert: opt_sva_label TOK_RESTRICT opt_property "'('" expr "')'" "';'"
#line 2637 "frontends/verilog/verilog_parser.y"
                                                                                       {
		if (mode->norestrict) {
		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSUME, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, (yystack_[6].value.as < string_t > () != nullptr ? yystack_[6].location : yystack_[5].location), yystack_[1].location);
			if (yystack_[6].value.as < string_t > () != nullptr)
				node->str = *yystack_[6].value.as < string_t > ();
		}
		if (!yystack_[4].value.as < boolean_t > ())
			warn_at_loc(yystack_[4].location, "SystemVerilog does not allow \"restrict\" without \"property\".");
	}
#line 4135 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 534: // assert: opt_sva_label TOK_RESTRICT opt_property "'('" TOK_EVENTUALLY expr "')'" "';'"
#line 2648 "frontends/verilog/verilog_parser.y"
                                                                                                      {
		if (mode->norestrict) {
		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_FAIR, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, (yystack_[7].value.as < string_t > () != nullptr ? yystack_[7].location : yystack_[6].location), yystack_[1].location);
			if (yystack_[7].value.as < string_t > () != nullptr)
				node->str = *yystack_[7].value.as < string_t > ();
		}
		if (!yystack_[5].value.as < boolean_t > ())
			warn_at_loc(yystack_[5].location, "SystemVerilog does not allow \"restrict\" without \"property\".");
	}
#line 4151 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 535: // assert_property: opt_sva_label TOK_ASSERT TOK_PROPERTY "'('" expr "')'" "';'"
#line 2661 "frontends/verilog/verilog_parser.y"
                                                                                     {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, mode->assume_asserts ? AST_ASSUME : AST_ASSERT, std::move(yystack_[2].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[6].location, yystack_[1].location);
		if (yystack_[6].value.as < string_t > () != nullptr) {
			extra->ast_stack.back()->children.back()->str = *yystack_[6].value.as < string_t > ();
		}
	}
#line 4163 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 536: // assert_property: opt_sva_label TOK_ASSUME TOK_PROPERTY "'('" expr "')'" "';'"
#line 2668 "frontends/verilog/verilog_parser.y"
                                                                                     {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSUME, std::move(yystack_[2].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[6].location, yystack_[1].location);
		if (yystack_[6].value.as < string_t > () != nullptr) {
			extra->ast_stack.back()->children.back()->str = *yystack_[6].value.as < string_t > ();
		}
	}
#line 4175 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 537: // assert_property: opt_sva_label TOK_ASSERT TOK_PROPERTY "'('" TOK_EVENTUALLY expr "')'" "';'"
#line 2675 "frontends/verilog/verilog_parser.y"
                                                                                                    {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, mode->assume_asserts ? AST_FAIR : AST_LIVE, std::move(yystack_[2].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[7].location, yystack_[1].location);
		if (yystack_[7].value.as < string_t > () != nullptr) {
			extra->ast_stack.back()->children.back()->str = *yystack_[7].value.as < string_t > ();
		}
	}
#line 4187 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 538: // assert_property: opt_sva_label TOK_ASSUME TOK_PROPERTY "'('" TOK_EVENTUALLY expr "')'" "';'"
#line 2682 "frontends/verilog/verilog_parser.y"
                                                                                                    {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_FAIR, std::move(yystack_[2].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[7].location, yystack_[1].location);
		if (yystack_[7].value.as < string_t > () != nullptr) {
			extra->ast_stack.back()->children.back()->str = *yystack_[7].value.as < string_t > ();
		}
	}
#line 4199 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 539: // assert_property: opt_sva_label TOK_COVER TOK_PROPERTY "'('" expr "')'" "';'"
#line 2689 "frontends/verilog/verilog_parser.y"
                                                                                    {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_COVER, std::move(yystack_[2].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[6].location, yystack_[1].location);
		if (yystack_[6].value.as < string_t > () != nullptr) {
			extra->ast_stack.back()->children.back()->str = *yystack_[6].value.as < string_t > ();
		}
	}
#line 4211 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 540: // assert_property: opt_sva_label TOK_RESTRICT TOK_PROPERTY "'('" expr "')'" "';'"
#line 2696 "frontends/verilog/verilog_parser.y"
                                                                                       {
		if (mode->norestrict) {
		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSUME, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, yystack_[6].location, yystack_[1].location);
			if (yystack_[6].value.as < string_t > () != nullptr) {
				extra->ast_stack.back()->children.back()->str = *yystack_[6].value.as < string_t > ();
			}
		}
	}
#line 4226 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 541: // assert_property: opt_sva_label TOK_RESTRICT TOK_PROPERTY "'('" TOK_EVENTUALLY expr "')'" "';'"
#line 2706 "frontends/verilog/verilog_parser.y"
                                                                                                      {
		if (mode->norestrict) {
		} else {
			AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_FAIR, std::move(yystack_[2].value.as < ast_t > ())));
			SET_AST_NODE_LOC(node, yystack_[7].location, yystack_[1].location);
			if (yystack_[7].value.as < string_t > () != nullptr) {
				extra->ast_stack.back()->children.back()->str = *yystack_[7].value.as < string_t > ();
			}
		}
	}
#line 4241 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 542: // simple_behavioral_stmt: attr lvalue "'='" delay expr
#line 2718 "frontends/verilog/verilog_parser.y"
                                      {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_EQ, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[3].location, yystack_[0].location);
		append_attr(node, std::move(yystack_[4].value.as < al_t > ()));
	}
#line 4251 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 543: // simple_behavioral_stmt: attr lvalue attr inc_or_dec_op
#line 2723 "frontends/verilog/verilog_parser.y"
                                       {
		extra->addIncOrDecStmt(std::move(yystack_[3].value.as < al_t > ()), std::move(yystack_[2].value.as < ast_t > ()), std::move(yystack_[1].value.as < al_t > ()), yystack_[0].value.as < ast_node_type_t > (), location_range(yystack_[3].location, yystack_[0].location));
	}
#line 4259 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 544: // simple_behavioral_stmt: attr inc_or_dec_op attr lvalue
#line 2726 "frontends/verilog/verilog_parser.y"
                                       {
		extra->addIncOrDecStmt(std::move(yystack_[3].value.as < al_t > ()), std::move(yystack_[0].value.as < ast_t > ()), std::move(yystack_[1].value.as < al_t > ()), yystack_[2].value.as < ast_node_type_t > (), location_range(yystack_[3].location, yystack_[0].location));
	}
#line 4267 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 545: // simple_behavioral_stmt: attr lvalue OP_LE delay expr
#line 2729 "frontends/verilog/verilog_parser.y"
                                     {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_LE, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[3].location, yystack_[0].location);
		append_attr(node, std::move(yystack_[4].value.as < al_t > ()));
	}
#line 4277 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 546: // simple_behavioral_stmt: attr lvalue asgn_binop delay expr
#line 2734 "frontends/verilog/verilog_parser.y"
                                          {
		(void)extra->addAsgnBinopStmt(std::move(yystack_[4].value.as < al_t > ()), std::move(yystack_[3].value.as < ast_t > ()), yystack_[2].value.as < ast_node_type_t > (), std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 4285 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 547: // asgn_binop: TOK_BIT_OR_ASSIGN
#line 2739 "frontends/verilog/verilog_parser.y"
                          { yylhs.value.as < ast_node_type_t > () = AST_BIT_OR; }
#line 4291 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 548: // asgn_binop: TOK_BIT_AND_ASSIGN
#line 2740 "frontends/verilog/verilog_parser.y"
                           { yylhs.value.as < ast_node_type_t > () = AST_BIT_AND; }
#line 4297 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 549: // asgn_binop: TOK_BIT_XOR_ASSIGN
#line 2741 "frontends/verilog/verilog_parser.y"
                           { yylhs.value.as < ast_node_type_t > () = AST_BIT_XOR; }
#line 4303 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 550: // asgn_binop: TOK_ADD_ASSIGN
#line 2742 "frontends/verilog/verilog_parser.y"
                       { yylhs.value.as < ast_node_type_t > () = AST_ADD; }
#line 4309 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 551: // asgn_binop: TOK_SUB_ASSIGN
#line 2743 "frontends/verilog/verilog_parser.y"
                       { yylhs.value.as < ast_node_type_t > () = AST_SUB; }
#line 4315 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 552: // asgn_binop: TOK_DIV_ASSIGN
#line 2744 "frontends/verilog/verilog_parser.y"
                       { yylhs.value.as < ast_node_type_t > () = AST_DIV; }
#line 4321 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 553: // asgn_binop: TOK_MOD_ASSIGN
#line 2745 "frontends/verilog/verilog_parser.y"
                       { yylhs.value.as < ast_node_type_t > () = AST_MOD; }
#line 4327 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 554: // asgn_binop: TOK_MUL_ASSIGN
#line 2746 "frontends/verilog/verilog_parser.y"
                       { yylhs.value.as < ast_node_type_t > () = AST_MUL; }
#line 4333 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 555: // asgn_binop: TOK_SHL_ASSIGN
#line 2747 "frontends/verilog/verilog_parser.y"
                       { yylhs.value.as < ast_node_type_t > () = AST_SHIFT_LEFT; }
#line 4339 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 556: // asgn_binop: TOK_SHR_ASSIGN
#line 2748 "frontends/verilog/verilog_parser.y"
                       { yylhs.value.as < ast_node_type_t > () = AST_SHIFT_RIGHT; }
#line 4345 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 557: // asgn_binop: TOK_SSHL_ASSIGN
#line 2749 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < ast_node_type_t > () = AST_SHIFT_SLEFT; }
#line 4351 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 558: // asgn_binop: TOK_SSHR_ASSIGN
#line 2750 "frontends/verilog/verilog_parser.y"
                        { yylhs.value.as < ast_node_type_t > () = AST_SHIFT_SRIGHT; }
#line 4357 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 559: // inc_or_dec_op: TOK_INCREMENT
#line 2755 "frontends/verilog/verilog_parser.y"
                      { yylhs.value.as < ast_node_type_t > () = AST_ADD; }
#line 4363 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 560: // inc_or_dec_op: TOK_DECREMENT
#line 2756 "frontends/verilog/verilog_parser.y"
                      { yylhs.value.as < ast_node_type_t > () = AST_SUB; }
#line 4369 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 561: // for_initialization: TOK_ID "'='" expr
#line 2759 "frontends/verilog/verilog_parser.y"
                           {
		auto ident = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
		ident->str = *yystack_[2].value.as < string_t > ();
		auto node = std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_EQ, std::move(ident), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(node.get(), yystack_[2].location, yystack_[0].location);
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 4381 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 562: // for_initialization: non_io_wire_type range TOK_ID
#line 2766 "frontends/verilog/verilog_parser.y"
                                      {
		err_at_loc(yystack_[0].location, "For loop variable declaration is missing initialization!");
	}
#line 4389 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 563: // for_initialization: non_io_wire_type range TOK_ID "'='" expr
#line 2769 "frontends/verilog/verilog_parser.y"
                                                  {
		if (!mode->sv)
			err_at_loc(yystack_[1].location, "For loop inline variable declaration is only supported in SystemVerilog mode!");

		// loop variable declaration
		auto wire = std::move(yystack_[4].value.as < ast_t > ());
		auto range = checkRange(wire.get(), std::move(yystack_[3].value.as < ast_t > ()));
		SET_AST_NODE_LOC(wire.get(), yystack_[4].location, yystack_[2].location);
		SET_AST_NODE_LOC(range.get(), yystack_[3].location, yystack_[3].location);
		if (range != nullptr)
			wire->children.push_back(std::move(range));

		auto ident = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
		ident->str = *yystack_[2].value.as < string_t > ();
		wire->str = *yystack_[2].value.as < string_t > ();

		AstNode *parent = extra->ast_stack.at(extra->ast_stack.size() - 2);
		auto& loop = parent->children.back();
		log_assert(extra->ast_stack.back() == loop.get());

		// loop variable initialization
		SET_AST_NODE_LOC(ident.get(), yystack_[2].location, yystack_[2].location);
		auto asgn = std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_EQ, std::move(ident), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(asgn.get(), yystack_[2].location, yystack_[0].location);
		loop->children.push_back(std::move(asgn));

		// inject a wrapping block to declare the loop variable and
		// contain the current loop
		auto wrapper = std::make_unique<AstNode>(yylhs.location, AST_BLOCK);
		wrapper->str = "$fordecl_block$" + std::to_string(autoidx++);
		wrapper->children.push_back(std::move(wire));
		wrapper->children.push_back(std::move(loop));
		parent->children.back() = std::move(wrapper);
	}
#line 4428 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 573: // $@59: %empty
#line 2810 "frontends/verilog/verilog_parser.y"
                             {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_TCALL));
		node->str = *yystack_[0].value.as < string_t > ();
		append_attr(node, std::move(yystack_[1].value.as < al_t > ()));
	}
#line 4438 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 574: // behavioral_stmt: attr hierarchical_id $@59 opt_arg_list "';'"
#line 2814 "frontends/verilog/verilog_parser.y"
                                  {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[3].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 4447 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 575: // $@60: %empty
#line 2818 "frontends/verilog/verilog_parser.y"
                           {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_TCALL));
		node->str = *yystack_[0].value.as < string_t > ();
		append_attr(node, std::move(yystack_[1].value.as < al_t > ()));
	}
#line 4457 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 576: // behavioral_stmt: attr TOK_MSG_TASKS $@60 opt_arg_list "';'"
#line 2822 "frontends/verilog/verilog_parser.y"
                                  {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[3].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 4466 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 577: // $@61: %empty
#line 2826 "frontends/verilog/verilog_parser.y"
                       {
		extra->enterTypeScope();
	}
#line 4474 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 578: // $@62: %empty
#line 2828 "frontends/verilog/verilog_parser.y"
                    {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_BLOCK));
		append_attr(node, std::move(yystack_[3].value.as < al_t > ()));
		if (yystack_[0].value.as < string_t > () != nullptr)
			node->str = *yystack_[0].value.as < string_t > ();
	}
#line 4485 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 579: // behavioral_stmt: attr TOK_BEGIN $@61 opt_label $@62 behavioral_stmt_list TOK_END opt_label
#line 2833 "frontends/verilog/verilog_parser.y"
                                                 {
		extra->exitTypeScope();
		checkLabelsMatch(yystack_[0].location, "Begin label", yystack_[4].value.as < string_t > ().get(), yystack_[0].value.as < string_t > ().get());
		AstNode *node = extra->ast_stack.back();
		// In SystemVerilog, unnamed blocks with block item declarations
		// create an implicit hierarchy scope
		if (mode->sv && node->str.empty())
		    for (auto& child : node->children)
			if (child->type == AST_WIRE || child->type == AST_MEMORY || child->type == AST_PARAMETER
				|| child->type == AST_LOCALPARAM || child->type == AST_TYPEDEF) {
			    node->str = "$unnamed_block$" + std::to_string(autoidx++);
			    break;
			}
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[6].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 4506 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 580: // $@63: %empty
#line 2849 "frontends/verilog/verilog_parser.y"
                                {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_FOR));
		append_attr(node, std::move(yystack_[2].value.as < al_t > ()));
	}
#line 4515 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 581: // $@64: %empty
#line 2852 "frontends/verilog/verilog_parser.y"
                                              {
		extra->ast_stack.back()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 4523 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 582: // $@65: %empty
#line 2854 "frontends/verilog/verilog_parser.y"
                                                        {
		AstNode* block = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_BLOCK));
		block->str = "$for_loop$" + std::to_string(autoidx++);
	}
#line 4532 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 583: // behavioral_stmt: attr TOK_FOR "'('" $@63 for_initialization "';'" expr $@64 "';'" simple_behavioral_stmt "')'" $@65 behavioral_stmt
#line 2857 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
		extra->ast_stack.pop_back();
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[11].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 4543 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 584: // $@66: %empty
#line 2863 "frontends/verilog/verilog_parser.y"
                                                  {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_WHILE));
		append_attr(node, std::move(yystack_[4].value.as < al_t > ()));
		auto block_owned = std::make_unique<AstNode>(yylhs.location, AST_BLOCK);
		auto* block = block_owned.get();
		extra->ast_stack.back()->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
		extra->ast_stack.back()->children.push_back(std::move(block_owned));
		extra->ast_stack.push_back(block);
	}
#line 4557 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 585: // behavioral_stmt: attr TOK_WHILE "'('" expr "')'" $@66 behavioral_stmt
#line 2871 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
		extra->ast_stack.pop_back();
		extra->ast_stack.pop_back();
	}
#line 4567 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 586: // $@67: %empty
#line 2876 "frontends/verilog/verilog_parser.y"
                                                   {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_REPEAT));
		append_attr(node, std::move(yystack_[4].value.as < al_t > ()));
		auto block_owned = std::make_unique<AstNode>(yylhs.location, AST_BLOCK);
		auto* block = block_owned.get();
		extra->ast_stack.back()->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
		extra->ast_stack.back()->children.push_back(std::move(block_owned));
		extra->ast_stack.push_back(block);
	}
#line 4581 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 587: // behavioral_stmt: attr TOK_REPEAT "'('" expr "')'" $@67 behavioral_stmt
#line 2884 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
		extra->ast_stack.pop_back();
		extra->ast_stack.pop_back();
	}
#line 4591 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 588: // $@68: %empty
#line 2889 "frontends/verilog/verilog_parser.y"
                                                  {
		std::unique_ptr<AstNode> node_owned;
		AstNode* node = nullptr;
		AstNode *context = extra->ast_stack.back();
		bool patch_block_on_stack = false;
		if (context && context->type == AST_BLOCK && context->get_bool_attribute(ID::promoted_if)) {
			AstNode *outer = extra->ast_stack[extra->ast_stack.size() - 2];
			log_assert (outer && outer->type == AST_CASE);
			if (outer->get_bool_attribute(ID::parallel_case)) {
				// parallel "else if": append condition to outer "if"
				node = outer;
				log_assert (node->children.size());
				node->children.pop_back();
				// `context` has been killed as a grandchild of `outer`
				// we have to undangle it from the stack
				patch_block_on_stack = true;
			} else if (outer->get_bool_attribute(ID::full_case))
				(*yystack_[4].value.as < al_t > ())[ID::full_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		}
		auto expr = std::make_unique<AstNode>(yylhs.location, AST_REDUCE_BOOL, std::move(yystack_[1].value.as < ast_t > ()));
		if (!node) {
			// not parallel "else if": begin new construction
			node_owned = std::make_unique<AstNode>(yylhs.location, AST_CASE);
			node = node_owned.get();
			append_attr(node, std::move(yystack_[4].value.as < al_t > ()));
			node->children.push_back(node->get_bool_attribute(ID::parallel_case) ? AstNode::mkconst_int(yylhs.location, 1, false, 1) : expr->clone());
			extra->ast_stack.back()->children.push_back(std::move(node_owned));
		}
		auto block_owned = std::make_unique<AstNode>(yylhs.location, AST_BLOCK);
		auto* block = block_owned.get();
		auto cond_owned = std::make_unique<AstNode>(yylhs.location, AST_COND, node->get_bool_attribute(ID::parallel_case) ? std::move(expr) : AstNode::mkconst_int(yylhs.location, 1, false, 1), std::move(block_owned));
		SET_AST_NODE_LOC(cond_owned.get(), yystack_[1].location, yystack_[1].location);
		node->children.push_back(std::move(cond_owned));
		// Double it and give it to the next person
		if (patch_block_on_stack)
			extra->ast_stack.back() = block;
		extra->ast_stack.push_back(node);
		extra->ast_stack.push_back(block);
	}
#line 4635 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 589: // $@69: %empty
#line 2927 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
	}
#line 4643 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 590: // behavioral_stmt: if_attr TOK_IF "'('" expr "')'" $@68 behavioral_stmt $@69 optional_else
#line 2929 "frontends/verilog/verilog_parser.y"
                        {
		extra->ast_stack.pop_back();
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[7].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 4653 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 591: // $@70: %empty
#line 2934 "frontends/verilog/verilog_parser.y"
                                                       {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_CASE, std::move(yystack_[1].value.as < ast_t > ())));
		append_attr(node, std::move(yystack_[4].value.as < al_t > ()));
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[1].location, yystack_[1].location);
	}
#line 4663 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 592: // behavioral_stmt: case_attr case_type "'('" expr "')'" $@70 opt_synopsys_attr case_body TOK_ENDCASE
#line 2938 "frontends/verilog/verilog_parser.y"
                                                  {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[7].location, yystack_[0].location);
		extra->case_type_stack.pop_back();
		extra->ast_stack.pop_back();
	}
#line 4673 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 593: // if_attr: attr
#line 2945 "frontends/verilog/verilog_parser.y"
             {
		yylhs.value.as < al_t > () = std::move(yystack_[0].value.as < al_t > ());
	}
#line 4681 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 594: // if_attr: attr TOK_UNIQUE0
#line 2948 "frontends/verilog/verilog_parser.y"
                         {
		AstNode *context = extra->ast_stack.back();
		if (context && context->type == AST_BLOCK && context->get_bool_attribute(ID::promoted_if))
			err_at_loc(yystack_[0].location, "unique0 keyword cannot be used for 'else if' branch.");
		(*yystack_[1].value.as < al_t > ())[ID::parallel_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		yylhs.value.as < al_t > () = std::move(yystack_[1].value.as < al_t > ());
	}
#line 4693 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 595: // if_attr: attr TOK_PRIORITY
#line 2955 "frontends/verilog/verilog_parser.y"
                          {
		AstNode *context = extra->ast_stack.back();
		if (context && context->type == AST_BLOCK && context->get_bool_attribute(ID::promoted_if))
			err_at_loc(yystack_[0].location, "priority keyword cannot be used for 'else if' branch.");
		(*yystack_[1].value.as < al_t > ())[ID::full_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		yylhs.value.as < al_t > () = std::move(yystack_[1].value.as < al_t > ());
	}
#line 4705 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 596: // if_attr: attr TOK_UNIQUE
#line 2962 "frontends/verilog/verilog_parser.y"
                        {
		AstNode *context = extra->ast_stack.back();
		if (context && context->type == AST_BLOCK && context->get_bool_attribute(ID::promoted_if))
			err_at_loc(yystack_[0].location, "unique keyword cannot be used for 'else if' branch.");
		(*yystack_[1].value.as < al_t > ())[ID::full_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		(*yystack_[1].value.as < al_t > ())[ID::parallel_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		yylhs.value.as < al_t > () = std::move(yystack_[1].value.as < al_t > ());
	}
#line 4718 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 597: // case_attr: attr
#line 2972 "frontends/verilog/verilog_parser.y"
             {
		yylhs.value.as < al_t > () = std::move(yystack_[0].value.as < al_t > ());
	}
#line 4726 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 598: // case_attr: attr TOK_UNIQUE0
#line 2975 "frontends/verilog/verilog_parser.y"
                         {
		(*yystack_[1].value.as < al_t > ())[ID::parallel_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		yylhs.value.as < al_t > () = std::move(yystack_[1].value.as < al_t > ());
	}
#line 4735 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 599: // case_attr: attr TOK_PRIORITY
#line 2979 "frontends/verilog/verilog_parser.y"
                          {
		(*yystack_[1].value.as < al_t > ())[ID::full_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		yylhs.value.as < al_t > () = std::move(yystack_[1].value.as < al_t > ());
	}
#line 4744 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 600: // case_attr: attr TOK_UNIQUE
#line 2983 "frontends/verilog/verilog_parser.y"
                        {
		(*yystack_[1].value.as < al_t > ())[ID::full_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		(*yystack_[1].value.as < al_t > ())[ID::parallel_case] = AstNode::mkconst_int(yylhs.location, 1, false);
		yylhs.value.as < al_t > () = std::move(yystack_[1].value.as < al_t > ());
	}
#line 4754 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 601: // case_type: TOK_CASE
#line 2990 "frontends/verilog/verilog_parser.y"
                 {
		extra->case_type_stack.push_back(0);
	}
#line 4762 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 602: // case_type: TOK_CASEX
#line 2993 "frontends/verilog/verilog_parser.y"
                  {
		extra->case_type_stack.push_back('x');
	}
#line 4770 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 603: // case_type: TOK_CASEZ
#line 2996 "frontends/verilog/verilog_parser.y"
                  {
		extra->case_type_stack.push_back('z');
	}
#line 4778 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 604: // opt_synopsys_attr: opt_synopsys_attr TOK_SYNOPSYS_FULL_CASE
#line 3001 "frontends/verilog/verilog_parser.y"
                                                 {
		if (extra->ast_stack.back()->attributes.count(ID::full_case) == 0)
			extra->ast_stack.back()->attributes[ID::full_case] = AstNode::mkconst_int(yylhs.location, 1, false);
	}
#line 4787 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 605: // opt_synopsys_attr: opt_synopsys_attr TOK_SYNOPSYS_PARALLEL_CASE
#line 3005 "frontends/verilog/verilog_parser.y"
                                                     {
		if (extra->ast_stack.back()->attributes.count(ID::parallel_case) == 0)
			extra->ast_stack.back()->attributes[ID::parallel_case] = AstNode::mkconst_int(yylhs.location, 1, false);
	}
#line 4796 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 609: // $@71: %empty
#line 3016 "frontends/verilog/verilog_parser.y"
                 {
		extra->ast_stack.pop_back();
		auto block_owned = std::make_unique<AstNode>(yylhs.location, AST_BLOCK);
		auto* block = block_owned.get();
		block->attributes[ID::promoted_if] = AstNode::mkconst_int(yylhs.location, 1, false);
		AstNode* cond = extra->saveChild(
			std::make_unique<AstNode>(yylhs.location, AST_COND,
				std::make_unique<AstNode>(yylhs.location, AST_DEFAULT),
				std::move(block_owned)));
		extra->ast_stack.push_back(block);
		SET_AST_NODE_LOC(cond, yystack_[0].location, yystack_[0].location);
	}
#line 4813 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 610: // optional_else: TOK_ELSE $@71 behavioral_stmt
#line 3027 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
	}
#line 4821 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 614: // $@72: %empty
#line 3037 "frontends/verilog/verilog_parser.y"
        {
		(void)extra->pushChild(std::make_unique<AstNode>(
				yylhs.location,
				extra->case_type_stack.size() && extra->case_type_stack.back() == 'x' ? AST_CONDX :
				extra->case_type_stack.size() && extra->case_type_stack.back() == 'z' ? AST_CONDZ : AST_COND));
	}
#line 4832 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 615: // $@73: %empty
#line 3042 "frontends/verilog/verilog_parser.y"
                      {
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_BLOCK));
		extra->case_type_stack.push_back(0);
	}
#line 4841 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 616: // case_item: $@72 case_select $@73 behavioral_stmt
#line 3045 "frontends/verilog/verilog_parser.y"
                          {
		extra->case_type_stack.pop_back();
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
		extra->ast_stack.pop_back();
		extra->ast_stack.pop_back();
	}
#line 4852 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 619: // $@74: %empty
#line 3057 "frontends/verilog/verilog_parser.y"
        {
		(void)extra->pushChild(std::make_unique<AstNode>(
				yylhs.location,
				extra->case_type_stack.size() && extra->case_type_stack.back() == 'x' ? AST_CONDX :
				extra->case_type_stack.size() && extra->case_type_stack.back() == 'z' ? AST_CONDZ : AST_COND));
	}
#line 4863 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 620: // $@75: %empty
#line 3062 "frontends/verilog/verilog_parser.y"
                      {
		extra->case_type_stack.push_back(0);
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
	}
#line 4872 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 621: // gen_case_item: $@74 case_select $@75 gen_stmt_block
#line 3065 "frontends/verilog/verilog_parser.y"
                         {
		extra->case_type_stack.pop_back();
		extra->ast_stack.pop_back();
	}
#line 4881 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 624: // case_expr_list: TOK_DEFAULT
#line 3075 "frontends/verilog/verilog_parser.y"
                    {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_DEFAULT));
		SET_AST_NODE_LOC(node, yystack_[0].location, yystack_[0].location);
	}
#line 4890 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 625: // case_expr_list: TOK_SVA_LABEL
#line 3079 "frontends/verilog/verilog_parser.y"
                      {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER));
		node->str = *yystack_[0].value.as < string_t > ();
		SET_AST_NODE_LOC(node, yystack_[0].location, yystack_[0].location);
	}
#line 4900 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 626: // case_expr_list: expr
#line 3084 "frontends/verilog/verilog_parser.y"
             {
		extra->ast_stack.back()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 4908 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 627: // case_expr_list: case_expr_list "','" expr
#line 3087 "frontends/verilog/verilog_parser.y"
                                      {
		extra->ast_stack.back()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 4916 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 628: // rvalue: hierarchical_id "'['" expr "']'" "'.'" rvalue
#line 3092 "frontends/verilog/verilog_parser.y"
                                                              {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_PREFIX, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->str = *yystack_[5].value.as < string_t > ();
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[5].location, yystack_[0].location);
	}
#line 4926 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 629: // rvalue: hierarchical_id range
#line 3097 "frontends/verilog/verilog_parser.y"
                              {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER, std::move(yystack_[0].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->str = *yystack_[1].value.as < string_t > ();
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[1].location, yystack_[1].location);
		if (yystack_[0].value.as < ast_t > () == nullptr && (yylhs.value.as < ast_t > ()->str == "\\$initstate" ||
				yylhs.value.as < ast_t > ()->str == "\\$anyconst" || yylhs.value.as < ast_t > ()->str == "\\$anyseq" ||
				yylhs.value.as < ast_t > ()->str == "\\$allconst" || yylhs.value.as < ast_t > ()->str == "\\$allseq"))
			yylhs.value.as < ast_t > ()->type = AST_FCALL;
	}
#line 4940 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 630: // rvalue: hierarchical_id non_opt_multirange
#line 3106 "frontends/verilog/verilog_parser.y"
                                           {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER, std::move(yystack_[0].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->str = *yystack_[1].value.as < string_t > ();
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[1].location, yystack_[1].location);
	}
#line 4950 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 631: // lvalue: rvalue
#line 3113 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 4958 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 632: // lvalue: "'{'" lvalue_concat_list "'}'"
#line 3116 "frontends/verilog/verilog_parser.y"
                                               {
		yylhs.value.as < ast_t > () = std::move(yystack_[1].value.as < ast_t > ());
	}
#line 4966 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 633: // lvalue_concat_list: expr
#line 3121 "frontends/verilog/verilog_parser.y"
             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_CONCAT);
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 4975 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 634: // lvalue_concat_list: expr "','" lvalue_concat_list
#line 3125 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[2].value.as < ast_t > ()));
	}
#line 4984 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 641: // single_arg: expr
#line 3143 "frontends/verilog/verilog_parser.y"
             {
		extra->ast_stack.back()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 4992 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 648: // genvar_identifier: TOK_ID
#line 3157 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
		yylhs.value.as < ast_t > ()->str = *yystack_[0].value.as < string_t > ();
	}
#line 5001 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 649: // genvar_initialization: TOK_GENVAR genvar_identifier
#line 3163 "frontends/verilog/verilog_parser.y"
                                     {
		err_at_loc(yystack_[0].location, "Generate for loop variable declaration is missing initialization!");
	}
#line 5009 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 650: // genvar_initialization: TOK_GENVAR genvar_identifier "'='" expr
#line 3166 "frontends/verilog/verilog_parser.y"
                                                 {
		if (!mode->sv)
			err_at_loc(yystack_[1].location, "Generate for loop inline variable declaration is only supported in SystemVerilog mode!");
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_GENVAR));
		node->is_reg = true;
		node->is_signed = true;
		node->range_left = 31;
		node->range_right = 0;
		node->str = yystack_[2].value.as < ast_t > ()->str;
		node->children.push_back(checkRange(node, nullptr));
		SET_AST_NODE_LOC(node, yystack_[3].location, yystack_[0].location);
		node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_EQ, std::move(yystack_[2].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[3].location, yystack_[0].location);
	}
#line 5028 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 651: // genvar_initialization: genvar_identifier "'='" expr
#line 3180 "frontends/verilog/verilog_parser.y"
                                      {
		AstNode* node = extra->saveChild(std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_EQ, std::move(yystack_[2].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(node, yystack_[2].location, yystack_[0].location);
	}
#line 5037 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 652: // $@76: %empty
#line 3187 "frontends/verilog/verilog_parser.y"
                           {
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_GENFOR));
	}
#line 5045 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 653: // $@77: %empty
#line 3189 "frontends/verilog/verilog_parser.y"
                                                 {
		extra->ast_stack.back()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 5053 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 654: // gen_stmt: TOK_FOR "'('" $@76 genvar_initialization "';'" expr $@77 "';'" simple_behavioral_stmt "')'" gen_stmt_block
#line 3191 "frontends/verilog/verilog_parser.y"
                                                                       {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[10].location, yystack_[0].location);
		extra->rewriteGenForDeclInit(extra->ast_stack.back());
		extra->ast_stack.pop_back();
	}
#line 5063 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 655: // $@78: %empty
#line 3196 "frontends/verilog/verilog_parser.y"
                                          {
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_GENIF));
		extra->ast_stack.back()->children.push_back(std::move(yystack_[1].value.as < ast_t > ()));
	}
#line 5072 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 656: // gen_stmt: TOK_IF "'('" expr "')'" $@78 gen_stmt_block opt_gen_else
#line 3199 "frontends/verilog/verilog_parser.y"
                                      {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[6].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 5081 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 657: // $@79: %empty
#line 3203 "frontends/verilog/verilog_parser.y"
                                             {
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_GENCASE, std::move(yystack_[1].value.as < ast_t > ())));
	}
#line 5089 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 658: // gen_stmt: case_type "'('" expr "')'" $@79 gen_case_body TOK_ENDCASE
#line 3205 "frontends/verilog/verilog_parser.y"
                                    {
		extra->case_type_stack.pop_back();
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[6].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 5099 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 659: // $@80: %empty
#line 3210 "frontends/verilog/verilog_parser.y"
                      {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_TECALL));
		node->str = *yystack_[0].value.as < string_t > ();
	}
#line 5108 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 660: // gen_stmt: TOK_MSG_TASKS $@80 opt_arg_list "';'"
#line 3213 "frontends/verilog/verilog_parser.y"
                                  {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[3].location, yystack_[1].location);
		extra->ast_stack.pop_back();
	}
#line 5117 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 661: // $@81: %empty
#line 3219 "frontends/verilog/verilog_parser.y"
                  {
		extra->enterTypeScope();
	}
#line 5125 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 662: // $@82: %empty
#line 3221 "frontends/verilog/verilog_parser.y"
                    {
		AstNode* node = extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_GENBLOCK));
		node->str = yystack_[0].value.as < string_t > () ? *yystack_[0].value.as < string_t > () : std::string();
	}
#line 5134 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 663: // gen_block: TOK_BEGIN $@81 opt_label $@82 module_gen_body TOK_END opt_label
#line 3224 "frontends/verilog/verilog_parser.y"
                                            {
		extra->exitTypeScope();
		checkLabelsMatch(yystack_[0].location, "Begin label", yystack_[4].value.as < string_t > ().get(), yystack_[0].value.as < string_t > ().get());
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[6].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 5145 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 664: // $@83: %empty
#line 3233 "frontends/verilog/verilog_parser.y"
        {
		(void)extra->pushChild(std::make_unique<AstNode>(yylhs.location, AST_GENBLOCK));
	}
#line 5153 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 665: // gen_stmt_block: $@83 gen_stmt_or_module_body_stmt
#line 3235 "frontends/verilog/verilog_parser.y"
                                       {
		SET_AST_NODE_LOC(extra->ast_stack.back(), yystack_[0].location, yystack_[0].location);
		extra->ast_stack.pop_back();
	}
#line 5162 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 669: // expr: basic_expr
#line 3244 "frontends/verilog/verilog_parser.y"
                   {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 5170 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 670: // expr: basic_expr "'?'" attr expr "':'" expr
#line 3247 "frontends/verilog/verilog_parser.y"
                                                  {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_TERNARY);
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[5].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[2].value.as < ast_t > ()));
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[5].location, yylhs.location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[3].value.as < al_t > ()));
	}
#line 5183 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 671: // expr: inc_or_dec_op attr rvalue
#line 3255 "frontends/verilog/verilog_parser.y"
                                  {
		yylhs.value.as < ast_t > () = extra->addIncOrDecExpr(std::move(yystack_[0].value.as < ast_t > ()), std::move(yystack_[1].value.as < al_t > ()), yystack_[2].value.as < ast_node_type_t > (), location_range(yystack_[2].location, yystack_[0].location), false, mode->sv);
	}
#line 5191 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 672: // expr: rvalue inc_or_dec_op
#line 3260 "frontends/verilog/verilog_parser.y"
                             {
		yylhs.value.as < ast_t > () = extra->addIncOrDecExpr(std::move(yystack_[1].value.as < ast_t > ()), nullptr, yystack_[0].value.as < ast_node_type_t > (), location_range(yystack_[1].location, yystack_[0].location), true, mode->sv);
	}
#line 5199 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 673: // basic_expr: rvalue
#line 3265 "frontends/verilog/verilog_parser.y"
               {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
	}
#line 5207 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 674: // basic_expr: "'('" expr "')'" integral_number
#line 3268 "frontends/verilog/verilog_parser.y"
                                                   {
		if (yystack_[0].value.as < string_t > ()->compare(0, 1, "'") != 0)
			err_at_loc(yystack_[0].location, "Cast operation must be applied on sized constants e.g. (<expr>)<constval> , while %s is not a sized constant.", *yystack_[0].value.as < string_t > ());
		ConstParser p{yystack_[0].location};
		auto val = p.const2ast(*yystack_[0].value.as < string_t > (), extra->case_type_stack.size() == 0 ? 0 : extra->case_type_stack.back(), !mode->lib);
		if (val == nullptr)
			log_error("Value conversion failed: `%s'\n", *yystack_[0].value.as < string_t > ());
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_TO_BITS, std::move(yystack_[2].value.as < ast_t > ()), std::move(val));
	}
#line 5221 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 675: // basic_expr: hierarchical_id integral_number
#line 3277 "frontends/verilog/verilog_parser.y"
                                        {
		if (yystack_[0].value.as < string_t > ()->compare(0, 1, "'") != 0)
			err_at_loc(yystack_[0].location, "Cast operation must be applied on sized constants, e.g. <ID>\'d0, while %s is not a sized constant.", *yystack_[0].value.as < string_t > ());
		auto bits = std::make_unique<AstNode>(yylhs.location, AST_IDENTIFIER);
		bits->str = *yystack_[1].value.as < string_t > ();
		SET_AST_NODE_LOC(bits.get(), yystack_[1].location, yystack_[1].location);
		ConstParser p{yystack_[0].location};
		auto val = p.const2ast(*yystack_[0].value.as < string_t > (), extra->case_type_stack.size() == 0 ? 0 : extra->case_type_stack.back(), !mode->lib);
		SET_AST_NODE_LOC(val.get(), yystack_[0].location, yystack_[0].location);
		if (val == nullptr)
			log_error("Value conversion failed: `%s'\n", *yystack_[0].value.as < string_t > ());
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_TO_BITS, std::move(bits), std::move(val));
	}
#line 5239 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 676: // basic_expr: integral_number
#line 3290 "frontends/verilog/verilog_parser.y"
                        {
		ConstParser p{yystack_[0].location};
		yylhs.value.as < ast_t > () = p.const2ast(*yystack_[0].value.as < string_t > (), extra->case_type_stack.size() == 0 ? 0 : extra->case_type_stack.back(), !mode->lib);
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[0].location, yystack_[0].location);
		if (yylhs.value.as < ast_t > () == nullptr)
			log_error("Value conversion failed: `%s'\n", *yystack_[0].value.as < string_t > ());
	}
#line 5251 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 677: // basic_expr: TOK_REALVAL
#line 3297 "frontends/verilog/verilog_parser.y"
                    {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REALVALUE);
		char *p = (char*)malloc(GetSize(*yystack_[0].value.as < string_t > ()) + 1), *q;
		for (int i = 0, j = 0; j < GetSize(*yystack_[0].value.as < string_t > ()); j++)
			if ((*yystack_[0].value.as < string_t > ())[j] != '_')
				p[i++] = (*yystack_[0].value.as < string_t > ())[j], p[i] = 0;
		yylhs.value.as < ast_t > ()->realvalue = strtod(p, &q);
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[0].location, yystack_[0].location);
		log_assert(*q == 0);
		free(p);
	}
#line 5267 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 678: // basic_expr: TOK_STRING
#line 3308 "frontends/verilog/verilog_parser.y"
                   {
		yylhs.value.as < ast_t > () = AstNode::mkconst_str(yystack_[0].location, *yystack_[0].value.as < string_t > ());
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[0].location, yystack_[0].location);
	}
#line 5276 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 679: // @84: %empty
#line 3312 "frontends/verilog/verilog_parser.y"
                                    {
		// Here we use "Typed Midrule Actions".
		// https://www.gnu.org/software/bison/manual/html_node/Typed-Midrule-Actions.html
		auto fcall = std::make_unique<AstNode>(yystack_[1].location, AST_FCALL);
		AstNode *fcall_node = fcall.get();
		fcall_node->str = *yystack_[1].value.as < string_t > ();
		extra->ast_stack.push_back(fcall_node);
		SET_AST_NODE_LOC(fcall_node, yystack_[1].location, yystack_[1].location);
		append_attr(fcall_node, std::move(yystack_[0].value.as < al_t > ()));
		yylhs.value.as < ast_t > () = std::move(fcall);
	}
#line 5292 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 680: // basic_expr: hierarchical_id attr @84 "'('" arg_list optional_comma "')'"
#line 3322 "frontends/verilog/verilog_parser.y"
                                                        {
		log_assert(yystack_[4].value.as < ast_t > () != nullptr);
		yylhs.value.as < ast_t > () = std::move(yystack_[4].value.as < ast_t > ());
		extra->ast_stack.pop_back();
	}
#line 5302 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 681: // basic_expr: TOK_TO_SIGNED attr "'('" expr "')'"
#line 3327 "frontends/verilog/verilog_parser.y"
                                                      {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_TO_SIGNED, std::move(yystack_[1].value.as < ast_t > ()));
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[3].value.as < al_t > ()));
	}
#line 5311 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 682: // basic_expr: TOK_TO_UNSIGNED attr "'('" expr "')'"
#line 3331 "frontends/verilog/verilog_parser.y"
                                                        {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_TO_UNSIGNED, std::move(yystack_[1].value.as < ast_t > ()));
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[3].value.as < al_t > ()));
	}
#line 5320 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 683: // basic_expr: "'('" expr "')'"
#line 3335 "frontends/verilog/verilog_parser.y"
                                   {
		yylhs.value.as < ast_t > () = std::move(yystack_[1].value.as < ast_t > ());
	}
#line 5328 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 684: // basic_expr: "'('" expr "':'" expr "':'" expr "')'"
#line 3338 "frontends/verilog/verilog_parser.y"
                                                             {
		yylhs.value.as < ast_t > () = std::move(yystack_[3].value.as < ast_t > ());
	}
#line 5336 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 685: // basic_expr: "'{'" concat_list "'}'"
#line 3341 "frontends/verilog/verilog_parser.y"
                                        {
		yylhs.value.as < ast_t > () = std::move(yystack_[1].value.as < ast_t > ());
	}
#line 5344 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 686: // basic_expr: "'{'" expr "'{'" concat_list "'}'" "'}'"
#line 3344 "frontends/verilog/verilog_parser.y"
                                                                 {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REPLICATE, std::move(yystack_[4].value.as < ast_t > ()), std::move(yystack_[2].value.as < ast_t > ()));
	}
#line 5352 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 687: // basic_expr: "'~'" attr basic_expr
#line 3347 "frontends/verilog/verilog_parser.y"
                                                  {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_BIT_NOT, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5362 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 688: // basic_expr: basic_expr "'&'" attr basic_expr
#line 3352 "frontends/verilog/verilog_parser.y"
                                           {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_BIT_AND, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5372 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 689: // basic_expr: basic_expr OP_NAND attr basic_expr
#line 3357 "frontends/verilog/verilog_parser.y"
                                           {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_BIT_NOT, std::make_unique<AstNode>(yylhs.location, AST_BIT_AND, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5382 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 690: // basic_expr: basic_expr "'|'" attr basic_expr
#line 3362 "frontends/verilog/verilog_parser.y"
                                            {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_BIT_OR, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5392 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 691: // basic_expr: basic_expr OP_NOR attr basic_expr
#line 3367 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_BIT_NOT, std::make_unique<AstNode>(yylhs.location, AST_BIT_OR, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5402 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 692: // basic_expr: basic_expr "'^'" attr basic_expr
#line 3372 "frontends/verilog/verilog_parser.y"
                                             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_BIT_XOR, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5412 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 693: // basic_expr: basic_expr OP_XNOR attr basic_expr
#line 3377 "frontends/verilog/verilog_parser.y"
                                           {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_BIT_XNOR, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5422 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 694: // basic_expr: "'&'" attr basic_expr
#line 3382 "frontends/verilog/verilog_parser.y"
                                                {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REDUCE_AND, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5432 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 695: // basic_expr: OP_NAND attr basic_expr
#line 3387 "frontends/verilog/verilog_parser.y"
                                                {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REDUCE_AND, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_LOGIC_NOT, std::move(yylhs.value.as < ast_t > ()));
	}
#line 5443 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 696: // basic_expr: "'|'" attr basic_expr
#line 3393 "frontends/verilog/verilog_parser.y"
                                                 {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REDUCE_OR, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5453 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 697: // basic_expr: OP_NOR attr basic_expr
#line 3398 "frontends/verilog/verilog_parser.y"
                                               {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REDUCE_OR, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_LOGIC_NOT, std::move(yylhs.value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
	}
#line 5465 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 698: // basic_expr: "'^'" attr basic_expr
#line 3405 "frontends/verilog/verilog_parser.y"
                                                  {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REDUCE_XOR, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5475 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 699: // basic_expr: OP_XNOR attr basic_expr
#line 3410 "frontends/verilog/verilog_parser.y"
                                                {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_REDUCE_XNOR, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5485 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 700: // basic_expr: basic_expr OP_SHL attr basic_expr
#line 3415 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_SHIFT_LEFT, std::move(yystack_[3].value.as < ast_t > ()), std::make_unique<AstNode>(yylhs.location, AST_TO_UNSIGNED, std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5495 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 701: // basic_expr: basic_expr OP_SHR attr basic_expr
#line 3420 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_SHIFT_RIGHT, std::move(yystack_[3].value.as < ast_t > ()), std::make_unique<AstNode>(yylhs.location, AST_TO_UNSIGNED, std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5505 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 702: // basic_expr: basic_expr OP_SSHL attr basic_expr
#line 3425 "frontends/verilog/verilog_parser.y"
                                           {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_SHIFT_SLEFT, std::move(yystack_[3].value.as < ast_t > ()), std::make_unique<AstNode>(yylhs.location, AST_TO_UNSIGNED, std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5515 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 703: // basic_expr: basic_expr OP_SSHR attr basic_expr
#line 3430 "frontends/verilog/verilog_parser.y"
                                           {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_SHIFT_SRIGHT, std::move(yystack_[3].value.as < ast_t > ()), std::make_unique<AstNode>(yylhs.location, AST_TO_UNSIGNED, std::move(yystack_[0].value.as < ast_t > ())));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5525 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 704: // basic_expr: basic_expr "'<'" attr basic_expr
#line 3435 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_LT, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5535 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 705: // basic_expr: basic_expr OP_LE attr basic_expr
#line 3440 "frontends/verilog/verilog_parser.y"
                                         {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_LE, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5545 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 706: // basic_expr: basic_expr OP_EQ attr basic_expr
#line 3445 "frontends/verilog/verilog_parser.y"
                                         {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_EQ, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5555 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 707: // basic_expr: basic_expr OP_NE attr basic_expr
#line 3450 "frontends/verilog/verilog_parser.y"
                                         {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_NE, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5565 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 708: // basic_expr: basic_expr OP_EQX attr basic_expr
#line 3455 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_EQX, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5575 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 709: // basic_expr: basic_expr OP_NEX attr basic_expr
#line 3460 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_NEX, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5585 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 710: // basic_expr: basic_expr OP_GE attr basic_expr
#line 3465 "frontends/verilog/verilog_parser.y"
                                         {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_GE, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5595 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 711: // basic_expr: basic_expr "'>'" attr basic_expr
#line 3470 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_GT, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5605 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 712: // basic_expr: basic_expr "'+'" attr basic_expr
#line 3475 "frontends/verilog/verilog_parser.y"
                                            {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_ADD, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5615 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 713: // basic_expr: basic_expr "'-'" attr basic_expr
#line 3480 "frontends/verilog/verilog_parser.y"
                                             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_SUB, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5625 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 714: // basic_expr: basic_expr "'*'" attr basic_expr
#line 3485 "frontends/verilog/verilog_parser.y"
                                             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_MUL, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5635 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 715: // basic_expr: basic_expr "'/'" attr basic_expr
#line 3490 "frontends/verilog/verilog_parser.y"
                                             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_DIV, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5645 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 716: // basic_expr: basic_expr "'%'" attr basic_expr
#line 3495 "frontends/verilog/verilog_parser.y"
                                            {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_MOD, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5655 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 717: // basic_expr: basic_expr OP_POW attr basic_expr
#line 3500 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_POW, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5665 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 718: // basic_expr: "'+'" attr basic_expr
#line 3505 "frontends/verilog/verilog_parser.y"
                                                 {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_POS, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5675 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 719: // basic_expr: "'-'" attr basic_expr
#line 3510 "frontends/verilog/verilog_parser.y"
                                                  {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_NEG, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5685 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 720: // basic_expr: basic_expr OP_LAND attr basic_expr
#line 3515 "frontends/verilog/verilog_parser.y"
                                           {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_LOGIC_AND, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5695 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 721: // basic_expr: basic_expr OP_LOR attr basic_expr
#line 3520 "frontends/verilog/verilog_parser.y"
                                          {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_LOGIC_OR, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[3].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5705 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 722: // basic_expr: "'!'" attr basic_expr
#line 3525 "frontends/verilog/verilog_parser.y"
                                                 {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_LOGIC_NOT, std::move(yystack_[0].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[2].location, yystack_[0].location);
		append_attr(yylhs.value.as < ast_t > ().get(), std::move(yystack_[1].value.as < al_t > ()));
	}
#line 5715 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 723: // basic_expr: TOK_SIGNED OP_CAST "'('" expr "')'"
#line 3530 "frontends/verilog/verilog_parser.y"
                                                      {
		if (!mode->sv)
			err_at_loc(yystack_[3].location, "Static cast is only supported in SystemVerilog mode.");
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_TO_SIGNED, std::move(yystack_[1].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[4].location, yystack_[1].location);
	}
#line 5726 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 724: // basic_expr: TOK_UNSIGNED OP_CAST "'('" expr "')'"
#line 3536 "frontends/verilog/verilog_parser.y"
                                                        {
		if (!mode->sv)
			err_at_loc(yystack_[3].location, "Static cast is only supported in SystemVerilog mode.");
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_TO_UNSIGNED, std::move(yystack_[1].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[4].location, yystack_[1].location);
	}
#line 5737 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 725: // basic_expr: basic_expr OP_CAST "'('" expr "')'"
#line 3542 "frontends/verilog/verilog_parser.y"
                                                      {
		if (!mode->sv)
			err_at_loc(yystack_[3].location, "Static cast is only supported in SystemVerilog mode.");
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_CAST_SIZE, std::move(yystack_[4].value.as < ast_t > ()), std::move(yystack_[1].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[4].location, yystack_[1].location);
	}
#line 5748 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 726: // basic_expr: typedef_base_type OP_CAST "'('" expr "')'"
#line 3548 "frontends/verilog/verilog_parser.y"
                                                             {
		if (!mode->sv)
			err_at_loc(yystack_[3].location, "Static cast is only supported in SystemVerilog mode.");
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_CAST_SIZE, std::move(yystack_[4].value.as < ast_t > ()), std::move(yystack_[1].value.as < ast_t > ()));
		SET_AST_NODE_LOC(yylhs.value.as < ast_t > ().get(), yystack_[4].location, yystack_[1].location);
	}
#line 5759 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 727: // basic_expr: "'('" expr "'='" expr "')'"
#line 3554 "frontends/verilog/verilog_parser.y"
                                               {
		extra->ensureAsgnExprAllowed(yystack_[2].location, mode->sv);
		yylhs.value.as < ast_t > () = yystack_[3].value.as < ast_t > ()->clone();
		auto node = std::make_unique<AstNode>(yylhs.location, AST_ASSIGN_EQ, std::move(yystack_[3].value.as < ast_t > ()), std::move(yystack_[1].value.as < ast_t > ()));
		SET_AST_NODE_LOC(node.get(), yystack_[3].location, yystack_[1].location);
		extra->ast_stack.back()->children.push_back(std::move(node));
	}
#line 5771 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 728: // basic_expr: "'('" expr asgn_binop expr "')'"
#line 3561 "frontends/verilog/verilog_parser.y"
                                                   {
		extra->ensureAsgnExprAllowed(yystack_[2].location, mode->sv);
		yylhs.value.as < ast_t > () = extra->addAsgnBinopStmt(nullptr, std::move(yystack_[3].value.as < ast_t > ()), yystack_[2].value.as < ast_node_type_t > (), std::move(yystack_[1].value.as < ast_t > ()))-> clone();
	}
#line 5780 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 729: // concat_list: expr
#line 3567 "frontends/verilog/verilog_parser.y"
             {
		yylhs.value.as < ast_t > () = std::make_unique<AstNode>(yylhs.location, AST_CONCAT, std::move(yystack_[0].value.as < ast_t > ()));
	}
#line 5788 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 730: // concat_list: expr "','" concat_list
#line 3570 "frontends/verilog/verilog_parser.y"
                                   {
		yylhs.value.as < ast_t > () = std::move(yystack_[0].value.as < ast_t > ());
		yylhs.value.as < ast_t > ()->children.push_back(std::move(yystack_[2].value.as < ast_t > ()));
	}
#line 5797 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 731: // integral_number: TOK_CONSTVAL
#line 3576 "frontends/verilog/verilog_parser.y"
                     { yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ()); }
#line 5803 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 732: // integral_number: TOK_UNBASED_UNSIZED_CONSTVAL
#line 3577 "frontends/verilog/verilog_parser.y"
                                     { yylhs.value.as < string_t > () = std::move(yystack_[0].value.as < string_t > ()); }
#line 5809 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 733: // integral_number: TOK_BASE TOK_BASED_CONSTVAL
#line 3578 "frontends/verilog/verilog_parser.y"
                                    {
		yystack_[1].value.as < string_t > ()->append(*yystack_[0].value.as < string_t > ());
		yylhs.value.as < string_t > () = std::move(yystack_[1].value.as < string_t > ());
	}
#line 5818 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 734: // integral_number: TOK_CONSTVAL TOK_BASE TOK_BASED_CONSTVAL
#line 3582 "frontends/verilog/verilog_parser.y"
                                                 {
		yystack_[2].value.as < string_t > ()->append(*yystack_[1].value.as < string_t > ()).append(*yystack_[0].value.as < string_t > ());
		yylhs.value.as < string_t > () = std::move(yystack_[2].value.as < string_t > ());
	}
#line 5827 "frontends/verilog/verilog_parser.tab.cc"
    break;


#line 5831 "frontends/verilog/verilog_parser.tab.cc"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (yyla.location, YY_MOVE (msg));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yyerror_range[1].location = yystack_[0].location;
        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      yy_lac_discard_ ("error recovery");
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what ());
  }

  const char *
  parser::symbol_name (symbol_kind_type yysymbol)
  {
    static const char *const yy_sname[] =
    {
    "end of file", "error", "invalid token", "string", "ast_t", "al_t",
  "specify target", "specify triple", "specify rise and fall", "boolean",
  "invalid token", "integer", "ast_node_type_t", "TOK_STRING", "TOK_ID",
  "TOK_CONSTVAL", "TOK_REALVAL", "TOK_PRIMITIVE", "TOK_SVA_LABEL",
  "TOK_SPECIFY_OPER", "TOK_MSG_TASKS", "TOK_BASE", "TOK_BASED_CONSTVAL",
  "TOK_UNBASED_UNSIZED_CONSTVAL", "TOK_USER_TYPE", "TOK_PKG_USER_TYPE",
  "TOK_ASSERT", "TOK_ASSUME", "TOK_RESTRICT", "TOK_COVER", "TOK_FINAL",
  "ATTR_BEGIN", "ATTR_END", "DEFATTR_BEGIN", "DEFATTR_END", "TOK_MODULE",
  "TOK_ENDMODULE", "TOK_PARAMETER", "TOK_LOCALPARAM", "TOK_DEFPARAM",
  "TOK_PACKAGE", "TOK_ENDPACKAGE", "TOK_PACKAGESEP", "TOK_INTERFACE",
  "TOK_ENDINTERFACE", "TOK_MODPORT", "TOK_VAR", "TOK_WILDCARD_CONNECT",
  "TOK_INPUT", "TOK_OUTPUT", "TOK_INOUT", "TOK_WIRE", "TOK_WAND",
  "TOK_WOR", "TOK_REG", "TOK_LOGIC", "TOK_INTEGER", "TOK_SIGNED",
  "TOK_ASSIGN", "TOK_ALWAYS", "TOK_INITIAL", "TOK_ALWAYS_FF",
  "TOK_ALWAYS_COMB", "TOK_ALWAYS_LATCH", "TOK_BEGIN", "TOK_END", "TOK_IF",
  "TOK_ELSE", "TOK_IFNONE", "TOK_FOR", "TOK_WHILE", "TOK_REPEAT",
  "TOK_DPI_FUNCTION", "TOK_POSEDGE", "TOK_NEGEDGE", "TOK_OR",
  "TOK_AUTOMATIC", "TOK_CASE", "TOK_CASEX", "TOK_CASEZ", "TOK_ENDCASE",
  "TOK_DEFAULT", "TOK_FUNCTION", "TOK_ENDFUNCTION", "TOK_TASK",
  "TOK_ENDTASK", "TOK_SPECIFY", "TOK_IGNORED_SPECIFY", "TOK_ENDSPECIFY",
  "TOK_SPECPARAM", "TOK_SPECIFY_AND", "TOK_IGNORED_SPECIFY_AND",
  "TOK_GENERATE", "TOK_ENDGENERATE", "TOK_GENVAR", "TOK_REAL",
  "TOK_SYNOPSYS_FULL_CASE", "TOK_SYNOPSYS_PARALLEL_CASE", "TOK_SUPPLY0",
  "TOK_SUPPLY1", "TOK_TO_SIGNED", "TOK_TO_UNSIGNED", "TOK_POS_INDEXED",
  "TOK_NEG_INDEXED", "TOK_PROPERTY", "TOK_ENUM", "TOK_TYPEDEF", "TOK_RAND",
  "TOK_CONST", "TOK_CHECKER", "TOK_ENDCHECKER", "TOK_EVENTUALLY",
  "TOK_INCREMENT", "TOK_DECREMENT", "TOK_UNIQUE", "TOK_UNIQUE0",
  "TOK_PRIORITY", "TOK_STRUCT", "TOK_PACKED", "TOK_UNSIGNED", "TOK_INT",
  "TOK_BYTE", "TOK_SHORTINT", "TOK_LONGINT", "TOK_VOID", "TOK_UNION",
  "TOK_BIT_OR_ASSIGN", "TOK_BIT_AND_ASSIGN", "TOK_BIT_XOR_ASSIGN",
  "TOK_ADD_ASSIGN", "TOK_SUB_ASSIGN", "TOK_DIV_ASSIGN", "TOK_MOD_ASSIGN",
  "TOK_MUL_ASSIGN", "TOK_SHL_ASSIGN", "TOK_SHR_ASSIGN", "TOK_SSHL_ASSIGN",
  "TOK_SSHR_ASSIGN", "TOK_BIND", "TOK_TIME_SCALE", "TOK_IMPORT", "'!'",
  "'#'", "'%'", "'&'", "'('", "')'", "'*'", "'+'", "','", "'-'", "'.'",
  "'/'", "':'", "';'", "'<'", "'='", "'>'", "'?'", "'@'", "'['", "']'",
  "'^'", "'_'", "'{'", "'|'", "'}'", "'~'", "'n'", "'p'", "'x'", "'z'",
  "OP_LOR", "OP_LAND", "OP_NOR", "OP_XNOR", "OP_NAND", "OP_EQ", "OP_NE",
  "OP_EQX", "OP_NEX", "OP_LE", "OP_GE", "OP_SHL", "OP_SHR", "OP_SSHL",
  "OP_SSHR", "OP_POW", "OP_CAST", "UNARY_OPS", "FAKE_THEN", "$accept",
  "input", "$@1", "design", "attr", "$@2", "attr_opt", "defattr", "$@3",
  "$@4", "opt_attr_list", "attr_list", "attr_assign", "hierarchical_id",
  "hierarchical_type_id", "module", "$@5", "$@6", "module_para_opt",
  "module_para_list", "single_module_para", "$@7", "$@8",
  "module_args_opt", "module_args", "optional_comma",
  "module_arg_opt_assignment", "module_arg", "$@9", "$@10", "$@11", "$@12",
  "package", "$@13", "$@14", "package_body", "package_body_stmt",
  "import_stmt", "$@15", "import_item_list", "import_item", "interface",
  "$@16", "$@17", "interface_body", "interface_body_stmt",
  "bind_directive", "$@18", "$@19", "$@20", "bind_target",
  "opt_bind_target_instance_list", "bind_target_instance_list",
  "bind_target_instance", "mintypmax_expr", "non_opt_delay", "delay",
  "io_wire_type", "$@21", "non_io_wire_type", "$@22", "wire_type",
  "wire_type_token_io", "wire_type_signedness", "wire_type_const_rand",
  "opt_wire_type_token", "wire_type_token", "net_type", "logic_type",
  "integer_atom_type", "integer_vector_type", "non_opt_range",
  "non_opt_multirange", "range", "range_or_multirange", "module_body",
  "module_body_stmt", "checker_decl", "$@23", "task_func_decl", "$@24",
  "$@25", "$@26", "$@27", "$@28", "$@29", "func_return_type",
  "opt_type_vec", "opt_signedness_default_signed",
  "opt_signedness_default_unsigned", "dpi_function_arg",
  "opt_dpi_function_args", "dpi_function_args", "opt_automatic",
  "task_func_args_opt", "$@30", "$@31", "task_func_args", "task_func_port",
  "$@32", "$@33", "task_func_body", "specify_block", "specify_item_list",
  "specify_item", "specify_opt_triple", "specify_if", "specify_condition",
  "specify_target", "specify_edge", "specify_rise_fall", "specify_triple",
  "ignored_specify_block", "ignored_specify_item_opt",
  "ignored_specify_item", "specparam_declaration", "specparam_range",
  "list_of_specparam_assignments", "specparam_assignment",
  "path_declaration", "simple_path_declaration",
  "state_dependent_path_declaration", "module_path_expression",
  "module_path_primary", "number", "path_delay_value",
  "list_of_path_delay_extra_expressions", "specify_edge_identifier",
  "parallel_path_description", "full_path_description",
  "list_of_path_inputs", "more_path_inputs", "list_of_path_outputs",
  "opt_polarity_operator", "specify_input_terminal_descriptor",
  "specify_output_terminal_descriptor", "system_timing_declaration",
  "system_timing_arg", "system_timing_args", "ignspec_constant_expression",
  "ignspec_expr", "ignspec_id", "$@34", "param_signed", "param_integer",
  "param_real", "param_range", "param_integer_type", "param_range_type",
  "param_implicit_type", "param_type", "param_decl", "$@35",
  "localparam_decl", "$@36", "param_decl_list", "single_param_decl",
  "single_param_decl_ident", "defparam_decl", "defparam_decl_list",
  "single_defparam_decl", "enum_type", "$@37", "enum_base_type",
  "type_atom", "type_vec", "type_signing", "enum_name_list",
  "enum_name_decl", "opt_enum_init", "enum_var_list", "enum_var",
  "enum_decl", "struct_decl", "$@38", "struct_type", "$@39",
  "struct_union", "struct_body", "opt_packed", "opt_signed_struct",
  "struct_member_list", "struct_member", "member_name_list", "member_name",
  "$@40", "struct_member_type", "$@41", "member_type_token", "$@42",
  "$@43", "member_type", "struct_var_list", "struct_var", "wire_decl",
  "$@44", "$@45", "$@46", "$@47", "opt_supply_wires", "wire_name_list",
  "wire_name_and_opt_assign", "wire_name", "assign_stmt",
  "assign_expr_list", "assign_expr", "type_name", "typedef_decl",
  "typedef_base_type", "enum_struct_type", "cell_stmt", "$@48", "$@49",
  "tok_prim_wrapper", "cell_list", "single_cell", "single_cell_no_array",
  "$@50", "single_cell_arraylist", "$@51", "cell_list_no_array",
  "prim_list", "single_prim", "$@52", "cell_parameter_list_opt",
  "cell_parameter_list", "cell_parameter", "cell_port_list",
  "cell_port_list_rules", "cell_port", "always_comb_or_latch",
  "always_or_always_ff", "always_stmt", "$@53", "$@54", "$@55", "$@56",
  "always_cond", "always_events", "always_event", "opt_label",
  "opt_sva_label", "opt_property", "modport_stmt", "$@57", "$@58",
  "modport_args_opt", "modport_args", "modport_arg", "modport_member",
  "modport_type_token", "assert", "assert_property",
  "simple_behavioral_stmt", "asgn_binop", "inc_or_dec_op",
  "for_initialization", "behavioral_stmt", "$@59", "$@60", "$@61", "$@62",
  "$@63", "$@64", "$@65", "$@66", "$@67", "$@68", "$@69", "$@70",
  "if_attr", "case_attr", "case_type", "opt_synopsys_attr",
  "behavioral_stmt_list", "optional_else", "$@71", "case_body",
  "case_item", "$@72", "$@73", "gen_case_body", "gen_case_item", "$@74",
  "$@75", "case_select", "case_expr_list", "rvalue", "lvalue",
  "lvalue_concat_list", "opt_arg_list", "arg_list", "arg_list2",
  "single_arg", "module_gen_body", "gen_stmt_or_module_body_stmt",
  "genvar_identifier", "genvar_initialization", "gen_stmt", "$@76", "$@77",
  "$@78", "$@79", "$@80", "gen_block", "$@81", "$@82", "gen_stmt_block",
  "$@83", "opt_gen_else", "expr", "basic_expr", "@84", "concat_list",
  "integral_number", YY_NULLPTR
    };
    return yy_sname[yysymbol];
  }



  // parser::context.
  parser::context::context (const parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

#if FRONTEND_VERILOG_YYDEBUG
    // Execute LAC once. We don't care if it is successful, we
    // only do it for the sake of debugging output.
    if (!yyparser_.yy_lac_established_)
      yyparser_.yy_lac_check_ (yyla_.kind ());
#endif

    for (int yyx = 0; yyx < YYNTOKENS; ++yyx)
      {
        symbol_kind_type yysym = YY_CAST (symbol_kind_type, yyx);
        if (yysym != symbol_kind::S_YYerror
            && yysym != symbol_kind::S_YYUNDEF
            && yyparser_.yy_lac_check_ (yysym))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
      }
    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }




  bool
  parser::yy_lac_check_ (symbol_kind_type yytoken) const
  {
    // Logically, the yylac_stack's lifetime is confined to this function.
    // Clear it, to get rid of potential left-overs from previous call.
    yylac_stack_.clear ();
    // Reduce until we encounter a shift and thereby accept the token.
#if FRONTEND_VERILOG_YYDEBUG
    YYCDEBUG << "LAC: checking lookahead " << symbol_name (yytoken) << ':';
#endif
    std::ptrdiff_t lac_top = 0;
    while (true)
      {
        state_type top_state = (yylac_stack_.empty ()
                                ? yystack_[lac_top].state
                                : yylac_stack_.back ());
        int yyrule = yypact_[+top_state];
        if (yy_pact_value_is_default_ (yyrule)
            || (yyrule += yytoken) < 0 || yylast_ < yyrule
            || yycheck_[yyrule] != yytoken)
          {
            // Use the default action.
            yyrule = yydefact_[+top_state];
            if (yyrule == 0)
              {
                YYCDEBUG << " Err\n";
                return false;
              }
          }
        else
          {
            // Use the action from yytable.
            yyrule = yytable_[yyrule];
            if (yy_table_value_is_error_ (yyrule))
              {
                YYCDEBUG << " Err\n";
                return false;
              }
            if (0 < yyrule)
              {
                YYCDEBUG << " S" << yyrule << '\n';
                return true;
              }
            yyrule = -yyrule;
          }
        // By now we know we have to simulate a reduce.
        YYCDEBUG << " R" << yyrule - 1;
        // Pop the corresponding number of values from the stack.
        {
          std::ptrdiff_t yylen = yyr2_[yyrule];
          // First pop from the LAC stack as many tokens as possible.
          std::ptrdiff_t lac_size = std::ptrdiff_t (yylac_stack_.size ());
          if (yylen < lac_size)
            {
              yylac_stack_.resize (std::size_t (lac_size - yylen));
              yylen = 0;
            }
          else if (lac_size)
            {
              yylac_stack_.clear ();
              yylen -= lac_size;
            }
          // Only afterwards look at the main stack.
          // We simulate popping elements by incrementing lac_top.
          lac_top += yylen;
        }
        // Keep top_state in sync with the updated stack.
        top_state = (yylac_stack_.empty ()
                     ? yystack_[lac_top].state
                     : yylac_stack_.back ());
        // Push the resulting state of the reduction.
        state_type state = yy_lr_goto_state_ (top_state, yyr1_[yyrule]);
        YYCDEBUG << " G" << int (state);
        yylac_stack_.push_back (state);
      }
  }

  // Establish the initial context if no initial context currently exists.
  bool
  parser::yy_lac_establish_ (symbol_kind_type yytoken)
  {
    /* Establish the initial context for the current lookahead if no initial
       context is currently established.

       We define a context as a snapshot of the parser stacks.  We define
       the initial context for a lookahead as the context in which the
       parser initially examines that lookahead in order to select a
       syntactic action.  Thus, if the lookahead eventually proves
       syntactically unacceptable (possibly in a later context reached via a
       series of reductions), the initial context can be used to determine
       the exact set of tokens that would be syntactically acceptable in the
       lookahead's place.  Moreover, it is the context after which any
       further semantic actions would be erroneous because they would be
       determined by a syntactically unacceptable token.

       yy_lac_establish_ should be invoked when a reduction is about to be
       performed in an inconsistent state (which, for the purposes of LAC,
       includes consistent states that don't know they're consistent because
       their default reductions have been disabled).

       For parse.lac=full, the implementation of yy_lac_establish_ is as
       follows.  If no initial context is currently established for the
       current lookahead, then check if that lookahead can eventually be
       shifted if syntactic actions continue from the current context.  */
    if (yy_lac_established_)
      return true;
    else
      {
#if FRONTEND_VERILOG_YYDEBUG
        YYCDEBUG << "LAC: initial context established for "
                 << symbol_name (yytoken) << '\n';
#endif
        yy_lac_established_ = true;
        return yy_lac_check_ (yytoken);
      }
  }

  // Discard any previous initial lookahead context.
  void
  parser::yy_lac_discard_ (const char* event)
  {
   /* Discard any previous initial lookahead context because of Event,
      which may be a lookahead change or an invalidation of the currently
      established initial context for the current lookahead.

      The most common example of a lookahead change is a shift.  An example
      of both cases is syntax error recovery.  That is, a syntax error
      occurs when the lookahead is syntactically erroneous for the
      currently established initial context, so error recovery manipulates
      the parser stacks to try to find a new initial context in which the
      current lookahead is syntactically acceptable.  If it fails to find
      such a context, it discards the lookahead.  */
    if (yy_lac_established_)
      {
        YYCDEBUG << "LAC: initial context discarded due to "
                 << event << '\n';
        yy_lac_established_ = false;
      }
  }


  int
  parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
         In the first two cases, it might appear that the current syntax
         error should have been detected in the previous state when
         yy_lac_check was invoked.  However, at that time, there might
         have been a different syntax error that discarded a different
         initial context during error recovery, leaving behind the
         current lookahead.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short parser::yypact_ninf_ = -1170;

  const short parser::yytable_ninf_ = -625;

  const short
  parser::yypact_[] =
  {
   -1170,   128,   186, -1170, -1170, -1170,   958, -1170,   122, -1170,
     686, -1170,   186,   186,   186,   186,   186,   186,   186,   186,
     186,   186,   231,   242, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170,   141, -1170,    36,    52,
   -1170, -1170, -1170,    98,   113,   231,   244, -1170, -1170, -1170,
   -1170,   291,   246,   246,   263, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170,   194, -1170,   137,
   -1170,   417,   191, -1170, -1170, -1170, -1170, -1170, -1170,   248,
    2933,    98,    98, -1170,   113, -1170, -1170,   195,    66, -1170,
     202,   217,   367,   689,   689,   428,    43, -1170,  1118,   439,
     231,   421,   231,   460,   492,  2933,   375, -1170, -1170, -1170,
     382,   187,   187, -1170,   208, -1170,   398, -1170,   527, -1170,
     544, -1170,   393, -1170, -1170, -1170, -1170,   436, -1170, -1170,
    2993, -1170, -1170, -1170,  2933, -1170, -1170, -1170, -1170, -1170,
     151,   494, -1170,   320,   238,  3731, -1170, -1170, -1170,    98,
   -1170,   604,   231, -1170,   515,   634, -1170, -1170, -1170, -1170,
   -1170,    98,   278, -1170, -1170, -1170, -1170,   673, -1170,   278,
     673, -1170, -1170,   677,   706, -1170, -1170,   708, -1170,    36,
     711,    52, -1170,   695, -1170, -1170, -1170, -1170, -1170,   583,
     589,   722, -1170, -1170, -1170,    98, -1170, -1170, -1170, -1170,
     729, -1170,   608,   611,   618,   619,  3341,  3341,   191,  1503,
    3341,  3341,  3341,   102,   612,  3341,  3341,  3341,  3341,  3341,
    2933, -1170,    98, -1170, -1170,   632,   231, -1170,  2933,  2933,
    2933, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,   635,
     628, -1170,   637, -1170, -1170, -1170,   326, -1170,   375, -1170,
   -1170, -1170, -1170, -1170,   358, -1170,   627,    98,   373,   633,
     644,   650,   783, -1170, -1170, -1170,    98,   662, -1170,    64,
      41,   668,   660,   682, -1170, -1170,   658, -1170,   823,  1129,
   -1170,  2933,  2933,  2933,  2933, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
     415,  2933,  2933,  2933, -1170, -1170, -1170,  2933,  2933, -1170,
   -1170, -1170, -1170, -1170, -1170,   347,   688,  2933,    40, -1170,
     680,   691,   705,  3341,  3341,  3341,  3341,  3341,  3341,  3341,
    3341,  2933,  3341,  3341,  3341,  3341,  3341,  3341,  3341,  3341,
    3341,  3341,  3341,  3341,  3341,  3341,  3341,  3341,  3341,  3341,
    2933, -1170,   727,   231,   634, -1170,   589,   673, -1170,  2933,
   -1170, -1170, -1170,   856,   718,   859, -1170,   662,   662, -1170,
     728,   723,   444,   131, -1170, -1170,   862, -1170,   730,   667,
     731, -1170, -1170,  3341, -1170,   722,   712, -1170, -1170, -1170,
     374, -1170, -1170,   187,   187, -1170,   190,    98,   736,   738,
     739,   741, -1170,   735,   743,   754,   752, -1170,   742,   758,
    2933,   759, -1170, -1170, -1170,   280,  1769,   280,   368,   368,
     280,  1271,  1271,   765,  1254,  3915,  3823,  3869,  3915,  1254,
    1769,  2010,  2010,  2010,  2010,  1271,  1271,   607,   607,   607,
     607,   732,   766,   774,   897, -1170, -1170,   767, -1170, -1170,
      53,   909, -1170,   305, -1170,   911,   644,   776,   777, -1170,
     914, -1170, -1170, -1170, -1170,    64,   778,   919,   790, -1170,
     724, -1170,   406,    98,    60,   796,   641,  3777, -1170, -1170,
      98,   823, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170,  2933, -1170, -1170,   782,   231,   794, -1170, -1170, -1170,
   -1170,  2933, -1170,  1949, -1170, -1170,   400, -1170,   798,   481,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170,   856, -1170,   795,
   -1170, -1170,   667,   805, -1170,   941,   359,   689,   689, -1170,
    2933, -1170, -1170, -1170, -1170, -1170, -1170,   406,   848, -1170,
    1015,   943, -1170, -1170,    98, -1170,   944,   818,  1069, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170,   248,   815, -1170, -1170,  2933,   816, -1170,   950,   350,
   -1170, -1170,   821,   897, -1170,  3492,   954, -1170, -1170,   644,
   -1170,   419,   629,    98,    48, -1170,    98, -1170,   817, -1170,
     169,  1256, -1170,   675, -1170, -1170, -1170, -1170,   801, -1170,
     822, -1170,   903,   714,   673,   673, -1170,   778,  1015, -1170,
    1241, -1170, -1170, -1170, -1170, -1170, -1170, -1170,   279,  1167,
   -1170, -1170, -1170,   231,   420, -1170, -1170, -1170,    25, -1170,
   -1170, -1170, -1170, -1170,   961,   963,    98, -1170, -1170, -1170,
   -1170, -1170, -1170,   827, -1170,  1949, -1170, -1170, -1170,   798,
   -1170,   833,   835, -1170, -1170, -1170,    67,   193,    37, -1170,
     967, -1170,  3774, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170,   970, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170,   819, -1170,   842, -1170, -1170, -1170,   834, -1170,
   -1170, -1170, -1170,   843, -1170, -1170, -1170, -1170, -1170, -1170,
    2063, -1170, -1170,   845,   846,   849,   927,   929,   930, -1170,
    2933,   188, -1170, -1170,  1247, -1170,   114,   114,   114,    47,
   -1170,   864,   865, -1170, -1170, -1170,   279, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170,   778,   855,    98, -1170,   870,   422,
   -1170,   860,   675, -1170, -1170, -1170,   675,   840,  2123, -1170,
    1570,   871,   869, -1170,   874, -1170,   798,  2933, -1170,   885,
     887,   945,    67,   890, -1170,   892,   893, -1170,   286,   290,
   -1170, -1170, -1170,   895,   899,   900,   901, -1170,   906,  2933,
    1041,   424, -1170,   916,  3609,   920, -1170, -1170, -1170, -1170,
     818, -1170,   430, -1170,   969,   972,   973,   980,  2933, -1170,
     941, -1170,   939,   384,   912,   874,   798, -1170,  2933,  2933,
     924,   942,   874,    25,   818,   818,   320,   818, -1170, -1170,
     947,   948,   949, -1170,   952,  2933,  2933, -1170, -1170,  2933,
   -1170,    81, -1170,    25, -1170,  2933, -1170, -1170, -1170,   818,
   -1170,   218, -1170, -1170,   959, -1170,  1081, -1170, -1170, -1170,
    2933,   946, -1170,   974,   111,   562,  2933, -1170, -1170,   562,
      98,   154, -1170, -1170, -1170,  1041,   951,   654, -1170, -1170,
   -1170, -1170, -1170,  3107,  3107,  1684,   968, -1170,   466,  1041,
   -1170,  2933, -1170,   854, -1170, -1170, -1170, -1170, -1170,   727,
    1090, -1170,   970, -1170,   977,   978,   979,   981,   987, -1170,
   -1170, -1170,  2933,  2933,   985, -1170,  1120,   995,   998, -1170,
    2933,   993, -1170,  2933,  2933, -1170,  2933,  2237,  2297,  2411,
    2471,  1002,  1003, -1170, -1170, -1170, -1170, -1170,  1001, -1170,
   -1170,  1137,  1004, -1170, -1170,   467,   476,   941,  1006,  1500,
   -1170,   675, -1170,  1011, -1170,   794, -1170, -1170, -1170, -1170,
    1143,  1005,  1008, -1170, -1170,  2933,  1017,  2933, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
     721, -1170, -1170, -1170,  1018,   394,  1007, -1170,  1041, -1170,
     670,  1010,  2993, -1170,  1022,  1023, -1170,  1041,  1041, -1170,
     317, -1170,  2933, -1170, -1170, -1170, -1170, -1170,  1161, -1170,
     479, -1170,  1161, -1170,  2585,  2645,  2759,  2933, -1170,   431,
    1026, -1170, -1170,  1024,    98,  1027, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170,  2933,  1040,  2933,  1044,  2933,  1048,  1033,
    1050, -1170, -1170,   296,  1052, -1170, -1170,  1186, -1170, -1170,
    1056, -1170,  1051, -1170, -1170,  2933,  2933,  1063,    87, -1170,
   -1170, -1170,  2819,  1065,  3664,  1149,  1058,  2933,  2933,  1126,
   -1170,  1198,   716,   716,   716,   716,   716,   716,   716,   716,
   -1170,   893, -1170, -1170, -1170, -1170, -1170, -1170, -1170,  1062,
    1068, -1170,  1041, -1170,  1041, -1170,  1070,  1022,  1882,  2933,
   -1170,  2933, -1170, -1170,  1684,  1066,  1684,  1067,  3516,    98,
     488, -1170, -1170, -1170,  1090, -1170, -1170,   511, -1170,  1085,
    2933,  1086,  2933,  1087,  2933,  1088,  1089, -1170, -1170,  2933,
    2933,   646,  2933,  1217,  2933,   675,   675,  1091,  1093,  1097,
    1094,  1098,  1099, -1170,  1101,   675, -1170, -1170, -1170, -1170,
     941,  1102,  2933, -1170, -1170, -1170,  1765, -1170,  1765, -1170,
    1111, -1170,   798, -1170,  1178,  3739,  2933, -1170, -1170,  2933,
    1112,  3167, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
     154, -1170,   154,   154,   154,   154,   154,   154,   154,  1122,
    1123,   503, -1170, -1170, -1170,  1041,  1125,  2933,  1022,  1119,
   -1170, -1170, -1170, -1170, -1170, -1170,  1161, -1170, -1170,  1161,
   -1170, -1170,  1127,  1121,  1131,  1128,  1134,  1138,  1144,  1201,
    1139, -1170,   798, -1170, -1170,  1135, -1170, -1170, -1170,  1145,
   -1170,  1146, -1170,  1148, -1170, -1170, -1170,   580, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170,  1149, -1170, -1170, -1170,  1153,
   -1170,   562,  2993,  1157, -1170,   529,   251,   623,   762,   661,
     251, -1170, -1170,  1041,  1041, -1170,  1041,  1162, -1170,  1130,
   -1170,  2933,  1164, -1170, -1170,  1165,  1159, -1170,  1160, -1170,
    1163, -1170, -1170, -1170, -1170,  1879, -1170, -1170,  2933,  1169,
   -1170, -1170, -1170,  1248, -1170, -1170,  1236, -1170, -1170,  2933,
    1434,  1168,    -3,   232, -1170, -1170,  2933, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170,    82, -1170,   240, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170,  1879,    45,  1172,  1126,  2933,  2933,
    2933,  3281,  2933,  1166,  2933,  1176,   815,  1184,  1149,  2933,
   -1170,  1185,   675, -1170,  1149,  1183,  1190,  1199,   237,  2993,
    1195, -1170,  1197,  1219,  2933,  1220,  2933, -1170, -1170, -1170,
   -1170, -1170,   675, -1170,  2933, -1170, -1170, -1170,  1218,  2238,
   -1170,  2933,  1239,  1242,  1243,  1244,   675, -1170,  1238,  2933,
    2933,  1240, -1170,  1245, -1170,  1249, -1170,  2933,  1250,   521,
    1246,  2933, -1170, -1170, -1170,  1251, -1170,  2933,  2933, -1170,
   -1170,   532,   815, -1170,  2933,  1258,  2933,  1259,  2933,   543,
   -1170,  2933,  1263,  2933,  1264,  2933,  1266,  2933,  1267,  2933,
    1268,  2933,  1276, -1170
  };

  const short
  parser::yydefact_[] =
  {
       2,     0,    15,     1,    19,    79,     0,    93,     0,     3,
       0,    18,    15,    15,    15,    15,    15,    15,    15,    15,
      15,    15,    23,     0,    31,    32,   153,   152,   147,   368,
     392,   148,   151,   149,   150,   393,     0,   441,   209,   212,
     444,   445,   390,   161,     0,     0,     0,    34,   355,   357,
      64,     0,   224,   224,    16,     5,     4,    10,    11,    12,
      13,     6,     7,     8,     9,    28,    20,    22,    24,    26,
      80,   372,     0,   210,   211,   443,   213,   214,   442,   396,
       0,   160,   163,   162,     0,   437,   438,     0,   102,    94,
      99,    74,     0,   342,   342,     0,     0,   223,   206,     0,
      23,     0,     0,     0,     0,     0,    38,   374,   375,   373,
       0,   378,   378,    33,   399,   391,     0,   678,   731,   677,
       0,   732,     0,    15,    15,   559,   560,     0,    15,    15,
       0,    15,    15,    15,     0,    15,    15,    15,    15,    15,
     161,     0,    15,   673,     0,   669,   676,   158,   159,   161,
     440,     0,     0,    97,     0,     0,    35,   340,   344,   341,
     354,   161,   342,   351,   350,   352,   353,     0,   343,   342,
       0,    65,   190,     0,     0,   207,   208,     0,   202,   209,
       0,   212,   196,     0,    21,    25,    29,    30,    27,     0,
      48,     0,   376,   377,   370,   161,   397,   398,   395,   407,
       0,   733,     0,     0,     0,     0,     0,     0,    31,     0,
       0,     0,     0,   729,     0,     0,     0,     0,     0,     0,
       0,   679,   630,   629,   675,     0,     0,   672,     0,     0,
       0,   157,    15,    15,    15,    15,    15,    15,    15,    15,
      15,    15,    15,    15,    15,    15,    15,    15,    15,    15,
      15,    15,    15,    15,    15,    15,    15,    15,    15,     0,
       0,    95,    98,   100,    73,    78,     0,    76,    38,   160,
     345,   349,   346,   363,     0,   359,   362,   347,     0,     0,
     218,     0,     0,   198,   205,   200,   203,   226,    17,    15,
      15,     0,   383,    53,   379,   371,   407,   400,     0,   410,
     734,     0,     0,     0,     0,   673,   722,   694,   547,   548,
     549,   550,   551,   552,   553,   554,   555,   556,   557,   558,
     683,     0,     0,     0,   718,   719,   698,     0,     0,   685,
     696,   687,   697,   699,   695,     0,     0,     0,   161,   671,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   439,   468,     0,     0,    75,    48,     0,   356,     0,
     348,   358,    68,   222,     0,     0,   192,   226,   226,   204,
     227,     0,     0,     0,    39,    46,    56,    47,     0,   117,
      53,    50,    83,     0,   381,    52,     0,   394,   401,   405,
       0,   403,   415,   378,   378,   408,     0,   161,     0,     0,
       0,     0,   674,     0,     0,     0,   729,   730,     0,   157,
     638,     0,   155,   156,   154,   716,   688,   714,   712,   713,
     715,   704,   711,     0,   692,   690,   721,   720,   691,   693,
     689,   706,   707,   708,   709,   705,   710,   700,   701,   702,
     703,   717,     0,     0,     0,   101,    77,     0,   360,   361,
      15,   216,   221,     0,   191,     0,   218,     0,     0,   225,
      15,   237,    42,    44,    37,    15,    55,     0,     0,   119,
       0,   120,   130,   161,    15,     0,    15,   382,   380,   369,
     161,     0,   402,   413,   414,   411,   409,   723,   681,   682,
     724,     0,   727,   728,     0,     0,    53,   637,   639,   641,
     726,     0,   725,   471,   456,   460,     0,   168,   508,     0,
      67,    72,    71,    70,    69,   215,   217,   220,   194,     0,
     237,   237,   117,    53,   230,     0,    15,   342,   342,    40,
       0,    57,    59,    63,   121,   122,   123,   130,   129,   128,
       0,     0,    51,    49,   161,    81,     0,   114,   117,    82,
      92,    84,    85,    87,    88,    90,    86,    89,    91,   406,
     404,   396,     0,   686,   628,    52,     0,   670,     0,     0,
     469,   472,     0,     0,    96,    15,     0,    66,   219,   218,
     193,    15,    15,   161,    15,   228,   161,   235,     0,   197,
       0,   117,   564,    15,   567,   568,   566,   569,     0,   565,
       0,   236,     0,     0,     0,     0,    54,    55,   132,   127,
     137,   143,   142,   141,   135,   144,   140,   146,   126,   133,
     139,   145,    61,     0,     0,   365,   514,   113,     0,   486,
     493,   487,   484,   485,     0,     0,   161,   491,   488,   412,
     684,   640,   680,     0,   467,   471,    15,   461,   659,   508,
     661,     0,     0,   601,   602,   603,   240,     0,     0,   644,
       0,   167,   117,   184,   181,   164,   186,   169,   170,   187,
     175,   171,   172,   174,     0,   179,   180,   176,   177,   173,
     178,   182,     0,   185,     0,   165,   166,   507,     0,   199,
     201,   232,   231,     0,   432,   509,   105,   106,   107,   108,
       0,   575,   577,     0,     0,     0,   600,   598,   599,   572,
       0,   161,    15,   631,    15,   570,   513,   513,   513,   513,
     571,     0,     0,    43,    45,    60,   126,   131,   136,   138,
     124,   125,   118,   134,    55,     0,   161,   364,     0,     0,
     434,     0,    15,   422,   424,   419,    15,   500,     0,   470,
     478,     0,   475,   476,   636,    36,   508,     0,   652,     0,
       0,     0,   240,     0,   338,     0,     0,   264,     0,     0,
     266,   267,   268,     0,     0,     0,     0,   269,     0,     0,
       0,     0,   273,     0,    15,     0,   446,   450,   451,   388,
     114,   386,     0,   384,     0,     0,     0,     0,     0,   195,
       0,   229,     0,     0,   103,   636,   508,   580,     0,     0,
       0,   633,   636,     0,   114,   114,     0,   114,   512,   511,
       0,     0,     0,   532,     0,     0,     0,   116,    62,     0,
     366,     0,   515,     0,   433,     0,   494,   426,   426,   114,
     492,     0,   489,   473,     0,   483,     0,   479,   457,    15,
     638,     0,   662,     0,     0,   255,     0,   238,   239,   255,
     161,     0,   281,   309,   310,     0,     0,   325,   326,   263,
     265,   276,   277,     0,     0,     0,     0,   335,     0,     0,
     270,     0,   183,   117,   646,   642,   645,   643,   188,   468,
       0,   448,     0,   387,     0,     0,     0,     0,     0,   233,
     109,   110,     0,     0,     0,   578,   117,     0,     0,   632,
       0,     0,   544,     0,     0,   543,     0,     0,     0,     0,
       0,     0,     0,   367,   523,   524,   525,   517,    53,   519,
     522,     0,     0,   435,   436,     0,     0,     0,     0,     0,
     499,    15,   474,   482,   477,    53,   660,   644,   655,   648,
       0,     0,     0,   253,   254,     0,     0,     0,   339,   301,
     300,   303,    15,    15,    15,    15,    15,    15,    15,    15,
       0,   282,   299,   302,     0,   325,     0,   323,     0,   324,
     325,   317,     0,   278,   305,   336,   279,     0,     0,   332,
       0,   331,     0,   271,   274,   275,   647,   168,     0,   418,
       0,   416,   465,   385,     0,     0,     0,     0,   657,     0,
       0,   576,   608,     0,   161,     0,   584,   586,   634,   574,
     542,   545,   546,     0,     0,     0,     0,     0,     0,     0,
       0,   588,   591,    52,     0,   521,   516,     0,   423,   425,
     420,   428,   430,   497,   498,     0,     0,     0,     0,   501,
     506,   490,     0,     0,    15,   664,   649,     0,     0,   248,
     245,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      15,     0,    15,    15,    15,    15,    15,    15,    15,     0,
       0,   317,     0,   319,     0,   318,     0,     0,   336,     0,
     306,     0,   329,   330,     0,     0,     0,     0,    15,   456,
       0,   452,   454,   455,     0,   389,   464,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   618,   111,     0,
       0,    15,     0,     0,     0,    15,    15,     0,     0,     0,
       0,     0,     0,   531,     0,    15,   606,   520,   518,   427,
       0,     0,     0,   504,   505,   496,     0,   495,     0,   481,
       0,   635,   508,   666,   668,    15,     0,   651,   653,     0,
       0,     0,   283,   285,   289,   287,   284,   288,   290,   286,
       0,   280,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,   327,   320,     0,     0,     0,   307,     0,
     333,   328,   334,   272,   189,   458,     0,   447,   417,   465,
     449,    15,     0,     0,     0,     0,     0,     0,     0,   619,
       0,   104,   508,   607,   561,   562,   581,   585,   587,     0,
     526,     0,   527,     0,   533,   530,   589,   613,   429,   421,
     431,   502,   503,   480,   663,   664,   656,   665,   650,     0,
     247,   255,     0,     0,   249,   295,   297,   296,   294,   293,
     298,   291,   292,     0,     0,   314,     0,     0,   304,     0,
     308,     0,     0,   453,   463,     0,     0,   535,     0,   536,
       0,   540,   539,   658,   617,     0,   112,   579,     0,     0,
     528,   529,   534,   611,   604,   605,   614,   667,    15,     0,
       0,     0,   325,   325,   322,   311,     0,   337,    15,   466,
     537,   538,   541,   625,   623,   620,     0,   626,   563,    15,
     609,   590,   592,   612,     0,     0,     0,   248,     0,     0,
       0,     0,     0,     0,     0,     0,   337,     0,   664,     0,
     622,     0,    15,   615,   664,     0,     0,     0,     0,     0,
       0,   256,   261,     0,     0,     0,     0,   459,   621,   627,
     582,   610,    15,   654,     0,   252,   251,   250,     0,   261,
     241,     0,     0,     0,     0,     0,    15,   616,   244,     0,
       0,     0,   316,     0,   313,     0,   583,     0,     0,     0,
       0,     0,   315,   312,   243,     0,   257,     0,     0,   262,
     242,     0,   262,   258,     0,     0,     0,     0,     0,     0,
     259,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   260
  };

  const short
  parser::yypgoto_[] =
  {
   -1170, -1170, -1170,  1448,   355, -1170, -1170,   103, -1170, -1170,
    1294, -1170,  1298,    11,   -71, -1170, -1170, -1170,  1156, -1170,
     940, -1170, -1170,  1095, -1170,  -390,  -551,   932, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
    1053, -1170, -1170, -1170, -1170, -1170,  -492, -1170, -1170, -1170,
   -1170, -1170, -1170,  -123,  -884,  -550,  -196, -1170, -1170,   517,
   -1170,  -347, -1170,   698,   889, -1170,   844, -1170,  -498,     4,
   -1170,   -61,  -112,   -60,  -147,   453,  -586, -1170, -1170,  -457,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,  1295,  1296,
     938,  -397, -1170,  1423,   322, -1170, -1170, -1170,   875, -1170,
   -1170,   200, -1170,   696, -1170, -1170, -1170,   143, -1170,  -867,
   -1170,  -219, -1170, -1170,   692,  -581, -1170,   683,   593, -1170,
    -771, -1170,  -170,   -41, -1170,   588,  -976, -1170, -1170, -1170,
     626, -1170,   239,  -981,  -825,  -951, -1170, -1004, -1170,   505,
    -713,  -646, -1170,   265, -1170, -1170, -1170, -1170, -1170, -1170,
     -86,    28, -1170,    51, -1170,  1348,  -271, -1170,  1030, -1170,
     763,  1514, -1170, -1170,   -47,   -37,   -96, -1170,  1117, -1170,
   -1170,   615, -1170, -1170, -1170,  1522, -1170,  1113,   953, -1170,
   -1170, -1170,  1235, -1170,  1032, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170,   411,  -491, -1170, -1170, -1170, -1170,   681,
   -1170,   378,  -519,  1045, -1170,   687,  1458,    71,  1537, -1170,
   -1170, -1170, -1170, -1170, -1170,  -982,  -403, -1170, -1170, -1170,
   -1170, -1170,   327, -1170,   636, -1170,   882, -1114, -1170,   679,
   -1170, -1170,  1054, -1170, -1170, -1170, -1170, -1170, -1170,  -990,
    -662,  -589,   124, -1170, -1170, -1170, -1170, -1170,   496,   600,
   -1170, -1170, -1170, -1169,   824,  -142, -1170,  -610, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170,   936, -1170, -1170, -1170, -1170, -1170, -1170, -1170,
   -1170, -1170, -1170, -1170, -1170,   219, -1170,    57,  -613,   622,
    -368,   702, -1170,   990,   610,   403,   609, -1170,  -584, -1170,
   -1170, -1170, -1170, -1170,  -558, -1170, -1170, -1057, -1170, -1170,
     -80,  1141, -1170,   433,   -82
  };

  const short
  parser::yydefgoto_[] =
  {
       0,     1,     2,     9,   611,    11,    54,   612,    22,   101,
      66,    67,    68,   140,    37,    13,    92,   268,   190,   393,
     394,   547,   548,   291,   400,   406,   551,   401,   486,   487,
     627,   754,    14,    95,   279,   470,   530,    15,   155,   266,
     267,    16,    23,   106,   496,   569,    17,    45,   151,   372,
      89,   153,   262,    90,   823,   613,   648,   489,   490,   491,
     492,   656,   557,   752,   560,   746,   638,   639,   640,    38,
      39,    81,    82,    83,    84,   595,   904,   686,  1017,    18,
     280,   476,   599,   287,   387,   388,   180,   181,    75,    78,
     472,   384,   473,    98,   391,   480,   713,   543,   544,   820,
     545,   546,   688,   781,   782,  1398,   783,  1180,  1263,   975,
    1360,  1361,   689,   789,   790,   690,   800,   801,   802,   792,
     793,   794,   990,   991,   992,  1003,  1110,   885,   795,   796,
     886,  1000,  1201,  1001,   887,  1202,   797,  1009,  1010,   896,
    1011,  1203,   880,   161,   162,   163,   271,   164,   165,   166,
     167,   614,    93,   615,    94,   274,   275,   276,   693,   644,
     645,   694,    71,   110,   168,   169,   194,   293,   294,   404,
     812,   813,   695,   696,   910,   809,    79,    42,   115,   116,
     198,   296,   297,   410,   411,   500,   298,   299,   415,   416,
     581,   417,  1020,  1021,   616,   859,  1161,   857,   858,   955,
    1060,  1061,  1062,   698,   759,   760,    87,   617,   141,    44,
     700,   909,  1022,   810,  1120,  1126,  1122,   592,  1123,  1282,
     526,  1127,  1128,  1129,   464,   589,   590,   771,   772,   773,
     657,   658,   701,   767,   961,   766,   762,   862,  1068,  1069,
     597,   618,   840,   578,   758,   952,   852,   948,   949,   950,
     951,   619,   703,   620,   323,   142,  1035,   621,   832,   825,
     826,  1032,   926,  1299,  1386,  1145,  1146,  1155,  1303,  1156,
     622,   623,   704,  1247,  1141,  1331,  1352,  1306,  1333,  1334,
    1372,  1229,  1294,  1295,  1348,  1325,  1326,   143,   734,   830,
     871,   516,   517,   518,   804,   905,   971,   972,   906,   874,
    1259,  1075,  1137,   774,  1173,   776,   967,  1174,  1175,  1256,
    1362,   145,   336,   214,   146
  };

  const short
  parser::yytable_[] =
  {
     144,   227,   260,   735,   570,   574,   702,   775,   170,   685,
     495,   705,   977,   531,  1101,   882,   195,   647,   395,  1105,
     147,   148,   160,   160,   111,   188,   607,   178,   222,   263,
      19,   798,   803,    69,   112,   761,  1121,   706,  1029,    65,
      19,    19,    19,    19,    19,    19,    19,    19,    19,    19,
     209,   784,   493,    20,   213,   396,    88,   172,   224,    65,
     995,   525,  -234,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    21,   396,   109,   745,   838,   273,   539,
     223,   779,   103,    21,    21,    21,    21,    21,    21,    21,
      21,    21,    21,    73,   528,   944,   791,   109,   109,  1342,
     269,   270,   179,   684,   697,    12,   468,  1285,   103,    76,
    1210,    69,  1212,    69,   872,    12,    12,    12,    12,    12,
      12,    12,    12,    12,    12,   969,   586,    85,     3,   945,
     946,  1206,   749,   780,   269,   295,    46,    86,   687,  1336,
     335,   753,   888,   798,   838,   997,  1276,   999,   340,   341,
     342,   839,   856,   605,   803,    74,   860,   125,   126,     6,
    1351,   148,  1166,    88,   925,    72,   118,   979,   980,   118,
     981,    77,   120,  1103,   121,   120,  1251,   121,  1252,   103,
    1004,  1004,   -15,   716,   717,   718,   -14,   397,  1015,   730,
     667,   104,   398,   103,   -52,   603,   173,   799,  1307,   174,
     220,   843,   708,   848,  1347,   970,   -52,   784,   791,   730,
     -41,   398,  -246,   -41,   395,   702,   380,   104,   839,     4,
     932,   418,   419,   420,   421,   389,   222,   947,   412,     5,
     103,  -624,  1280,  1167,  1283,  -624,  1168,   338,   422,   888,
     761,   423,   424,   425,   192,    65,   907,   426,   426,   958,
     465,   327,   413,   803,  1277,  1230,    70,   431,    80,   785,
     647,   786,   414,   305,   305,   196,   328,   305,   305,   305,
     506,   443,   305,   305,   305,   305,   305,   484,   223,  1204,
     485,   787,   678,   339,   647,   647,    91,   647,   104,  1107,
     462,  1368,     6,   105,   100,   982,   -15,  1373,   983,   469,
     784,   919,   104,   109,   784,    96,   193,    30,   719,   647,
     944,   220,   684,   697,   720,    35,   984,   503,   504,   985,
    1191,   986,    97,  1313,     7,  1314,     8,   197,   987,   988,
     989,  1343,  1345,  -573,  1344,   157,   750,   113,   788,   104,
     228,   229,  -573,   102,   945,   946,   561,   687,   220,   150,
     519,  1071,   888,   743,   744,   152,   785,    10,   786,   883,
     884,  1112,  1113,   959,   154,   960,   114,    10,    10,    10,
      10,    10,    10,    10,    10,    10,    10,   608,   889,   678,
     997,   156,   999,  1377,    88,  -510,  -510,  -510,  -510,  1349,
     511,   230,     4,  1350,  1309,  1090,  1208,   159,   751,   231,
     305,   305,   305,   305,   305,   305,   305,   305,  1114,   305,
     305,   305,   305,   305,   305,   305,   305,   305,   305,   305,
     305,   305,   305,   305,   305,   305,   305,   272,  1097,  1098,
     118,   582,   125,   126,   277,   788,   120,   608,   121,   269,
     579,   587,   171,   591,   609,  -510,  -510,  -510,  -510,   228,
     229,   536,     4,   182,   537,   184,   711,   924,   888,   714,
     305,   624,   625,  1115,   931,     6,  1116,   258,   259,   732,
     626,   107,   108,    28,   186,   374,   160,   160,   203,   204,
     375,   482,   483,   206,   207,   702,   210,   211,   212,   637,
     215,   216,   217,   218,   219,   221,   664,   226,   532,   665,
     230,   610,   709,   269,   643,   519,   187,   377,   429,   765,
    1254,   232,   378,   558,   559,   234,   907,   189,    48,    49,
     237,   533,   377,   501,   571,     6,   338,   381,   502,   702,
     921,  1233,   685,   922,   705,  1237,  1238,    31,    32,    33,
      34,   534,   997,   998,   999,  1246,   191,   572,   200,   593,
    1100,   109,   109,    51,   594,   258,   259,   637,  1054,   637,
     706,   610,   199,    52,   641,    53,   201,   576,   637,   756,
    1297,   853,   584,   899,   757,  1073,   854,  1138,   900,   912,
    1139,   202,   684,   697,   913,   591,   702,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   911,   899,  1057,   687,   261,   222,
    1013,  1058,   731,   691,   205,  1057,   684,   697,  1124,  1363,
    1059,  1365,   641,  1125,   641,   973,   974,  1216,   933,   934,
     824,   936,  1217,   641,   392,   399,   692,   608,   265,  1275,
     831,  1383,  1276,  1385,   338,  -510,  -510,  -510,  -510,   338,
    1219,   687,     4,   957,   608,  1220,   699,  1406,   733,   264,
    1407,   223,  -510,  -510,  -510,  -510,  1304,  1305,  1413,     4,
     564,  1414,   225,   684,   697,   565,   566,   273,   864,  1420,
     867,   281,  1421,   608,   935,   269,   643,   873,   683,   567,
     755,  -510,  -510,  -510,  -510,   733,  1097,  1098,     4,   477,
     478,  1232,   710,    24,    25,  -115,  -115,  -115,   687,   897,
     282,    47,   283,    48,    49,   285,    50,   288,   289,   979,
     980,   118,   981,   978,   290,     6,   292,   120,   918,   121,
     601,   602,  1371,   107,   108,    28,   157,     6,   927,   928,
     232,   300,     6,   301,   234,   235,   302,   236,    51,   237,
     427,   428,  1387,   303,   304,   941,   942,  1090,    52,   943,
      53,   610,   554,   555,   556,   954,  1396,   337,   329,     7,
     370,     6,   371,   379,   158,  1092,   373,   382,   610,   383,
     519,   673,   674,   675,   258,   259,   976,   386,  1096,   993,
    1097,  1098,   997,   998,   999,  1090,   385,   390,   159,    31,
      32,    33,    34,  1005,  1005,  1005,   403,   610,   997,  1104,
     999,  1005,   402,  1092,   407,   529,  1093,   736,   737,   738,
     739,   405,   691,   430,    36,   542,  1096,   409,  1097,  1098,
     392,   432,   824,  1030,   338,   814,   815,   816,   817,   399,
     831,   568,   433,  1040,  1041,   692,  1042,  1044,  1046,  1048,
    1050,   841,   842,   844,   338,  1090,   434,  1091,   806,   463,
     471,   807,   474,   475,   479,   699,   -58,   481,   499,  1070,
     494,   488,   507,  1092,   508,   509,  1093,   510,   511,   512,
     733,    48,    49,  1094,  1095,  1079,  1096,  1081,  1097,  1098,
     513,   327,  -115,  -115,  -115,   520,  1090,   683,   514,   515,
     733,   524,   522,   649,   650,   651,   652,   653,   521,   523,
     259,   527,  1108,   535,  1092,   538,    51,  1093,  -234,   808,
     540,   541,   897,   552,   550,  1095,    52,  1096,    53,  1097,
    1098,   553,   563,   585,  1131,  1133,  1135,  1136,   583,   600,
     682,   596,   654,   655,   604,   606,   629,   642,   646,   542,
     610,   660,   662,  1147,   663,  1149,   666,  1151,   707,   741,
     715,    30,   768,   269,  1143,   763,   740,   764,   777,    35,
     778,   805,    24,    25,   811,  1163,  1164,   818,   819,   821,
     827,   828,  1170,  -596,   829,  -594,  -595,  1177,  1178,   861,
     993,   993,   993,   993,   993,   993,   993,   993,  1016,   845,
     846,   849,    26,    27,    28,   851,   855,   868,   869,   870,
    1265,   770,  1266,  1267,  1268,  1269,  1270,  1271,  1272,  1005,
     875,  1209,   876,   877,  1005,   879,  1005,   881,   788,    24,
      25,  1182,  1183,  1184,  1185,  1186,  1187,  1188,  1189,   891,
    1222,   895,  1224,   892,  1226,   784,   893,   894,  1215,   824,
    1231,   630,  1234,    29,  1236,   923,   631,   632,   633,   634,
     635,    28,   901,   914,   908,    30,   915,   916,    31,    32,
      33,    34,  1250,    35,   917,   920,  1070,   833,  1070,   836,
     929,   930,   937,   938,   939,   963,  1258,   940,   996,  1260,
     966,  1264,   691,    36,  1019,   962,    48,    49,   993,   636,
     993,   993,   993,   993,   993,   993,   993,  -115,  -115,  -115,
     968,  1012,  1024,  1025,  1026,   692,  1027,  1279,   649,   650,
     651,   652,   653,  1028,  1033,    31,    32,    33,    34,  1031,
    1378,  1036,    24,    25,  1037,   699,   691,  1039,  1051,  1052,
    1053,   944,  1063,    24,    25,  1388,  1072,   969,  1056,   903,
      36,  1077,  1078,  1080,  1102,  1099,  1106,   654,   655,   692,
    1399,  1109,   175,   176,    28,  1119,  1111,   683,  1404,  1140,
    1142,  1144,  1310,   107,   108,    28,  1148,  1153,  1411,   699,
    1150,    24,    25,   732,  1152,  1415,  1154,  1417,  1158,  1419,
    1159,  1317,  1422,   691,  1424,  1160,  1426,  1162,  1428,  1165,
    1430,  1171,  1432,   670,  1176,  1327,  1179,  1181,  1328,  1199,
    1211,   683,   635,    28,   770,  1200,   692,  1205,  1213,  1337,
    1221,  1235,  1223,  1225,  1227,  1228,  1346,  1239,    31,    32,
      33,    34,   177,  1241,  1243,  1255,   699,  1240,  1242,    31,
      32,    33,    34,  1244,  1327,  1245,  1249,  1253,  1356,  1357,
    1358,  1261,  1005,    36,  1005,    24,    25,  1273,  1274,  1369,
      65,  1278,  1281,  1286,    36,  1287,   721,  1288,   683,  1379,
    1290,  1293,  1289,  1316,  1005,  1296,  1005,    31,    32,    33,
      34,  1298,  1291,    48,    49,   748,   635,    28,  1292,  1300,
    1301,  1391,  1302,  1311,  -115,  -115,  -115,  1308,  1315,  1318,
    1400,  1319,    36,  1320,  1321,  1330,  1332,  1322,  1354,  1364,
     722,  1409,  -593,  1329,  1341,   723,   724,   725,  1412,  1366,
    1367,  1370,  1374,  -597,  -597,  -597,  1375,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1376,   338,   306,   307,  1380,
    1381,   324,   325,   326,   654,   655,   330,   331,   332,   333,
     334,    31,    32,    33,    34,  1382,  1384,  1389,   125,   126,
     726,   727,   728,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,  1392,    36,  1397,  1393,  1394,
    1395,  1402,   733,  1401,   183,  1403,  1405,   232,   233,  1408,
     185,   234,   235,   834,   236,  1410,   237,  1416,  1418,   238,
     729,   239,  1423,  1425,   232,  1427,  1429,  1431,   234,   235,
     730,   236,  1433,   237,   376,   549,   562,   466,   835,   903,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,  1034,   847,  1190,   628,  1192,  1193,  1194,
    1195,  1196,  1197,  1198,   254,   255,   256,   257,   258,   259,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
    1118,   467,   747,   682,   284,   598,    99,   286,   878,   712,
    1355,   890,  1006,   898,   435,   436,   437,   438,   439,   440,
     441,   442,  1014,   444,   445,   446,   447,   448,   449,   450,
     451,   452,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   994,  1312,   117,    65,   118,   119,  1117,   278,   850,
      40,   120,   498,   121,    24,    25,   573,  1023,    41,   505,
     903,   408,  1064,   580,   659,  1218,  1338,  1339,  1248,   956,
     953,   575,   149,    43,   497,  1018,  1284,   769,   964,  1157,
     577,  1055,  1038,  1353,    26,    27,    28,   122,   837,   742,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   965,  1065,  1066,   661,   770,  1074,  1257,  1076,
     320,     0,     0,   117,    65,   118,   119,  1340,     0,     0,
     322,   120,     0,   121,    24,    25,     0,     0,     0,     0,
     123,   124,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   125,   126,     0,     0,     0,   865,     0,   127,
      31,    32,    33,    34,    26,    27,    28,   122,     0,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   128,     0,     0,   129,   130,     0,  1067,   131,   320,
     132,     0,     0,     0,     0,     0,   321,     0,     0,   322,
       0,     0,   133,  1335,   134,   135,     0,   136,     0,     0,
     123,   124,     0,   770,   137,   138,   139,     0,     0,     0,
       0,     0,   125,   126,  1335,     0,     0,     0,     0,   127,
      31,    32,    33,    34,     0,     0,     0,   117,    65,   118,
     119,     0,     0,     0,     0,   120,     0,   121,    24,    25,
       0,   128,     0,     0,   129,   130,     0,     0,   131,     0,
     132,   866,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,   134,   135,     0,   136,    26,    27,
      28,   122,     0,     0,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1007,  1008,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   117,    65,
     118,   119,     0,     0,   123,   124,   120,     0,   121,    24,
      25,     0,     0,     0,     0,     0,   125,   126,     0,     0,
       0,     0,     0,   127,    31,    32,    33,    34,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    26,
      27,    28,   122,     0,     0,   128,     0,     0,   129,   130,
       0,     0,   131,     0,   132,     0,     0,     0,  1065,  1066,
       0,     0,     0,     0,     0,     0,   133,     0,   134,   135,
       0,   136,     0,     0,     0,     0,     0,     0,   137,   138,
     139,     0,     0,     0,     0,   123,   124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   125,   126,     0,
       0,     0,     0,     0,   127,    31,    32,    33,    34,     0,
       0,     0,   117,    65,   118,   119,     0,  1323,     0,     0,
     120,     0,   121,    24,    25,     0,   128,     0,     0,   129,
     130,     0,   232,   131,     0,   132,   234,   235,     0,   236,
       0,   237,     0,     0,   238,     0,   239,   133,     0,   134,
     135,     0,   136,    26,    27,    28,   122,     0,     0,   137,
     138,   139,     0,     0,     0,     0,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,     0,     0,
    1324,     0,   117,    65,   118,   119,     0,     0,     0,     0,
     120,     0,   121,    24,    25,     0,     0,     0,     0,   123,
     124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   125,   126,     0,     0,     0,     0,     0,   127,    31,
      32,    33,    34,    26,    27,    28,   122,     0,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     128,     0,     0,   129,   130,     0,     0,   131,   320,   132,
       0,     0,     0,     0,     0,  1207,     0,     0,   322,     0,
       0,   133,     0,   134,   135,     0,   136,     0,     0,   123,
     124,     0,     0,   137,   138,   139,     0,     0,     0,     0,
       0,   125,   126,     0,     0,     0,     0,     0,   127,    31,
      32,    33,    34,     0,     0,     0,   117,    65,   118,   119,
       0,     0,     0,     0,   120,     0,   121,    24,    25,     0,
     128,     0,     0,   129,   130,     0,     0,   131,     0,   132,
     588,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,   134,   135,     0,   136,    26,    27,    28,
     122,     0,     0,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   117,    65,   118,   119,
       0,     0,     0,     0,   120,     0,   121,    24,    25,     0,
       0,     0,     0,   232,     0,     0,     0,   234,   235,     0,
     236,     0,   237,   123,   124,   238,     0,   239,     0,     0,
       0,     0,     0,     0,     0,   125,   126,    26,    27,    28,
     122,     0,   127,    31,    32,    33,    34,     0,     0,     0,
       0,   252,   253,   254,   255,   256,   257,   258,   259,     0,
       0,     0,   822,     0,   128,     0,     0,   129,   130,     0,
       0,   131,     0,   132,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   123,   124,   133,     0,   134,   135,     0,
     136,     0,     0,     0,     0,   125,   126,   137,   138,   139,
       0,     0,   127,    31,    32,    33,    34,     0,     0,     0,
     117,    65,   118,   119,     0,     0,     0,     0,   120,     0,
     121,    24,    25,     0,   128,     0,     0,   129,   130,   863,
       0,   131,     0,   132,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,   134,   135,     0,
     136,    26,    27,    28,   122,     0,     0,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     117,    65,   118,   119,     0,     0,     0,     0,   120,     0,
     121,    24,    25,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   123,   124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1043,   125,
     126,    26,    27,    28,   122,     0,   127,    31,    32,    33,
      34,     0,     0,     0,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,     0,     0,   128,     0,
       0,   129,   130,     0,   320,   131,     0,   132,     0,     0,
       0,  1390,     0,     0,   322,     0,     0,   123,   124,   133,
       0,   134,   135,     0,   136,     0,     0,     0,  1045,   125,
     126,   137,   138,   139,     0,     0,   127,    31,    32,    33,
      34,     0,     0,     0,   117,    65,   118,   119,     0,     0,
       0,     0,   120,     0,   121,    24,    25,     0,   128,     0,
       0,   129,   130,     0,     0,   131,     0,   132,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,   134,   135,     0,   136,    26,    27,    28,   122,     0,
       0,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   117,    65,   118,   119,     0,     0,
       0,     0,   120,     0,   121,    24,    25,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   123,   124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1047,   125,   126,    26,    27,    28,   122,     0,
     127,    31,    32,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   128,     0,     0,   129,   130,     0,     0,   131,
       0,   132,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   123,   124,   133,     0,   134,   135,     0,   136,     0,
       0,     0,     0,   125,   126,   137,   138,   139,     0,     0,
     127,    31,    32,    33,    34,     0,     0,     0,   117,    65,
     118,   119,     0,     0,     0,     0,   120,     0,   121,    24,
      25,     0,   128,     0,     0,   129,   130,  1049,     0,   131,
       0,   132,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,   134,   135,     0,   136,    26,
      27,    28,   122,     0,     0,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   117,    65,
     118,   119,     0,     0,     0,     0,   120,     0,   121,    24,
      25,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   123,   124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1130,   125,   126,    26,
      27,    28,   122,     0,   127,    31,    32,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,     0,     0,   129,
     130,     0,     0,   131,     0,   132,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   123,   124,   133,     0,   134,
     135,     0,   136,     0,     0,     0,  1132,   125,   126,   137,
     138,   139,     0,     0,   127,    31,    32,    33,    34,     0,
       0,     0,   117,    65,   118,   119,     0,     0,     0,     0,
     120,     0,   121,    24,    25,     0,   128,     0,     0,   129,
     130,     0,     0,   131,     0,   132,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,   134,
     135,     0,   136,    26,    27,    28,   122,     0,     0,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   117,    65,   118,   119,     0,     0,     0,     0,
     120,     0,   121,    24,    25,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   123,
     124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1134,   125,   126,    26,    27,    28,   122,     0,   127,    31,
      32,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,   129,   130,     0,     0,   131,     0,   132,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   123,
     124,   133,     0,   134,   135,     0,   136,     0,     0,     0,
       0,   125,   126,   137,   138,   139,     0,     0,   127,    31,
      32,    33,    34,     0,     0,     0,   117,    65,   118,   119,
       0,     0,     0,     0,   120,     0,   121,    24,    25,     0,
     128,     0,     0,   129,   130,  1169,     0,   131,     0,   132,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,   134,   135,     0,   136,    26,    27,    28,
     122,     0,     0,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   117,    65,   118,   119,
       0,     0,     0,     0,   120,     0,   121,   208,    25,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   123,   124,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   125,   126,    26,    27,    28,
     122,     0,   127,    31,    32,    33,    34,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   128,     0,     0,   129,   130,     0,
       0,   131,     0,   132,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   123,   124,   133,     0,   134,   135,     0,
     136,     0,     0,     0,     0,   125,   126,   137,   138,   139,
       0,     0,   127,    31,    32,    33,    34,     0,     0,     0,
     117,    65,   118,   119,     0,     0,     0,     0,   120,     0,
     121,    24,    25,     0,   128,     0,     0,   129,   130,     0,
       0,   131,     0,   132,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,   134,   135,     0,
     136,    26,    27,    28,   122,     0,     0,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     117,    65,   118,   119,     0,     0,     0,     0,   120,     0,
     121,    24,    25,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   123,   124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   125,
     126,    26,    27,    28,   122,     0,   127,    31,    32,    33,
      34,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   128,     0,
       0,   129,  1002,     0,     0,   131,     0,   132,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   123,   124,   133,
       0,   134,   135,     0,   136,     0,     0,     0,     0,   125,
     126,   137,   138,   139,     0,     0,   127,    31,    32,    33,
      34,     0,     0,     0,   117,    65,   118,   119,     0,     0,
       0,     0,   120,     0,   121,    24,    25,     0,   128,     0,
       0,   129,  1262,     0,     0,   131,     0,   132,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,   134,   135,     0,   136,    26,    27,    28,   122,     0,
       0,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   117,    65,   118,   119,     0,     0,
       0,     0,   120,     0,   121,    24,    25,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   123,   124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   125,   126,    26,    27,    28,   122,     0,
     127,    31,    32,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   128,     0,     0,   129,  1359,     0,     0,   131,
       0,   132,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   123,   124,   133,     0,   134,   135,     0,   136,     0,
       0,     0,     0,     0,     0,   137,   138,   139,     0,     0,
     127,    31,    32,    33,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   128,     0,     0,   129,   130,     0,     0,   131,
       0,   132,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,   134,   135,     0,   136,     0,
     608,     0,   668,     0,     0,   137,   138,   139,  -510,  -510,
    -510,  -510,     0,     0,     0,     4,     0,     0,   669,     0,
       0,   564,     0,     0,   608,     0,   668,     0,     0,     0,
       0,     0,  -510,  -510,  -510,  -510,     0,     0,     0,     4,
     567,     0,     0,     0,     0,   564,   670,     0,   671,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,   673,
     674,   675,     0,     0,   567,     0,     0,     0,   676,   677,
     670,   678,   671,     0,   679,   672,     0,     0,     0,     0,
       0,     0,     0,   673,   674,   675,     0,    29,     6,     0,
       0,   680,   676,   677,     0,   678,     0,     0,   679,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    29,     6,     0,     0,   680,  1214,   608,     0,   668,
       7,     0,     0,     0,     0,  -510,  -510,  -510,  -510,     0,
       0,     0,     4,     0,     0,     0,   681,     0,   564,     0,
       0,     0,     0,     0,     7,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   567,     0,     0,
     681,     0,     0,   670,     0,   671,     0,     0,   672,     0,
       0,     0,   608,     0,   668,     0,   673,   674,   675,     0,
    -510,  -510,  -510,  -510,     0,   676,   677,     4,   678,     0,
       0,   679,   902,   564,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    29,     6,     0,     0,   680,     0,
       0,     0,   567,     0,     0,     0,     0,     0,   670,  1172,
     671,     0,     0,   672,     0,     0,     0,     0,     0,     0,
       0,   673,   674,   675,     0,     0,     0,     7,     0,     0,
     676,   677,     0,   678,     0,     0,   679,   608,     0,   668,
       0,     0,     0,     0,     0,  -510,  -510,  -510,  -510,    29,
       6,     0,     4,   680,     0,     0,     0,     0,   564,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   806,     0,
       0,   807,     0,     0,     0,     0,     0,   567,     0,     0,
       0,     0,     7,     0,     0,   671,     0,     0,   672,     0,
       0,    48,    49,     0,     0,     0,   673,   674,   675,     0,
       0,     0,  -115,  -115,  -115,   676,   677,     0,   678,     0,
       0,   679,     0,   649,   650,   651,   652,   653,     0,     0,
       0,     0,     0,     0,    29,     6,    51,     0,   680,   808,
       0,     0,     0,     0,     0,     0,    52,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   654,   655,   232,   233,     0,     7,   234,   235,
       0,   236,     0,   237,     0,     0,   238,     0,   239,   240,
       0,    30,     0,   241,     0,     0,   242,     0,     0,    35,
       0,     0,     0,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     232,   233,     0,     0,   234,   235,     0,   236,     0,   237,
       0,     0,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,   242,     0,     0,     0,     0,     0,     0,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   232,   233,     0,     0,
     234,   235,     0,   236,     0,   237,     0,     0,   238,     0,
     239,     0,     0,     0,     0,   241,     0,     0,   242,     0,
       0,     0,     0,     0,     0,     0,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   232,   233,     0,     0,   234,   235,     0,   236,
       0,   237,     0,     0,   238,     0,   239,     0,     0,     0,
       0,   241,     0,     0,   242,     0,     0,     0,     0,     0,
       0,     0,     0,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   232,   233,
       0,     0,   234,   235,     0,   236,     0,   237,     0,     0,
     238,     0,   239,     0,     0,     0,     0,   241,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259
  };

  const short
  parser::yycheck_[] =
  {
      80,   143,   149,   613,   496,   496,   595,   669,    94,   595,
     400,   595,   879,   470,   995,   786,   112,   567,   289,  1000,
      81,    82,    93,    94,    71,   105,   545,    98,   140,   152,
       2,   677,   678,    22,    71,   648,  1018,   595,   922,    14,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
     130,    14,   399,     2,   134,    14,    45,    14,   140,    14,
     885,   464,    14,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,     2,    14,    71,   627,    30,    14,   476,
     140,    14,    42,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    57,    41,    14,   677,    93,    94,   102,
     161,   161,    98,   595,   595,     2,   377,  1221,    42,    57,
    1114,   100,  1116,   102,   776,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    14,   516,    14,     0,    48,
      49,  1107,   630,    66,   195,   195,    14,    24,   595,  1308,
     220,   639,   788,   789,    30,   148,   149,   150,   228,   229,
     230,   104,   762,   543,   800,   119,   766,   112,   113,   106,
    1329,   222,    75,   152,   826,    24,    15,    13,    14,    15,
      16,   119,    21,   998,    23,    21,  1166,    23,  1168,    42,
     893,   894,    31,    14,    15,    16,     0,   146,   901,   164,
     593,   151,   151,    42,   146,   542,   153,   160,  1255,   156,
     160,   154,   599,   754,  1318,    94,   146,    14,   789,   164,
     146,   151,   145,   149,   485,   804,   277,   151,   104,    33,
     833,   301,   302,   303,   304,   286,   338,   146,   299,    43,
      42,   149,  1208,   146,  1216,   153,   149,   226,   320,   885,
     853,   321,   322,   323,    57,    14,   804,   327,   328,    31,
     373,   149,   299,   899,  1205,  1139,    14,   337,   160,    66,
     810,    68,   299,   206,   207,    57,   164,   210,   211,   212,
     417,   351,   215,   216,   217,   218,   219,   146,   338,  1104,
     149,    88,    89,   226,   834,   835,    42,   837,   151,  1002,
     370,  1348,   106,   156,    31,   141,   145,  1354,   144,   379,
      14,   820,   151,   299,    14,    14,   119,   117,   139,   859,
      14,   160,   804,   804,   145,   125,   162,   413,   414,   165,
    1091,   167,    76,  1274,   138,  1276,   140,   119,   174,   175,
     176,  1312,  1313,   145,   102,    57,    57,   146,   145,   151,
     102,   103,   154,   149,    48,    49,   493,   804,   160,   154,
     430,   961,   998,   624,   625,   153,    66,     2,    68,    73,
      74,  1007,  1008,   145,   147,   147,   118,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    18,    88,    89,
     148,    14,   150,   146,   373,    26,    27,    28,    29,   149,
     153,   153,    33,   153,  1261,   144,  1109,   119,   119,   161,
     343,   344,   345,   346,   347,   348,   349,   350,    91,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   162,   177,   178,
      15,   511,   112,   113,   169,   145,    21,    18,    23,   500,
     500,   521,    14,   523,    85,    26,    27,    28,    29,   102,
     103,   146,    33,    14,   149,    34,   603,   825,  1104,   606,
     403,   547,   548,   146,   832,   106,   149,   187,   188,   611,
     550,    54,    55,    56,    14,   149,   547,   548,   123,   124,
     154,    37,    38,   128,   129,  1074,   131,   132,   133,   560,
     135,   136,   137,   138,   139,   140,   146,   142,   470,   149,
     153,   142,    83,   564,   564,   585,    14,   149,   161,   656,
    1172,   143,   154,   107,   108,   147,  1074,   142,    37,    38,
     152,   470,   149,   149,   496,   106,   515,   154,   154,  1118,
     146,  1141,  1118,   149,  1118,  1145,  1146,   120,   121,   122,
     123,   470,   148,   149,   150,  1155,   164,   496,    21,   149,
     156,   547,   548,    72,   154,   187,   188,   628,   948,   630,
    1118,   142,   164,    82,   560,    84,    22,   496,   639,   149,
    1232,   149,   515,   149,   154,   965,   154,   146,   154,   149,
     149,   188,  1074,  1074,   154,   665,  1175,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   810,   149,   149,  1074,    14,   731,
     154,   154,   611,   595,   188,   149,  1118,  1118,   149,  1342,
     154,  1344,   628,   154,   630,    73,    74,   149,   834,   835,
     720,   837,   154,   639,   289,   290,   595,    18,    14,   146,
     730,  1364,   149,  1366,   643,    26,    27,    28,    29,   648,
     149,  1118,    33,   859,    18,   154,   595,   146,   611,   154,
     149,   731,    26,    27,    28,    29,    96,    97,   146,    33,
      39,   149,   188,  1175,  1175,    44,    45,    14,   768,   146,
     770,    14,   149,    18,   836,   756,   756,   777,   595,    58,
     643,    26,    27,    28,    29,   648,   177,   178,    33,   387,
     388,    65,    83,    24,    25,    48,    49,    50,  1175,   799,
      14,    35,    14,    37,    38,    14,    40,    32,   145,    13,
      14,    15,    16,   880,   145,   106,    14,    21,   818,    23,
     540,   541,  1352,    54,    55,    56,    57,   106,   828,   829,
     143,    22,   106,   145,   147,   148,   145,   150,    72,   152,
     327,   328,  1372,   145,   145,   845,   846,   144,    82,   849,
      84,   142,    48,    49,    50,   855,  1386,   145,   166,   138,
     145,   106,   154,   156,    95,   162,   149,   154,   142,   145,
     870,    77,    78,    79,   187,   188,   876,    14,   175,   881,
     177,   178,   148,   149,   150,   144,   156,   145,   119,   120,
     121,   122,   123,   893,   894,   895,   156,   142,   148,   149,
     150,   901,   154,   162,   166,   470,   165,    26,    27,    28,
      29,   149,   804,   145,   145,   480,   175,    14,   177,   178,
     485,   161,   922,   923,   833,    26,    27,    28,    29,   494,
     930,   496,   161,   933,   934,   804,   936,   937,   938,   939,
     940,   737,   738,   739,   853,   144,   161,   146,    14,   142,
      14,    17,   154,    14,   146,   804,    14,   154,   166,   959,
     149,   151,   146,   162,   146,   146,   165,   146,   153,   146,
     833,    37,    38,   172,   173,   975,   175,   977,   177,   178,
     146,   149,    48,    49,    50,   146,   144,   804,   166,   151,
     853,    14,   146,    59,    60,    61,    62,    63,   153,   145,
     188,   154,  1002,    14,   162,    14,    72,   165,    14,    75,
     154,   154,  1012,    14,   156,   173,    82,   175,    84,   177,
     178,   151,   146,   149,  1024,  1025,  1026,  1027,   166,   154,
     595,   153,    98,    99,   149,    14,   108,    14,    14,   604,
     142,   146,   146,  1043,    14,  1045,   145,  1047,    14,    66,
     153,   117,   145,  1034,  1034,    14,   154,    14,   145,   125,
     145,    14,    24,    25,    14,  1065,  1066,   145,   154,   146,
     145,   145,  1072,    66,   145,    66,    66,  1077,  1078,   159,
    1082,  1083,  1084,  1085,  1086,  1087,  1088,  1089,   154,   145,
     145,   156,    54,    55,    56,   145,   156,   146,   149,   145,
    1190,   666,  1192,  1193,  1194,  1195,  1196,  1197,  1198,  1109,
     145,  1111,   145,    88,  1114,   145,  1116,   145,   145,    24,
      25,  1082,  1083,  1084,  1085,  1086,  1087,  1088,  1089,   154,
    1130,   145,  1132,   154,  1134,    14,   156,   156,  1119,  1139,
    1140,    46,  1142,   105,  1144,   153,    51,    52,    53,    54,
      55,    56,   156,   104,   154,   117,   104,   104,   120,   121,
     122,   123,  1162,   125,   104,   146,  1166,   732,  1168,   734,
     166,   149,   145,   145,   145,    14,  1176,   145,   147,  1179,
     154,  1181,  1074,   145,    14,   146,    37,    38,  1190,    94,
    1192,  1193,  1194,  1195,  1196,  1197,  1198,    48,    49,    50,
     146,   153,   145,   145,   145,  1074,   145,  1207,    59,    60,
      61,    62,    63,   146,    14,   120,   121,   122,   123,   154,
    1359,   146,    24,    25,   146,  1074,  1118,   154,   146,   146,
     149,    14,   146,    24,    25,  1374,   145,    14,   154,   804,
     145,   156,   154,   146,   157,   147,   156,    98,    99,  1118,
    1389,   149,    54,    55,    56,    14,   153,  1074,  1397,   153,
     156,   154,  1262,    54,    55,    56,   146,   154,  1407,  1118,
     146,    24,    25,  1335,   146,  1414,   146,  1416,   146,  1418,
      14,  1281,  1421,  1175,  1423,   149,  1425,   156,  1427,   146,
    1429,   146,  1431,    64,   156,  1295,    90,    19,  1298,   157,
     154,  1118,    55,    56,   869,   157,  1175,   157,   161,  1309,
     145,    14,   146,   146,   146,   146,  1316,   146,   120,   121,
     122,   123,   124,   146,   146,    67,  1175,   154,   154,   120,
     121,   122,   123,   154,  1334,   154,   154,   146,  1338,  1339,
    1340,   149,  1342,   145,  1344,    24,    25,   145,   145,  1349,
      14,   146,   153,   146,   145,   154,    20,   146,  1175,  1359,
     146,    80,   154,   153,  1364,   146,  1366,   120,   121,   122,
     123,   156,   154,    37,    38,    54,    55,    56,   154,   154,
     154,  1381,   154,   146,    48,    49,    50,   154,   146,   145,
    1390,   146,   145,   154,   154,    67,    80,   154,   146,   153,
      64,  1401,    66,   154,   156,    69,    70,    71,  1408,   153,
     146,   146,   149,    77,    78,    79,   146,   982,   983,   984,
     985,   986,   987,   988,   989,   146,  1335,   206,   207,   154,
     153,   210,   211,   212,    98,    99,   215,   216,   217,   218,
     219,   120,   121,   122,   123,   146,   146,   149,   112,   113,
     114,   115,   116,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   146,   145,   149,   146,   146,
     146,   146,  1335,   153,   100,   146,   146,   143,   144,   153,
     102,   147,   148,   156,   150,   154,   152,   149,   149,   155,
     154,   157,   149,   149,   143,   149,   149,   149,   147,   148,
     164,   150,   146,   152,   268,   485,   494,   374,   181,  1074,
     176,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   926,   746,  1090,   557,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,   183,   184,   185,   186,   187,   188,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
    1017,   376,   628,  1118,   179,   537,    53,   181,   782,   604,
    1337,   789,   894,   800,   343,   344,   345,   346,   347,   348,
     349,   350,   899,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   885,  1273,    13,    14,    15,    16,  1012,   170,   756,
       6,    21,   405,    23,    24,    25,   496,   912,     6,   416,
    1175,   296,    32,   501,   581,  1124,   102,   103,  1160,   858,
     853,   496,    84,     6,   403,   909,  1219,   665,   869,  1053,
     496,   951,   930,  1334,    54,    55,    56,    57,   734,   623,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   870,    73,    74,   585,  1221,   967,  1175,   970,
     146,    -1,    -1,    13,    14,    15,    16,   153,    -1,    -1,
     156,    21,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,
     100,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   112,   113,    -1,    -1,    -1,    47,    -1,   119,
     120,   121,   122,   123,    54,    55,    56,    57,    -1,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   141,    -1,    -1,   144,   145,    -1,   147,   148,   146,
     150,    -1,    -1,    -1,    -1,    -1,   153,    -1,    -1,   156,
      -1,    -1,   162,  1308,   164,   165,    -1,   167,    -1,    -1,
     100,   101,    -1,  1318,   174,   175,   176,    -1,    -1,    -1,
      -1,    -1,   112,   113,  1329,    -1,    -1,    -1,    -1,   119,
     120,   121,   122,   123,    -1,    -1,    -1,    13,    14,    15,
      16,    -1,    -1,    -1,    -1,    21,    -1,    23,    24,    25,
      -1,   141,    -1,    -1,   144,   145,    -1,    -1,   148,    -1,
     150,   151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   162,    -1,   164,   165,    -1,   167,    54,    55,
      56,    57,    -1,    -1,   174,   175,   176,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    14,
      15,    16,    -1,    -1,   100,   101,    21,    -1,    23,    24,
      25,    -1,    -1,    -1,    -1,    -1,   112,   113,    -1,    -1,
      -1,    -1,    -1,   119,   120,   121,   122,   123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    54,
      55,    56,    57,    -1,    -1,   141,    -1,    -1,   144,   145,
      -1,    -1,   148,    -1,   150,    -1,    -1,    -1,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,   162,    -1,   164,   165,
      -1,   167,    -1,    -1,    -1,    -1,    -1,    -1,   174,   175,
     176,    -1,    -1,    -1,    -1,   100,   101,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,   113,    -1,
      -1,    -1,    -1,    -1,   119,   120,   121,   122,   123,    -1,
      -1,    -1,    13,    14,    15,    16,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    -1,   141,    -1,    -1,   144,
     145,    -1,   143,   148,    -1,   150,   147,   148,    -1,   150,
      -1,   152,    -1,    -1,   155,    -1,   157,   162,    -1,   164,
     165,    -1,   167,    54,    55,    56,    57,    -1,    -1,   174,
     175,   176,    -1,    -1,    -1,    -1,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,    -1,    -1,
      81,    -1,    13,    14,    15,    16,    -1,    -1,    -1,    -1,
      21,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,   100,
     101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   112,   113,    -1,    -1,    -1,    -1,    -1,   119,   120,
     121,   122,   123,    54,    55,    56,    57,    -1,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     141,    -1,    -1,   144,   145,    -1,    -1,   148,   146,   150,
      -1,    -1,    -1,    -1,    -1,   153,    -1,    -1,   156,    -1,
      -1,   162,    -1,   164,   165,    -1,   167,    -1,    -1,   100,
     101,    -1,    -1,   174,   175,   176,    -1,    -1,    -1,    -1,
      -1,   112,   113,    -1,    -1,    -1,    -1,    -1,   119,   120,
     121,   122,   123,    -1,    -1,    -1,    13,    14,    15,    16,
      -1,    -1,    -1,    -1,    21,    -1,    23,    24,    25,    -1,
     141,    -1,    -1,   144,   145,    -1,    -1,   148,    -1,   150,
     151,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   162,    -1,   164,   165,    -1,   167,    54,    55,    56,
      57,    -1,    -1,   174,   175,   176,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    13,    14,    15,    16,
      -1,    -1,    -1,    -1,    21,    -1,    23,    24,    25,    -1,
      -1,    -1,    -1,   143,    -1,    -1,    -1,   147,   148,    -1,
     150,    -1,   152,   100,   101,   155,    -1,   157,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   112,   113,    54,    55,    56,
      57,    -1,   119,   120,   121,   122,   123,    -1,    -1,    -1,
      -1,   181,   182,   183,   184,   185,   186,   187,   188,    -1,
      -1,    -1,   139,    -1,   141,    -1,    -1,   144,   145,    -1,
      -1,   148,    -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   100,   101,   162,    -1,   164,   165,    -1,
     167,    -1,    -1,    -1,    -1,   112,   113,   174,   175,   176,
      -1,    -1,   119,   120,   121,   122,   123,    -1,    -1,    -1,
      13,    14,    15,    16,    -1,    -1,    -1,    -1,    21,    -1,
      23,    24,    25,    -1,   141,    -1,    -1,   144,   145,   146,
      -1,   148,    -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   162,    -1,   164,   165,    -1,
     167,    54,    55,    56,    57,    -1,    -1,   174,   175,   176,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    14,    15,    16,    -1,    -1,    -1,    -1,    21,    -1,
      23,    24,    25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,   101,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,   112,
     113,    54,    55,    56,    57,    -1,   119,   120,   121,   122,
     123,    -1,    -1,    -1,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,    -1,    -1,   141,    -1,
      -1,   144,   145,    -1,   146,   148,    -1,   150,    -1,    -1,
      -1,   153,    -1,    -1,   156,    -1,    -1,   100,   101,   162,
      -1,   164,   165,    -1,   167,    -1,    -1,    -1,   111,   112,
     113,   174,   175,   176,    -1,    -1,   119,   120,   121,   122,
     123,    -1,    -1,    -1,    13,    14,    15,    16,    -1,    -1,
      -1,    -1,    21,    -1,    23,    24,    25,    -1,   141,    -1,
      -1,   144,   145,    -1,    -1,   148,    -1,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,
      -1,   164,   165,    -1,   167,    54,    55,    56,    57,    -1,
      -1,   174,   175,   176,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    14,    15,    16,    -1,    -1,
      -1,    -1,    21,    -1,    23,    24,    25,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   111,   112,   113,    54,    55,    56,    57,    -1,
     119,   120,   121,   122,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   141,    -1,    -1,   144,   145,    -1,    -1,   148,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,   101,   162,    -1,   164,   165,    -1,   167,    -1,
      -1,    -1,    -1,   112,   113,   174,   175,   176,    -1,    -1,
     119,   120,   121,   122,   123,    -1,    -1,    -1,    13,    14,
      15,    16,    -1,    -1,    -1,    -1,    21,    -1,    23,    24,
      25,    -1,   141,    -1,    -1,   144,   145,   146,    -1,   148,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   162,    -1,   164,   165,    -1,   167,    54,
      55,    56,    57,    -1,    -1,   174,   175,   176,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    14,
      15,    16,    -1,    -1,    -1,    -1,    21,    -1,    23,    24,
      25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   100,   101,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   111,   112,   113,    54,
      55,    56,    57,    -1,   119,   120,   121,   122,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   141,    -1,    -1,   144,
     145,    -1,    -1,   148,    -1,   150,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   100,   101,   162,    -1,   164,
     165,    -1,   167,    -1,    -1,    -1,   111,   112,   113,   174,
     175,   176,    -1,    -1,   119,   120,   121,   122,   123,    -1,
      -1,    -1,    13,    14,    15,    16,    -1,    -1,    -1,    -1,
      21,    -1,    23,    24,    25,    -1,   141,    -1,    -1,   144,
     145,    -1,    -1,   148,    -1,   150,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,    -1,   164,
     165,    -1,   167,    54,    55,    56,    57,    -1,    -1,   174,
     175,   176,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    14,    15,    16,    -1,    -1,    -1,    -1,
      21,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,
     101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     111,   112,   113,    54,    55,    56,    57,    -1,   119,   120,
     121,   122,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     141,    -1,    -1,   144,   145,    -1,    -1,   148,    -1,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,
     101,   162,    -1,   164,   165,    -1,   167,    -1,    -1,    -1,
      -1,   112,   113,   174,   175,   176,    -1,    -1,   119,   120,
     121,   122,   123,    -1,    -1,    -1,    13,    14,    15,    16,
      -1,    -1,    -1,    -1,    21,    -1,    23,    24,    25,    -1,
     141,    -1,    -1,   144,   145,   146,    -1,   148,    -1,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   162,    -1,   164,   165,    -1,   167,    54,    55,    56,
      57,    -1,    -1,   174,   175,   176,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    13,    14,    15,    16,
      -1,    -1,    -1,    -1,    21,    -1,    23,    24,    25,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   100,   101,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   112,   113,    54,    55,    56,
      57,    -1,   119,   120,   121,   122,   123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   141,    -1,    -1,   144,   145,    -1,
      -1,   148,    -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   100,   101,   162,    -1,   164,   165,    -1,
     167,    -1,    -1,    -1,    -1,   112,   113,   174,   175,   176,
      -1,    -1,   119,   120,   121,   122,   123,    -1,    -1,    -1,
      13,    14,    15,    16,    -1,    -1,    -1,    -1,    21,    -1,
      23,    24,    25,    -1,   141,    -1,    -1,   144,   145,    -1,
      -1,   148,    -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   162,    -1,   164,   165,    -1,
     167,    54,    55,    56,    57,    -1,    -1,   174,   175,   176,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    14,    15,    16,    -1,    -1,    -1,    -1,    21,    -1,
      23,    24,    25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,   101,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   112,
     113,    54,    55,    56,    57,    -1,   119,   120,   121,   122,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   141,    -1,
      -1,   144,   145,    -1,    -1,   148,    -1,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,   101,   162,
      -1,   164,   165,    -1,   167,    -1,    -1,    -1,    -1,   112,
     113,   174,   175,   176,    -1,    -1,   119,   120,   121,   122,
     123,    -1,    -1,    -1,    13,    14,    15,    16,    -1,    -1,
      -1,    -1,    21,    -1,    23,    24,    25,    -1,   141,    -1,
      -1,   144,   145,    -1,    -1,   148,    -1,   150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,
      -1,   164,   165,    -1,   167,    54,    55,    56,    57,    -1,
      -1,   174,   175,   176,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    14,    15,    16,    -1,    -1,
      -1,    -1,    21,    -1,    23,    24,    25,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   112,   113,    54,    55,    56,    57,    -1,
     119,   120,   121,   122,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   141,    -1,    -1,   144,   145,    -1,    -1,   148,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   100,   101,   162,    -1,   164,   165,    -1,   167,    -1,
      -1,    -1,    -1,    -1,    -1,   174,   175,   176,    -1,    -1,
     119,   120,   121,   122,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   141,    -1,    -1,   144,   145,    -1,    -1,   148,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   162,    -1,   164,   165,    -1,   167,    -1,
      18,    -1,    20,    -1,    -1,   174,   175,   176,    26,    27,
      28,    29,    -1,    -1,    -1,    33,    -1,    -1,    36,    -1,
      -1,    39,    -1,    -1,    18,    -1,    20,    -1,    -1,    -1,
      -1,    -1,    26,    27,    28,    29,    -1,    -1,    -1,    33,
      58,    -1,    -1,    -1,    -1,    39,    64,    -1,    66,    -1,
      -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    77,
      78,    79,    -1,    -1,    58,    -1,    -1,    -1,    86,    87,
      64,    89,    66,    -1,    92,    69,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    78,    79,    -1,   105,   106,    -1,
      -1,   109,    86,    87,    -1,    89,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,   109,   110,    18,    -1,    20,
     138,    -1,    -1,    -1,    -1,    26,    27,    28,    29,    -1,
      -1,    -1,    33,    -1,    -1,    -1,   154,    -1,    39,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,    -1,    -1,
     154,    -1,    -1,    64,    -1,    66,    -1,    -1,    69,    -1,
      -1,    -1,    18,    -1,    20,    -1,    77,    78,    79,    -1,
      26,    27,    28,    29,    -1,    86,    87,    33,    89,    -1,
      -1,    92,    93,    39,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,   109,    -1,
      -1,    -1,    58,    -1,    -1,    -1,    -1,    -1,    64,    65,
      66,    -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    77,    78,    79,    -1,    -1,    -1,   138,    -1,    -1,
      86,    87,    -1,    89,    -1,    -1,    92,    18,    -1,    20,
      -1,    -1,    -1,    -1,    -1,    26,    27,    28,    29,   105,
     106,    -1,    33,   109,    -1,    -1,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    14,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    58,    -1,    -1,
      -1,    -1,   138,    -1,    -1,    66,    -1,    -1,    69,    -1,
      -1,    37,    38,    -1,    -1,    -1,    77,    78,    79,    -1,
      -1,    -1,    48,    49,    50,    86,    87,    -1,    89,    -1,
      -1,    92,    -1,    59,    60,    61,    62,    63,    -1,    -1,
      -1,    -1,    -1,    -1,   105,   106,    72,    -1,   109,    75,
      -1,    -1,    -1,    -1,    -1,    -1,    82,    -1,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    99,   143,   144,    -1,   138,   147,   148,
      -1,   150,    -1,   152,    -1,    -1,   155,    -1,   157,   158,
      -1,   117,    -1,   162,    -1,    -1,   165,    -1,    -1,   125,
      -1,    -1,    -1,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     143,   144,    -1,    -1,   147,   148,    -1,   150,    -1,   152,
      -1,    -1,   155,    -1,   157,    -1,    -1,    -1,    -1,   162,
      -1,    -1,   165,    -1,    -1,    -1,    -1,    -1,    -1,   172,
     173,   174,   175,   176,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   143,   144,    -1,    -1,
     147,   148,    -1,   150,    -1,   152,    -1,    -1,   155,    -1,
     157,    -1,    -1,    -1,    -1,   162,    -1,    -1,   165,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   173,   174,   175,   176,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   143,   144,    -1,    -1,   147,   148,    -1,   150,
      -1,   152,    -1,    -1,   155,    -1,   157,    -1,    -1,    -1,
      -1,   162,    -1,    -1,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   143,   144,
      -1,    -1,   147,   148,    -1,   150,    -1,   152,    -1,    -1,
     155,    -1,   157,    -1,    -1,    -1,    -1,   162,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188
  };

  const short
  parser::yystos_[] =
  {
       0,   192,   193,     0,    33,    43,   106,   138,   140,   194,
     195,   196,   198,   206,   223,   228,   232,   237,   270,   342,
     344,   398,   199,   233,    24,    25,    54,    55,    56,   105,
     117,   120,   121,   122,   123,   125,   145,   205,   260,   261,
     352,   366,   368,   399,   400,   238,    14,    35,    37,    38,
      40,    72,    82,    84,   197,   194,   194,   194,   194,   194,
     194,   194,   194,   194,   194,    14,   201,   202,   203,   204,
      14,   353,    24,    57,   119,   279,    57,   119,   280,   367,
     160,   262,   263,   264,   265,    14,    24,   397,   204,   241,
     244,    42,   207,   343,   345,   224,    14,    76,   284,   284,
      31,   200,   149,    42,   151,   156,   234,    54,    55,   260,
     354,   355,   356,   146,   118,   369,   370,    13,    15,    16,
      21,    23,    57,   100,   101,   112,   113,   119,   141,   144,
     145,   148,   150,   162,   164,   165,   167,   174,   175,   176,
     204,   399,   446,   478,   501,   502,   505,   262,   262,   397,
     154,   239,   153,   242,   147,   229,    14,    57,    95,   119,
     205,   334,   335,   336,   338,   339,   340,   341,   355,   356,
     341,    14,    14,   153,   156,    54,    55,   124,   205,   260,
     277,   278,    14,   201,    34,   203,    14,    14,   501,   142,
     209,   164,    57,   119,   357,   357,    57,   119,   371,   164,
      21,    22,   188,   195,   195,   188,   195,   195,    24,   501,
     195,   195,   195,   501,   504,   195,   195,   195,   195,   195,
     160,   195,   263,   264,   505,   188,   195,   446,   102,   103,
     153,   161,   143,   144,   147,   148,   150,   152,   155,   157,
     158,   162,   165,   172,   173,   174,   175,   176,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     265,    14,   243,   244,   154,    14,   230,   231,   208,   262,
     264,   337,   334,    14,   346,   347,   348,   334,   346,   225,
     271,    14,    14,    14,   279,    14,   280,   274,    32,   145,
     145,   214,    14,   358,   359,   264,   372,   373,   377,   378,
      22,   145,   145,   145,   145,   478,   502,   502,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     146,   153,   156,   445,   502,   502,   502,   149,   164,   166,
     502,   502,   502,   502,   502,   501,   503,   145,   204,   478,
     501,   501,   501,   195,   195,   195,   195,   195,   195,   195,
     195,   195,   195,   195,   195,   195,   195,   195,   195,   195,
     195,   195,   195,   195,   195,   195,   195,   195,   195,   195,
     145,   154,   240,   149,   149,   154,   209,   149,   154,   156,
     262,   154,   154,   145,   282,   156,    14,   275,   276,   262,
     145,   285,   195,   210,   211,   347,    14,   146,   151,   195,
     215,   218,   154,   156,   360,   149,   216,   166,   373,    14,
     374,   375,   205,   355,   356,   379,   380,   382,   501,   501,
     501,   501,   505,   501,   501,   501,   501,   504,   504,   161,
     145,   501,   161,   161,   161,   502,   502,   502,   502,   502,
     502,   502,   502,   501,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   501,   142,   415,   244,   231,   214,   347,   501,
     226,    14,   281,   283,   154,    14,   272,   285,   285,   146,
     286,   154,    37,    38,   146,   149,   219,   220,   151,   248,
     249,   250,   251,   252,   149,   216,   235,   502,   359,   166,
     376,   149,   154,   357,   357,   368,   265,   146,   146,   146,
     146,   153,   146,   146,   166,   151,   482,   483,   484,   501,
     146,   153,   146,   145,    14,   407,   411,   154,    41,   195,
     227,   270,   342,   344,   398,    14,   146,   149,    14,   282,
     154,   154,   195,   288,   289,   291,   292,   212,   213,   211,
     156,   217,    14,   151,    48,    49,    50,   253,   107,   108,
     255,   265,   218,   146,    39,    44,    45,    58,   195,   236,
     237,   342,   344,   349,   385,   394,   398,   423,   434,   264,
     375,   381,   501,   166,   478,   149,   216,   501,   151,   416,
     417,   501,   408,   149,   154,   266,   153,   431,   281,   273,
     154,   292,   292,   252,   149,   216,    14,   393,    18,    85,
     142,   195,   198,   246,   342,   344,   385,   398,   432,   442,
     444,   448,   461,   462,   341,   341,   501,   221,   255,   108,
      46,    51,    52,    53,    54,    55,    94,   205,   257,   258,
     259,   260,    14,   264,   350,   351,    14,   246,   247,    59,
      60,    61,    62,    63,    98,    99,   252,   421,   422,   369,
     146,   484,   146,    14,   146,   149,   145,   407,    20,    36,
      64,    66,    69,    77,    78,    79,    86,    87,    89,    92,
     109,   154,   195,   198,   237,   267,   268,   270,   293,   303,
     306,   342,   344,   349,   352,   363,   364,   385,   394,   398,
     401,   423,   432,   443,   463,   489,   495,    14,   282,    83,
      83,   265,   289,   287,   265,   153,    14,    15,    16,   139,
     145,    20,    64,    69,    70,    71,   114,   115,   116,   154,
     164,   204,   446,   478,   479,   448,    26,    27,    28,    29,
     154,    66,   463,   347,   347,   217,   256,   257,    54,   259,
      57,   119,   254,   259,   222,   478,   149,   154,   435,   395,
     396,   479,   427,    14,    14,   265,   426,   424,   145,   417,
     195,   418,   419,   420,   494,   431,   496,   145,   145,    14,
      66,   294,   295,   297,    14,    66,    68,    88,   145,   304,
     305,   306,   310,   311,   312,   319,   320,   327,   332,   160,
     307,   308,   309,   332,   485,    14,    14,    17,    75,   366,
     404,    14,   361,   362,    26,    27,    28,    29,   145,   154,
     290,   146,   139,   245,   501,   450,   451,   145,   145,   145,
     480,   501,   449,   195,   156,   181,   195,   445,    30,   104,
     433,   433,   433,   154,   433,   145,   145,   254,   217,   156,
     351,   145,   437,   149,   154,   156,   448,   388,   389,   386,
     448,   159,   428,   146,   501,    47,   151,   501,   146,   149,
     145,   481,   431,   501,   490,   145,   145,    88,   294,   145,
     333,   145,   311,    73,    74,   318,   321,   325,   332,    88,
     305,   154,   154,   156,   156,   145,   330,   501,   308,   149,
     154,   156,    93,   195,   267,   486,   489,   495,   154,   402,
     365,   247,   149,   154,   104,   104,   104,   104,   501,   393,
     146,   146,   149,   153,   481,   431,   453,   501,   501,   166,
     149,   481,   479,   247,   247,   446,   247,   145,   145,   145,
     145,   501,   501,   501,    14,    48,    49,   146,   438,   439,
     440,   441,   436,   396,   501,   390,   390,   247,    31,   145,
     147,   425,   146,    14,   420,   482,   154,   497,   146,    14,
      94,   487,   488,    73,    74,   300,   501,   300,   265,    13,
      14,    16,   141,   144,   162,   165,   167,   174,   175,   176,
     313,   314,   315,   505,   321,   325,   147,   148,   149,   150,
     322,   324,   145,   316,   331,   501,   316,    73,    74,   328,
     329,   331,   153,   154,   309,   331,   154,   269,   415,    14,
     383,   384,   403,   362,   145,   145,   145,   145,   146,   245,
     501,   154,   452,    14,   250,   447,   146,   146,   480,   154,
     501,   501,   501,   111,   501,   111,   501,   111,   501,   146,
     501,   146,   146,   149,   216,   440,   154,   149,   154,   154,
     391,   392,   393,   146,    32,    73,    74,   147,   429,   430,
     501,   448,   145,   216,   485,   492,   487,   156,   154,   501,
     146,   501,   195,   195,   195,   195,   195,   195,   195,   195,
     144,   146,   162,   165,   172,   173,   175,   177,   178,   147,
     156,   324,   157,   325,   149,   324,   156,   331,   501,   149,
     317,   153,   332,   332,    91,   146,   149,   330,   266,    14,
     405,   406,   407,   409,   149,   154,   406,   412,   413,   414,
     111,   501,   111,   501,   111,   501,   501,   493,   146,   149,
     153,   465,   156,   264,   154,   456,   457,   501,   146,   501,
     146,   501,   146,   154,   146,   458,   460,   439,   146,    14,
     149,   387,   156,   501,   501,   146,    75,   146,   149,   146,
     501,   146,    65,   495,   498,   499,   156,   501,   501,    90,
     298,    19,   314,   314,   314,   314,   314,   314,   314,   314,
     195,   311,   195,   195,   195,   195,   195,   195,   195,   157,
     157,   323,   326,   332,   325,   157,   317,   153,   331,   501,
     328,   154,   328,   161,   110,   262,   149,   154,   384,   149,
     154,   145,   501,   146,   501,   146,   501,   146,   146,   472,
     245,   501,    65,   448,   501,    14,   501,   448,   448,   146,
     154,   146,   154,   146,   154,   154,   448,   464,   392,   154,
     501,   430,   430,   146,   431,    67,   500,   486,   501,   491,
     501,   149,   145,   299,   501,   313,   313,   313,   313,   313,
     313,   313,   313,   145,   145,   146,   149,   326,   146,   501,
     317,   153,   410,   406,   413,   418,   146,   154,   146,   154,
     146,   154,   154,    80,   473,   474,   146,   431,   156,   454,
     154,   154,   154,   459,    96,    97,   468,   498,   154,   300,
     501,   146,   323,   326,   326,   146,   153,   501,   145,   146,
     154,   154,   154,    18,    81,   476,   477,   501,   501,   154,
      67,   466,    80,   469,   470,   195,   444,   501,   102,   103,
     153,   156,   102,   324,   102,   324,   501,   418,   475,   149,
     153,   444,   467,   476,   146,   298,   501,   501,   501,   145,
     301,   302,   501,   331,   153,   331,   153,   146,   498,   501,
     146,   448,   471,   498,   149,   146,   146,   146,   302,   501,
     154,   153,   146,   331,   146,   331,   455,   448,   302,   149,
     153,   501,   146,   146,   146,   146,   448,   149,   296,   302,
     501,   153,   146,   146,   302,   146,   146,   149,   153,   501,
     154,   302,   501,   146,   149,   302,   149,   302,   149,   302,
     146,   149,   302,   149,   302,   149,   302,   149,   302,   149,
     302,   149,   302,   146
  };

  const short
  parser::yyr1_[] =
  {
       0,   191,   193,   192,   194,   194,   194,   194,   194,   194,
     194,   194,   194,   194,   194,   196,   195,   197,   197,   199,
     200,   198,   201,   201,   202,   202,   203,   203,   204,   204,
     204,   205,   205,   205,   207,   208,   206,   209,   209,   210,
     210,   211,   212,   211,   213,   211,   211,   214,   214,   214,
     215,   215,   216,   216,   217,   217,   219,   218,   220,   221,
     218,   222,   218,   218,   224,   225,   223,   226,   226,   227,
     227,   227,   227,   228,   229,   228,   230,   230,   231,   233,
     234,   232,   235,   235,   236,   236,   236,   236,   236,   236,
     236,   236,   236,   238,   239,   240,   237,   241,   242,   242,
     243,   243,   244,   245,   245,   246,   246,   246,   246,   246,
     246,   246,   246,   247,   247,   249,   248,   251,   250,   252,
     252,   253,   253,   253,   254,   254,   254,   255,   255,   255,
     255,   256,   256,   257,   257,   257,   257,   257,   257,   257,
     257,   258,   258,   258,   259,   259,   259,   260,   260,   260,
     260,   260,   261,   261,   262,   262,   262,   262,   263,   263,
     264,   264,   265,   265,   266,   266,   266,   266,   266,   267,
     267,   267,   267,   267,   267,   267,   267,   267,   267,   267,
     267,   267,   267,   267,   267,   267,   267,   267,   269,   268,
     271,   270,   272,   270,   273,   270,   274,   270,   275,   270,
     276,   270,   277,   277,   277,   277,   278,   278,   278,   279,
     279,   279,   280,   280,   280,   281,   281,   282,   282,   283,
     283,   283,   283,   284,   284,   285,   285,   286,   287,   285,
     288,   288,   290,   289,   291,   289,   292,   292,   293,   294,
     294,   295,   295,   296,   296,   297,   297,   298,   298,   299,
     299,   299,   299,   300,   300,   300,   301,   301,   301,   301,
     301,   302,   302,   303,   303,   304,   304,   305,   305,   305,
     306,   306,   307,   308,   308,   309,   310,   310,   311,   311,
     312,   312,   313,   313,   313,   313,   313,   313,   313,   313,
     313,   313,   313,   313,   313,   313,   313,   313,   313,   314,
     314,   314,   315,   315,   316,   316,   316,   317,   317,   318,
     318,   319,   319,   319,   320,   320,   320,   321,   321,   322,
     322,   323,   323,   324,   324,   324,   325,   326,   327,   328,
     328,   328,   329,   329,   329,   330,   331,   331,   333,   332,
     334,   334,   334,   335,   336,   337,   338,   339,   339,   340,
     341,   341,   341,   341,   341,   343,   342,   345,   344,   346,
     346,   347,   347,   348,   349,   350,   350,   351,   353,   352,
     354,   354,   354,   355,   356,   356,   357,   357,   357,   358,
     358,   359,   360,   360,   361,   361,   362,   363,   365,   364,
     367,   366,   368,   368,   369,   370,   370,   371,   371,   371,
     372,   372,   373,   374,   374,   376,   375,   378,   377,   379,
     380,   381,   379,   382,   382,   382,   383,   383,   384,   386,
     387,   385,   388,   385,   389,   385,   390,   390,   391,   391,
     392,   392,   393,   394,   395,   395,   396,   397,   397,   398,
     398,   399,   399,   399,   400,   400,   402,   401,   403,   401,
     404,   404,   405,   405,   406,   406,   408,   407,   410,   409,
     411,   411,   412,   412,   413,   414,   413,   415,   415,   416,
     416,   417,   417,   417,   417,   418,   419,   419,   420,   420,
     420,   420,   420,   420,   421,   421,   422,   422,   424,   425,
     423,   426,   423,   427,   423,   428,   428,   428,   428,   428,
     428,   429,   429,   429,   430,   430,   430,   431,   431,   432,
     432,   433,   433,   433,   435,   436,   434,   437,   437,   438,
     438,   439,   439,   440,   441,   441,   442,   442,   442,   442,
     442,   442,   442,   442,   442,   443,   443,   443,   443,   443,
     443,   443,   444,   444,   444,   444,   444,   445,   445,   445,
     445,   445,   445,   445,   445,   445,   445,   445,   445,   446,
     446,   447,   447,   447,   448,   448,   448,   448,   448,   448,
     448,   448,   448,   449,   448,   450,   448,   451,   452,   448,
     453,   454,   455,   448,   456,   448,   457,   448,   458,   459,
     448,   460,   448,   461,   461,   461,   461,   462,   462,   462,
     462,   463,   463,   463,   464,   464,   464,   465,   465,   467,
     466,   466,   468,   468,   470,   471,   469,   472,   472,   474,
     475,   473,   476,   476,   477,   477,   477,   477,   478,   478,
     478,   479,   479,   480,   480,   481,   481,   482,   482,   483,
     483,   484,   485,   485,   485,   486,   486,   486,   487,   488,
     488,   488,   490,   491,   489,   492,   489,   493,   489,   494,
     489,   496,   497,   495,   499,   498,   498,   500,   500,   501,
     501,   501,   501,   502,   502,   502,   502,   502,   502,   503,
     502,   502,   502,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   502,   502,   502,   502,   502,   502,   504,
     504,   505,   505,   505,   505
  };

  const signed char
  parser::yyr2_[] =
  {
       0,     2,     0,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     0,     0,     2,     4,     0,     0,
       0,     5,     1,     0,     1,     3,     1,     3,     1,     3,
       3,     1,     1,     3,     0,     0,    11,     4,     0,     1,
       3,     0,     0,     5,     0,     5,     1,     2,     0,     4,
       1,     3,     1,     0,     2,     0,     0,     3,     0,     0,
       5,     0,     6,     3,     0,     0,     9,     2,     0,     1,
       1,     1,     1,     5,     0,     6,     1,     3,     1,     0,
       0,     9,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     0,     0,     9,     2,     2,     0,
       1,     3,     1,     1,     5,     2,     2,     2,     2,     4,
       4,     6,     8,     1,     0,     0,     5,     0,     4,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     1,     2,     1,     2,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     5,     5,     3,     2,     2,
       1,     0,     1,     1,     2,     2,     2,     2,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     1,     1,     0,     6,
       0,     7,     0,     9,     0,    11,     0,     9,     0,    10,
       0,    10,     1,     2,     3,     2,     0,     1,     1,     0,
       1,     1,     0,     1,     1,     2,     1,     3,     0,     3,
       2,     1,     0,     1,     0,     2,     0,     0,     0,     6,
       1,     3,     0,     5,     0,     2,     2,     0,     3,     2,
       0,    10,    14,     2,     0,     4,     0,     2,     0,     1,
       5,     5,     5,     1,     1,     0,     1,     5,     7,    13,
      25,     1,     5,     3,     2,     2,     1,     1,     1,     1,
       3,     4,     5,     1,     3,     3,     2,     2,     3,     3,
       5,     2,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     4,     4,     4,     4,     4,     4,     4,     1,
       1,     1,     1,     1,     4,     1,     2,     2,     3,     1,
       1,     7,    12,    11,     6,    12,    11,     2,     3,     2,
       3,     1,     3,     1,     1,     0,     1,     1,     5,     2,
       2,     1,     1,     3,     3,     1,     1,     5,     0,     3,
       1,     1,     0,     1,     1,     1,     2,     2,     3,     2,
       1,     1,     1,     1,     1,     0,     6,     0,     6,     1,
       3,     3,     1,     1,     3,     1,     3,     4,     0,     7,
       2,     3,     0,     1,     1,     1,     1,     1,     0,     1,
       3,     2,     2,     0,     1,     3,     1,     3,     0,     5,
       0,     3,     1,     1,     4,     2,     0,     1,     1,     0,
       1,     2,     3,     1,     3,     0,     3,     0,     2,     2,
       0,     0,     4,     2,     2,     1,     1,     3,     1,     0,
       0,     8,     0,     6,     0,     6,     0,     3,     1,     3,
       1,     3,     2,     4,     1,     3,     3,     1,     1,     6,
       4,     1,     2,     2,     1,     1,     0,     6,     0,     6,
       1,     1,     1,     3,     1,     1,     0,     5,     0,     6,
       1,     3,     1,     3,     1,     0,     4,     4,     0,     1,
       3,     0,     1,     4,     5,     1,     1,     3,     1,     2,
       6,     5,     3,     2,     1,     1,     1,     1,     0,     0,
       6,     0,     4,     0,     4,     4,     4,     3,     3,     2,
       0,     1,     3,     3,     2,     2,     1,     2,     0,     2,
       0,     1,     1,     0,     0,     0,     6,     2,     4,     1,
       3,     2,     1,     1,     1,     1,     7,     7,     8,     8,
       7,     6,     3,     7,     8,     7,     7,     8,     8,     7,
       7,     8,     5,     4,     4,     5,     5,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     5,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     0,     5,     0,     5,     0,     0,     8,
       0,     0,     0,    13,     0,     7,     0,     7,     0,     0,
       9,     0,     9,     1,     2,     2,     2,     1,     2,     2,
       2,     1,     1,     1,     2,     2,     0,     2,     0,     0,
       3,     0,     2,     0,     0,     0,     4,     2,     0,     0,
       0,     4,     2,     1,     1,     1,     1,     3,     6,     2,
       2,     1,     3,     1,     3,     4,     0,     1,     0,     1,
       3,     1,     2,     2,     0,     1,     1,     2,     1,     2,
       4,     3,     0,     0,    11,     0,     7,     0,     7,     0,
       4,     0,     0,     7,     0,     2,     1,     2,     0,     1,
       6,     3,     2,     1,     4,     2,     1,     1,     1,     0,
       7,     5,     5,     3,     7,     3,     6,     3,     4,     4,
       4,     4,     4,     4,     3,     3,     3,     3,     3,     3,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     3,     3,
       4,     4,     3,     5,     5,     5,     5,     5,     5,     1,
       3,     1,     1,     2,     3
  };




#if FRONTEND_VERILOG_YYDEBUG
  const short
  parser::yyrline_[] =
  {
       0,   593,   593,   593,   604,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   617,   617,   633,   636,   639,
     644,   639,   655,   655,   658,   659,   662,   665,   670,   673,
     680,   689,   690,   691,   695,   697,   695,   718,   718,   721,
     721,   724,   725,   725,   730,   730,   735,   738,   738,   738,
     741,   741,   744,   744,   747,   763,   766,   766,   779,   783,
     779,   791,   791,   806,   811,   813,   811,   826,   826,   829,
     829,   829,   829,   832,   838,   838,   848,   849,   852,   860,
     862,   860,   880,   880,   883,   883,   883,   883,   883,   883,
     883,   884,   884,   887,   890,   894,   887,   921,   926,   927,
     930,   931,   936,   943,   944,   947,   948,   949,   951,   952,
     953,   954,   955,   958,   958,   961,   961,   966,   966,   971,
     972,   975,   978,   981,   987,   988,   989,   992,   996,   999,
    1002,  1005,  1005,  1009,  1011,  1014,  1017,  1021,  1024,  1027,
    1030,  1039,  1042,  1045,  1048,  1050,  1055,  1060,  1061,  1062,
    1063,  1064,  1067,  1068,  1071,  1076,  1082,  1088,  1094,  1097,
    1103,  1106,  1111,  1112,  1115,  1117,  1118,  1119,  1120,  1123,
    1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1124,
    1124,  1124,  1125,  1125,  1125,  1125,  1125,  1125,  1128,  1128,
    1136,  1136,  1143,  1143,  1150,  1150,  1157,  1157,  1166,  1166,
    1180,  1180,  1202,  1206,  1209,  1213,  1218,  1219,  1220,  1224,
    1225,  1226,  1229,  1230,  1231,  1235,  1238,  1243,  1244,  1247,
    1248,  1249,  1250,  1253,  1254,  1257,  1257,  1257,  1261,  1257,
    1269,  1269,  1272,  1272,  1293,  1293,  1307,  1308,  1313,  1316,
    1317,  1320,  1401,  1472,  1475,  1480,  1483,  1488,  1491,  1496,
    1502,  1508,  1514,  1522,  1523,  1524,  1527,  1534,  1539,  1545,
    1551,  1559,  1565,  1575,  1576,  1579,  1580,  1583,  1586,  1587,
    1591,  1592,  1598,  1601,  1601,  1604,  1607,  1609,  1613,  1614,
    1618,  1620,  1624,  1626,  1627,  1628,  1629,  1630,  1631,  1632,
    1633,  1635,  1636,  1637,  1638,  1639,  1640,  1641,  1642,  1647,
    1648,  1650,  1658,  1659,  1663,  1664,  1665,  1669,  1670,  1674,
    1674,  1677,  1678,  1679,  1682,  1683,  1684,  1688,  1689,  1692,
    1693,  1696,  1697,  1700,  1700,  1700,  1704,  1708,  1711,  1714,
    1715,  1716,  1719,  1720,  1721,  1728,  1731,  1732,  1736,  1736,
    1742,  1744,  1746,  1749,  1754,  1759,  1765,  1767,  1770,  1773,
    1776,  1776,  1776,  1776,  1777,  1782,  1782,  1791,  1791,  1800,
    1800,  1803,  1808,  1820,  1837,  1840,  1840,  1843,  1856,  1856,
    1882,  1883,  1884,  1888,  1894,  1895,  1899,  1900,  1901,  1904,
    1905,  1909,  1922,  1923,  1927,  1928,  1931,  1941,  1949,  1949,
    1957,  1957,  1966,  1967,  1970,  1974,  1975,  1978,  1979,  1980,
    1983,  1984,  1987,  1991,  1992,  1995,  1995,  2009,  2009,  2013,
    2018,  2020,  2018,  2033,  2034,  2035,  2038,  2039,  2043,  2055,
    2059,  2055,  2065,  2065,  2072,  2072,  2081,  2082,  2092,  2092,
    2095,  2133,  2158,  2203,  2206,  2206,  2209,  2214,  2215,  2219,
    2234,  2238,  2243,  2252,  2261,  2262,  2266,  2266,  2274,  2274,
    2283,  2286,  2291,  2292,  2295,  2295,  2298,  2298,  2312,  2312,
    2326,  2327,  2330,  2331,  2334,  2335,  2335,  2348,  2348,  2351,
    2351,  2354,  2355,  2360,  2363,  2371,  2397,  2397,  2400,  2404,
    2409,  2415,  2420,  2427,  2434,  2437,  2442,  2445,  2450,  2455,
    2450,  2466,  2466,  2478,  2478,  2488,  2489,  2490,  2491,  2492,
    2493,  2496,  2497,  2498,  2501,  2507,  2513,  2520,  2523,  2528,
    2531,  2536,  2539,  2542,  2547,  2551,  2547,  2557,  2557,  2560,
    2560,  2563,  2564,  2567,  2576,  2576,  2579,  2589,  2598,  2607,
    2616,  2623,  2630,  2637,  2648,  2661,  2668,  2675,  2682,  2689,
    2696,  2706,  2718,  2723,  2726,  2729,  2734,  2739,  2740,  2741,
    2742,  2743,  2744,  2745,  2746,  2747,  2748,  2749,  2750,  2755,
    2756,  2759,  2766,  2769,  2806,  2806,  2806,  2806,  2806,  2806,
    2807,  2808,  2809,  2810,  2810,  2818,  2818,  2826,  2828,  2826,
    2849,  2852,  2854,  2849,  2863,  2863,  2876,  2876,  2889,  2927,
    2889,  2934,  2934,  2945,  2948,  2955,  2962,  2972,  2975,  2979,
    2983,  2990,  2993,  2996,  3001,  3005,  3009,  3012,  3013,  3016,
    3016,  3030,  3033,  3034,  3037,  3042,  3037,  3053,  3054,  3057,
    3062,  3057,  3071,  3072,  3075,  3079,  3084,  3087,  3092,  3097,
    3106,  3113,  3116,  3121,  3125,  3131,  3132,  3135,  3136,  3139,
    3140,  3143,  3148,  3149,  3150,  3153,  3153,  3154,  3157,  3163,
    3166,  3180,  3187,  3189,  3187,  3196,  3196,  3203,  3203,  3210,
    3210,  3219,  3221,  3219,  3233,  3233,  3238,  3241,  3241,  3244,
    3247,  3255,  3260,  3265,  3268,  3277,  3290,  3297,  3308,  3312,
    3312,  3327,  3331,  3335,  3338,  3341,  3344,  3347,  3352,  3357,
    3362,  3367,  3372,  3377,  3382,  3387,  3393,  3398,  3405,  3410,
    3415,  3420,  3425,  3430,  3435,  3440,  3445,  3450,  3455,  3460,
    3465,  3470,  3475,  3480,  3485,  3490,  3495,  3500,  3505,  3510,
    3515,  3520,  3525,  3530,  3536,  3542,  3548,  3554,  3561,  3567,
    3570,  3576,  3577,  3578,  3582
  };

  void
  parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // FRONTEND_VERILOG_YYDEBUG


} // frontend_verilog_yy
#line 8027 "frontends/verilog/verilog_parser.tab.cc"

