#line 1 "/build/yosys-git/src/yosys/pyosys/wrappers_tpl.cc"
/*
 *  yosys -- Yosys Open SYnthesis Suite
 *
 *  Copyright (C) 2012  Claire Xenia Wolf <claire@yosyshq.com>
 *
 *  Permission to use, copy, modify, and/or distribute this software for any
 *  purpose with or without fee is hereby granted, provided that the above
 *  copyright notice and this permission notice appear in all copies.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifdef YOSYS_ENABLE_PYTHON

#include "kernel/binding.h"
#include "libs/sha1/sha1.h"
#include "kernel/log.h"
#include "kernel/yosys.h"
#include "kernel/cost.h"
#include "kernel/celltypes.h"
#include "kernel/consteval.h"
#include "kernel/register.h"
#include "kernel/rtlil.h"
#line 22 "/build/yosys-git/src/yosys/pyosys/wrappers_tpl.cc"
#include <pybind11/pybind11.h>
#include <pybind11/native_enum.h>
#include <pybind11/functional.h>

// duplicates for LSPs
#include "kernel/register.h"
#include "kernel/yosys_common.h"

#include "pyosys/hashlib.h"

namespace py = pybind11;

USING_YOSYS_NAMESPACE

using std::set;
using std::function;
using std::ostream;
using namespace RTLIL;

#include "wrappers.inc.cc"

namespace pyosys {
	struct Globals {};

	// Trampolines for Classes with Python-Overridable Virtual Methods
	// https://pybind11.readthedocs.io/en/stable/advanced/classes.html#overriding-virtual-functions-in-python
	class PassTrampoline : public Pass {
	public:
		using Pass::Pass;

		void help() override {
			PYBIND11_OVERRIDE(void, Pass, help);
		}

		bool formatted_help() override {
			PYBIND11_OVERRIDE(bool, Pass, formatted_help);
		}

		void clear_flags() override {
			PYBIND11_OVERRIDE(void, Pass, clear_flags);
		}

		void execute(std::vector<std::string> args, RTLIL::Design *design) override {
			PYBIND11_OVERRIDE_PURE(
				void,
				Pass,
				execute,
				args,
				design
			);
		}

		void on_register() override {
			PYBIND11_OVERRIDE(void, Pass, on_register);
		}

		void on_shutdown() override {
			PYBIND11_OVERRIDE(void, Pass, on_shutdown);
		}

		bool replace_existing_pass() const override {
			PYBIND11_OVERRIDE(
				bool,
				Pass,
				replace_existing_pass
			);
		}
	};

	class MonitorTrampoline : public RTLIL::Monitor {
	public:
		using RTLIL::Monitor::Monitor;

		void notify_module_add(RTLIL::Module *module) override {
			PYBIND11_OVERRIDE(
				void,
				RTLIL::Monitor,
				notify_module_add,
				module
			);
		}

		void notify_module_del(RTLIL::Module *module) override {
			PYBIND11_OVERRIDE(
				void,
				RTLIL::Monitor,
				notify_module_del,
				module
			);
		}

		void notify_connect(
			RTLIL::Cell *cell,
			const RTLIL::IdString &port,
			const RTLIL::SigSpec &old_sig,
			const RTLIL::SigSpec &sig
		) override {
			PYBIND11_OVERRIDE(
				void,
				RTLIL::Monitor,
				notify_connect,
				cell,
				port,
				old_sig,
				sig
			);
		}

		void notify_connect(
			RTLIL::Module *module,
			const RTLIL::SigSig &sigsig
		) override {
			PYBIND11_OVERRIDE(
				void,
				RTLIL::Monitor,
				notify_connect,
				module,
				sigsig
			);
		}

		void notify_connect(
			RTLIL::Module *module,
			const std::vector<RTLIL::SigSig> &sigsig_vec
		) override {
			PYBIND11_OVERRIDE(
				void,
				RTLIL::Monitor,
				notify_connect,
				module,
				sigsig_vec
			);
		}

		void notify_blackout(
			RTLIL::Module *module
		) override {
			PYBIND11_OVERRIDE(
				void,
				RTLIL::Monitor,
				notify_blackout,
				module
			);
		}
	};

	PYBIND11_MODULE(libyosys, m) {
		// this code is run on import
		m.doc() = "python access to libyosys";

		if (!yosys_already_setup()) {
			log_streams.push_back(&std::cout);
			log_error_stderr = true;
			yosys_setup();

			// Cleanup
			m.add_object("_cleanup_handle", py::capsule([](){
				yosys_shutdown();
			}));
		}

		// Logging Methods
		m.def("log_header", [](Design *d, std::string s) { log_formatted_header(d, "%s", s); });
		m.def("log", [](std::string s) { log_formatted_string("%s", s); });
		m.def("log_file_info", [](std::string_view file, int line, std::string s) { log_formatted_file_info(file, line, s); });
		m.def("log_warning", [](std::string s) { log_formatted_warning("Warning: ", s); });
		m.def("log_warning_noprefix", [](std::string s) { log_formatted_warning("", s); });
		m.def("log_file_warning", [](std::string_view file, int line, std::string s) { log_formatted_file_warning(file, line, s); });
		m.def("log_error", [](std::string s) { log_formatted_error(s); });
		m.def("log_file_error", [](std::string_view file, int line, std::string s) { log_formatted_file_error(file, line, s); });

		// Namespace to host global objects
		auto global_variables = py::class_<Globals>(m, "Globals");

		// Trampoline Classes
		py::class_<Pass, pyosys::PassTrampoline, std::unique_ptr<Pass, py::nodelete>>(m, "Pass")
			.def(py::init([](std::string name, std::string short_help) {
				auto created = new pyosys::PassTrampoline(name, short_help);
				Pass::init_register();
				return created;
			}), py::arg("name"), py::arg("short_help"))
			.def("help", &Pass::help)
			.def("formatted_help", &Pass::formatted_help)
			.def("execute", &Pass::execute)
			.def("clear_flags", &Pass::clear_flags)
			.def("on_register", &Pass::on_register)
			.def("on_shutdown", &Pass::on_shutdown)
			.def("replace_existing_pass", &Pass::replace_existing_pass)
			.def("experimental", &Pass::experimental)
			.def("internal", &Pass::internal)
			.def("pre_execute", &Pass::pre_execute)
			.def("post_execute", &Pass::post_execute)
			.def("cmd_log_args", &Pass::cmd_log_args)
			.def("cmd_error", &Pass::cmd_error)
			.def("extra_args", &Pass::extra_args)
			.def("call", py::overload_cast<RTLIL::Design *,std::string>(&Pass::call))
			.def("call", py::overload_cast<RTLIL::Design *,std::vector<std::string>>(&Pass::call))
		;

		py::class_<RTLIL::Monitor, pyosys::MonitorTrampoline>(m, "Monitor")
			.def(py::init([]() {
				return new pyosys::MonitorTrampoline();
			}))
			.def("notify_module_add", &RTLIL::Monitor::notify_module_add)
			.def("notify_module_del", &RTLIL::Monitor::notify_module_del)
			.def(
				"notify_connect",
				py::overload_cast<
					RTLIL::Cell *,
					const RTLIL::IdString &,
					const RTLIL::SigSpec &,
					const RTLIL::SigSpec &
				>(&RTLIL::Monitor::notify_connect)
			)
			.def(
				"notify_connect",
				py::overload_cast<
					RTLIL::Module *,
					const RTLIL::SigSig &
				>(&RTLIL::Monitor::notify_connect)
			)
			.def(
				"notify_connect",
				py::overload_cast<
					RTLIL::Module *,
					const std::vector<RTLIL::SigSig> &
				>(&RTLIL::Monitor::notify_connect)
			)
			.def("notify_blackout", &RTLIL::Monitor::notify_blackout)
		;

		// Bind Opaque Containers
		bind_autogenerated_opaque_containers(m);

		{ using namespace Yosys;
			m.def("log_formatted_string", static_cast <void(*)(std::string_view, std::string)>(&log_formatted_string), py::arg("format"), py::arg("str"));
			m.def("log_formatted_header", static_cast <void(*)(RTLIL::Design*, std::string_view, std::string)>(&log_formatted_header), py::arg("design"), py::arg("format"), py::arg("str"));
			m.def("log_formatted_warning", static_cast <void(*)(std::string_view, std::string)>(&log_formatted_warning), py::arg("prefix"), py::arg("str"));
			m.def("log_formatted_warning_noprefix", static_cast <void(*)(std::string)>(&log_formatted_warning_noprefix), py::arg("str"));
			m.def("log_experimental", static_cast <void(*)(const std::string&)>(&log_experimental), py::arg("str"));
			m.def("log_formatted_file_warning", static_cast <void(*)(std::string_view, int, std::string)>(&log_formatted_file_warning), py::arg("filename"), py::arg("lineno"), py::arg("str"));
			m.def("log_formatted_file_info", static_cast <void(*)(std::string_view, int, std::string)>(&log_formatted_file_info), py::arg("filename"), py::arg("lineno"), py::arg("str"));
			m.def("log_formatted_error", static_cast <void(*)(std::string)>(&log_formatted_error), py::arg("str"));
			m.def("log_formatted_file_error", static_cast <void(*)(std::string_view, int, std::string)>(&log_formatted_file_error), py::arg("filename"), py::arg("lineno"), py::arg("str"));
			m.def("log_formatted_cmd_error", static_cast <void(*)(std::string)>(&log_formatted_cmd_error), py::arg("str"));
			m.def("log_spacer", static_cast <void(*)()>(&log_spacer));
			m.def("log_push", static_cast <void(*)()>(&log_push));
			m.def("log_pop", static_cast <void(*)()>(&log_pop));
			m.def("log_backtrace", static_cast <void(*)(const char*, int)>(&log_backtrace), py::arg("prefix"), py::arg("levels"));
			m.def("log_reset_stack", static_cast <void(*)()>(&log_reset_stack));
			m.def("log_flush", static_cast <void(*)()>(&log_flush));
			m.def("log_check_expected", static_cast <void(*)()>(&log_check_expected));
			m.def("log_signal", static_cast <std::string(*)(const RTLIL::SigSpec&, bool)>(&log_signal), py::arg("sig"), py::arg("autoint") = true);
			m.def("log_const", static_cast <std::string(*)(const RTLIL::Const&, bool)>(&log_const), py::arg("value"), py::arg("autoint") = true);
			m.def("log_id", static_cast <const char*(*)(const RTLIL::IdString&)>(&log_id), py::arg("id"));
			m.def("log_module", static_cast <void(*)(RTLIL::Module*, std::string)>(&log_module), py::arg("module"), py::arg("indent") = "");
			m.def("log_cell", static_cast <void(*)(RTLIL::Cell*, std::string)>(&log_cell), py::arg("cell"), py::arg("indent") = "");
			m.def("log_wire", static_cast <void(*)(RTLIL::Wire*, std::string)>(&log_wire), py::arg("wire"), py::arg("indent") = "");
			m.def("log_assert_failure", static_cast <void(*)(const char*, const char*, int)>(&log_assert_failure), py::arg("expr"), py::arg("file"), py::arg("line"));
			m.def("log_abort_internal", static_cast <void(*)(const char*, int)>(&log_abort_internal), py::arg("file"), py::arg("line"));
			m.def("log_dump_val_worker", static_cast <void(*)(RTLIL::IdString)>(&log_dump_val_worker), py::arg("v"));
			m.def("log_dump_val_worker", static_cast <void(*)(RTLIL::SigSpec)>(&log_dump_val_worker), py::arg("v"));
			m.def("log_dump_val_worker", static_cast <void(*)(RTLIL::State)>(&log_dump_val_worker), py::arg("v"));
			global_variables.def_readwrite_static("log_files", &log_files);
			global_variables.def_readwrite_static("log_streams", &log_streams);
			global_variables.def_readwrite_static("log_scratchpads", &log_scratchpads);
			global_variables.def_readwrite_static("log_hdump", &log_hdump);
			global_variables.def_readwrite_static("log_warnings", &log_warnings);
			global_variables.def_readwrite_static("log_experimentals", &log_experimentals);
			global_variables.def_readwrite_static("log_experimentals_ignored", &log_experimentals_ignored);
			global_variables.def_readwrite_static("log_warnings_count", &log_warnings_count);
			global_variables.def_readwrite_static("log_warnings_count_noexpect", &log_warnings_count_noexpect);
			global_variables.def_readwrite_static("log_expect_no_warnings", &log_expect_no_warnings);
			global_variables.def_readwrite_static("log_hdump_all", &log_hdump_all);
			global_variables.def_readwrite_static("log_errfile", &log_errfile);
			global_variables.def_readwrite_static("log_hasher", &log_hasher);
			global_variables.def_readwrite_static("log_time", &log_time);
			global_variables.def_readwrite_static("log_error_stderr", &log_error_stderr);
			global_variables.def_readwrite_static("log_cmd_error_throw", &log_cmd_error_throw);
			global_variables.def_readwrite_static("log_quiet_warnings", &log_quiet_warnings);
			global_variables.def_readwrite_static("log_verbose_level", &log_verbose_level);
			global_variables.def_readwrite_static("log_last_error", &log_last_error);
			global_variables.def_readwrite_static("log_make_debug", &log_make_debug);
			global_variables.def_readwrite_static("log_force_debug", &log_force_debug);
			global_variables.def_readwrite_static("log_debug_suppressed", &log_debug_suppressed);
			global_variables.def_readwrite_static("log_expect_log", &log_expect_log);
			global_variables.def_readwrite_static("log_expect_warning", &log_expect_warning);
			global_variables.def_readwrite_static("log_expect_error", &log_expect_error);
			global_variables.def_readwrite_static("log_expect_prefix_log", &log_expect_prefix_log);
			global_variables.def_readwrite_static("log_expect_prefix_warning", &log_expect_prefix_warning);
			global_variables.def_readwrite_static("log_expect_prefix_error", &log_expect_prefix_error);
		}
		{ using namespace Yosys;
			m.def("yosys_setup", static_cast <void(*)()>(&yosys_setup));
			m.def("yosys_already_setup", static_cast <bool(*)()>(&yosys_already_setup));
			m.def("yosys_shutdown", static_cast <void(*)()>(&yosys_shutdown));
			m.def("yosys_get_design", static_cast <RTLIL::Design*(*)()>(&yosys_get_design));
			m.def("proc_self_dirname", static_cast <std::string(*)()>(&proc_self_dirname));
			m.def("proc_share_dirname", static_cast <std::string(*)()>(&proc_share_dirname));
			m.def("proc_program_prefix", static_cast <std::string(*)()>(&proc_program_prefix));
			m.def("create_prompt", static_cast <const char*(*)(RTLIL::Design*, int)>(&create_prompt), py::arg("design"), py::arg("recursion_counter"));
			m.def("glob_filename", static_cast <std::vector<std::string>(*)(const std::string&)>(&glob_filename), py::arg("filename_pattern"));
			m.def("rewrite_filename", static_cast <void(*)(std::string&)>(&rewrite_filename), py::arg("filename"));
			m.def("run_pass", static_cast <void(*)(std::string, RTLIL::Design*)>(&run_pass), py::arg("command"), py::arg("design") = nullptr);
			m.def("run_frontend", static_cast <bool(*)(std::string, std::string, RTLIL::Design*, std::string*)>(&run_frontend), py::arg("filename"), py::arg("command"), py::arg("design") = nullptr, py::arg("from_to_label") = nullptr);
			m.def("run_backend", static_cast <void(*)(std::string, std::string, RTLIL::Design*)>(&run_backend), py::arg("filename"), py::arg("command"), py::arg("design") = nullptr);
			m.def("shell", static_cast <void(*)(RTLIL::Design*)>(&shell), py::arg("design"));
			m.def("yosys_maybe_version", static_cast <const char*(*)()>(&yosys_maybe_version));
			m.def("load_plugin", static_cast <void(*)(std::string, std::vector<std::string>)>(&load_plugin), py::arg("filename"), py::arg("aliases"));
			global_variables.def_readwrite_static("yosys_design", &yosys_design);
			global_variables.def_readwrite_static("yosys_input_files", &yosys_input_files);
			global_variables.def_readwrite_static("yosys_output_files", &yosys_output_files);
			global_variables.def_readwrite_static("yosys_version_str", &yosys_version_str);
			global_variables.def_readwrite_static("saved_designs", &saved_designs);
			global_variables.def_readwrite_static("pushed_designs", &pushed_designs);
			global_variables.def_readwrite_static("loaded_plugins", &loaded_plugins);
			global_variables.def_readwrite_static("loaded_python_plugins", &loaded_python_plugins);
			global_variables.def_readwrite_static("loaded_plugin_aliases", &loaded_plugin_aliases);
			global_variables.def_readwrite_static("yosys_share_dirname", &yosys_share_dirname);
			global_variables.def_readwrite_static("yosys_abc_executable", &yosys_abc_executable);
		}
		{ using namespace Yosys;
			global_variables.def_readwrite_static("yosys_celltypes", &yosys_celltypes);
		}
		{using namespace Yosys; py::class_<CellType>(m, "CellType")
			.def_readwrite("type", &CellType::type, py::return_value_policy::copy)
			.def_readwrite("inputs", &CellType::inputs, py::return_value_policy::copy)
			.def_readwrite("outputs", &CellType::outputs, py::return_value_policy::copy)
			.def_readwrite("is_evaluable", &CellType::is_evaluable, py::return_value_policy::copy)
			.def_readwrite("is_combinatorial", &CellType::is_combinatorial, py::return_value_policy::copy)
			.def_readwrite("is_synthesizable", &CellType::is_synthesizable, py::return_value_policy::copy)
		.def("__hash__", [](const CellType &s) { return run_hash(s.type); })
		;}
		{using namespace Yosys; py::class_<CellTypes>(m, "CellTypes")
			.def(py::init<>())
			.def(py::init<RTLIL::Design*>())
			.def("setup", static_cast <void(CellTypes::*)(RTLIL::Design*)>(&CellTypes::setup), py::arg("design") = __null)
			.def("setup_type", static_cast <void(CellTypes::*)(RTLIL::IdString, const pool<RTLIL::IdString>&, const pool<RTLIL::IdString>&, bool, bool, bool)>(&CellTypes::setup_type), py::arg("type"), py::arg("inputs"), py::arg("outputs"), py::arg("is_evaluable") = false, py::arg("is_combinatorial") = false, py::arg("is_synthesizable") = false)
			.def("setup_module", static_cast <void(CellTypes::*)(RTLIL::Module*)>(&CellTypes::setup_module), py::arg("module"))
			.def("setup_design", static_cast <void(CellTypes::*)(RTLIL::Design*)>(&CellTypes::setup_design), py::arg("design"))
			.def("setup_internals", static_cast <void(CellTypes::*)()>(&CellTypes::setup_internals))
			.def("setup_internals_eval", static_cast <void(CellTypes::*)()>(&CellTypes::setup_internals_eval))
			.def("setup_internals_ff", static_cast <void(CellTypes::*)()>(&CellTypes::setup_internals_ff))
			.def("setup_internals_anyinit", static_cast <void(CellTypes::*)()>(&CellTypes::setup_internals_anyinit))
			.def("setup_internals_mem", static_cast <void(CellTypes::*)()>(&CellTypes::setup_internals_mem))
			.def("setup_stdcells", static_cast <void(CellTypes::*)()>(&CellTypes::setup_stdcells))
			.def("setup_stdcells_eval", static_cast <void(CellTypes::*)()>(&CellTypes::setup_stdcells_eval))
			.def("setup_stdcells_mem", static_cast <void(CellTypes::*)()>(&CellTypes::setup_stdcells_mem))
			.def("clear", static_cast <void(CellTypes::*)()>(&CellTypes::clear))
			.def("cell_known", static_cast <bool(CellTypes::*)(const RTLIL::IdString&) const>(&CellTypes::cell_known), py::arg("type"))
			.def("cell_output", static_cast <bool(CellTypes::*)(const RTLIL::IdString&, const RTLIL::IdString&) const>(&CellTypes::cell_output), py::arg("type"), py::arg("port"))
			.def("cell_input", static_cast <bool(CellTypes::*)(const RTLIL::IdString&, const RTLIL::IdString&) const>(&CellTypes::cell_input), py::arg("type"), py::arg("port"))
			.def("cell_port_dir", static_cast <RTLIL::PortDir(CellTypes::*)(RTLIL::IdString, RTLIL::IdString) const>(&CellTypes::cell_port_dir), py::arg("type"), py::arg("port"))
			.def("cell_evaluable", static_cast <bool(CellTypes::*)(const RTLIL::IdString&) const>(&CellTypes::cell_evaluable), py::arg("type"))
			.def_static("eval_not", static_cast <RTLIL::Const(*)(RTLIL::Const)>(&CellTypes::eval_not), py::arg("v"))
			.def_static("eval", static_cast <RTLIL::Const(*)(RTLIL::IdString, const RTLIL::Const&, const RTLIL::Const&, bool, bool, int, bool*)>(&CellTypes::eval), py::arg("type"), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"), py::arg("errp") = nullptr)
			.def_static("eval", static_cast <RTLIL::Const(*)(RTLIL::Cell*, const RTLIL::Const&, const RTLIL::Const&, bool*)>(&CellTypes::eval), py::arg("cell"), py::arg("arg1"), py::arg("arg2"), py::arg("errp") = nullptr)
			.def_static("eval", static_cast <RTLIL::Const(*)(RTLIL::Cell*, const RTLIL::Const&, const RTLIL::Const&, const RTLIL::Const&, bool*)>(&CellTypes::eval), py::arg("cell"), py::arg("arg1"), py::arg("arg2"), py::arg("arg3"), py::arg("errp") = nullptr)
			.def_static("eval", static_cast <RTLIL::Const(*)(RTLIL::Cell*, const RTLIL::Const&, const RTLIL::Const&, const RTLIL::Const&, const RTLIL::Const&, bool*)>(&CellTypes::eval), py::arg("cell"), py::arg("arg1"), py::arg("arg2"), py::arg("arg3"), py::arg("arg4"), py::arg("errp") = nullptr)
			.def_readwrite("cell_types", &CellTypes::cell_types, py::return_value_policy::copy)
		;}
		{using namespace Yosys; py::class_<ConstEval>(m, "ConstEval")
			.def(py::init<RTLIL::Module*, RTLIL::State>())
			.def("clear", static_cast <void(ConstEval::*)()>(&ConstEval::clear))
			.def("push", static_cast <void(ConstEval::*)()>(&ConstEval::push))
			.def("pop", static_cast <void(ConstEval::*)()>(&ConstEval::pop))
			.def("set", static_cast <void(ConstEval::*)(RTLIL::SigSpec, RTLIL::Const)>(&ConstEval::set), py::arg("sig"), py::arg("value"))
			.def("stop", static_cast <void(ConstEval::*)(RTLIL::SigSpec)>(&ConstEval::stop), py::arg("sig"))
			.def("eval", static_cast <bool(ConstEval::*)(RTLIL::Cell*, RTLIL::SigSpec&)>(&ConstEval::eval), py::arg("cell"), py::arg("undef"))
			.def("eval", static_cast <bool(ConstEval::*)(RTLIL::SigSpec&, RTLIL::SigSpec&, RTLIL::Cell*)>(&ConstEval::eval), py::arg("sig"), py::arg("undef"), py::arg("busy_cell") = __null)
			.def("eval", static_cast <bool(ConstEval::*)(RTLIL::SigSpec&)>(&ConstEval::eval), py::arg("sig"))
			.def_readwrite("module", &ConstEval::module, py::return_value_policy::reference_internal)
			.def_readwrite("assign_map", &ConstEval::assign_map, py::return_value_policy::copy)
			.def_readwrite("values_map", &ConstEval::values_map, py::return_value_policy::copy)
			.def_readwrite("stop_signals", &ConstEval::stop_signals, py::return_value_policy::copy)
			.def_readwrite("sig2driver", &ConstEval::sig2driver, py::return_value_policy::copy)
			.def_readwrite("busy", &ConstEval::busy, py::return_value_policy::copy)
			.def_readwrite("stack", &ConstEval::stack, py::return_value_policy::copy)
			.def_readwrite("defaultval", &ConstEval::defaultval, py::return_value_policy::copy)
		;}
		{ using namespace Yosys;
			m.def("request_garbage_collection", static_cast <void(*)()>(&request_garbage_collection));
			m.def("try_collect_garbage", static_cast <void(*)()>(&try_collect_garbage));
			m.def("handle_extra_select_args", static_cast <void(*)(Pass*, const std::vector<std::string>&, size_t, size_t, RTLIL::Design*)>(&handle_extra_select_args), py::arg("pass"), py::arg("args"), py::arg("argidx"), py::arg("args_size"), py::arg("design"));
			m.def("eval_select_args", static_cast <RTLIL::Selection(*)(const vector<string>&, RTLIL::Design*)>(&eval_select_args), py::arg("args"), py::arg("design"));
			m.def("eval_select_op", static_cast <void(*)(vector<RTLIL::Selection>&, const string&, RTLIL::Design*)>(&eval_select_op), py::arg("work"), py::arg("op"), py::arg("design"));
			global_variables.def_readwrite_static("pass_register", &pass_register);
			global_variables.def_readwrite_static("frontend_register", &frontend_register);
			global_variables.def_readwrite_static("backend_register", &backend_register);
		}
		{ using namespace Yosys::RTLIL;
			m.def("const_not", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_not), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_and", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_and), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_or", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_or), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_xor", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_xor), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_xnor", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_xnor), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_reduce_and", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_reduce_and), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_reduce_or", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_reduce_or), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_reduce_xor", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_reduce_xor), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_reduce_xnor", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_reduce_xnor), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_reduce_bool", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_reduce_bool), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_logic_not", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_logic_not), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_logic_and", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_logic_and), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_logic_or", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_logic_or), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_shl", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_shl), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_shr", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_shr), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_sshl", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_sshl), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_sshr", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_sshr), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_shift", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_shift), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_shiftx", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_shiftx), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_lt", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_lt), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_le", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_le), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_eq", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_eq), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_ne", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_ne), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_eqx", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_eqx), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_nex", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_nex), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_ge", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_ge), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_gt", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_gt), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_add", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_add), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_sub", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_sub), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_mul", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_mul), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_div", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_div), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_divfloor", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_divfloor), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_modfloor", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_modfloor), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_mod", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_mod), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_pow", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_pow), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_pos", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_pos), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_buf", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_buf), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_neg", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, bool, bool, int)>(&const_neg), py::arg("arg1"), py::arg("arg2"), py::arg("signed1"), py::arg("signed2"), py::arg("result_len"));
			m.def("const_mux", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, const RTLIL::Const&)>(&const_mux), py::arg("arg1"), py::arg("arg2"), py::arg("arg3"));
			m.def("const_pmux", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, const RTLIL::Const&)>(&const_pmux), py::arg("arg1"), py::arg("arg2"), py::arg("arg3"));
			m.def("const_bmux", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&)>(&const_bmux), py::arg("arg1"), py::arg("arg2"));
			m.def("const_demux", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&)>(&const_demux), py::arg("arg1"), py::arg("arg2"));
			m.def("const_bweqx", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&)>(&const_bweqx), py::arg("arg1"), py::arg("arg2"));
			m.def("const_bwmux", static_cast <RTLIL::Const(*)(const RTLIL::Const&, const RTLIL::Const&, const RTLIL::Const&)>(&const_bwmux), py::arg("arg1"), py::arg("arg2"), py::arg("arg3"));
			global_variables.def_readwrite_static("constpad", &constpad);
		}
		{using namespace Yosys::RTLIL; py::native_enum<State>(m, "State", "enum.Enum")
			.value("S0", S0)
			.value("S1", S1)
			.value("Sx", Sx)
			.value("Sz", Sz)
			.value("Sa", Sa)
			.value("Sm", Sm)
			.finalize();}
		{using namespace Yosys::RTLIL; py::native_enum<SyncType>(m, "SyncType", "enum.Enum")
			.value("ST0", ST0)
			.value("ST1", ST1)
			.value("STp", STp)
			.value("STn", STn)
			.value("STe", STe)
			.value("STa", STa)
			.value("STg", STg)
			.value("STi", STi)
			.finalize();}
		{using namespace Yosys::RTLIL; py::native_enum<ConstFlags>(m, "ConstFlags", "enum.Enum")
			.value("CONST_FLAG_NONE", CONST_FLAG_NONE)
			.value("CONST_FLAG_STRING", CONST_FLAG_STRING)
			.value("CONST_FLAG_SIGNED", CONST_FLAG_SIGNED)
			.value("CONST_FLAG_REAL", CONST_FLAG_REAL)
			.value("CONST_FLAG_UNSIZED", CONST_FLAG_UNSIZED)
			.finalize();}
		{using namespace Yosys::RTLIL; py::native_enum<SelectPartials>(m, "SelectPartials", "enum.Enum")
			.value("SELECT_ALL", SELECT_ALL)
			.value("SELECT_WHOLE_ONLY", SELECT_WHOLE_ONLY)
			.value("SELECT_WHOLE_WARN", SELECT_WHOLE_WARN)
			.value("SELECT_WHOLE_ERR", SELECT_WHOLE_ERR)
			.value("SELECT_WHOLE_CMDERR", SELECT_WHOLE_CMDERR)
			.finalize();}
		{using namespace Yosys::RTLIL; py::native_enum<SelectBoxes>(m, "SelectBoxes", "enum.Enum")
			.value("SB_ALL", SB_ALL)
			.value("SB_WARN", SB_WARN)
			.value("SB_ERR", SB_ERR)
			.value("SB_CMDERR", SB_CMDERR)
			.value("SB_UNBOXED_ONLY", SB_UNBOXED_ONLY)
			.value("SB_UNBOXED_WARN", SB_UNBOXED_WARN)
			.value("SB_UNBOXED_ERR", SB_UNBOXED_ERR)
			.value("SB_UNBOXED_CMDERR", SB_UNBOXED_CMDERR)
			.value("SB_INCL_WB", SB_INCL_WB)
			.value("SB_EXCL_BB_ONLY", SB_EXCL_BB_ONLY)
			.value("SB_EXCL_BB_WARN", SB_EXCL_BB_WARN)
			.value("SB_EXCL_BB_ERR", SB_EXCL_BB_ERR)
			.value("SB_EXCL_BB_CMDERR", SB_EXCL_BB_CMDERR)
			.finalize();}
		{using namespace Yosys::RTLIL; py::native_enum<StaticId>(m, "StaticId", "enum.Enum")
			.value("STATIC_ID_BEGIN", StaticId::STATIC_ID_BEGIN)
			.value("STATIC_ID_END", StaticId::STATIC_ID_END)
			.finalize();}
		{using namespace Yosys::RTLIL; py::native_enum<PortDir>(m, "PortDir", "enum.Enum")
			.value("PD_UNKNOWN", PD_UNKNOWN)
			.value("PD_INPUT", PD_INPUT)
			.value("PD_OUTPUT", PD_OUTPUT)
			.value("PD_INOUT", PD_INOUT)
			.finalize();}
		{ using namespace Yosys::RTLIL_BACKEND;
			m.def("dump_wire", static_cast <void(*)(std::ostream&, std::string, const RTLIL::Wire*)>(&dump_wire), py::arg("f"), py::arg("indent"), py::arg("wire"));
		}
		{ using namespace Yosys;
			m.def("lookup_well_known_id", static_cast <int(*)(std::string_view)>(&lookup_well_known_id), py::arg("name"));
			m.def("GetSize", static_cast <int(*)(RTLIL::Wire*)>(&GetSize), py::arg("wire"));
		}
		{using namespace Yosys::RTLIL; py::class_<IdString>(m, "IdString")
			.def_static("refcount", static_cast <int(*)(int)>(&IdString::refcount), py::arg("idx"))
			.def_static("xtrace_db_dump", static_cast <void(*)()>(&IdString::xtrace_db_dump))
			.def_static("checkpoint", static_cast <void(*)()>(&IdString::checkpoint))
			.def_static("insert", static_cast <int(*)(std::string_view)>(&IdString::insert), py::arg("p"))
			.def_static("new_autoidx_with_prefix", static_cast <IdString(*)(const std::string*)>(&IdString::new_autoidx_with_prefix), py::arg("prefix"))
			.def(py::init<>())
			.def(py::init<const char*>())
			.def(py::init<const IdString&>())
			.def(py::init<const std::string&>())
			.def(py::init<std::string_view>())
			.def(py::init<StaticId>())
			.def("id_string", static_cast <const IdString&(IdString::*)() const>(&IdString::id_string))
			.def("c_str", static_cast <const char*(IdString::*)() const>(&IdString::c_str))
			.def("str", static_cast <std::string(IdString::*)() const>(&IdString::str))
			.def("append_to", static_cast <void(IdString::*)(std::string*) const>(&IdString::append_to), py::arg("out"))
			.def("begin", static_cast <IdString::const_iterator(IdString::*)() const>(&IdString::begin))
			.def("end", static_cast <IdString::const_iterator(IdString::*)() const>(&IdString::end))
			.def("lt_by_name", static_cast <bool(IdString::*)(const IdString&) const>(&IdString::lt_by_name), py::arg("rhs"))
			.def("__lt__", static_cast <bool(IdString::*)(const IdString&) const>(&IdString::operator<), py::arg("rhs"))
			.def("__eq__", static_cast <bool(IdString::*)(const IdString&) const>(&IdString::operator==), py::arg("rhs"))
			.def("__ne__", static_cast <bool(IdString::*)(const IdString&) const>(&IdString::operator!=), py::arg("rhs"))
			.def("__eq__", static_cast <bool(IdString::*)(const std::string&) const>(&IdString::operator==), py::arg("rhs"))
			.def("__ne__", static_cast <bool(IdString::*)(const std::string&) const>(&IdString::operator!=), py::arg("rhs"))
			.def("__eq__", static_cast <bool(IdString::*)(const char*) const>(&IdString::operator==), py::arg("rhs"))
			.def("__ne__", static_cast <bool(IdString::*)(const char*) const>(&IdString::operator!=), py::arg("rhs"))
			.def("__getitem__", static_cast <char(IdString::*)(size_t) const>(&IdString::operator[]), py::arg("i"))
			.def("substr", static_cast <std::string(IdString::*)(size_t, size_t) const>(&IdString::substr), py::arg("pos") = 0, py::arg("len") = std::string::npos)
			.def("compare", static_cast <int(IdString::*)(size_t, size_t, const char*) const>(&IdString::compare), py::arg("pos"), py::arg("len"), py::arg("s"))
			.def("begins_with", static_cast <bool(IdString::*)(std::string_view) const>(&IdString::begins_with), py::arg("prefix"))
			.def("ends_with", static_cast <bool(IdString::*)(std::string_view) const>(&IdString::ends_with), py::arg("suffix"))
			.def("contains", static_cast <bool(IdString::*)(std::string_view) const>(&IdString::contains), py::arg("s"))
			.def("size", static_cast <size_t(IdString::*)() const>(&IdString::size))
			.def("empty", static_cast <bool(IdString::*)() const>(&IdString::empty))
			.def("clear", static_cast <void(IdString::*)()>(&IdString::clear))
			.def("hash_into", static_cast <Hasher(IdString::*)(Hasher) const>(&IdString::hash_into), py::arg("h"))
			.def("hash_top", static_cast <Hasher(IdString::*)() const>(&IdString::hash_top))
			.def("in_", static_cast <bool(IdString::*)(const IdString&) const>(&IdString::in), py::arg("rhs"))
			.def("in_", static_cast <bool(IdString::*)(const char*) const>(&IdString::in), py::arg("rhs"))
			.def("in_", static_cast <bool(IdString::*)(const std::string&) const>(&IdString::in), py::arg("rhs"))
			.def("in_", static_cast <bool(IdString::*)(const pool<IdString>&) const>(&IdString::in), py::arg("rhs"))
			.def("isPublic", static_cast <bool(IdString::*)() const>(&IdString::isPublic))
			.def_static("ensure_prepopulated", static_cast <void(*)()>(&IdString::ensure_prepopulated))
			.def_readwrite_static("destruct_guard_ok", &IdString::destruct_guard_ok, py::return_value_policy::copy)
			.def_readwrite_static("destruct_guard", &IdString::destruct_guard, py::return_value_policy::copy)
			.def_readwrite("index_", &IdString::index_, py::return_value_policy::copy)
		.def("__str__", [](const IdString &s) { return s.str(); })
		.def("__repr__", [](const IdString &s) { std::stringstream ss; ss << "<IdString " << s.str() << ">"; return ss.str(); })
		.def("__hash__", [](const IdString &s) { return run_hash(s.str()); })
		;}
		{using namespace Yosys::RTLIL; py::class_<Const>(m, "Const")
			.def(py::init<>())
			.def(py::init<std::string>())
			.def(py::init<long long>())
			.def(py::init<long long, int>())
			.def(py::init<RTLIL::State, int>())
			.def(py::init<std::vector<RTLIL::State>>())
			.def(py::init<const std::vector<bool>&>())
			.def(py::init<const RTLIL::Const&>())
			.def("__lt__", static_cast <bool(Const::*)(const RTLIL::Const&) const>(&Const::operator<), py::arg("other"))
			.def("__eq__", static_cast <bool(Const::*)(const RTLIL::Const&) const>(&Const::operator==), py::arg("other"))
			.def("__ne__", static_cast <bool(Const::*)(const RTLIL::Const&) const>(&Const::operator!=), py::arg("other"))
			.def("as_bool", static_cast <bool(Const::*)() const>(&Const::as_bool))
			.def("as_int", static_cast <int(Const::*)(bool) const>(&Const::as_int), py::arg("is_signed") = false)
			.def("convertible_to_int", static_cast <bool(Const::*)(bool) const>(&Const::convertible_to_int), py::arg("is_signed") = false)
			.def("try_as_int", static_cast <std::optional<int>(Const::*)(bool) const>(&Const::try_as_int), py::arg("is_signed") = false)
			.def("as_int_saturating", static_cast <int(Const::*)(bool) const>(&Const::as_int_saturating), py::arg("is_signed") = false)
			.def("as_string", static_cast <std::string(Const::*)(const char*) const>(&Const::as_string), py::arg("any") = "-")
			.def_static("from_string", static_cast <Const(*)(const std::string&)>(&Const::from_string), py::arg("str"))
			.def("to_bits", static_cast <std::vector<RTLIL::State>(Const::*)() const>(&Const::to_bits))
			.def("decode_string", static_cast <std::string(Const::*)() const>(&Const::decode_string))
			.def("size", static_cast <int(Const::*)() const>(&Const::size))
			.def("empty", static_cast <bool(Const::*)() const>(&Const::empty))
			.def("append", static_cast <void(Const::*)(const RTLIL::Const&)>(&Const::append), py::arg("other"))
			.def("set", static_cast <void(Const::*)(int, RTLIL::State)>(&Const::set), py::arg("i"), py::arg("state"))
			.def("resize", static_cast <void(Const::*)(int, RTLIL::State)>(&Const::resize), py::arg("size"), py::arg("fill"))
			.def("begin", static_cast <Const::const_iterator(Const::*)() const>(&Const::begin))
			.def("end", static_cast <Const::const_iterator(Const::*)() const>(&Const::end))
			.def("begin", static_cast <Const::iterator(Const::*)()>(&Const::begin))
			.def("end", static_cast <Const::iterator(Const::*)()>(&Const::end))
			.def("back", static_cast <State(Const::*)() const>(&Const::back))
			.def("front", static_cast <State(Const::*)() const>(&Const::front))
			.def("at", static_cast <State(Const::*)(size_t) const>(&Const::at), py::arg("i"))
			.def("__getitem__", static_cast <State(Const::*)(size_t) const>(&Const::operator[]), py::arg("i"))
			.def("is_fully_zero", static_cast <bool(Const::*)() const>(&Const::is_fully_zero))
			.def("is_fully_ones", static_cast <bool(Const::*)() const>(&Const::is_fully_ones))
			.def("is_fully_def", static_cast <bool(Const::*)() const>(&Const::is_fully_def))
			.def("is_fully_undef", static_cast <bool(Const::*)() const>(&Const::is_fully_undef))
			.def("is_fully_undef_x_only", static_cast <bool(Const::*)() const>(&Const::is_fully_undef_x_only))
			.def("is_onehot", static_cast <bool(Const::*)(int*) const>(&Const::is_onehot), py::arg("pos") = nullptr)
			.def("extract", static_cast <RTLIL::Const(Const::*)(int, int, RTLIL::State) const>(&Const::extract), py::arg("offset"), py::arg("len") = 1, py::arg("padding") = RTLIL::State::S0)
			.def("get_min_size", static_cast <int(Const::*)(bool) const>(&Const::get_min_size), py::arg("is_signed"))
			.def("compress", static_cast <void(Const::*)(bool)>(&Const::compress), py::arg("is_signed") = false)
			.def("as_int_compress", static_cast <std::optional<int>(Const::*)(bool) const>(&Const::as_int_compress), py::arg("is_signed"))
			.def("extu", static_cast <void(Const::*)(int)>(&Const::extu), py::arg("width"))
			.def("exts", static_cast <void(Const::*)(int)>(&Const::exts), py::arg("width"))
			.def("hash_into", static_cast <Hasher(Const::*)(Hasher) const>(&Const::hash_into), py::arg("h"))
			.def_readwrite("flags", &Const::flags, py::return_value_policy::copy)
		.def("__str__", [](const Const &s) { return s.as_string(); })
		.def("__repr__", [](const Const &s) { std::stringstream ss; ss << "<Const " << s.as_string() << ">"; return ss.str(); })
		;}
		{using namespace Yosys::RTLIL; py::class_<AttrObject>(m, "AttrObject")
			.def("has_attribute", static_cast <bool(AttrObject::*)(const RTLIL::IdString&) const>(&AttrObject::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(AttrObject::*)(const RTLIL::IdString&, bool)>(&AttrObject::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(AttrObject::*)(const RTLIL::IdString&) const>(&AttrObject::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(AttrObject::*)(const RTLIL::IdString&, string)>(&AttrObject::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(AttrObject::*)(const RTLIL::IdString&) const>(&AttrObject::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(AttrObject::*)(const RTLIL::IdString&, const pool<string>&)>(&AttrObject::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(AttrObject::*)(const RTLIL::IdString&, const pool<string>&)>(&AttrObject::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(AttrObject::*)(const RTLIL::IdString&) const>(&AttrObject::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(AttrObject::*)(const std::string&)>(&AttrObject::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(AttrObject::*)() const>(&AttrObject::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(AttrObject::*)(const vector<string>&)>(&AttrObject::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(AttrObject::*)() const>(&AttrObject::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(AttrObject::*)(const RTLIL::IdString&, const vector<int>&)>(&AttrObject::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(AttrObject::*)(const RTLIL::IdString&) const>(&AttrObject::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &AttrObject::attributes, py::return_value_policy::copy)
		;}
		{using namespace Yosys::RTLIL; py::class_<NamedObject>(m, "NamedObject")
			.def_readwrite("name", &NamedObject::name, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(NamedObject::*)(const RTLIL::IdString&) const>(&NamedObject::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(NamedObject::*)(const RTLIL::IdString&, bool)>(&NamedObject::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(NamedObject::*)(const RTLIL::IdString&) const>(&NamedObject::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(NamedObject::*)(const RTLIL::IdString&, string)>(&NamedObject::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(NamedObject::*)(const RTLIL::IdString&) const>(&NamedObject::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(NamedObject::*)(const RTLIL::IdString&, const pool<string>&)>(&NamedObject::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(NamedObject::*)(const RTLIL::IdString&, const pool<string>&)>(&NamedObject::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(NamedObject::*)(const RTLIL::IdString&) const>(&NamedObject::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(NamedObject::*)(const std::string&)>(&NamedObject::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(NamedObject::*)() const>(&NamedObject::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(NamedObject::*)(const vector<string>&)>(&NamedObject::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(NamedObject::*)() const>(&NamedObject::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(NamedObject::*)(const RTLIL::IdString&, const vector<int>&)>(&NamedObject::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(NamedObject::*)(const RTLIL::IdString&) const>(&NamedObject::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &NamedObject::attributes, py::return_value_policy::copy)
		;}
		{using namespace Yosys::RTLIL; py::class_<SigChunk>(m, "SigChunk")
			.def(py::init<>())
			.def(py::init<const RTLIL::Const&>())
			.def(py::init<RTLIL::Wire*>())
			.def(py::init<RTLIL::Wire*, int, int>())
			.def(py::init<const std::string&>())
			.def(py::init<int>())
			.def(py::init<int, int>())
			.def(py::init<RTLIL::State, int>())
			.def(py::init<const RTLIL::SigBit&>())
			.def("extract", static_cast <RTLIL::SigChunk(SigChunk::*)(int, int) const>(&SigChunk::extract), py::arg("offset"), py::arg("length"))
			.def("__getitem__", static_cast <RTLIL::SigBit(SigChunk::*)(int) const>(&SigChunk::operator[]), py::arg("offset"))
			.def("size", static_cast <int(SigChunk::*)() const>(&SigChunk::size))
			.def("is_wire", static_cast <bool(SigChunk::*)() const>(&SigChunk::is_wire))
			.def("__lt__", static_cast <bool(SigChunk::*)(const RTLIL::SigChunk&) const>(&SigChunk::operator<), py::arg("other"))
			.def("__eq__", static_cast <bool(SigChunk::*)(const RTLIL::SigChunk&) const>(&SigChunk::operator==), py::arg("other"))
			.def("__ne__", static_cast <bool(SigChunk::*)(const RTLIL::SigChunk&) const>(&SigChunk::operator!=), py::arg("other"))
			.def_readwrite("wire", &SigChunk::wire, py::return_value_policy::reference_internal)
			.def_readwrite("data", &SigChunk::data, py::return_value_policy::copy)
			.def_readwrite("width", &SigChunk::width, py::return_value_policy::copy)
			.def_readwrite("offset", &SigChunk::offset, py::return_value_policy::copy)
		;}
		{using namespace Yosys::RTLIL; py::class_<SigBit>(m, "SigBit")
			.def(py::init<>())
			.def(py::init<RTLIL::State>())
			.def(py::init<bool>())
			.def(py::init<RTLIL::Wire*>())
			.def(py::init<RTLIL::Wire*, int>())
			.def(py::init<const RTLIL::SigChunk&>())
			.def(py::init<const RTLIL::SigChunk&, int>())
			.def(py::init<const RTLIL::SigSpec&>())
			.def(py::init<const RTLIL::SigBit&>())
			.def("is_wire", static_cast <bool(SigBit::*)() const>(&SigBit::is_wire))
			.def("__lt__", static_cast <bool(SigBit::*)(const RTLIL::SigBit&) const>(&SigBit::operator<), py::arg("other"))
			.def("__eq__", static_cast <bool(SigBit::*)(const RTLIL::SigBit&) const>(&SigBit::operator==), py::arg("other"))
			.def("__ne__", static_cast <bool(SigBit::*)(const RTLIL::SigBit&) const>(&SigBit::operator!=), py::arg("other"))
			.def("hash_into", static_cast <Hasher(SigBit::*)(Hasher) const>(&SigBit::hash_into), py::arg("h"))
			.def("hash_top", static_cast <Hasher(SigBit::*)() const>(&SigBit::hash_top))
			.def_readwrite("wire", &SigBit::wire, py::return_value_policy::reference_internal)
			.def_readwrite("data", &SigBit::data, py::return_value_policy::copy)
			.def_readwrite("offset", &SigBit::offset, py::return_value_policy::copy)
		.def("__hash__", [](const SigBit &s) { return run_hash(s); })
		;}
		{using namespace Yosys::RTLIL; py::class_<SigSpec>(m, "SigSpec")
			.def(py::init<>())
			.def(py::init<std::initializer_list<RTLIL::SigSpec>>())
			.def(py::init<const SigSpec&>())
			.def(py::init<const RTLIL::Const&>())
			.def(py::init<const RTLIL::SigChunk&>())
			.def(py::init<RTLIL::Wire*>())
			.def(py::init<RTLIL::Wire*, int, int>())
			.def(py::init<const std::string&>())
			.def(py::init<int, int>())
			.def(py::init<RTLIL::State, int>())
			.def(py::init<const RTLIL::SigBit&, int>())
			.def(py::init<const std::vector<RTLIL::SigChunk>&>())
			.def(py::init<const std::vector<RTLIL::SigBit>&>())
			.def(py::init<const pool<RTLIL::SigBit>&>())
			.def(py::init<const std::set<RTLIL::SigBit>&>())
			.def(py::init<bool>())
			.def("bits", static_cast <const SigSpec&(SigSpec::*)() const>(&SigSpec::bits))
			.def("size", static_cast <int(SigSpec::*)() const>(&SigSpec::size))
			.def("empty", static_cast <bool(SigSpec::*)() const>(&SigSpec::empty))
			.def("__getitem__", static_cast <RTLIL::SigBit(SigSpec::*)(int) const>(&SigSpec::operator[]), py::arg("index"))
			.def("begin", static_cast <RTLIL::SigSpecIterator(SigSpec::*)()>(&SigSpec::begin))
			.def("end", static_cast <RTLIL::SigSpecIterator(SigSpec::*)()>(&SigSpec::end))
			.def("begin", static_cast <RTLIL::SigSpecConstIterator(SigSpec::*)() const>(&SigSpec::begin))
			.def("end", static_cast <RTLIL::SigSpecConstIterator(SigSpec::*)() const>(&SigSpec::end))
			.def("sort", static_cast <void(SigSpec::*)()>(&SigSpec::sort))
			.def("sort_and_unify", static_cast <void(SigSpec::*)()>(&SigSpec::sort_and_unify))
			.def("replace", static_cast <void(SigSpec::*)(const RTLIL::SigSpec&, const RTLIL::SigSpec&)>(&SigSpec::replace), py::arg("pattern"), py::arg("with"))
			.def("replace", static_cast <void(SigSpec::*)(const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::SigSpec*) const>(&SigSpec::replace), py::arg("pattern"), py::arg("with"), py::arg("other"))
			.def("replace", static_cast <void(SigSpec::*)(const dict<RTLIL::SigBit, RTLIL::SigBit>&)>(&SigSpec::replace), py::arg("rules"))
			.def("replace", static_cast <void(SigSpec::*)(const dict<RTLIL::SigBit, RTLIL::SigBit>&, RTLIL::SigSpec*) const>(&SigSpec::replace), py::arg("rules"), py::arg("other"))
			.def("replace", static_cast <void(SigSpec::*)(const std::map<RTLIL::SigBit, RTLIL::SigBit>&)>(&SigSpec::replace), py::arg("rules"))
			.def("replace", static_cast <void(SigSpec::*)(const std::map<RTLIL::SigBit, RTLIL::SigBit>&, RTLIL::SigSpec*) const>(&SigSpec::replace), py::arg("rules"), py::arg("other"))
			.def("replace", static_cast <void(SigSpec::*)(int, const RTLIL::SigSpec&)>(&SigSpec::replace), py::arg("offset"), py::arg("with"))
			.def("remove", static_cast <void(SigSpec::*)(const RTLIL::SigSpec&)>(&SigSpec::remove), py::arg("pattern"))
			.def("remove", static_cast <void(SigSpec::*)(const RTLIL::SigSpec&, RTLIL::SigSpec*) const>(&SigSpec::remove), py::arg("pattern"), py::arg("other"))
			.def("remove2", static_cast <void(SigSpec::*)(const RTLIL::SigSpec&, RTLIL::SigSpec*)>(&SigSpec::remove2), py::arg("pattern"), py::arg("other"))
			.def("remove", static_cast <void(SigSpec::*)(const pool<RTLIL::SigBit>&)>(&SigSpec::remove), py::arg("pattern"))
			.def("remove", static_cast <void(SigSpec::*)(const pool<RTLIL::SigBit>&, RTLIL::SigSpec*) const>(&SigSpec::remove), py::arg("pattern"), py::arg("other"))
			.def("remove2", static_cast <void(SigSpec::*)(const pool<RTLIL::SigBit>&, RTLIL::SigSpec*)>(&SigSpec::remove2), py::arg("pattern"), py::arg("other"))
			.def("remove2", static_cast <void(SigSpec::*)(const std::set<RTLIL::SigBit>&, RTLIL::SigSpec*)>(&SigSpec::remove2), py::arg("pattern"), py::arg("other"))
			.def("remove2", static_cast <void(SigSpec::*)(const pool<RTLIL::Wire*>&, RTLIL::SigSpec*)>(&SigSpec::remove2), py::arg("pattern"), py::arg("other"))
			.def("remove", static_cast <void(SigSpec::*)(int, int)>(&SigSpec::remove), py::arg("offset"), py::arg("length") = 1)
			.def("remove_const", static_cast <void(SigSpec::*)()>(&SigSpec::remove_const))
			.def("extract", static_cast <RTLIL::SigSpec(SigSpec::*)(const RTLIL::SigSpec&, const RTLIL::SigSpec*) const>(&SigSpec::extract), py::arg("pattern"), py::arg("other") = __null)
			.def("extract", static_cast <RTLIL::SigSpec(SigSpec::*)(const pool<RTLIL::SigBit>&, const RTLIL::SigSpec*) const>(&SigSpec::extract), py::arg("pattern"), py::arg("other") = __null)
			.def("extract", static_cast <RTLIL::SigSpec(SigSpec::*)(int, int) const>(&SigSpec::extract), py::arg("offset"), py::arg("length") = 1)
			.def("extract_end", static_cast <RTLIL::SigSpec(SigSpec::*)(int) const>(&SigSpec::extract_end), py::arg("offset"))
			.def("rewrite_wires", static_cast <void(SigSpec::*)(std::function<void (RTLIL::Wire*& wire)>)>(&SigSpec::rewrite_wires), py::arg("rewrite"))
			.def("lsb", static_cast <RTLIL::SigBit(SigSpec::*)() const>(&SigSpec::lsb))
			.def("msb", static_cast <RTLIL::SigBit(SigSpec::*)() const>(&SigSpec::msb))
			.def("front", static_cast <RTLIL::SigBit(SigSpec::*)() const>(&SigSpec::front))
			.def("back", static_cast <RTLIL::SigBit(SigSpec::*)() const>(&SigSpec::back))
			.def("append", static_cast <void(SigSpec::*)(const RTLIL::SigSpec&)>(&SigSpec::append), py::arg("signal"))
			.def("append", static_cast <void(SigSpec::*)(Wire*)>(&SigSpec::append), py::arg("wire"))
			.def("append", static_cast <void(SigSpec::*)(const RTLIL::SigChunk&)>(&SigSpec::append), py::arg("chunk"))
			.def("append", static_cast <void(SigSpec::*)(const RTLIL::Const&)>(&SigSpec::append), py::arg("const_"))
			.def("append", static_cast <void(SigSpec::*)(const RTLIL::SigBit&)>(&SigSpec::append), py::arg("bit"))
			.def("append", static_cast <void(SigSpec::*)(RTLIL::State)>(&SigSpec::append), py::arg("state"))
			.def("append", static_cast <void(SigSpec::*)(bool)>(&SigSpec::append), py::arg("bool_"))
			.def("extend_u0", static_cast <void(SigSpec::*)(int, bool)>(&SigSpec::extend_u0), py::arg("width"), py::arg("is_signed") = false)
			.def("repeat", static_cast <RTLIL::SigSpec(SigSpec::*)(int) const>(&SigSpec::repeat), py::arg("num"))
			.def("reverse", static_cast <void(SigSpec::*)()>(&SigSpec::reverse))
			.def("__lt__", static_cast <bool(SigSpec::*)(const RTLIL::SigSpec&) const>(&SigSpec::operator<), py::arg("other"))
			.def("__eq__", static_cast <bool(SigSpec::*)(const RTLIL::SigSpec&) const>(&SigSpec::operator==), py::arg("other"))
			.def("__ne__", static_cast <bool(SigSpec::*)(const RTLIL::SigSpec&) const>(&SigSpec::operator!=), py::arg("other"))
			.def("is_wire", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_wire))
			.def("is_chunk", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_chunk))
			.def("is_bit", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_bit))
			.def("known_driver", static_cast <bool(SigSpec::*)() const>(&SigSpec::known_driver))
			.def("is_fully_const", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_fully_const))
			.def("is_fully_zero", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_fully_zero))
			.def("is_fully_ones", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_fully_ones))
			.def("is_fully_def", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_fully_def))
			.def("is_fully_undef", static_cast <bool(SigSpec::*)() const>(&SigSpec::is_fully_undef))
			.def("has_const", static_cast <bool(SigSpec::*)() const>(&SigSpec::has_const))
			.def("has_const", static_cast <bool(SigSpec::*)(State) const>(&SigSpec::has_const), py::arg("state"))
			.def("has_marked_bits", static_cast <bool(SigSpec::*)() const>(&SigSpec::has_marked_bits))
			.def("is_onehot", static_cast <bool(SigSpec::*)(int*) const>(&SigSpec::is_onehot), py::arg("pos") = nullptr)
			.def("as_bool", static_cast <bool(SigSpec::*)() const>(&SigSpec::as_bool))
			.def("as_int", static_cast <int(SigSpec::*)(bool) const>(&SigSpec::as_int), py::arg("is_signed") = false)
			.def("convertible_to_int", static_cast <bool(SigSpec::*)(bool) const>(&SigSpec::convertible_to_int), py::arg("is_signed") = false)
			.def("try_as_int", static_cast <std::optional<int>(SigSpec::*)(bool) const>(&SigSpec::try_as_int), py::arg("is_signed") = false)
			.def("as_int_saturating", static_cast <int(SigSpec::*)(bool) const>(&SigSpec::as_int_saturating), py::arg("is_signed") = false)
			.def("as_string", static_cast <std::string(SigSpec::*)() const>(&SigSpec::as_string))
			.def("try_as_const", static_cast <std::optional<RTLIL::Const>(SigSpec::*)() const>(&SigSpec::try_as_const))
			.def("as_const", static_cast <RTLIL::Const(SigSpec::*)() const>(&SigSpec::as_const))
			.def("as_wire", static_cast <RTLIL::Wire*(SigSpec::*)() const>(&SigSpec::as_wire))
			.def("as_chunk", static_cast <RTLIL::SigChunk(SigSpec::*)() const>(&SigSpec::as_chunk))
			.def("as_bit", static_cast <RTLIL::SigBit(SigSpec::*)() const>(&SigSpec::as_bit))
			.def("match", static_cast <bool(SigSpec::*)(const char*) const>(&SigSpec::match), py::arg("pattern"))
			.def("to_sigbit_set", static_cast <std::set<RTLIL::SigBit>(SigSpec::*)() const>(&SigSpec::to_sigbit_set))
			.def("to_sigbit_pool", static_cast <pool<RTLIL::SigBit>(SigSpec::*)() const>(&SigSpec::to_sigbit_pool))
			.def("to_sigbit_vector", static_cast <std::vector<RTLIL::SigBit>(SigSpec::*)() const>(&SigSpec::to_sigbit_vector))
			.def("to_sigbit_map", static_cast <std::map<RTLIL::SigBit, RTLIL::SigBit>(SigSpec::*)(const RTLIL::SigSpec&) const>(&SigSpec::to_sigbit_map), py::arg("other"))
			.def("to_sigbit_dict", static_cast <dict<RTLIL::SigBit, RTLIL::SigBit>(SigSpec::*)(const RTLIL::SigSpec&) const>(&SigSpec::to_sigbit_dict), py::arg("other"))
			.def_static("parse", static_cast <bool(*)(RTLIL::SigSpec&, RTLIL::Module*, std::string)>(&SigSpec::parse), py::arg("sig"), py::arg("module"), py::arg("str"))
			.def_static("parse_sel", static_cast <bool(*)(RTLIL::SigSpec&, RTLIL::Design*, RTLIL::Module*, std::string)>(&SigSpec::parse_sel), py::arg("sig"), py::arg("design"), py::arg("module"), py::arg("str"))
			.def_static("parse_rhs", static_cast <bool(*)(const RTLIL::SigSpec&, RTLIL::SigSpec&, RTLIL::Module*, std::string)>(&SigSpec::parse_rhs), py::arg("lhs"), py::arg("sig"), py::arg("module"), py::arg("str"))
			.def("at", static_cast <const RTLIL::SigBit&(SigSpec::*)(int, const RTLIL::SigBit&)>(&SigSpec::at), py::arg("offset"), py::arg("defval"))
			.def("at", static_cast <RTLIL::SigBit&(SigSpec::*)(int)>(&SigSpec::at), py::arg("offset"))
			.def("at", static_cast <RTLIL::SigBit(SigSpec::*)(int) const>(&SigSpec::at), py::arg("offset"))
			.def("hash_into", static_cast <Hasher(SigSpec::*)(Hasher) const>(&SigSpec::hash_into), py::arg("h"))
			.def("check", static_cast <void(SigSpec::*)(Module*) const>(&SigSpec::check), py::arg("mod") = nullptr)
		.def("__hash__", [](const SigSpec &s) { return run_hash(s); })
		;}
		{using namespace Yosys::RTLIL; py::class_<Selection>(m, "Selection")
			.def(py::init<bool, bool, RTLIL::Design*>())
			.def("boxed_module", static_cast <bool(Selection::*)(const RTLIL::IdString&) const>(&Selection::boxed_module), py::arg("mod_name"))
			.def("selected_module", static_cast <bool(Selection::*)(const RTLIL::IdString&) const>(&Selection::selected_module), py::arg("mod_name"))
			.def("selected_whole_module", static_cast <bool(Selection::*)(const RTLIL::IdString&) const>(&Selection::selected_whole_module), py::arg("mod_name"))
			.def("selected_member", static_cast <bool(Selection::*)(const RTLIL::IdString&, const RTLIL::IdString&) const>(&Selection::selected_member), py::arg("mod_name"), py::arg("memb_name"))
			.def("optimize", static_cast <void(Selection::*)(RTLIL::Design*)>(&Selection::optimize), py::arg("design"))
			.def("selects_all", static_cast <bool(Selection::*)() const>(&Selection::selects_all))
			.def("empty", static_cast <bool(Selection::*)() const>(&Selection::empty))
			.def("clear", static_cast <void(Selection::*)()>(&Selection::clear))
			.def_static("EmptySelection", static_cast <Selection(*)(RTLIL::Design*)>(&Selection::EmptySelection), py::arg("design") = nullptr)
			.def_static("FullSelection", static_cast <Selection(*)(RTLIL::Design*)>(&Selection::FullSelection), py::arg("design") = nullptr)
			.def_static("CompleteSelection", static_cast <Selection(*)(RTLIL::Design*)>(&Selection::CompleteSelection), py::arg("design") = nullptr)
			.def_readwrite("selects_boxes", &Selection::selects_boxes, py::return_value_policy::copy)
			.def_readwrite("complete_selection", &Selection::complete_selection, py::return_value_policy::copy)
			.def_readwrite("full_selection", &Selection::full_selection, py::return_value_policy::copy)
			.def_readwrite("selected_modules", &Selection::selected_modules, py::return_value_policy::copy)
			.def_readwrite("selected_members", &Selection::selected_members, py::return_value_policy::copy)
			.def_readwrite("current_design", &Selection::current_design, py::return_value_policy::reference_internal)
		;}
		{using namespace Yosys::RTLIL; py::class_<Design>(m, "Design")
			.def("hash_into", static_cast <Hasher(Design::*)(Hasher) const>(&Design::hash_into), py::arg("h"))
			.def("bufNormalize", static_cast <void(Design::*)(bool)>(&Design::bufNormalize), py::arg("enable") = true)
			.def(py::init<>())
			.def("modules", static_cast <RTLIL::ObjRange<RTLIL::Module*>(Design::*)()>(&Design::modules))
			.def("module", static_cast <RTLIL::Module*(Design::*)(const RTLIL::IdString&)>(&Design::module), py::arg("name"))
			.def("module", static_cast <const RTLIL::Module*(Design::*)(const RTLIL::IdString&) const>(&Design::module), py::arg("name"))
			.def("top_module", static_cast <RTLIL::Module*(Design::*)() const>(&Design::top_module))
			.def("has", static_cast <bool(Design::*)(const RTLIL::IdString&) const>(&Design::has), py::arg("id"))
			.def("add", static_cast <void(Design::*)(RTLIL::Module*)>(&Design::add), py::arg("module"))
			.def("add", static_cast <void(Design::*)(RTLIL::Binding*)>(&Design::add), py::arg("binding"))
			.def("addModule", static_cast <RTLIL::Module*(Design::*)(RTLIL::IdString)>(&Design::addModule), py::arg("name"))
			.def("remove", static_cast <void(Design::*)(RTLIL::Module*)>(&Design::remove), py::arg("module"))
			.def("rename", static_cast <void(Design::*)(RTLIL::Module*, RTLIL::IdString)>(&Design::rename), py::arg("module"), py::arg("new_name"))
			.def("scratchpad_unset", static_cast <void(Design::*)(const std::string&)>(&Design::scratchpad_unset), py::arg("varname"))
			.def("scratchpad_set_int", static_cast <void(Design::*)(const std::string&, int)>(&Design::scratchpad_set_int), py::arg("varname"), py::arg("value"))
			.def("scratchpad_set_bool", static_cast <void(Design::*)(const std::string&, bool)>(&Design::scratchpad_set_bool), py::arg("varname"), py::arg("value"))
			.def("scratchpad_set_string", static_cast <void(Design::*)(const std::string&, std::string)>(&Design::scratchpad_set_string), py::arg("varname"), py::arg("value"))
			.def("scratchpad_get_int", static_cast <int(Design::*)(const std::string&, int) const>(&Design::scratchpad_get_int), py::arg("varname"), py::arg("default_value") = 0)
			.def("scratchpad_get_bool", static_cast <bool(Design::*)(const std::string&, bool) const>(&Design::scratchpad_get_bool), py::arg("varname"), py::arg("default_value") = false)
			.def("scratchpad_get_string", static_cast <std::string(Design::*)(const std::string&, const std::string&) const>(&Design::scratchpad_get_string), py::arg("varname"), py::arg("default_value") = std::string ())
			.def("sort", static_cast <void(Design::*)()>(&Design::sort))
			.def("sort_modules", static_cast <void(Design::*)()>(&Design::sort_modules))
			.def("check", static_cast <void(Design::*)()>(&Design::check))
			.def("optimize", static_cast <void(Design::*)()>(&Design::optimize))
			.def("selected_module", static_cast <bool(Design::*)(const RTLIL::IdString&) const>(&Design::selected_module), py::arg("mod_name"))
			.def("selected_whole_module", static_cast <bool(Design::*)(const RTLIL::IdString&) const>(&Design::selected_whole_module), py::arg("mod_name"))
			.def("selected_member", static_cast <bool(Design::*)(const RTLIL::IdString&, const RTLIL::IdString&) const>(&Design::selected_member), py::arg("mod_name"), py::arg("memb_name"))
			.def("selected_module", static_cast <bool(Design::*)(RTLIL::Module*) const>(&Design::selected_module), py::arg("mod"))
			.def("selected_whole_module", static_cast <bool(Design::*)(RTLIL::Module*) const>(&Design::selected_whole_module), py::arg("mod"))
			.def("push_selection", static_cast <void(Design::*)(RTLIL::Selection)>(&Design::push_selection), py::arg("sel"))
			.def("push_empty_selection", static_cast <void(Design::*)()>(&Design::push_empty_selection))
			.def("push_full_selection", static_cast <void(Design::*)()>(&Design::push_full_selection))
			.def("push_complete_selection", static_cast <void(Design::*)()>(&Design::push_complete_selection))
			.def("pop_selection", static_cast <void(Design::*)()>(&Design::pop_selection))
			.def("selection", static_cast <RTLIL::Selection&(Design::*)()>(&Design::selection))
			.def("selection", static_cast <const RTLIL::Selection&(Design::*)() const>(&Design::selection))
			.def("full_selection", static_cast <bool(Design::*)() const>(&Design::full_selection))
			.def("selected_modules", static_cast <std::vector<RTLIL::Module*>(Design::*)(RTLIL::SelectPartials, RTLIL::SelectBoxes) const>(&Design::selected_modules), py::arg("partials") = SELECT_ALL, py::arg("boxes") = SB_UNBOXED_WARN)
			.def("all_selected_modules", static_cast <std::vector<RTLIL::Module*>(Design::*)() const>(&Design::all_selected_modules))
			.def("selected_unboxed_modules", static_cast <std::vector<RTLIL::Module*>(Design::*)() const>(&Design::selected_unboxed_modules))
			.def("selected_unboxed_modules_warn", static_cast <std::vector<RTLIL::Module*>(Design::*)() const>(&Design::selected_unboxed_modules_warn))
			.def("all_selected_whole_modules", static_cast <std::vector<RTLIL::Module*>(Design::*)() const>(&Design::all_selected_whole_modules))
			.def("selected_whole_modules_warn", static_cast <std::vector<RTLIL::Module*>(Design::*)(bool) const>(&Design::selected_whole_modules_warn), py::arg("include_wb") = false)
			.def("selected_unboxed_whole_modules", static_cast <std::vector<RTLIL::Module*>(Design::*)() const>(&Design::selected_unboxed_whole_modules))
			.def("selected_unboxed_whole_modules_warn", static_cast <std::vector<RTLIL::Module*>(Design::*)() const>(&Design::selected_unboxed_whole_modules_warn))
			.def_static("get_all_designs", static_cast <std::map<unsigned int, RTLIL::Design*>*(*)()>(&Design::get_all_designs))
			.def_readwrite("hashidx_", &Design::hashidx_, py::return_value_policy::copy)
			.def_readwrite("monitors", &Design::monitors, py::return_value_policy::copy)
			.def_readwrite("scratchpad", &Design::scratchpad, py::return_value_policy::copy)
			.def_readwrite("flagBufferedNormalized", &Design::flagBufferedNormalized, py::return_value_policy::copy)
			.def_readwrite("refcount_modules_", &Design::refcount_modules_, py::return_value_policy::copy)
			.def_readwrite("modules_", &Design::modules_, py::return_value_policy::copy)
			.def_readwrite("bindings_", &Design::bindings_, py::return_value_policy::copy)
			.def_readwrite("selection_stack", &Design::selection_stack, py::return_value_policy::copy)
			.def_readwrite("selection_vars", &Design::selection_vars, py::return_value_policy::copy)
			.def_readwrite("selected_active_module", &Design::selected_active_module, py::return_value_policy::copy)
		.def("__str__", [](const Design &s) { return std::to_string(s.hashidx_); })
		.def("__repr__", [](const Design &s) { std::stringstream ss; ss << "<Design " << std::to_string(s.hashidx_) << ">"; return ss.str(); })
		.def("__hash__", [](const Design &s) { return run_hash(s); })
		;}
		{using namespace Yosys::RTLIL; py::class_<Module, std::unique_ptr<Module, py::nodelete>>(m, "Module")
			.def("hash_into", static_cast <Hasher(Module::*)(Hasher) const>(&Module::hash_into), py::arg("h"))
			.def("derive", static_cast <RTLIL::IdString(Module::*)(RTLIL::Design*, const dict<RTLIL::IdString, RTLIL::Const>&, bool)>(&Module::derive), py::arg("design"), py::arg("parameters"), py::arg("mayfail") = false)
			.def("derive", static_cast <RTLIL::IdString(Module::*)(RTLIL::Design*, const dict<RTLIL::IdString, RTLIL::Const>&, const dict<RTLIL::IdString, RTLIL::Module*>&, const dict<RTLIL::IdString, RTLIL::IdString>&, bool)>(&Module::derive), py::arg("design"), py::arg("parameters"), py::arg("interfaces"), py::arg("modports"), py::arg("mayfail") = false)
			.def("count_id", static_cast <size_t(Module::*)(const RTLIL::IdString&)>(&Module::count_id), py::arg("id"))
			.def("expand_interfaces", static_cast <void(Module::*)(RTLIL::Design*, const dict<RTLIL::IdString, RTLIL::Module*>&)>(&Module::expand_interfaces), py::arg("design"), py::arg("local_interfaces"))
			.def("reprocess_if_necessary", static_cast <bool(Module::*)(RTLIL::Design*)>(&Module::reprocess_if_necessary), py::arg("design"))
			.def("sort", static_cast <void(Module::*)()>(&Module::sort))
			.def("check", static_cast <void(Module::*)()>(&Module::check))
			.def("optimize", static_cast <void(Module::*)()>(&Module::optimize))
			.def("makeblackbox", static_cast <void(Module::*)()>(&Module::makeblackbox))
			.def("get_blackbox_attribute", static_cast <bool(Module::*)(bool) const>(&Module::get_blackbox_attribute), py::arg("ignore_wb") = false)
			.def("connect", static_cast <void(Module::*)(const RTLIL::SigSig&)>(&Module::connect), py::arg("conn"))
			.def("connect", static_cast <void(Module::*)(const RTLIL::SigSpec&, const RTLIL::SigSpec&)>(&Module::connect), py::arg("lhs"), py::arg("rhs"))
			.def("new_connections", static_cast <void(Module::*)(const std::vector<RTLIL::SigSig>&)>(&Module::new_connections), py::arg("new_conn"))
			.def("connections", static_cast <const std::vector<RTLIL::SigSig>&(Module::*)() const>(&Module::connections))
			.def("fixup_ports", static_cast <void(Module::*)()>(&Module::fixup_ports))
			.def("bufNormalize", static_cast <void(Module::*)()>(&Module::bufNormalize))
			.def("cloneInto", static_cast <void(Module::*)(RTLIL::Module*) const>(&Module::cloneInto), py::arg("new_mod"))
			.def("clone", static_cast <RTLIL::Module*(Module::*)() const>(&Module::clone))
			.def("has_memories", static_cast <bool(Module::*)() const>(&Module::has_memories))
			.def("has_processes", static_cast <bool(Module::*)() const>(&Module::has_processes))
			.def("has_memories_warn", static_cast <bool(Module::*)() const>(&Module::has_memories_warn))
			.def("has_processes_warn", static_cast <bool(Module::*)() const>(&Module::has_processes_warn))
			.def("is_selected", static_cast <bool(Module::*)() const>(&Module::is_selected))
			.def("is_selected_whole", static_cast <bool(Module::*)() const>(&Module::is_selected_whole))
			.def("selected_wires", static_cast <std::vector<RTLIL::Wire*>(Module::*)() const>(&Module::selected_wires))
			.def("selected_cells", static_cast <std::vector<RTLIL::Cell*>(Module::*)() const>(&Module::selected_cells))
			.def("selected_memories", static_cast <std::vector<RTLIL::Memory*>(Module::*)() const>(&Module::selected_memories))
			.def("selected_processes", static_cast <std::vector<RTLIL::Process*>(Module::*)() const>(&Module::selected_processes))
			.def("selected_members", static_cast <std::vector<RTLIL::NamedObject*>(Module::*)() const>(&Module::selected_members))
			.def("wire", static_cast <RTLIL::Wire*(Module::*)(const RTLIL::IdString&)>(&Module::wire), py::arg("id"))
			.def("cell", static_cast <RTLIL::Cell*(Module::*)(const RTLIL::IdString&)>(&Module::cell), py::arg("id"))
			.def("wire", static_cast <const RTLIL::Wire*(Module::*)(const RTLIL::IdString&) const>(&Module::wire), py::arg("id"))
			.def("cell", static_cast <const RTLIL::Cell*(Module::*)(const RTLIL::IdString&) const>(&Module::cell), py::arg("id"))
			.def("wires", static_cast <RTLIL::ObjRange<RTLIL::Wire*>(Module::*)()>(&Module::wires))
			.def("cells", static_cast <RTLIL::ObjRange<RTLIL::Cell*>(Module::*)()>(&Module::cells))
			.def("add", static_cast <void(Module::*)(RTLIL::Binding*)>(&Module::add), py::arg("binding"))
			.def("remove", static_cast <void(Module::*)(const pool<RTLIL::Wire*>&)>(&Module::remove), py::arg("wires"))
			.def("remove", static_cast <void(Module::*)(RTLIL::Cell*)>(&Module::remove), py::arg("cell"))
			.def("remove", static_cast <void(Module::*)(RTLIL::Process*)>(&Module::remove), py::arg("process"))
			.def("rename", static_cast <void(Module::*)(RTLIL::Wire*, RTLIL::IdString)>(&Module::rename), py::arg("wire"), py::arg("new_name"))
			.def("rename", static_cast <void(Module::*)(RTLIL::Cell*, RTLIL::IdString)>(&Module::rename), py::arg("cell"), py::arg("new_name"))
			.def("rename", static_cast <void(Module::*)(RTLIL::IdString, RTLIL::IdString)>(&Module::rename), py::arg("old_name"), py::arg("new_name"))
			.def("swap_names", static_cast <void(Module::*)(RTLIL::Wire*, RTLIL::Wire*)>(&Module::swap_names), py::arg("w1"), py::arg("w2"))
			.def("swap_names", static_cast <void(Module::*)(RTLIL::Cell*, RTLIL::Cell*)>(&Module::swap_names), py::arg("c1"), py::arg("c2"))
			.def("uniquify", static_cast <RTLIL::IdString(Module::*)(RTLIL::IdString)>(&Module::uniquify), py::arg("name"))
			.def("uniquify", static_cast <RTLIL::IdString(Module::*)(RTLIL::IdString, int&)>(&Module::uniquify), py::arg("name"), py::arg("index"))
			.def("addWire", static_cast <RTLIL::Wire*(Module::*)(RTLIL::IdString, int)>(&Module::addWire), py::arg("name"), py::arg("width") = 1)
			.def("addWire", static_cast <RTLIL::Wire*(Module::*)(RTLIL::IdString, const RTLIL::Wire*)>(&Module::addWire), py::arg("name"), py::arg("other"))
			.def("addCell", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, RTLIL::IdString)>(&Module::addCell), py::arg("name"), py::arg("type"))
			.def("addCell", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::Cell*)>(&Module::addCell), py::arg("name"), py::arg("other"))
			.def("addMemory", static_cast <RTLIL::Memory*(Module::*)(RTLIL::IdString)>(&Module::addMemory), py::arg("name"))
			.def("addMemory", static_cast <RTLIL::Memory*(Module::*)(RTLIL::IdString, const RTLIL::Memory*)>(&Module::addMemory), py::arg("name"), py::arg("other"))
			.def("addProcess", static_cast <RTLIL::Process*(Module::*)(RTLIL::IdString)>(&Module::addProcess), py::arg("name"))
			.def("addProcess", static_cast <RTLIL::Process*(Module::*)(RTLIL::IdString, const RTLIL::Process*)>(&Module::addProcess), py::arg("name"), py::arg("other"))
			.def("addNot", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addNot), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addPos", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addPos), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addBuf", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addBuf), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addNeg", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addNeg), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addAnd", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addAnd), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addOr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addOr), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addXor", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addXor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addXnor", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addXnor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addReduceAnd", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addReduceAnd), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addReduceOr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addReduceOr), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addReduceXor", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addReduceXor), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addReduceXnor", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addReduceXnor), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addReduceBool", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addReduceBool), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addShl", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addShl), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addShr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addShr), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addSshl", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addSshl), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addSshr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addSshr), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addShift", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addShift), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addShiftx", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addShiftx), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addLt", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addLt), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addLe", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addLe), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addEq", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addEq), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addNe", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addNe), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addEqx", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addEqx), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addNex", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addNex), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addGe", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addGe), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addGt", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addGt), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addAdd", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addAdd), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addSub", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addSub), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addMul", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addMul), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addDiv", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addDiv), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addMod", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addMod), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addDivFloor", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addDivFloor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addModFloor", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addModFloor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addPow", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, const std::string&)>(&Module::addPow), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("a_signed") = false, py::arg("b_signed") = false, py::arg("src") = "")
			.def("addFa", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addFa), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("sig_x"), py::arg("sig_y"), py::arg("src") = "")
			.def("addLogicNot", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addLogicNot), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addLogicAnd", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addLogicAnd), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addLogicOr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addLogicOr), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("addMux", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addMux), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("sig_y"), py::arg("src") = "")
			.def("addPmux", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addPmux), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("sig_y"), py::arg("src") = "")
			.def("addBmux", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addBmux), py::arg("name"), py::arg("sig_a"), py::arg("sig_s"), py::arg("sig_y"), py::arg("src") = "")
			.def("addDemux", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addDemux), py::arg("name"), py::arg("sig_a"), py::arg("sig_s"), py::arg("sig_y"), py::arg("src") = "")
			.def("addBweqx", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addBweqx), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addBwmux", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addBwmux), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("sig_y"), py::arg("src") = "")
			.def("addSlice", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, const std::string&)>(&Module::addSlice), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("offset"), py::arg("src") = "")
			.def("addConcat", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addConcat), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addLut", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, const std::string&)>(&Module::addLut), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("lut"), py::arg("src") = "")
			.def("addTribuf", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addTribuf), py::arg("name"), py::arg("sig_a"), py::arg("sig_en"), py::arg("sig_y"), py::arg("src") = "")
			.def("addAssert", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addAssert), py::arg("name"), py::arg("sig_a"), py::arg("sig_en"), py::arg("src") = "")
			.def("addAssume", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addAssume), py::arg("name"), py::arg("sig_a"), py::arg("sig_en"), py::arg("src") = "")
			.def("addLive", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addLive), py::arg("name"), py::arg("sig_a"), py::arg("sig_en"), py::arg("src") = "")
			.def("addFair", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addFair), py::arg("name"), py::arg("sig_a"), py::arg("sig_en"), py::arg("src") = "")
			.def("addCover", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addCover), py::arg("name"), py::arg("sig_a"), py::arg("sig_en"), py::arg("src") = "")
			.def("addEquiv", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addEquiv), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addSr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, const std::string&)>(&Module::addSr), py::arg("name"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_q"), py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addFf", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addFf), py::arg("name"), py::arg("sig_d"), py::arg("sig_q"), py::arg("src") = "")
			.def("addDff", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addDff), py::arg("name"), py::arg("sig_clk"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("src") = "")
			.def("addDffe", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, const std::string&)>(&Module::addDffe), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("src") = "")
			.def("addDffsr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::SigSpec, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addDffsr), py::arg("name"), py::arg("sig_clk"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addDffsre", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::SigSpec, const RTLIL::SigSpec&, bool, bool, bool, bool, const std::string&)>(&Module::addDffsre), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addAdff", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, bool, bool, const std::string&)>(&Module::addAdff), py::arg("name"), py::arg("sig_clk"), py::arg("sig_arst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("arst_value"), py::arg("clk_polarity") = true, py::arg("arst_polarity") = true, py::arg("src") = "")
			.def("addAdffe", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, bool, bool, bool, const std::string&)>(&Module::addAdffe), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_arst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("arst_value"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("arst_polarity") = true, py::arg("src") = "")
			.def("addAldff", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, const std::string&)>(&Module::addAldff), py::arg("name"), py::arg("sig_clk"), py::arg("sig_aload"), py::arg("sig_d"), py::arg("sig_q"), py::arg("sig_ad"), py::arg("clk_polarity") = true, py::arg("aload_polarity") = true, py::arg("src") = "")
			.def("addAldffe", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addAldffe), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_aload"), py::arg("sig_d"), py::arg("sig_q"), py::arg("sig_ad"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("aload_polarity") = true, py::arg("src") = "")
			.def("addSdff", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, bool, bool, const std::string&)>(&Module::addSdff), py::arg("name"), py::arg("sig_clk"), py::arg("sig_srst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("srst_value"), py::arg("clk_polarity") = true, py::arg("srst_polarity") = true, py::arg("src") = "")
			.def("addSdffe", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, bool, bool, bool, const std::string&)>(&Module::addSdffe), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_srst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("srst_value"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("srst_polarity") = true, py::arg("src") = "")
			.def("addSdffce", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, bool, bool, bool, const std::string&)>(&Module::addSdffce), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_srst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("srst_value"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("srst_polarity") = true, py::arg("src") = "")
			.def("addDlatch", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addDlatch), py::arg("name"), py::arg("sig_en"), py::arg("sig_d"), py::arg("sig_q"), py::arg("en_polarity") = true, py::arg("src") = "")
			.def("addAdlatch", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::Const, bool, bool, const std::string&)>(&Module::addAdlatch), py::arg("name"), py::arg("sig_en"), py::arg("sig_arst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("arst_value"), py::arg("en_polarity") = true, py::arg("arst_polarity") = true, py::arg("src") = "")
			.def("addDlatchsr", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::SigSpec, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addDlatchsr), py::arg("name"), py::arg("sig_en"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_d"), py::arg("sig_q"), py::arg("en_polarity") = true, py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addBufGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addBufGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("src") = "")
			.def("addNotGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addNotGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_y"), py::arg("src") = "")
			.def("addAndGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addAndGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addNandGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addNandGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addOrGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addOrGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addNorGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addNorGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addXorGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addXorGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addXnorGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addXnorGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addAndnotGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addAndnotGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addOrnotGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addOrnotGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_y"), py::arg("src") = "")
			.def("addMuxGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addMuxGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("sig_y"), py::arg("src") = "")
			.def("addNmuxGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addNmuxGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("sig_y"), py::arg("src") = "")
			.def("addAoi3Gate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addAoi3Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("sig_y"), py::arg("src") = "")
			.def("addOai3Gate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addOai3Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("sig_y"), py::arg("src") = "")
			.def("addAoi4Gate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addAoi4Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("sig_d"), py::arg("sig_y"), py::arg("src") = "")
			.def("addOai4Gate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::addOai4Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("sig_d"), py::arg("sig_y"), py::arg("src") = "")
			.def("addSrGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, const std::string&)>(&Module::addSrGate), py::arg("name"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_q"), py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addFfGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addFfGate), py::arg("name"), py::arg("sig_d"), py::arg("sig_q"), py::arg("src") = "")
			.def("addDffGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addDffGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("src") = "")
			.def("addDffeGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, const std::string&)>(&Module::addDffeGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("src") = "")
			.def("addDffsrGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::SigSpec, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addDffsrGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addDffsreGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::SigSpec, const RTLIL::SigSpec&, bool, bool, bool, bool, const std::string&)>(&Module::addDffsreGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_d"), py::arg("sig_q"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addAdffGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addAdffGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_arst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("arst_value") = false, py::arg("clk_polarity") = true, py::arg("arst_polarity") = true, py::arg("src") = "")
			.def("addAdffeGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, bool, const std::string&)>(&Module::addAdffeGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_arst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("arst_value") = false, py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("arst_polarity") = true, py::arg("src") = "")
			.def("addAldffGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, const std::string&)>(&Module::addAldffGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_aload"), py::arg("sig_d"), py::arg("sig_q"), py::arg("sig_ad"), py::arg("clk_polarity") = true, py::arg("aload_polarity") = true, py::arg("src") = "")
			.def("addAldffeGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addAldffeGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_aload"), py::arg("sig_d"), py::arg("sig_q"), py::arg("sig_ad"), py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("aload_polarity") = true, py::arg("src") = "")
			.def("addSdffGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addSdffGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_srst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("srst_value") = false, py::arg("clk_polarity") = true, py::arg("srst_polarity") = true, py::arg("src") = "")
			.def("addSdffeGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, bool, const std::string&)>(&Module::addSdffeGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_srst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("srst_value") = false, py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("srst_polarity") = true, py::arg("src") = "")
			.def("addSdffceGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, bool, const std::string&)>(&Module::addSdffceGate), py::arg("name"), py::arg("sig_clk"), py::arg("sig_en"), py::arg("sig_srst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("srst_value") = false, py::arg("clk_polarity") = true, py::arg("en_polarity") = true, py::arg("srst_polarity") = true, py::arg("src") = "")
			.def("addDlatchGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::addDlatchGate), py::arg("name"), py::arg("sig_en"), py::arg("sig_d"), py::arg("sig_q"), py::arg("en_polarity") = true, py::arg("src") = "")
			.def("addAdlatchGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addAdlatchGate), py::arg("name"), py::arg("sig_en"), py::arg("sig_arst"), py::arg("sig_d"), py::arg("sig_q"), py::arg("arst_value") = false, py::arg("en_polarity") = true, py::arg("arst_polarity") = true, py::arg("src") = "")
			.def("addDlatchsrGate", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, RTLIL::SigSpec, const RTLIL::SigSpec&, bool, bool, bool, const std::string&)>(&Module::addDlatchsrGate), py::arg("name"), py::arg("sig_en"), py::arg("sig_set"), py::arg("sig_clr"), py::arg("sig_d"), py::arg("sig_q"), py::arg("en_polarity") = true, py::arg("set_polarity") = true, py::arg("clr_polarity") = true, py::arg("src") = "")
			.def("addAnyinit", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addAnyinit), py::arg("name"), py::arg("sig_d"), py::arg("sig_q"), py::arg("src") = "")
			.def("Not", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Not), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Pos", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Pos), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Buf", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Buf), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Neg", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Neg), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("And", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::And), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Or", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Or), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Xor", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Xor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Xnor", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Xnor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("ReduceAnd", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::ReduceAnd), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("ReduceOr", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::ReduceOr), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("ReduceXor", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::ReduceXor), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("ReduceXnor", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::ReduceXnor), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("ReduceBool", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::ReduceBool), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Shl", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Shl), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Shr", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Shr), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Sshl", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Sshl), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Sshr", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Sshr), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Shift", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Shift), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Shiftx", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Shiftx), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Lt", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Lt), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Le", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Le), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Eq", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Eq), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Ne", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Ne), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Eqx", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Eqx), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Nex", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Nex), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Ge", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Ge), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Gt", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Gt), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Add", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Add), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Sub", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Sub), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Mul", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Mul), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Div", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Div), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Mod", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::Mod), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("DivFloor", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::DivFloor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("ModFloor", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::ModFloor), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("LogicNot", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::LogicNot), py::arg("name"), py::arg("sig_a"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("LogicAnd", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::LogicAnd), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("LogicOr", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, bool, const std::string&)>(&Module::LogicOr), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("is_signed") = false, py::arg("src") = "")
			.def("Mux", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::Mux), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("src") = "")
			.def("Pmux", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::Pmux), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("src") = "")
			.def("Bmux", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::Bmux), py::arg("name"), py::arg("sig_a"), py::arg("sig_s"), py::arg("src") = "")
			.def("Demux", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::Demux), py::arg("name"), py::arg("sig_a"), py::arg("sig_s"), py::arg("src") = "")
			.def("Bweqx", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::Bweqx), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("Bwmux", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::Bwmux), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("src") = "")
			.def("BufGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const std::string&)>(&Module::BufGate), py::arg("name"), py::arg("sig_a"), py::arg("src") = "")
			.def("NotGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const std::string&)>(&Module::NotGate), py::arg("name"), py::arg("sig_a"), py::arg("src") = "")
			.def("AndGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::AndGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("NandGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::NandGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("OrGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::OrGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("NorGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::NorGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("XorGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::XorGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("XnorGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::XnorGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("AndnotGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::AndnotGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("OrnotGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::OrnotGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("src") = "")
			.def("MuxGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::MuxGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("src") = "")
			.def("NmuxGate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::NmuxGate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_s"), py::arg("src") = "")
			.def("Aoi3Gate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::Aoi3Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("src") = "")
			.def("Oai3Gate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::Oai3Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("src") = "")
			.def("Aoi4Gate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::Aoi4Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("sig_d"), py::arg("src") = "")
			.def("Oai4Gate", static_cast <RTLIL::SigBit(Module::*)(RTLIL::IdString, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const RTLIL::SigBit&, const std::string&)>(&Module::Oai4Gate), py::arg("name"), py::arg("sig_a"), py::arg("sig_b"), py::arg("sig_c"), py::arg("sig_d"), py::arg("src") = "")
			.def("Anyconst", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, int, const std::string&)>(&Module::Anyconst), py::arg("name"), py::arg("width") = 1, py::arg("src") = "")
			.def("Anyseq", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, int, const std::string&)>(&Module::Anyseq), py::arg("name"), py::arg("width") = 1, py::arg("src") = "")
			.def("Allconst", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, int, const std::string&)>(&Module::Allconst), py::arg("name"), py::arg("width") = 1, py::arg("src") = "")
			.def("Allseq", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, int, const std::string&)>(&Module::Allseq), py::arg("name"), py::arg("width") = 1, py::arg("src") = "")
			.def("Initstate", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const std::string&)>(&Module::Initstate), py::arg("name"), py::arg("src") = "")
			.def("SetTag", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const std::string&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::SetTag), py::arg("name"), py::arg("tag"), py::arg("sig_a"), py::arg("sig_s"), py::arg("sig_c"), py::arg("src") = "")
			.def("addSetTag", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const std::string&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addSetTag), py::arg("name"), py::arg("tag"), py::arg("sig_a"), py::arg("sig_s"), py::arg("sig_c"), py::arg("sig_y"), py::arg("src") = "")
			.def("GetTag", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const std::string&, const RTLIL::SigSpec&, const std::string&)>(&Module::GetTag), py::arg("name"), py::arg("tag"), py::arg("sig_a"), py::arg("src") = "")
			.def("addOverwriteTag", static_cast <RTLIL::Cell*(Module::*)(RTLIL::IdString, const std::string&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const RTLIL::SigSpec&, const std::string&)>(&Module::addOverwriteTag), py::arg("name"), py::arg("tag"), py::arg("sig_a"), py::arg("sig_s"), py::arg("sig_c"), py::arg("src") = "")
			.def("OriginalTag", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const std::string&, const RTLIL::SigSpec&, const std::string&)>(&Module::OriginalTag), py::arg("name"), py::arg("tag"), py::arg("sig_a"), py::arg("src") = "")
			.def("FutureFF", static_cast <RTLIL::SigSpec(Module::*)(RTLIL::IdString, const RTLIL::SigSpec&, const std::string&)>(&Module::FutureFF), py::arg("name"), py::arg("sig_e"), py::arg("src") = "")
			.def_static("get_all_modules", static_cast <std::map<unsigned int, RTLIL::Module*>*(*)()>(&Module::get_all_modules))
			.def_readwrite("hashidx_", &Module::hashidx_, py::return_value_policy::copy)
			.def_readwrite("design", &Module::design, py::return_value_policy::reference_internal)
			.def_readwrite("monitors", &Module::monitors, py::return_value_policy::copy)
			.def_readwrite("refcount_wires_", &Module::refcount_wires_, py::return_value_policy::copy)
			.def_readwrite("refcount_cells_", &Module::refcount_cells_, py::return_value_policy::copy)
			.def_readwrite("wires_", &Module::wires_, py::return_value_policy::copy)
			.def_readwrite("cells_", &Module::cells_, py::return_value_policy::copy)
			.def_readwrite("connections_", &Module::connections_, py::return_value_policy::copy)
			.def_readwrite("bindings_", &Module::bindings_, py::return_value_policy::copy)
			.def_readwrite("avail_parameters", &Module::avail_parameters, py::return_value_policy::copy)
			.def_readwrite("parameter_default_values", &Module::parameter_default_values, py::return_value_policy::copy)
			.def_readwrite("memories", &Module::memories, py::return_value_policy::copy)
			.def_readwrite("processes", &Module::processes, py::return_value_policy::copy)
			.def_readwrite("ports", &Module::ports, py::return_value_policy::copy)
			.def_readwrite("buf_norm_cell_queue", &Module::buf_norm_cell_queue, py::return_value_policy::copy)
			.def_readwrite("buf_norm_cell_port_queue", &Module::buf_norm_cell_port_queue, py::return_value_policy::copy)
			.def_readwrite("buf_norm_wire_queue", &Module::buf_norm_wire_queue, py::return_value_policy::copy)
			.def_readwrite("pending_deleted_cells", &Module::pending_deleted_cells, py::return_value_policy::copy)
			.def_readwrite("buf_norm_connect_index", &Module::buf_norm_connect_index, py::return_value_policy::copy)
			.def_readwrite("name", &Module::name, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(Module::*)(const RTLIL::IdString&) const>(&Module::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(Module::*)(const RTLIL::IdString&, bool)>(&Module::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(Module::*)(const RTLIL::IdString&) const>(&Module::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(Module::*)(const RTLIL::IdString&, string)>(&Module::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(Module::*)(const RTLIL::IdString&) const>(&Module::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(Module::*)(const RTLIL::IdString&, const pool<string>&)>(&Module::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(Module::*)(const RTLIL::IdString&, const pool<string>&)>(&Module::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(Module::*)(const RTLIL::IdString&) const>(&Module::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(Module::*)(const std::string&)>(&Module::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(Module::*)() const>(&Module::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(Module::*)(const vector<string>&)>(&Module::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(Module::*)() const>(&Module::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(Module::*)(const RTLIL::IdString&, const vector<int>&)>(&Module::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(Module::*)(const RTLIL::IdString&) const>(&Module::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &Module::attributes, py::return_value_policy::copy)
		.def("__str__", [](const Module &s) { return s.name.c_str(); })
		.def("__repr__", [](const Module &s) { std::stringstream ss; ss << "<Module " << s.name.c_str() << ">"; return ss.str(); })
		.def("__hash__", [](const Module &s) { return run_hash(s); })
		;}
		{using namespace Yosys::RTLIL; py::class_<Wire, std::unique_ptr<Wire, py::nodelete>>(m, "Wire")
			.def("hash_into", static_cast <Hasher(Wire::*)(Hasher) const>(&Wire::hash_into), py::arg("h"))
			.def("known_driver", static_cast <bool(Wire::*)() const>(&Wire::known_driver))
			.def("driverCell", static_cast <RTLIL::Cell*(Wire::*)() const>(&Wire::driverCell))
			.def("driverPort", static_cast <RTLIL::IdString(Wire::*)() const>(&Wire::driverPort))
			.def("from_hdl_index", static_cast <int(Wire::*)(int)>(&Wire::from_hdl_index), py::arg("hdl_index"))
			.def("to_hdl_index", static_cast <int(Wire::*)(int)>(&Wire::to_hdl_index), py::arg("rtlil_index"))
			.def_static("get_all_wires", static_cast <std::map<unsigned int, RTLIL::Wire*>*(*)()>(&Wire::get_all_wires))
			.def_readwrite("hashidx_", &Wire::hashidx_, py::return_value_policy::copy)
			.def_readwrite("module", &Wire::module, py::return_value_policy::reference_internal)
			.def_readwrite("width", &Wire::width, py::return_value_policy::copy)
			.def_readwrite("start_offset", &Wire::start_offset, py::return_value_policy::copy)
			.def_readwrite("port_id", &Wire::port_id, py::return_value_policy::copy)
			.def_readwrite("port_input", &Wire::port_input, py::return_value_policy::copy)
			.def_readwrite("port_output", &Wire::port_output, py::return_value_policy::copy)
			.def_readwrite("upto", &Wire::upto, py::return_value_policy::copy)
			.def_readwrite("is_signed", &Wire::is_signed, py::return_value_policy::copy)
			.def_readwrite("name", &Wire::name, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(Wire::*)(const RTLIL::IdString&) const>(&Wire::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(Wire::*)(const RTLIL::IdString&, bool)>(&Wire::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(Wire::*)(const RTLIL::IdString&) const>(&Wire::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(Wire::*)(const RTLIL::IdString&, string)>(&Wire::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(Wire::*)(const RTLIL::IdString&) const>(&Wire::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(Wire::*)(const RTLIL::IdString&, const pool<string>&)>(&Wire::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(Wire::*)(const RTLIL::IdString&, const pool<string>&)>(&Wire::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(Wire::*)(const RTLIL::IdString&) const>(&Wire::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(Wire::*)(const std::string&)>(&Wire::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(Wire::*)() const>(&Wire::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(Wire::*)(const vector<string>&)>(&Wire::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(Wire::*)() const>(&Wire::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(Wire::*)(const RTLIL::IdString&, const vector<int>&)>(&Wire::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(Wire::*)(const RTLIL::IdString&) const>(&Wire::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &Wire::attributes, py::return_value_policy::copy)
		.def("__str__", [](const Wire &s) { return s.name.c_str(); })
		.def("__repr__", [](const Wire &s) { std::stringstream ss; ss << "<Wire " << s.name.c_str() << ">"; return ss.str(); })
		.def("__hash__", [](const Wire &s) { return run_hash(s); })
		;}
		{using namespace Yosys::RTLIL; py::class_<Memory, std::unique_ptr<Memory, py::nodelete>>(m, "Memory")
			.def("hash_into", static_cast <Hasher(Memory::*)(Hasher) const>(&Memory::hash_into), py::arg("h"))
			.def_static("get_all_memorys", static_cast <std::map<unsigned int, RTLIL::Memory*>*(*)()>(&Memory::get_all_memorys))
			.def_readwrite("hashidx_", &Memory::hashidx_, py::return_value_policy::copy)
			.def_readwrite("width", &Memory::width, py::return_value_policy::copy)
			.def_readwrite("start_offset", &Memory::start_offset, py::return_value_policy::copy)
			.def_readwrite("size", &Memory::size, py::return_value_policy::copy)
			.def_readwrite("name", &Memory::name, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(Memory::*)(const RTLIL::IdString&) const>(&Memory::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(Memory::*)(const RTLIL::IdString&, bool)>(&Memory::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(Memory::*)(const RTLIL::IdString&) const>(&Memory::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(Memory::*)(const RTLIL::IdString&, string)>(&Memory::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(Memory::*)(const RTLIL::IdString&) const>(&Memory::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(Memory::*)(const RTLIL::IdString&, const pool<string>&)>(&Memory::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(Memory::*)(const RTLIL::IdString&, const pool<string>&)>(&Memory::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(Memory::*)(const RTLIL::IdString&) const>(&Memory::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(Memory::*)(const std::string&)>(&Memory::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(Memory::*)() const>(&Memory::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(Memory::*)(const vector<string>&)>(&Memory::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(Memory::*)() const>(&Memory::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(Memory::*)(const RTLIL::IdString&, const vector<int>&)>(&Memory::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(Memory::*)(const RTLIL::IdString&) const>(&Memory::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &Memory::attributes, py::return_value_policy::copy)
		.def("__str__", [](const Memory &s) { return s.name.c_str(); })
		.def("__repr__", [](const Memory &s) { std::stringstream ss; ss << "<Memory " << s.name.c_str() << ">"; return ss.str(); })
		.def("__hash__", [](const Memory &s) { return run_hash(s); })
		;}
		{using namespace Yosys::RTLIL; py::class_<Cell, std::unique_ptr<Cell, py::nodelete>>(m, "Cell")
			.def("hash_into", static_cast <Hasher(Cell::*)(Hasher) const>(&Cell::hash_into), py::arg("h"))
			.def("hasPort", static_cast <bool(Cell::*)(const RTLIL::IdString&) const>(&Cell::hasPort), py::arg("portname"))
			.def("unsetPort", static_cast <void(Cell::*)(const RTLIL::IdString&)>(&Cell::unsetPort), py::arg("portname"))
			.def("setPort", static_cast <void(Cell::*)(const RTLIL::IdString&, RTLIL::SigSpec)>(&Cell::setPort), py::arg("portname"), py::arg("signal"))
			.def("getPort", static_cast <const RTLIL::SigSpec&(Cell::*)(const RTLIL::IdString&) const>(&Cell::getPort), py::arg("portname"))
			.def("connections", static_cast <const dict<RTLIL::IdString, RTLIL::SigSpec>&(Cell::*)() const>(&Cell::connections))
			.def("known", static_cast <bool(Cell::*)() const>(&Cell::known))
			.def("input", static_cast <bool(Cell::*)(const RTLIL::IdString&) const>(&Cell::input), py::arg("portname"))
			.def("output", static_cast <bool(Cell::*)(const RTLIL::IdString&) const>(&Cell::output), py::arg("portname"))
			.def("port_dir", static_cast <PortDir(Cell::*)(const RTLIL::IdString&) const>(&Cell::port_dir), py::arg("portname"))
			.def("hasParam", static_cast <bool(Cell::*)(const RTLIL::IdString&) const>(&Cell::hasParam), py::arg("paramname"))
			.def("unsetParam", static_cast <void(Cell::*)(const RTLIL::IdString&)>(&Cell::unsetParam), py::arg("paramname"))
			.def("setParam", static_cast <void(Cell::*)(const RTLIL::IdString&, RTLIL::Const)>(&Cell::setParam), py::arg("paramname"), py::arg("value"))
			.def("getParam", static_cast <const RTLIL::Const&(Cell::*)(const RTLIL::IdString&) const>(&Cell::getParam), py::arg("paramname"))
			.def("sort", static_cast <void(Cell::*)()>(&Cell::sort))
			.def("check", static_cast <void(Cell::*)()>(&Cell::check))
			.def("fixup_parameters", static_cast <void(Cell::*)(bool, bool)>(&Cell::fixup_parameters), py::arg("set_a_signed") = false, py::arg("set_b_signed") = false)
			.def("has_keep_attr", static_cast <bool(Cell::*)() const>(&Cell::has_keep_attr))
			.def_static("get_all_cells", static_cast <std::map<unsigned int, RTLIL::Cell*>*(*)()>(&Cell::get_all_cells))
			.def("has_memid", static_cast <bool(Cell::*)() const>(&Cell::has_memid))
			.def("is_mem_cell", static_cast <bool(Cell::*)() const>(&Cell::is_mem_cell))
			.def("is_builtin_ff", static_cast <bool(Cell::*)() const>(&Cell::is_builtin_ff))
			.def_readwrite("hashidx_", &Cell::hashidx_, py::return_value_policy::copy)
			.def_readwrite("module", &Cell::module, py::return_value_policy::reference_internal)
			.def_readwrite("type", &Cell::type, py::return_value_policy::copy)
			.def_readwrite("connections_", &Cell::connections_, py::return_value_policy::copy)
			.def_readwrite("parameters", &Cell::parameters, py::return_value_policy::copy)
			.def_readwrite("name", &Cell::name, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(Cell::*)(const RTLIL::IdString&) const>(&Cell::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(Cell::*)(const RTLIL::IdString&, bool)>(&Cell::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(Cell::*)(const RTLIL::IdString&) const>(&Cell::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(Cell::*)(const RTLIL::IdString&, string)>(&Cell::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(Cell::*)(const RTLIL::IdString&) const>(&Cell::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(Cell::*)(const RTLIL::IdString&, const pool<string>&)>(&Cell::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(Cell::*)(const RTLIL::IdString&, const pool<string>&)>(&Cell::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(Cell::*)(const RTLIL::IdString&) const>(&Cell::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(Cell::*)(const std::string&)>(&Cell::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(Cell::*)() const>(&Cell::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(Cell::*)(const vector<string>&)>(&Cell::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(Cell::*)() const>(&Cell::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(Cell::*)(const RTLIL::IdString&, const vector<int>&)>(&Cell::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(Cell::*)(const RTLIL::IdString&) const>(&Cell::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &Cell::attributes, py::return_value_policy::copy)
		.def("__str__", [](const Cell &s) { return s.name.c_str(); })
		.def("__repr__", [](const Cell &s) { std::stringstream ss; ss << "<Cell " << s.name.c_str() << ">"; return ss.str(); })
		.def("__hash__", [](const Cell &s) { return run_hash(s); })
		;}
		{using namespace Yosys::RTLIL; py::class_<CaseRule>(m, "CaseRule")
			.def("empty", static_cast <bool(CaseRule::*)() const>(&CaseRule::empty))
			.def("clone", static_cast <RTLIL::CaseRule*(CaseRule::*)() const>(&CaseRule::clone))
			.def_readwrite("compare", &CaseRule::compare, py::return_value_policy::copy)
			.def_readwrite("actions", &CaseRule::actions, py::return_value_policy::copy)
			.def_readwrite("switches", &CaseRule::switches, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(CaseRule::*)(const RTLIL::IdString&) const>(&CaseRule::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(CaseRule::*)(const RTLIL::IdString&, bool)>(&CaseRule::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(CaseRule::*)(const RTLIL::IdString&) const>(&CaseRule::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(CaseRule::*)(const RTLIL::IdString&, string)>(&CaseRule::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(CaseRule::*)(const RTLIL::IdString&) const>(&CaseRule::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(CaseRule::*)(const RTLIL::IdString&, const pool<string>&)>(&CaseRule::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(CaseRule::*)(const RTLIL::IdString&, const pool<string>&)>(&CaseRule::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(CaseRule::*)(const RTLIL::IdString&) const>(&CaseRule::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(CaseRule::*)(const std::string&)>(&CaseRule::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(CaseRule::*)() const>(&CaseRule::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(CaseRule::*)(const vector<string>&)>(&CaseRule::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(CaseRule::*)() const>(&CaseRule::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(CaseRule::*)(const RTLIL::IdString&, const vector<int>&)>(&CaseRule::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(CaseRule::*)(const RTLIL::IdString&) const>(&CaseRule::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &CaseRule::attributes, py::return_value_policy::copy)
		;}
		{using namespace Yosys::RTLIL; py::class_<SwitchRule>(m, "SwitchRule")
			.def("empty", static_cast <bool(SwitchRule::*)() const>(&SwitchRule::empty))
			.def("clone", static_cast <RTLIL::SwitchRule*(SwitchRule::*)() const>(&SwitchRule::clone))
			.def_readwrite("signal", &SwitchRule::signal, py::return_value_policy::copy)
			.def_readwrite("cases", &SwitchRule::cases, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(SwitchRule::*)(const RTLIL::IdString&) const>(&SwitchRule::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(SwitchRule::*)(const RTLIL::IdString&, bool)>(&SwitchRule::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(SwitchRule::*)(const RTLIL::IdString&) const>(&SwitchRule::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(SwitchRule::*)(const RTLIL::IdString&, string)>(&SwitchRule::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(SwitchRule::*)(const RTLIL::IdString&) const>(&SwitchRule::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(SwitchRule::*)(const RTLIL::IdString&, const pool<string>&)>(&SwitchRule::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(SwitchRule::*)(const RTLIL::IdString&, const pool<string>&)>(&SwitchRule::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(SwitchRule::*)(const RTLIL::IdString&) const>(&SwitchRule::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(SwitchRule::*)(const std::string&)>(&SwitchRule::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(SwitchRule::*)() const>(&SwitchRule::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(SwitchRule::*)(const vector<string>&)>(&SwitchRule::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(SwitchRule::*)() const>(&SwitchRule::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(SwitchRule::*)(const RTLIL::IdString&, const vector<int>&)>(&SwitchRule::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(SwitchRule::*)(const RTLIL::IdString&) const>(&SwitchRule::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &SwitchRule::attributes, py::return_value_policy::copy)
		;}
		{using namespace Yosys::RTLIL; py::class_<SyncRule>(m, "SyncRule")
			.def("clone", static_cast <RTLIL::SyncRule*(SyncRule::*)() const>(&SyncRule::clone))
			.def_readwrite("type", &SyncRule::type, py::return_value_policy::copy)
			.def_readwrite("signal", &SyncRule::signal, py::return_value_policy::copy)
			.def_readwrite("actions", &SyncRule::actions, py::return_value_policy::copy)
			.def_readwrite("mem_write_actions", &SyncRule::mem_write_actions, py::return_value_policy::copy)
		;}
		{using namespace Yosys::RTLIL; py::class_<Process, std::unique_ptr<Process, py::nodelete>>(m, "Process")
			.def("hash_into", static_cast <Hasher(Process::*)(Hasher) const>(&Process::hash_into), py::arg("h"))
			.def("clone", static_cast <RTLIL::Process*(Process::*)() const>(&Process::clone))
			.def_readwrite("hashidx_", &Process::hashidx_, py::return_value_policy::copy)
			.def_readwrite("module", &Process::module, py::return_value_policy::reference_internal)
			.def_readwrite("root_case", &Process::root_case, py::return_value_policy::copy)
			.def_readwrite("syncs", &Process::syncs, py::return_value_policy::copy)
			.def_readwrite("name", &Process::name, py::return_value_policy::copy)
			.def("has_attribute", static_cast <bool(Process::*)(const RTLIL::IdString&) const>(&Process::has_attribute), py::arg("id"))
			.def("set_bool_attribute", static_cast <void(Process::*)(const RTLIL::IdString&, bool)>(&Process::set_bool_attribute), py::arg("id"), py::arg("value") = true)
			.def("get_bool_attribute", static_cast <bool(Process::*)(const RTLIL::IdString&) const>(&Process::get_bool_attribute), py::arg("id"))
			.def("set_string_attribute", static_cast <void(Process::*)(const RTLIL::IdString&, string)>(&Process::set_string_attribute), py::arg("id"), py::arg("value"))
			.def("get_string_attribute", static_cast <string(Process::*)(const RTLIL::IdString&) const>(&Process::get_string_attribute), py::arg("id"))
			.def("set_strpool_attribute", static_cast <void(Process::*)(const RTLIL::IdString&, const pool<string>&)>(&Process::set_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("add_strpool_attribute", static_cast <void(Process::*)(const RTLIL::IdString&, const pool<string>&)>(&Process::add_strpool_attribute), py::arg("id"), py::arg("data"))
			.def("get_strpool_attribute", static_cast <pool<string>(Process::*)(const RTLIL::IdString&) const>(&Process::get_strpool_attribute), py::arg("id"))
			.def("set_src_attribute", static_cast <void(Process::*)(const std::string&)>(&Process::set_src_attribute), py::arg("src"))
			.def("get_src_attribute", static_cast <std::string(Process::*)() const>(&Process::get_src_attribute))
			.def("set_hdlname_attribute", static_cast <void(Process::*)(const vector<string>&)>(&Process::set_hdlname_attribute), py::arg("hierarchy"))
			.def("get_hdlname_attribute", static_cast <vector<string>(Process::*)() const>(&Process::get_hdlname_attribute))
			.def("set_intvec_attribute", static_cast <void(Process::*)(const RTLIL::IdString&, const vector<int>&)>(&Process::set_intvec_attribute), py::arg("id"), py::arg("data"))
			.def("get_intvec_attribute", static_cast <vector<int>(Process::*)(const RTLIL::IdString&) const>(&Process::get_intvec_attribute), py::arg("id"))
			.def_readwrite("attributes", &Process::attributes, py::return_value_policy::copy)
		.def("__str__", [](const Process &s) { return s.name.c_str(); })
		.def("__repr__", [](const Process &s) { std::stringstream ss; ss << "<Process " << s.name.c_str() << ">"; return ss.str(); })
		.def("__hash__", [](const Process &s) { return run_hash(s.name); })
		;}

		py::implicitly_convertible<std::string, RTLIL::IdString>();
		py::implicitly_convertible<const char *, RTLIL::IdString>();
	};
};

#endif // YOSYS_ENABLE_PYTHON
