// Generated by pmgen.py from techlibs/ice40/ice40_wrapcarry.pmg

struct ice40_wrapcarry_pm {
  Module *module;
  SigMap sigmap;
  std::function<void()> on_accept;
  bool setup_done;
  bool generate_mode;
  int accept_cnt;

  uint32_t rngseed;
  int rng(unsigned int n) {
    rngseed ^= rngseed << 13;
    rngseed ^= rngseed >> 17;
    rngseed ^= rngseed << 5;
    return rngseed % n;
  }

  typedef std::tuple<> index_0_key_type;
  typedef std::tuple<Cell*> index_0_value_type;
  dict<index_0_key_type, vector<index_0_value_type>> index_0;
  typedef std::tuple<SigSpec, SigSpec> index_1_key_type;
  typedef std::tuple<Cell*> index_1_value_type;
  dict<index_1_key_type, vector<index_1_value_type>> index_1;
  dict<SigBit, pool<Cell*>> sigusers;
  pool<Cell*> blacklist_cells;
  pool<Cell*> autoremove_cells;
  dict<Cell*,int> rollback_cache;
  int rollback;

  struct state_ice40_wrapcarry_t {
    Cell* carry;
    Cell* lut;
  } st_ice40_wrapcarry;

  struct udata_ice40_wrapcarry_t {
  } ud_ice40_wrapcarry;

  IdString id_b_I0{"\\I0"};
  IdString id_b_I1{"\\I1"};
  IdString id_b_I2{"\\I2"};
  IdString id_b_SB_CARRY{"\\SB_CARRY"};
  IdString id_b_SB_LUT4{"\\SB_LUT4"};

  void add_siguser(const SigSpec &sig, Cell *cell) {
    for (auto bit : sigmap(sig)) {
      if (bit.wire == nullptr) continue;
      sigusers[bit].insert(cell);
    }
  }

  void blacklist(Cell *cell) {
    if (cell != nullptr && blacklist_cells.insert(cell).second) {
      auto ptr = rollback_cache.find(cell);
      if (ptr == rollback_cache.end()) return;
      int rb = ptr->second;
      if (rollback == 0 || rollback > rb)
        rollback = rb;
    }
  }

  void autoremove(Cell *cell) {
    if (cell != nullptr) {
      autoremove_cells.insert(cell);
      blacklist(cell);
    }
  }

  SigSpec port(Cell *cell, IdString portname) {
    try {
      return sigmap(cell->getPort(portname));
    } catch(std::out_of_range&) { log_error("Accessing non existing port %s\n",portname); }
  }

  SigSpec port(Cell *cell, IdString portname, const SigSpec& defval) {
    return sigmap(cell->connections_.at(portname, defval));
  }

  Const param(Cell *cell, IdString paramname) {
    try {
      return cell->getParam(paramname);
    } catch(std::out_of_range&) { log_error("Accessing non existing parameter %s\n",paramname); }
  }

  Const param(Cell *cell, IdString paramname, const Const& defval) {
    return cell->parameters.at(paramname, defval);
  }

  int nusers(const SigSpec &sig) {
    pool<Cell*> users;
    for (auto bit : sigmap(sig))
      for (auto user : sigusers[bit])
        users.insert(user);
    return GetSize(users);
  }

  ice40_wrapcarry_pm(Module *module, const vector<Cell*> &cells) :
      module(module), sigmap(module), setup_done(false), generate_mode(false), rngseed(12345678) {
    setup(cells);
  }

  ice40_wrapcarry_pm(Module *module) :
      module(module), sigmap(module), setup_done(false), generate_mode(false), rngseed(12345678) {
  }

  void setup(const vector<Cell*> &cells) {
    log_assert(!setup_done);
    setup_done = true;
    for (auto port : module->ports)
      add_siguser(module->wire(port), nullptr);
    for (auto cell : module->cells())
      for (auto &conn : cell->connections())
        add_siguser(conn.second, cell);
    for (auto cell : cells) {
      do {
        Cell *carry = cell;
        index_0_value_type value;
        std::get<0>(value) = cell;
        if (!(carry->type.in(id_b_SB_CARRY))) continue;
        index_0_key_type key;
        index_0[key].push_back(value);
      } while (0);
      do {
        Cell *lut = cell;
        index_1_value_type value;
        std::get<0>(value) = cell;
        if (!(lut->type.in(id_b_SB_LUT4))) continue;
        index_1_key_type key;
        std::get<0>(key) = port(lut, id_b_I1);
        std::get<1>(key) = port(lut, id_b_I2);
        index_1[key].push_back(value);
      } while (0);
    }
  }

  ~ice40_wrapcarry_pm() {
    for (auto cell : autoremove_cells)
      module->remove(cell);
  }

  int run_ice40_wrapcarry(std::function<void()> on_accept_f) {
    log_assert(setup_done);
    accept_cnt = 0;
    on_accept = on_accept_f;
    rollback = 0;
    st_ice40_wrapcarry.carry = nullptr;
    st_ice40_wrapcarry.lut = nullptr;
    block_0(1);
    log_assert(rollback_cache.empty());
    return accept_cnt;
  }

  int run_ice40_wrapcarry(std::function<void(ice40_wrapcarry_pm&)> on_accept_f) {
    return run_ice40_wrapcarry([&](){on_accept_f(*this);});
  }

  int run_ice40_wrapcarry() {
    return run_ice40_wrapcarry([](){});
  }

  void block_subpattern_ice40_wrapcarry_(int recursion) { block_0(recursion); }

  // techlibs/ice40/ice40_wrapcarry.pmg:3
  void block_0(int recursion YS_MAYBE_UNUSED) {
    Cell* &carry YS_MAYBE_UNUSED = st_ice40_wrapcarry.carry;
    Cell* _pmg_backup_carry = carry;

    index_0_key_type key;
    auto cells_ptr = index_0.find(key);

    if (cells_ptr != index_0.end()) {
      const vector<index_0_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        carry = std::get<0>(cells[_pmg_idx]);
        if (blacklist_cells.count(carry)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_1(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            carry = _pmg_backup_carry;
            return;
          }
          rollback = 0;
        }
      }
    }

    carry = nullptr;
    carry = _pmg_backup_carry;
  }

  // techlibs/ice40/ice40_wrapcarry.pmg:7
  void block_1(int recursion YS_MAYBE_UNUSED) {
    Cell* const &carry YS_MAYBE_UNUSED = st_ice40_wrapcarry.carry;
    Cell* &lut YS_MAYBE_UNUSED = st_ice40_wrapcarry.lut;
    Cell* _pmg_backup_lut = lut;

    index_1_key_type key;
    std::get<0>(key) = port(carry, id_b_I0);
    std::get<1>(key) = port(carry, id_b_I1);
    auto cells_ptr = index_1.find(key);

    if (cells_ptr != index_1.end()) {
      const vector<index_1_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        lut = std::get<0>(cells[_pmg_idx]);
        if (blacklist_cells.count(lut)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_2(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            lut = _pmg_backup_lut;
            return;
          }
          rollback = 0;
        }
      }
    }

    lut = nullptr;
    lut = _pmg_backup_lut;
  }

  // techlibs/ice40/ice40_wrapcarry.pmg:13
  void block_2(int recursion YS_MAYBE_UNUSED) {
    Cell* const &carry YS_MAYBE_UNUSED = st_ice40_wrapcarry.carry;
    Cell* const &lut YS_MAYBE_UNUSED = st_ice40_wrapcarry.lut;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_3(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_ice40_wrapcarry_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    accept;

    block_3(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  void block_3(int recursion YS_MAYBE_UNUSED) {
  }
};
