// Generated by pmgen.py from techlibs/microchip/microchip_dsp.pmg

struct microchip_dsp_pm {
  Module *module;
  SigMap sigmap;
  std::function<void()> on_accept;
  bool setup_done;
  bool generate_mode;
  int accept_cnt;

  uint32_t rngseed;
  int rng(unsigned int n) {
    rngseed ^= rngseed << 13;
    rngseed ^= rngseed >> 17;
    rngseed ^= rngseed << 5;
    return rngseed % n;
  }

  typedef std::tuple<> index_0_key_type;
  typedef std::tuple<Cell*> index_0_value_type;
  dict<index_0_key_type, vector<index_0_value_type>> index_0;
  typedef std::tuple<SigBit> index_12_key_type;
  typedef std::tuple<Cell*, IdString> index_12_value_type;
  dict<index_12_key_type, vector<index_12_value_type>> index_12;
  typedef std::tuple<> index_16_key_type;
  typedef std::tuple<Cell*> index_16_value_type;
  dict<index_16_key_type, vector<index_16_value_type>> index_16;
  typedef std::tuple<SigBit> index_20_key_type;
  typedef std::tuple<Cell*, int> index_20_value_type;
  dict<index_20_key_type, vector<index_20_value_type>> index_20;
  typedef std::tuple<SigBit> index_24_key_type;
  typedef std::tuple<Cell*, int> index_24_value_type;
  dict<index_24_key_type, vector<index_24_value_type>> index_24;
  dict<SigBit, pool<Cell*>> sigusers;
  pool<Cell*> blacklist_cells;
  pool<Cell*> autoremove_cells;
  dict<Cell*,int> rollback_cache;
  int rollback;

  struct state_microchip_dsp_pack_t {
    SigSpec argD;
    SigSpec argQ;
    SigSpec bypassA;
    SigSpec bypassB;
    SigSpec bypassC;
    SigSpec bypassD;
    SigSpec bypassP;
    SigSpec bypassPASUB;
    SigBit clock;
    Cell* dsp;
    Cell* ff;
    Cell* ffA;
    Cell* ffB;
    Cell* ffD;
    Cell* ffP;
    bool moveBtoA;
    Cell* postAdd;
    IdString postAddAB;
    Cell* postAdderStatic;
    Cell* preAdd;
    Cell* preAdderStatic;
    SigSpec sigA;
    SigSpec sigB;
    SigSpec sigC;
    SigSpec sigD;
    SigSpec sigP;
    bool useFeedBack;
  } st_microchip_dsp_pack;

  struct udata_microchip_dsp_pack_t {
    bool allowAsync;
    Cell* dff;
    SigSpec dffD;
    SigSpec dffQ;
    SigBit dffclock;
    IdString u_postAddAB;
    Cell* u_postAdderStatic;
    Cell* u_preAdderStatic;
  } ud_microchip_dsp_pack;

  IdString id_b_A{"\\A"};
  IdString id_b_ARST_VALUE{"\\ARST_VALUE"};
  IdString id_b_A_BYPASS{"\\A_BYPASS"};
  IdString id_b_B{"\\B"};
  IdString id_b_B_BYPASS{"\\B_BYPASS"};
  IdString id_b_C{"\\C"};
  IdString id_b_CLK{"\\CLK"};
  IdString id_b_CLK_POLARITY{"\\CLK_POLARITY"};
  IdString id_b_C_BYPASS{"\\C_BYPASS"};
  IdString id_b_D{"\\D"};
  IdString id_b_D_BYPASS{"\\D_BYPASS"};
  IdString id_b_MACC_PA{"\\MACC_PA"};
  IdString id_b_P{"\\P"};
  IdString id_b_PASUB_BYPASS{"\\PASUB_BYPASS"};
  IdString id_b_P_BYPASS{"\\P_BYPASS"};
  IdString id_b_Q{"\\Q"};
  IdString id_b_SRST_VALUE{"\\SRST_VALUE"};
  IdString id_b_Y{"\\Y"};
  IdString id_b_init{"\\init"};
  IdString id_b_keep{"\\keep"};
  IdString id_d_add{"$add"};
  IdString id_d_adff{"$adff"};
  IdString id_d_adffe{"$adffe"};
  IdString id_d_dff{"$dff"};
  IdString id_d_dffe{"$dffe"};
  IdString id_d_mul{"$mul"};
  IdString id_d_sdff{"$sdff"};
  IdString id_d_sdffe{"$sdffe"};
  IdString id_d_sub{"$sub"};

  void add_siguser(const SigSpec &sig, Cell *cell) {
    for (auto bit : sigmap(sig)) {
      if (bit.wire == nullptr) continue;
      sigusers[bit].insert(cell);
    }
  }

  void blacklist(Cell *cell) {
    if (cell != nullptr && blacklist_cells.insert(cell).second) {
      auto ptr = rollback_cache.find(cell);
      if (ptr == rollback_cache.end()) return;
      int rb = ptr->second;
      if (rollback == 0 || rollback > rb)
        rollback = rb;
    }
  }

  void autoremove(Cell *cell) {
    if (cell != nullptr) {
      autoremove_cells.insert(cell);
      blacklist(cell);
    }
  }

  SigSpec port(Cell *cell, IdString portname) {
    try {
      return sigmap(cell->getPort(portname));
    } catch(std::out_of_range&) { log_error("Accessing non existing port %s\n",portname); }
  }

  SigSpec port(Cell *cell, IdString portname, const SigSpec& defval) {
    return sigmap(cell->connections_.at(portname, defval));
  }

  Const param(Cell *cell, IdString paramname) {
    try {
      return cell->getParam(paramname);
    } catch(std::out_of_range&) { log_error("Accessing non existing parameter %s\n",paramname); }
  }

  Const param(Cell *cell, IdString paramname, const Const& defval) {
    return cell->parameters.at(paramname, defval);
  }

  int nusers(const SigSpec &sig) {
    pool<Cell*> users;
    for (auto bit : sigmap(sig))
      for (auto user : sigusers[bit])
        users.insert(user);
    return GetSize(users);
  }

  microchip_dsp_pm(Module *module, const vector<Cell*> &cells) :
      module(module), sigmap(module), setup_done(false), generate_mode(false), rngseed(12345678) {
    setup(cells);
  }

  microchip_dsp_pm(Module *module) :
      module(module), sigmap(module), setup_done(false), generate_mode(false), rngseed(12345678) {
  }

  void setup(const vector<Cell*> &cells) {
    ud_microchip_dsp_pack.allowAsync = bool();
    ud_microchip_dsp_pack.dff = nullptr;
    ud_microchip_dsp_pack.dffD = SigSpec();
    ud_microchip_dsp_pack.dffQ = SigSpec();
    ud_microchip_dsp_pack.dffclock = SigBit();
    ud_microchip_dsp_pack.u_postAddAB = IdString();
    ud_microchip_dsp_pack.u_postAdderStatic = nullptr;
    ud_microchip_dsp_pack.u_preAdderStatic = nullptr;
    log_assert(!setup_done);
    setup_done = true;
    for (auto port : module->ports)
      add_siguser(module->wire(port), nullptr);
    for (auto cell : module->cells())
      for (auto &conn : cell->connections())
        add_siguser(conn.second, cell);
    for (auto cell : cells) {
      do {
        Cell *dsp = cell;
        index_0_value_type value;
        std::get<0>(value) = cell;
        if (!(dsp->type.in(id_b_MACC_PA))) continue;
        index_0_key_type key;
        index_0[key].push_back(value);
      } while (0);
      do {
        Cell *postAdd = cell;
        index_12_value_type value;
        std::get<0>(value) = cell;
        if (!(postAdd->type.in(id_d_add, id_d_sub))) continue;
        if (!(GetSize(port(postAdd, id_b_Y)) <= 48)) continue;
        vector<IdString> _pmg_choices_AB = {id_b_A, id_b_B};
        for (const IdString &AB : _pmg_choices_AB) {
        std::get<1>(value) = AB;
        if (!(nusers(port(postAdd, AB)) == 2)) continue;
        index_12_key_type key;
        std::get<0>(key) = port(postAdd, AB)[0];
        index_12[key].push_back(value);
        }
      } while (0);
      do {
        Cell *preAdd = cell;
        index_16_value_type value;
        std::get<0>(value) = cell;
        if (!(preAdd->type.in(id_d_add, id_d_sub))) continue;
        if (!(GetSize(port(preAdd, id_b_Y)) <= 18)) continue;
        if (!(nusers(port(preAdd, id_b_Y)) == 2)) continue;
        if (!(GetSize(port(preAdd, id_b_A)) <= 18)) continue;
        if (!(GetSize(port(preAdd, id_b_B)) <= 18)) continue;
        index_16_key_type key;
        index_16[key].push_back(value);
      } while (0);
      do {
        Cell *ff = cell;
        index_20_value_type value;
        std::get<0>(value) = cell;
        if (!(ff->type.in(id_d_dff, id_d_dffe, id_d_sdff, id_d_sdffe, id_d_adff, id_d_adffe))) continue;
        if (!(param(ff, id_b_CLK_POLARITY).as_bool())) continue;
        int &offset = std::get<1>(value);
        for (offset = 0; offset < GetSize(port(ff, id_b_D)); offset++) {
        index_20_key_type key;
        std::get<0>(key) = port(ff, id_b_Q)[offset];
        index_20[key].push_back(value);
        }
      } while (0);
      do {
        Cell *ff = cell;
        index_24_value_type value;
        std::get<0>(value) = cell;
        if (!(ff->type.in(id_d_dff, id_d_dffe, id_d_sdff, id_d_sdffe))) continue;
        if (!(param(ff, id_b_CLK_POLARITY).as_bool())) continue;
        int &offset = std::get<1>(value);
        for (offset = 0; offset < GetSize(port(ff, id_b_D)); offset++) {
        index_24_key_type key;
        std::get<0>(key) = port(ff, id_b_D)[offset];
        index_24[key].push_back(value);
        }
      } while (0);
    }
  }

  ~microchip_dsp_pm() {
    for (auto cell : autoremove_cells)
      module->remove(cell);
  }

  int run_microchip_dsp_pack(std::function<void()> on_accept_f) {
    log_assert(setup_done);
    accept_cnt = 0;
    on_accept = on_accept_f;
    rollback = 0;
    st_microchip_dsp_pack.argD = SigSpec();
    st_microchip_dsp_pack.argQ = SigSpec();
    st_microchip_dsp_pack.bypassA = SigSpec();
    st_microchip_dsp_pack.bypassB = SigSpec();
    st_microchip_dsp_pack.bypassC = SigSpec();
    st_microchip_dsp_pack.bypassD = SigSpec();
    st_microchip_dsp_pack.bypassP = SigSpec();
    st_microchip_dsp_pack.bypassPASUB = SigSpec();
    st_microchip_dsp_pack.clock = SigBit();
    st_microchip_dsp_pack.dsp = nullptr;
    st_microchip_dsp_pack.ff = nullptr;
    st_microchip_dsp_pack.ffA = nullptr;
    st_microchip_dsp_pack.ffB = nullptr;
    st_microchip_dsp_pack.ffD = nullptr;
    st_microchip_dsp_pack.ffP = nullptr;
    st_microchip_dsp_pack.moveBtoA = bool();
    st_microchip_dsp_pack.postAdd = nullptr;
    st_microchip_dsp_pack.postAddAB = IdString();
    st_microchip_dsp_pack.postAdderStatic = nullptr;
    st_microchip_dsp_pack.preAdd = nullptr;
    st_microchip_dsp_pack.preAdderStatic = nullptr;
    st_microchip_dsp_pack.sigA = SigSpec();
    st_microchip_dsp_pack.sigB = SigSpec();
    st_microchip_dsp_pack.sigC = SigSpec();
    st_microchip_dsp_pack.sigD = SigSpec();
    st_microchip_dsp_pack.sigP = SigSpec();
    st_microchip_dsp_pack.useFeedBack = bool();
    block_0(1);
    log_assert(rollback_cache.empty());
    return accept_cnt;
  }

  int run_microchip_dsp_pack(std::function<void(microchip_dsp_pm&)> on_accept_f) {
    return run_microchip_dsp_pack([&](){on_accept_f(*this);});
  }

  int run_microchip_dsp_pack() {
    return run_microchip_dsp_pack([](){});
  }

  void block_subpattern_microchip_dsp_pack_(int recursion) { block_0(recursion); }
  void block_subpattern_microchip_dsp_pack_in_dffe(int recursion) { block_19(recursion); }
  void block_subpattern_microchip_dsp_pack_out_dffe(int recursion) { block_23(recursion); }
  void block_subpattern_microchip_dsp_pack_postAddMatching(int recursion) { block_12(recursion); }
  void block_subpattern_microchip_dsp_pack_preAddMatching(int recursion) { block_15(recursion); }

  // techlibs/microchip/microchip_dsp.pmg:57
  void block_0(int recursion YS_MAYBE_UNUSED) {
    Cell* &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;
    Cell* _pmg_backup_dsp = dsp;

    index_0_key_type key;
    auto cells_ptr = index_0.find(key);

    if (cells_ptr != index_0.end()) {
      const vector<index_0_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        dsp = std::get<0>(cells[_pmg_idx]);
        if (blacklist_cells.count(dsp)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_1(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            dsp = _pmg_backup_dsp;
            return;
          }
          rollback = 0;
        }
      }
    }

    dsp = nullptr;
    dsp = _pmg_backup_dsp;
  }

  // techlibs/microchip/microchip_dsp.pmg:63
  void block_1(int recursion YS_MAYBE_UNUSED) {
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_2(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    //helper function to remove unused bits
    auto unextend = [](const SigSpec &sig) {
      int i;
      for (i = GetSize(sig)-1; i > 0; i--)
        if (sig[i] != sig[i-1])
          break;
      // Do not remove non-const sign bit
      if (sig[i].wire)
        ++i;
      return sig.extract(0, i);
    };
    //unextend to remove unused bits
    sigA = unextend(port(dsp, id_b_A));
    sigB = unextend(port(dsp, id_b_B));
    //update signals
    sigC = port(dsp, id_b_C, SigSpec());
    sigD = port(dsp, id_b_D, SigSpec());
    SigSpec P = port(dsp, id_b_P);
    // Only care about bits that are used
    int i;
    for (i = GetSize(P)-1; i >= 0; i--)
      if (nusers(P[i]) > 1)
        break;
    i++;
    log_assert(nusers(P.extract_end(i)) <= 1);
    // This sigP could have no users if downstream sinks (e.g. id_d_add) is
    //   narrower than id_d_mul result, for example
    if (i == 0)
      reject;
    sigP = P.extract(0, i);
    clock = port(dsp, id_b_CLK, SigBit());

    block_2(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    clock = SigBit();
    sigA = SigSpec();
    sigB = SigSpec();
    sigC = SigSpec();
    sigD = SigSpec();
    sigP = SigSpec();
  }

  // techlibs/microchip/microchip_dsp.pmg:103
  void block_2(int recursion YS_MAYBE_UNUSED) {
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_3(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    bypassA = port(dsp, id_b_A_BYPASS, SigSpec());
    bypassB = port(dsp, id_b_B_BYPASS, SigSpec());
    bypassC = port(dsp, id_b_C_BYPASS, SigSpec());
    bypassD = port(dsp, id_b_D_BYPASS, SigSpec());
    bypassPASUB = port(dsp, id_b_PASUB_BYPASS, SigSpec());
    bypassP = port(dsp, id_b_P_BYPASS, SigSpec());

    block_3(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    bypassA = SigSpec();
    bypassB = SigSpec();
    bypassC = SigSpec();
    bypassD = SigSpec();
    bypassP = SigSpec();
    bypassPASUB = SigSpec();
  }

  // techlibs/microchip/microchip_dsp.pmg:114
  void block_3(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_sigA = sigA;
    SigSpec _pmg_backup_sigB = sigB;
    SigSpec _pmg_backup_sigD = sigD;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_4(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    subpattern(preAddMatching);
    preAdderStatic = u_preAdderStatic;
    moveBtoA = false;
    if (preAdderStatic) {
      if (port(preAdderStatic, id_b_Y) == sigA)
      {
        //used for packing
        moveBtoA = true;
        // sigA should be the input to the multiplier without the preAdd. sigB and sigD should be
        //the preAdd inputs. If our "A" input into the multiplier is from the preAdd (not sigA), then
        // we basically swap it.
        sigA = sigB;
      }
      // port B of preAdderStatic must be mapped to port D of DSP for subtraction
      sigD = port(preAdderStatic, id_b_B);
      sigB = port(preAdderStatic, id_b_A);
    }

    block_4(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    sigA = _pmg_backup_sigA;
    sigB = _pmg_backup_sigB;
    sigD = _pmg_backup_sigD;
    moveBtoA = bool();
    preAdderStatic = nullptr;
  }

  // techlibs/microchip/microchip_dsp.pmg:140
  void block_4(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    const bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* const &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    Cell* &postAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdderStatic;
    SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_sigC = sigC;
    SigSpec _pmg_backup_sigP = sigP;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_5(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    u_postAdderStatic = nullptr;
    subpattern(postAddMatching);
    postAdderStatic = u_postAdderStatic;
    if (postAdderStatic) {
      //sigC will be whichever input to the postAdder that is NOT from the multiplier
      // u_postAddAB is the input to the postAdder from the multiplier
      sigC = port(postAdderStatic, u_postAddAB == id_b_A ? id_b_B : id_b_A);
      sigP = port(postAdderStatic, id_b_Y);
    }

    block_5(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    sigC = _pmg_backup_sigC;
    sigP = _pmg_backup_sigP;
    postAdderStatic = nullptr;
  }

  // techlibs/microchip/microchip_dsp.pmg:157
  void block_5(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    const bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* const &postAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdderStatic;
    Cell* const &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* &ffA YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffA;
    SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_bypassA = bypassA;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigA = sigA;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_6(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (bypassA.is_fully_ones()){
      argQ = sigA;
      allowAsync = false;
      subpattern(in_dffe);
      if (dff) {
        ffA = dff;
        clock = dffclock;
        sigA = dffD;
      }
    }

    block_6(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    bypassA = _pmg_backup_bypassA;
    clock = _pmg_backup_clock;
    sigA = _pmg_backup_sigA;
    argQ = SigSpec();
    ffA = nullptr;
  }

  // techlibs/microchip/microchip_dsp.pmg:171
  void block_6(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    Cell* const &ffA YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffA;
    const bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* const &postAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdderStatic;
    Cell* const &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* &ffB YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffB;
    SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_argQ = argQ;
    SigSpec _pmg_backup_bypassB = bypassB;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigB = sigB;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_7(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (bypassB.is_fully_ones()){
      argQ = sigB;
      allowAsync = false;
      subpattern(in_dffe);
      if (dff) {
        ffB = dff;
        clock = dffclock;
        sigB = dffD;
      }
    }

    block_7(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
    bypassB = _pmg_backup_bypassB;
    clock = _pmg_backup_clock;
    sigB = _pmg_backup_sigB;
    ffB = nullptr;
  }

  // techlibs/microchip/microchip_dsp.pmg:185
  void block_7(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    Cell* const &ffA YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffA;
    Cell* const &ffB YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffB;
    const bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* const &postAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdderStatic;
    Cell* const &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* &ffD YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffD;
    SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_argQ = argQ;
    SigSpec _pmg_backup_bypassP = bypassP;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigD = sigD;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_8(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (bypassD.is_fully_ones()){
      argQ = sigD;
      allowAsync = true;
      subpattern(in_dffe);
      if (dff) {
        ffD = dff;
        clock = dffclock;
        sigD = dffD;
      }
    }

    block_8(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
    bypassP = _pmg_backup_bypassP;
    clock = _pmg_backup_clock;
    sigD = _pmg_backup_sigD;
    ffD = nullptr;
  }

  // techlibs/microchip/microchip_dsp.pmg:199
  void block_8(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    const SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    Cell* const &ffA YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffA;
    Cell* const &ffB YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffB;
    Cell* const &ffD YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffD;
    const bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* const &postAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdderStatic;
    Cell* const &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    SigSpec &argD YS_MAYBE_UNUSED = st_microchip_dsp_pack.argD;
    SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* &ffP YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffP;
    SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_bypassP = bypassP;
    SigBit _pmg_backup_clock = clock;
    SigSpec _pmg_backup_sigP = sigP;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_9(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (bypassP.is_fully_ones() && nusers(sigP) == 2) {
      argD = sigP;
      allowAsync = false;
      subpattern(out_dffe);
      if (dff) {
        ffP = dff;
        clock = dffclock;
        sigP = dffQ;
      }
    }

    block_9(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    bypassP = _pmg_backup_bypassP;
    clock = _pmg_backup_clock;
    sigP = _pmg_backup_sigP;
    argD = SigSpec();
    ffP = nullptr;
  }

  // techlibs/microchip/microchip_dsp.pmg:220
  void block_9(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_microchip_dsp_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    const SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    Cell* const &ffA YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffA;
    Cell* const &ffB YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffB;
    Cell* const &ffD YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffD;
    Cell* const &ffP YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffP;
    const bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* const &postAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdderStatic;
    Cell* const &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    bool &useFeedBack YS_MAYBE_UNUSED = st_microchip_dsp_pack.useFeedBack;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_10(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    useFeedBack = false;
    if (postAdderStatic && ffP)  {
      if (sigC == sigP) {
        useFeedBack = true;
      }
    }

    block_10(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    useFeedBack = bool();
  }

  // techlibs/microchip/microchip_dsp.pmg:231
  void block_10(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_microchip_dsp_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    const SigSpec &bypassA YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassA;
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassC YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassC;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassP YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassP;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* const &dsp YS_MAYBE_UNUSED = st_microchip_dsp_pack.dsp;
    Cell* const &ffA YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffA;
    Cell* const &ffB YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffB;
    Cell* const &ffD YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffD;
    Cell* const &ffP YS_MAYBE_UNUSED = st_microchip_dsp_pack.ffP;
    const bool &moveBtoA YS_MAYBE_UNUSED = st_microchip_dsp_pack.moveBtoA;
    Cell* const &postAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdderStatic;
    Cell* const &preAdderStatic YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdderStatic;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigC YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigC;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    const bool &useFeedBack YS_MAYBE_UNUSED = st_microchip_dsp_pack.useFeedBack;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_11(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (preAdderStatic || postAdderStatic)
      accept;
    if (ffA || ffB || ffD || ffP)
      accept;

    block_11(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  void block_11(int recursion YS_MAYBE_UNUSED) {
  }

  // techlibs/microchip/microchip_dsp.pmg:248
  void block_12(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    Cell* &postAdd YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdd;
    IdString &postAddAB YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAddAB;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;
    Cell* _pmg_backup_postAdd = postAdd;

    index_12_key_type key;
    std::get<0>(key) = sigP[0];
    auto cells_ptr = index_12.find(key);

    if (cells_ptr != index_12.end()) {
      const vector<index_12_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        postAdd = std::get<0>(cells[_pmg_idx]);
        const IdString &AB YS_MAYBE_UNUSED = std::get<1>(cells[_pmg_idx]);
        if (blacklist_cells.count(postAdd)) continue;
        if (!(GetSize(port(postAdd, AB)) >= GetSize(sigP))) continue;
        if (!(port(postAdd, AB).extract(0, GetSize(sigP)) == sigP)) continue;
        if (!(port(postAdd, AB).extract_end(GetSize(sigP)) == SigSpec(sigP[GetSize(sigP)-1], GetSize(port(postAdd, AB))-GetSize(sigP)) || port(postAdd, AB).extract_end(GetSize(sigP)) == SigSpec(State::S0, GetSize(port(postAdd, AB))-GetSize(sigP)))) continue;
        auto _pmg_backup_postAddAB = postAddAB;
        postAddAB = AB;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_13(recursion+1);
        postAddAB = _pmg_backup_postAddAB;
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            postAdd = _pmg_backup_postAdd;
            return;
          }
          rollback = 0;
        }
      }
    }

    postAdd = nullptr;
    postAdd = _pmg_backup_postAdd;
  }

  // techlibs/microchip/microchip_dsp.pmg:268
  void block_13(int recursion YS_MAYBE_UNUSED) {
    Cell* const &postAdd YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAdd;
    const IdString &postAddAB YS_MAYBE_UNUSED = st_microchip_dsp_pack.postAddAB;
    const SigSpec &sigP YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigP;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_14(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (postAdd)
    {
      if (postAdd->type.in(id_d_sub) && postAddAB == id_b_A) {
        // if id_d_sub, the multiplier output must match to id_d_sub.B, otherwise no match
      } else {
        u_postAddAB = postAddAB;
        u_postAdderStatic = postAdd;
      }
    }

    block_14(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  void block_14(int recursion YS_MAYBE_UNUSED) {
  }

  // techlibs/microchip/microchip_dsp.pmg:289
  void block_15(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_16(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    u_preAdderStatic = nullptr;
    // Ensure that preAdder not already used
    // Assume we can inspect port D to see if its all zeros.
    if (!(sigD.empty() || sigD.is_fully_zero())) reject;
    if (!bypassB.is_fully_ones()) reject;
    if (!bypassD.is_fully_ones()) reject;
    if (!bypassPASUB.is_fully_ones()) reject;

    block_16(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  // techlibs/microchip/microchip_dsp.pmg:300
  void block_16(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    Cell* &preAdd YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdd;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;
    Cell* _pmg_backup_preAdd = preAdd;

    index_16_key_type key;
    auto cells_ptr = index_16.find(key);

    if (cells_ptr != index_16.end()) {
      const vector<index_16_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        preAdd = std::get<0>(cells[_pmg_idx]);
        if (blacklist_cells.count(preAdd)) continue;
        if (!(port(preAdd, id_b_Y) == sigB || port(preAdd, id_b_Y) == sigA)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_17(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            preAdd = _pmg_backup_preAdd;
            return;
          }
          rollback = 0;
        }
      }
    }

    preAdd = nullptr;
    preAdd = _pmg_backup_preAdd;
  }

  // techlibs/microchip/microchip_dsp.pmg:319
  void block_17(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &bypassB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassB;
    const SigSpec &bypassD YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassD;
    const SigSpec &bypassPASUB YS_MAYBE_UNUSED = st_microchip_dsp_pack.bypassPASUB;
    Cell* const &preAdd YS_MAYBE_UNUSED = st_microchip_dsp_pack.preAdd;
    const SigSpec &sigA YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigA;
    const SigSpec &sigB YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigB;
    const SigSpec &sigD YS_MAYBE_UNUSED = st_microchip_dsp_pack.sigD;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_18(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    if (preAdd)
    {
      u_preAdderStatic = preAdd;
    }

    block_18(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  void block_18(int recursion YS_MAYBE_UNUSED) {
  }

  // techlibs/microchip/microchip_dsp.pmg:332
  void block_19(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_20(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    dff = nullptr;
    if (argQ.empty())
      reject;
    for (const auto &c : argQ.chunks()) {
      // Abandon matches when 'Q' is a constant
      if (!c.wire)
        reject;
      // Abandon matches when 'Q' has the keep attribute set
      if (c.wire->get_bool_attribute(id_b_keep))
        reject;
      // Abandon matches when 'Q' has a non-zero init attribute set
      Const init = c.wire->attributes.at(id_b_init, Const());
      if (!init.empty())
        for (auto b : init.extract(c.offset, c.width))
          if (b != State::Sx && b != State::S0)
            reject;
    }

    block_20(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  // techlibs/microchip/microchip_dsp.pmg:352
  void block_20(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* &ff YS_MAYBE_UNUSED = st_microchip_dsp_pack.ff;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;
    Cell* _pmg_backup_ff = ff;

    index_20_key_type key;
    std::get<0>(key) = argQ[0];
    auto cells_ptr = index_20.find(key);

    if (cells_ptr != index_20.end()) {
      const vector<index_20_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        ff = std::get<0>(cells[_pmg_idx]);
        const int &offset YS_MAYBE_UNUSED = std::get<1>(cells[_pmg_idx]);
        if (blacklist_cells.count(ff)) continue;
        if (!(GetSize(port(ff, id_b_Q)) >= offset + GetSize(argQ))) continue;
        if (!(port(ff, id_b_Q).extract(offset, GetSize(argQ)) == argQ)) continue;
        if (!(!ff->type.in(id_d_adff, id_d_adffe) || allowAsync)) continue;
        if (!(clock == SigBit() || port(ff, id_b_CLK)[0] == clock)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_21(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            ff = _pmg_backup_ff;
            return;
          }
          rollback = 0;
        }
      }
    }

    ff = nullptr;
    ff = _pmg_backup_ff;
  }

  // techlibs/microchip/microchip_dsp.pmg:374
  void block_21(int recursion YS_MAYBE_UNUSED) {
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* const &ff YS_MAYBE_UNUSED = st_microchip_dsp_pack.ff;
    SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_argQ = argQ;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_22(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    // Check that reset value, if present, is fully 0.
    bool noResetFlop = ff->type.in(id_d_dff, id_d_dffe);
    bool srstZero = ff->type.in(id_d_sdff, id_d_sdffe) && param(ff, id_b_SRST_VALUE).is_fully_zero();
    bool arstZero = ff->type.in(id_d_adff, id_d_adffe) && param(ff, id_b_ARST_VALUE).is_fully_zero();
    bool resetLegal = noResetFlop || srstZero || arstZero;
    if (resetLegal)
    {
      SigSpec Q = port(ff, id_b_Q);
      dff = ff;
      dffclock = port(ff, id_b_CLK);
      dffD = argQ;
      SigSpec D = port(ff, id_b_D);
      argQ = Q;
      dffD.replace(argQ, D);
    }

    block_22(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
  }

  void block_22(int recursion YS_MAYBE_UNUSED) {
  }

  // techlibs/microchip/microchip_dsp.pmg:398
  void block_23(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_microchip_dsp_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_24(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    dff = nullptr;
    for (auto c : argD.chunks())
      // Abandon matches when 'D' has the keep attribute set
      if (c.wire->get_bool_attribute(id_b_keep))
        reject;

    block_24(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;
  }

  // techlibs/microchip/microchip_dsp.pmg:406
  void block_24(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_microchip_dsp_pack.argD;
    const SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* &ff YS_MAYBE_UNUSED = st_microchip_dsp_pack.ff;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;
    Cell* _pmg_backup_ff = ff;

    index_24_key_type key;
    std::get<0>(key) = argD[0];
    auto cells_ptr = index_24.find(key);

    if (cells_ptr != index_24.end()) {
      const vector<index_24_value_type> &cells = cells_ptr->second;
      for (int _pmg_idx = 0; _pmg_idx < GetSize(cells); _pmg_idx++) {
        ff = std::get<0>(cells[_pmg_idx]);
        const int &offset YS_MAYBE_UNUSED = std::get<1>(cells[_pmg_idx]);
        if (blacklist_cells.count(ff)) continue;
        if (!(GetSize(port(ff, id_b_D)) >= offset + GetSize(argD))) continue;
        if (!(port(ff, id_b_D).extract(offset, GetSize(argD)) == argD)) continue;
        if (!(clock == SigBit() || port(ff, id_b_CLK)[0] == clock)) continue;
        auto rollback_ptr = rollback_cache.insert(make_pair(std::get<0>(cells[_pmg_idx]), recursion));
        block_25(recursion+1);
        if (rollback_ptr.second)
          rollback_cache.erase(rollback_ptr.first);
        if (rollback) {
          if (rollback != recursion) {
            ff = _pmg_backup_ff;
            return;
          }
          rollback = 0;
        }
      }
    }

    ff = nullptr;
    ff = _pmg_backup_ff;
  }

  // techlibs/microchip/microchip_dsp.pmg:421
  void block_25(int recursion YS_MAYBE_UNUSED) {
    const SigSpec &argD YS_MAYBE_UNUSED = st_microchip_dsp_pack.argD;
    const SigBit &clock YS_MAYBE_UNUSED = st_microchip_dsp_pack.clock;
    Cell* const &ff YS_MAYBE_UNUSED = st_microchip_dsp_pack.ff;
    SigSpec &argQ YS_MAYBE_UNUSED = st_microchip_dsp_pack.argQ;
    bool &allowAsync YS_MAYBE_UNUSED = ud_microchip_dsp_pack.allowAsync;
    Cell* &dff YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dff;
    SigSpec &dffD YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffD;
    SigSpec &dffQ YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffQ;
    SigBit &dffclock YS_MAYBE_UNUSED = ud_microchip_dsp_pack.dffclock;
    IdString &u_postAddAB YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAddAB;
    Cell* &u_postAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_postAdderStatic;
    Cell* &u_preAdderStatic YS_MAYBE_UNUSED = ud_microchip_dsp_pack.u_preAdderStatic;

    SigSpec _pmg_backup_argQ = argQ;

#define reject do { goto rollback_label; } while(0)
#define accept do { accept_cnt++; on_accept(); if (rollback) goto rollback_label; } while(0)
#define finish do { rollback = -1; goto rollback_label; } while(0)
#define branch do { block_26(recursion+1); if (rollback) goto rollback_label; } while(0)
#define subpattern(pattern_name) do { block_subpattern_microchip_dsp_pack_ ## pattern_name (recursion+1); if (rollback) goto rollback_label; } while(0)
    SigSpec D = port(ff, id_b_D);
    SigSpec Q = port(ff, id_b_Q);
    argQ = argD;
    argQ.replace(D, Q);
    // Abandon matches when 'Q' has a non-zero init attribute set
    for (auto c : argQ.chunks()) {
      Const init = c.wire->attributes.at(id_b_init, Const());
      if (!init.empty())
        for (auto b : init.extract(c.offset, c.width))
          if (b != State::Sx && b != State::S0)
            reject;
    }
    dff = ff;
    dffQ = argQ;
    dffclock = port(ff, id_b_CLK);

    block_26(recursion+1);
#undef reject
#undef accept
#undef finish
#undef branch
#undef subpattern

rollback_label:
    YS_MAYBE_UNUSED;

    argQ = _pmg_backup_argQ;
  }

  void block_26(int recursion YS_MAYBE_UNUSED) {
  }
};
