/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math;

import com.jogamp.math.Binary32;
import com.jogamp.math.Binary64;

public final class Binary16 {
    public static final char NEGATIVE_INFINITY = (char)64512;
    public static final char POSITIVE_INFINITY = (char)31744;
    public static final char POSITIVE_ZERO = '\u0000';
    public static final char NEGATIVE_ZERO = (char)32768;
    public static final int BIAS = 15;
    private static final int MASK_SIGN = 32768;
    private static final int MASK_EXPONENT = 31744;
    private static final int MASK_SIGNIFICAND = 1023;

    public static char exampleNaN() {
        int n = Binary16.packSetExponentUnbiasedUnchecked(16) | Binary16.packSetSignificandUnchecked(1);
        char c = (char)n;
        return c;
    }

    public static boolean isInfinite(char c) {
        return Binary16.unpackGetExponentUnbiased(c) == 16 && Binary16.unpackGetSignificand(c) == 0;
    }

    public static boolean isNaN(char c) {
        int n = Binary16.unpackGetExponentUnbiased(c);
        int n2 = Binary16.unpackGetSignificand(c);
        return n == 16 && n2 > 0;
    }

    public static char packDouble(double d) {
        if (Double.isNaN(d)) {
            return Binary16.exampleNaN();
        }
        if (d == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Double.doubleToLongBits(d) == Binary64.NEGATIVE_ZERO_BITS) {
            return NEGATIVE_ZERO;
        }
        if (d == 0.0) {
            return POSITIVE_ZERO;
        }
        long l = Binary64.unpackGetExponentUnbiased(d);
        long l2 = Binary64.unpackGetSign(d);
        long l3 = Binary64.unpackGetSignificand(d);
        char c = Binary16.packSetSignUnchecked((int)l2);
        int n = (int)(l & 0x1FL);
        char c2 = Binary16.packSetExponentUnbiasedUnchecked(n);
        long l4 = l3 & 0xFFC0000000000L;
        long l5 = l4 >> 42;
        char c3 = Binary16.packSetSignificandUnchecked((int)l5);
        return (char)(c | c2 | c3);
    }

    public static char packFloat(float f) {
        if (Float.isNaN(f)) {
            return Binary16.exampleNaN();
        }
        if (f == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (Float.floatToIntBits(f) == Binary32.NEGATIVE_ZERO_BITS) {
            return NEGATIVE_ZERO;
        }
        if ((double)f == 0.0) {
            return POSITIVE_ZERO;
        }
        long l = Binary32.unpackGetExponentUnbiased(f);
        long l2 = Binary32.unpackGetSign(f);
        long l3 = Binary32.unpackGetSignificand(f);
        char c = Binary16.packSetSignUnchecked((int)l2);
        int n = (int)(l & 0x1FL);
        char c2 = Binary16.packSetExponentUnbiasedUnchecked(n);
        long l4 = l3 & 0x7FE000L;
        long l5 = l4 >> 13;
        char c3 = Binary16.packSetSignificandUnchecked((int)l5);
        return (char)(c | c2 | c3);
    }

    public static char packSetExponentUnbiasedUnchecked(int n) {
        int n2 = n + BIAS;
        int n3 = n2 << 10;
        int n4 = n3 & MASK_EXPONENT;
        return (char)n4;
    }

    public static char packSetSignificandUnchecked(int n) {
        int n2 = n & MASK_SIGNIFICAND;
        return (char)n2;
    }

    public static char packSetSignUnchecked(int n) {
        int n2 = n << 15;
        int n3 = n2 & MASK_SIGN;
        return (char)n3;
    }

    public static String toRawBinaryString(char n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        for (int i = 0; i < 16; ++i) {
            if ((n2 & '\u0001') == 1) {
                stringBuilder.insert(0, "1");
            } else {
                stringBuilder.insert(0, "0");
            }
            n2 >>= 1;
        }
        return stringBuilder.toString();
    }

    public static double unpackDouble(char c) {
        if (Binary16.isNaN(c)) {
            return Double.NaN;
        }
        if (c == POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (c == NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (c == NEGATIVE_ZERO) {
            return -0.0;
        }
        if (c == POSITIVE_ZERO) {
            return 0.0;
        }
        long l = Binary16.unpackGetExponentUnbiased(c);
        long l2 = Binary16.unpackGetSign(c);
        long l3 = Binary16.unpackGetSignificand(c);
        long l4 = l2 << 63;
        long l5 = l + Binary64.BIAS;
        long l6 = l5 << 52;
        long l7 = l3 << 42;
        return Double.longBitsToDouble(l4 | l6 | l7);
    }

    public static float unpackFloat(char c) {
        if (Binary16.isNaN(c)) {
            return Float.NaN;
        }
        if (c == POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        if (c == NEGATIVE_INFINITY) {
            return Float.NEGATIVE_INFINITY;
        }
        if (c == NEGATIVE_ZERO) {
            return -0.0f;
        }
        if (c == POSITIVE_ZERO) {
            return 0.0f;
        }
        int n = Binary16.unpackGetExponentUnbiased(c);
        int n2 = Binary16.unpackGetSign(c);
        int n3 = Binary16.unpackGetSignificand(c);
        int n4 = n2 << 31;
        int n5 = n + Binary32.BIAS;
        int n6 = n5 << 23;
        int n7 = n3 << 13;
        return Float.intBitsToFloat(n4 | n6 | n7);
    }

    public static int unpackGetExponentUnbiased(char c) {
        int n = c & MASK_EXPONENT;
        int n2 = n >> 10;
        return n2 - BIAS;
    }

    public static int unpackGetSign(char c) {
        return (c & MASK_SIGN) >> 15;
    }

    public static int unpackGetSignificand(char c) {
        return c & MASK_SIGNIFICAND;
    }

    private Binary16() {
        throw new AssertionError((Object)"Unreachable code, report this bug!");
    }
}

