/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.stream.StreamTransportResponse;

@PublicApi(since="1.0.0")
public interface TransportMessageListener {
    public static final TransportMessageListener NOOP_LISTENER = new TransportMessageListener(){};

    default public void onRequestReceived(long requestId, String action) {
    }

    default public void onResponseSent(long requestId, String action, TransportResponse response) {
    }

    @ExperimentalApi
    default public void onStreamResponseSent(long requestId, String action, StreamTransportResponse response) {
    }

    default public void onResponseSent(long requestId, String action, Exception error) {
    }

    default public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions finalOptions) {
    }

    default public void onResponseReceived(long requestId, Transport.ResponseContext context) {
    }
}

